/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ArrayUtil;

public class MultiClassVisitor
implements ClassVisitor {
    private ClassVisitor[] classVisitors;
    private int classVisitorCount;

    public MultiClassVisitor() {
        this.classVisitors = new ClassVisitor[16];
    }

    public MultiClassVisitor(ClassVisitor ... classVisitorArray) {
        this.classVisitors = classVisitorArray;
        this.classVisitorCount = classVisitorArray.length;
    }

    public void addClassVisitor(ClassVisitor classVisitor) {
        this.classVisitors = ArrayUtil.add(this.classVisitors, this.classVisitorCount++, classVisitor);
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        for (int i = 0; i < this.classVisitorCount; ++i) {
            this.classVisitors[i].visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        for (int i = 0; i < this.classVisitorCount; ++i) {
            this.classVisitors[i].visitLibraryClass(libraryClass);
        }
    }
}

