/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComboBoxAccessibleEditorValidator;
import org.fest.swing.driver.JComboBoxContentQuery;
import org.fest.swing.driver.JComboBoxDropDownListFinder;
import org.fest.swing.driver.JComboBoxEditableQuery;
import org.fest.swing.driver.JComboBoxItemCountQuery;
import org.fest.swing.driver.JComboBoxItemIndexValidator;
import org.fest.swing.driver.JComboBoxMatchingItemQuery;
import org.fest.swing.driver.JComboBoxSelectedIndexQuery;
import org.fest.swing.driver.JComboBoxSelectionValueQuery;
import org.fest.swing.driver.JComboBoxSetPopupVisibleTask;
import org.fest.swing.driver.JComboBoxSetSelectedIndexTask;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListDriver;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class JComboBoxDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private final JListDriver listDriver;
    private final JComboBoxDropDownListFinder dropDownListFinder;
    private JComboBoxCellReader cellReader;

    public JComboBoxDriver(Robot robot) {
        super(robot);
        this.listDriver = new JListDriver(robot);
        this.dropDownListFinder = new JComboBoxDropDownListFinder(robot);
        this.cellReader(new BasicJComboBoxCellReader());
    }

    @RunsInEDT
    public String[] contentsOf(JComboBox comboBox) {
        return JComboBoxContentQuery.contents(comboBox, this.cellReader);
    }

    @RunsInEDT
    public void selectItem(JComboBox comboBox, String value) {
        this.selectItem(comboBox, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(JComboBox comboBox, Pattern pattern) {
        this.selectItem(comboBox, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(JComboBox comboBox, TextMatcher matcher) {
        int index = JComboBoxMatchingItemQuery.matchingItemIndex(comboBox, matcher, this.cellReader);
        if (index < 0) {
            throw this.failMatchingNotFound(comboBox, matcher);
        }
        this.selectItem(comboBox, index);
    }

    private LocationUnavailableException failMatchingNotFound(JComboBox comboBox, TextMatcher matcher) {
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find item matching the ", matcher.description(), " ", matcher.formattedValues(), " among the JComboBox contents (", Arrays.format((Object)this.contentsOf(comboBox)), ")"}));
    }

    @RunsInEDT
    public void requireSelection(JComboBox comboBox, String value) {
        String selection = this.requiredSelectionOf(comboBox);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(JComboBox comboBox, Pattern pattern) {
        String selection = this.requiredSelectionOf(comboBox);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox)).matches(pattern);
    }

    private String requiredSelectionOf(JComboBox comboBox) throws AssertionError {
        Object selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader);
        if (JComboBoxSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            throw this.failNoSelection(comboBox);
        }
        return (String)selection;
    }

    @RunsInEDT
    public void requireSelection(JComboBox comboBox, int index) {
        int selectedIndex = JComboBoxSelectedIndexQuery.selectedIndexOf(comboBox);
        if (selectedIndex == -1) {
            this.failNoSelection(comboBox);
        }
        Assertions.assertThat((int)selectedIndex).as(this.selectedIndexProperty(comboBox)).isEqualTo(index);
    }

    private AssertionError failNoSelection(JComboBox comboBox) {
        throw Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(comboBox).value(), "] No selection"}));
    }

    @RunsInEDT
    public void requireNoSelection(JComboBox comboBox) {
        Object selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader);
        if (JComboBoxSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            return;
        }
        Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(comboBox).value(), "] Expecting no selection, but found:<", Strings.quote((Object)selection), ">"}));
    }

    public String value(JComboBox comboBox, int index) {
        return JComboBoxDriver.valueAsText(comboBox, index, this.cellReader);
    }

    @RunsInEDT
    private static String valueAsText(final JComboBox comboBox, final int index, final JComboBoxCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JComboBoxItemIndexValidator.validateIndex(comboBox, index);
                return cellReader.valueAt(comboBox, index);
            }
        });
    }

    private Description selectedIndexProperty(JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, SELECTED_INDEX_PROPERTY);
    }

    public void clearSelection(JComboBox comboBox) {
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, -1);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectItem(JComboBox comboBox, int index) {
        JComboBoxDriver.validateCanSelectItem(comboBox, index);
        this.showDropDownList(comboBox);
        this.selectItemAtIndex(comboBox, index);
        this.hideDropDownListIfVisible(comboBox);
    }

    @RunsInEDT
    private static void validateCanSelectItem(final JComboBox comboBox, final int index) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(comboBox);
                JComboBoxItemIndexValidator.validateIndex(comboBox, index);
            }
        });
    }

    @VisibleForTesting
    @RunsInEDT
    void showDropDownList(JComboBox comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, true);
    }

    @RunsInEDT
    private void selectItemAtIndex(JComboBox comboBox, int index) {
        JList dropDownList = this.dropDownListFinder.findDropDownList();
        if (dropDownList != null) {
            this.listDriver.selectItem(dropDownList, index);
            return;
        }
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, index);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void hideDropDownListIfVisible(JComboBox comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, false);
    }

    @RunsInEDT
    private void dropDownVisibleThroughUIDelegate(JComboBox comboBox, boolean visible) {
        JComboBoxSetPopupVisibleTask.setPopupVisible(comboBox, visible);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void replaceText(JComboBox comboBox, String text) {
        this.selectAllText(comboBox);
        this.enterText(comboBox, text);
    }

    @RunsInEDT
    public void selectAllText(JComboBox comboBox) {
        Component editor = JComboBoxDriver.accessibleEditorOf(comboBox);
        if (!(editor instanceof JComponent)) {
            return;
        }
        this.focus(editor);
        this.invokeAction((JComponent)editor, "select-all");
    }

    @RunsInEDT
    private static Component accessibleEditorOf(final JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                JComboBoxAccessibleEditorValidator.validateEditorIsAccessible(comboBox);
                return JComboBoxDriver.editorComponentOf(comboBox);
            }
        });
    }

    @RunsInEDT
    public void enterText(JComboBox comboBox, String text) {
        JComboBoxDriver.inEdtValidateEditorIsAccessible(comboBox);
        Component editor = JComboBoxDriver.editorComponentOf(comboBox);
        if (editor == null) {
            throw ActionFailedException.actionFailure("JComboBox does not have an editor");
        }
        this.focusAndWaitForFocusGain(editor);
        this.robot.enterText(text);
    }

    @RunsInEDT
    public void pressAndReleaseKeys(JComboBox comboBox, int ... keyCodes) {
        if (keyCodes == null) {
            throw new NullPointerException("The array of key codes should not be null");
        }
        JComboBoxDriver.assertIsEnabledAndShowing(comboBox);
        Component target = JComboBoxDriver.editorIfEditable(comboBox);
        if (target == null) {
            target = comboBox;
        }
        this.focusAndWaitForFocusGain(target);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    private static Component editorIfEditable(final JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                if (!comboBox.isEditable()) {
                    return null;
                }
                return JComboBoxDriver.editorComponent(comboBox);
            }
        });
    }

    @RunsInEDT
    private static void inEdtValidateEditorIsAccessible(final JComboBox comboBox) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JComboBoxAccessibleEditorValidator.validateEditorIsAccessible(comboBox);
            }
        });
    }

    @RunsInEDT
    private static Component editorComponentOf(final JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                return JComboBoxDriver.editorComponent(comboBox);
            }
        });
    }

    @RunsInCurrentThread
    private static Component editorComponent(JComboBox comboBox) {
        ComboBoxEditor editor = comboBox.getEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorComponent();
    }

    @RunsInEDT
    public JList dropDownList() {
        JList list = this.dropDownListFinder.findDropDownList();
        if (list == null) {
            throw this.listNotFound();
        }
        return list;
    }

    private ComponentLookupException listNotFound() {
        throw new ComponentLookupException("Unable to find the pop-up list for the JComboBox");
    }

    @RunsInEDT
    public void requireEditable(JComboBox comboBox) {
        this.assertEditable(comboBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(JComboBox comboBox) {
        this.assertEditable(comboBox, false);
    }

    @RunsInEDT
    private void assertEditable(JComboBox comboBox, boolean expected) {
        Assertions.assertThat((boolean)JComboBoxEditableQuery.isEditable(comboBox)).as(JComboBoxDriver.editableProperty(comboBox)).isEqualTo(expected);
    }

    @RunsInEDT
    private static Description editableProperty(JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, EDITABLE_PROPERTY);
    }

    public void cellReader(JComboBoxCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }

    @RunsInEDT
    public void requireItemCount(JComboBox comboBox, int expected) {
        int actual = JComboBoxItemCountQuery.itemCountIn(comboBox);
        Assertions.assertThat((int)actual).as(JComboBoxDriver.propertyName(comboBox, "itemCount")).isEqualTo(expected);
    }
}

