/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.XProfileBase;
import java.util.Iterator;
import java.util.Vector;

public final class X1Profile
extends XProfileBase {
    private boolean _x1aCompliant;

    public X1Profile(PdfModule pdfModule) {
        super(pdfModule, XProfileBase.PDFX1);
        this._profileText = "ISO PDF/X-1";
    }

    @Override
    public boolean satisfiesThisProfile() {
        this._x1aCompliant = false;
        try {
            PdfDictionary pdfDictionary = this._module.getCatalogDict();
            PdfArray pdfArray = (PdfArray)this._module.resolveIndirectObject(pdfDictionary.get("OutputIntents"));
            if (pdfArray == null) {
                return false;
            }
            PdfDictionary pdfDictionary2 = this._module.getDocInfo();
            try {
                PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary2.get("GTS_PDFXConformance");
                String string = pdfSimpleObject.getStringValue();
                if (string.startsWith("PDF/X-1a:")) {
                    this._x1aCompliant = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.outputIntentsOK(pdfArray)) {
                return false;
            }
            if (!this.resourcesOK()) {
                return false;
            }
            if (!this.trailerDictOK()) {
                return false;
            }
            if (!this.infoDictOK("PDF/X-1")) {
                return false;
            }
            if (!this.encryptionOK()) {
                return false;
            }
            if (!this.bboxOK(true)) {
                return false;
            }
            if (this._module.getActionsExist()) {
                return false;
            }
            if (this._module.getEncryptionDict() != null) {
                this._x1aCompliant = false;
            }
            if (!this.checkPrefsAgainstBleedBox()) {
                this._x1aCompliant = false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isX1aCompliant() {
        return this._x1aCompliant;
    }

    private boolean resourcesOK() {
        PageTreeNode pageTreeNode = this._module.getDocumentTree();
        try {
            DocNode docNode;
            pageTreeNode.startWalk();
            while ((docNode = pageTreeNode.nextDocNode()) != null) {
                Object object;
                PdfObject pdfObject;
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary;
                Object object2;
                Object object3;
                Object object4;
                PdfDictionary pdfDictionary2 = docNode.getResources();
                if (pdfDictionary2 != null) {
                    object4 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("ColorSpace"));
                    if (!this.colorSpaceOK((PdfDictionary)object4)) {
                        return false;
                    }
                    object3 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("ExtGState"));
                    if (!this.extGStateOK((PdfDictionary)object3)) {
                        return false;
                    }
                    object2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("XObject"));
                    if (!this.xObjectsOK((PdfDictionary)object2)) {
                        return false;
                    }
                }
                if (!(docNode instanceof PageObject)) continue;
                object4 = ((PageObject)docNode).getContentStreams();
                if (object4 != null) {
                    object3 = object4.listIterator();
                    while (object3.hasNext()) {
                        object2 = (PdfStream)object3.next();
                        PdfDictionary pdfDictionary3 = ((PdfStream)object2).getDict();
                        pdfDictionary = (PdfDictionary)pdfDictionary3.get("Resources");
                        if (pdfDictionary != null) {
                            pdfObject2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("ColorSpace"));
                            if (!this.colorSpaceOK((PdfDictionary)pdfObject2)) {
                                return false;
                            }
                            pdfObject = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("ExtGState"));
                            if (!this.extGStateOK((PdfDictionary)pdfObject)) {
                                return false;
                            }
                            object = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("XObject"));
                            if (!this.xObjectsOK((PdfDictionary)object)) {
                                return false;
                            }
                        }
                        if (this.filter1AOK(pdfObject2 = pdfDictionary3.get("Filter"))) continue;
                        this._x1aCompliant = false;
                    }
                }
                if ((object3 = ((PageObject)docNode).getAnnotations()) == null) continue;
                object2 = ((PdfArray)object3).getContent();
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    PdfSimpleObject pdfSimpleObject;
                    PdfDictionary pdfDictionary4;
                    pdfDictionary = (PdfDictionary)((Vector)object2).elementAt(i);
                    pdfObject2 = (PdfSimpleObject)pdfDictionary.get("Subtype");
                    if (!"TrapNet".equals(((PdfSimpleObject)pdfObject2).getStringValue())) continue;
                    pdfObject = (PdfArray)pdfDictionary.get("FontFauxing");
                    if (pdfObject != null && ((Vector)(object = pdfObject.getContent())).size() > 0) {
                        return false;
                    }
                    object = (PdfDictionary)pdfDictionary.get("AP");
                    if (object == null || (pdfDictionary4 = (PdfDictionary)((PdfDictionary)object).get("N")) == null || "DeviceCMYK".equals((pdfSimpleObject = (PdfSimpleObject)pdfDictionary4.get("PCM")).getStringValue())) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean colorSpaceOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        Iterator iterator = pdfDictionary.iterator();
        while (iterator.hasNext()) {
            PdfSimpleObject pdfSimpleObject;
            String string;
            PdfObject pdfObject = (PdfObject)iterator.next();
            if (!(pdfObject instanceof PdfArray)) continue;
            Vector vector = ((PdfArray)pdfObject).getContent();
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)vector.elementAt(0);
            String string2 = pdfSimpleObject2.getStringValue();
            if (("Separation".equals(string2) || "DeviceN".equals(string2)) && !"DeviceGray".equals(string = (pdfSimpleObject = (PdfSimpleObject)vector.elementAt(2)).getStringValue()) && !"DeviceCMYK".equals(string)) {
                return false;
            }
            if (!"Indexed".equals(string2) && !"Pattern".equals(string2) || "DeviceCMYK".equals(string = (pdfSimpleObject = (PdfSimpleObject)vector.elementAt(1)).getStringValue()) || "DeviceGray".equals(string) || "DeviceN".equals(string) || "Separation".equals(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean xObjectOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        if (!super.xObjectOK(pdfDictionary)) {
            return false;
        }
        try {
            Object object;
            Object object2;
            PdfDictionary pdfDictionary2 = (PdfDictionary)pdfDictionary.get("OPI");
            if (pdfDictionary2 == null) {
                return true;
            }
            this._x1aCompliant = false;
            PdfDictionary pdfDictionary3 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("2.0"));
            if (pdfDictionary3 == null) {
                return true;
            }
            PdfObject pdfObject = this._module.resolveIndirectObject(pdfDictionary3.get("Inks"));
            if (pdfObject == null) {
                return true;
            }
            if (pdfObject instanceof PdfSimpleObject ? !"full_color".equals(object2 = ((PdfSimpleObject)pdfObject).getStringValue()) && !"registration".equals(object2) : pdfObject instanceof PdfArray && !"monochrome".equals(((PdfSimpleObject)(object = (PdfSimpleObject)((Vector)(object2 = ((PdfArray)pdfObject).getContent())).elementAt(0))).getStringValue())) {
                return false;
            }
            object2 = this._module.resolveIndirectObject(pdfDictionary3.get("F"));
            object = this._module.getEmbeddedFiles();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean encryptionOK() {
        PdfDictionary pdfDictionary = this._module.getEncryptionDict();
        if (pdfDictionary == null) {
            return true;
        }
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Filter");
            if (!"Standard".equals(pdfSimpleObject.getStringValue())) {
                return false;
            }
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("P");
            if (pdfSimpleObject2 == null) {
                return false;
            }
            if ((pdfSimpleObject2.getIntValue() & 4) == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean filter1AOK(PdfObject pdfObject) {
        return !this.hasFilters(pdfObject, new String[]{"LZWDecode", "JBIG2Decode"});
    }

    @Override
    protected boolean formObjectOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary.get("Ref") != null) {
            this._x1aCompliant = false;
        }
        return true;
    }
}

