/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public class TiffProfileExifIFD
extends TiffProfile {
    private int _majVersion;
    private int _minVersion;

    public TiffProfileExifIFD() {
        this._profileText = null;
        this._majVersion = -1;
        this._minVersion = -1;
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof ExifIFD)) {
            return false;
        }
        ExifIFD exifIFD = (ExifIFD)iFD;
        String string = exifIFD.getExifVersion();
        if (string.equals("0220")) {
            this._majVersion = 2;
            this._minVersion = 2;
        } else if (string.equals("0210")) {
            this._majVersion = 2;
            this._minVersion = 1;
        } else if (string.equals("0200")) {
            this._majVersion = 2;
            this._minVersion = 0;
        } else {
            return false;
        }
        if (!exifIFD.getFlashpixVersion().equals("0100")) {
            return false;
        }
        int n = exifIFD.getColorspace();
        return n == 1 || n == 65535;
    }
}

