/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "cmpiOpenDRIM_Account.h"

CMPIObjectPath* Simple_Identity_Management_OpenDRIM_Account_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Account& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_Account_classnames[0], OpenDRIM_Account_NAMESPACE);

	if (!instance.SystemCreationClassName_isNULL)
		op.addKey("SystemCreationClassName", instance.SystemCreationClassName);

	if (!instance.SystemName_isNULL)
		op.addKey("SystemName", instance.SystemName);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	_L_;
	return op.getHdl();
}

CMPIInstance* Simple_Identity_Management_OpenDRIM_Account_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Account& instance) {
	_E_;
	Objectpath op(broker, Simple_Identity_Management_OpenDRIM_Account_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.UserID_isNULL)
		ci.setProperty("UserID", instance.UserID);

	if (!instance.ObjectClass_isNULL)
		ci.setProperty("ObjectClass", instance.ObjectClass);

	if (!instance.Descriptions_isNULL)
		ci.setProperty("Descriptions", instance.Descriptions);

	if (!instance.Host_isNULL)
		ci.setProperty("Host", instance.Host);

	if (!instance.LocalityName_isNULL)
		ci.setProperty("LocalityName", instance.LocalityName);

	if (!instance.OrganizationName_isNULL)
		ci.setProperty("OrganizationName", instance.OrganizationName);

	if (!instance.OU_isNULL)
		ci.setProperty("OU", instance.OU);

	if (!instance.SeeAlso_isNULL)
		ci.setProperty("SeeAlso", instance.SeeAlso);

	if (!instance.UserCertificate_isNULL)
		ci.setProperty("UserCertificate", instance.UserCertificate);

	if (!instance.UserPassword_isNULL)
		ci.setProperty("UserPassword", instance.UserPassword);

	if (!instance.PasswordHistoryDepth_isNULL)
		ci.setProperty("PasswordHistoryDepth", instance.PasswordHistoryDepth);

	if (!instance.PasswordExpiration_isNULL)
		ci.setPropertyDatetime("PasswordExpiration", instance.PasswordExpiration);

	if (!instance.ComplexPasswordRulesEnforced_isNULL)
		ci.setProperty("ComplexPasswordRulesEnforced", instance.ComplexPasswordRulesEnforced);

	if (!instance.InactivityTimeout_isNULL)
		ci.setPropertyDatetime("InactivityTimeout", instance.InactivityTimeout);

	if (!instance.MaximumSuccessiveLoginFailures_isNULL)
		ci.setProperty("MaximumSuccessiveLoginFailures", instance.MaximumSuccessiveLoginFailures);

	if (!instance.LastLogin_isNULL)
		ci.setPropertyDatetime("LastLogin", instance.LastLogin);

	if (!instance.PasswordLastChange_isNULL)
		ci.setPropertyDatetime("PasswordLastChange", instance.PasswordLastChange);

	if (!instance.AccountExpiration_isNULL)
		ci.setPropertyDatetime("AccountExpiration", instance.AccountExpiration);

	if (!instance.PrimaryGroup_isNULL)
		ci.setProperty("PrimaryGroup", instance.PrimaryGroup);

	if (!instance.LoginShell_isNULL)
		ci.setProperty("LoginShell", instance.LoginShell);

	if (!instance.HomeDirectory_isNULL)
		ci.setProperty("HomeDirectory", instance.HomeDirectory);

	_L_;
	return ci.getHdl();
}

void Simple_Identity_Management_OpenDRIM_Account_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Account& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (op.getKey("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	_L_;
}

void Simple_Identity_Management_OpenDRIM_Account_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Account& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (inst.getProperty("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("UserID", instance.UserID) == OK)
		instance.UserID_isNULL = false;

	if (inst.getProperty("ObjectClass", instance.ObjectClass) == OK)
		instance.ObjectClass_isNULL = false;

	if (inst.getProperty("Descriptions", instance.Descriptions) == OK)
		instance.Descriptions_isNULL = false;

	if (inst.getProperty("Host", instance.Host) == OK)
		instance.Host_isNULL = false;

	if (inst.getProperty("LocalityName", instance.LocalityName) == OK)
		instance.LocalityName_isNULL = false;

	if (inst.getProperty("OrganizationName", instance.OrganizationName) == OK)
		instance.OrganizationName_isNULL = false;

	if (inst.getProperty("OU", instance.OU) == OK)
		instance.OU_isNULL = false;

	if (inst.getProperty("SeeAlso", instance.SeeAlso) == OK)
		instance.SeeAlso_isNULL = false;

	if (inst.getProperty("UserCertificate", instance.UserCertificate) == OK)
		instance.UserCertificate_isNULL = false;

	if (inst.getProperty("UserPassword", instance.UserPassword) == OK)
		instance.UserPassword_isNULL = false;

	if (inst.getProperty("PasswordHistoryDepth", instance.PasswordHistoryDepth) == OK)
		instance.PasswordHistoryDepth_isNULL = false;

	if (inst.getPropertyDatetime("PasswordExpiration", instance.PasswordExpiration) == OK)
		instance.PasswordExpiration_isNULL = false;

	if (inst.getProperty("ComplexPasswordRulesEnforced", instance.ComplexPasswordRulesEnforced) == OK)
		instance.ComplexPasswordRulesEnforced_isNULL = false;

	if (inst.getPropertyDatetime("InactivityTimeout", instance.InactivityTimeout) == OK)
		instance.InactivityTimeout_isNULL = false;

	if (inst.getProperty("MaximumSuccessiveLoginFailures", instance.MaximumSuccessiveLoginFailures) == OK)
		instance.MaximumSuccessiveLoginFailures_isNULL = false;

	if (inst.getPropertyDatetime("LastLogin", instance.LastLogin) == OK)
		instance.LastLogin_isNULL = false;

	if (inst.getPropertyDatetime("PasswordLastChange", instance.PasswordLastChange) == OK)
		instance.PasswordLastChange_isNULL = false;

	if (inst.getPropertyDatetime("AccountExpiration", instance.AccountExpiration) == OK)
		instance.AccountExpiration_isNULL = false;

	if (inst.getProperty("PrimaryGroup", instance.PrimaryGroup) == OK)
		instance.PrimaryGroup_isNULL = false;

	if (inst.getProperty("LoginShell", instance.LoginShell) == OK)
		instance.LoginShell_isNULL = false;

	if (inst.getProperty("HomeDirectory", instance.HomeDirectory) == OK)
		instance.HomeDirectory_isNULL = false;

	_L_;
}

void Simple_Identity_Management_OpenDRIM_Account_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Account_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}

	_L_;
}

void Simple_Identity_Management_OpenDRIM_Account_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_Account_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
