/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_REGISTEREDSSHPROFILEACCESS_H_
#define OPENDRIM_REGISTEREDSSHPROFILEACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_RegisteredSSHProfile.h"

int SSH_OpenDRIM_RegisteredSSHProfile_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_unload(string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredSSHProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_RegisteredSSHProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredSSHProfile& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& newInstance, const OpenDRIM_RegisteredSSHProfile& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_CloseConformantInstances(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, unsigned int& returnValue, const OpenDRIM_RegisteredSSHProfile_CloseConformantInstances_In& in, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_OpenConformantInstances(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, unsigned int& returnValue, const OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_In& in, OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_Out& out, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_PullConformantInstances(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, unsigned int& returnValue, const OpenDRIM_RegisteredSSHProfile_PullConformantInstances_In& in, OpenDRIM_RegisteredSSHProfile_PullConformantInstances_Out& out, string& errorMessage);

int SSH_OpenDRIM_RegisteredSSHProfile_populate(OpenDRIM_RegisteredSSHProfile& instance, string& errorMessage);

#endif /*OPENDRIM_REGISTEREDSSHPROFILEACCESS_H_*/
