/*****************************************************************************
 * Copyright (c) 2014-2024 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "VehiclePaint.h"

#include "../Game.h"
#include "../GameState.h"
#include "../drawing/Drawing.h"
#include "../drawing/LightFX.h"
#include "../entity/EntityRegistry.h"
#include "../entity/Yaw.hpp"
#include "../interface/Viewport.h"
#include "../paint/Paint.h"
#include "../ride/CarEntry.h"
#include "../ride/RideData.h"
#include "../ride/Vehicle.h"
#include "Track.h"

#include <iterator>

using namespace OpenRCT2;
using namespace OpenRCT2::Entity::Yaw;

#pragma region VehicleBoundboxes

// 0x0098E52C:
const VehicleBoundBox VehicleBoundboxes[16][224] = {
    {
        // 0x0099123C:
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -5, -2, -22, 10, 4, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -2, -5, -22, 4, 10, 14 },   { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },    { -3, -3, -22, 6, 6, 14 },
        { -10, -6, -22, 16, 12, 14 }, { -8, -8, -22, 16, 16, 14 },  { -6, -11, -27, 3, 16, 19 },  { -8, -8, -22, 16, 16, 14 },
        { -11, -6, -27, 16, 5, 19 },  { -8, -8, -22, 16, 16, 14 },  { -6, -10, -22, 12, 16, 14 }, { -8, -8, -22, 16, 16, 14 },
        { -10, -6, -22, 16, 12, 14 }, { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -3, -10, -33, 3, 16, 27 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -13, -6, -33, 16, 5, 24 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -6, -10, -22, 12, 16, 14 }, { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },  { -6, -6, -22, 12, 12, 14 },
        { -10, -6, -33, 20, 12, 24 }, { -2, -3, -33, 3, 10, 29 },   { -13, -6, -33, 20, 5, 24 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -43, 5, 12, 34 },  { -10, -6, -43, 5, 12, 34 },  { -10, -6, -43, 5, 12, 34 },  { -10, -6, -43, 5, 12, 34 },
        { -2, 4, -33, 3, 10, 29 },    { -2, 4, -33, 3, 10, 29 },    { -2, 4, -33, 3, 10, 29 },    { -2, 4, -33, 3, 10, 29 },
        { -13, -6, -33, 20, 5, 24 },  { -13, -6, -33, 20, 5, 24 },  { -13, -6, -33, 20, 5, 24 },  { -13, -6, -33, 20, 5, 24 },
        { -6, -15, -22, 12, 10, 14 }, { -6, -15, -22, 12, 10, 14 }, { -6, -15, -22, 12, 10, 14 }, { -6, -15, -22, 12, 10, 14 },
        { -10, -6, -33, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -33, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -22, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -22, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -38, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -28, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },
        { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -8, -22, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -22, 12, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -6, -22, 16, 12, 14 },
        { -8, -6, -22, 16, 12, 14 },  { -8, -6, -22, 16, 12, 14 },  { -8, -8, -22, 16, 16, 14 },  { -6, -8, -22, 12, 16, 14 },
        { -6, -8, -22, 12, 16, 14 },  { -6, -8, -22, 12, 16, 14 },  { -8, -8, -22, 16, 16, 14 },  { -8, -6, -22, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -22, 20, 12, 14 }, { -6, -10, -22, 12, 20, 14 }, { -10, -6, -22, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -22, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x0099027C:
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x009907BC:
        { -8, -6, -23, 16, 12, 14 },  { -8, -6, -23, 16, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -8, -23, 12, 16, 14 },
        { -6, -8, -23, 12, 16, 14 },  { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -8, -6, -23, 16, 12, 14 },  { -8, -6, -23, 16, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -8, -23, 12, 16, 14 },
        { -6, -8, -23, 12, 16, 14 },  { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -9, -6, -23, 18, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -9, -23, 12, 18, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -6, -9, -23, 12, 18, 14 },  { -8, -8, -23, 16, 16, 14 },  { -9, -6, -23, 18, 12, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -9, -6, -23, 18, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -9, -23, 12, 18, 14 },
        { -6, -6, -23, 12, 12, 14 },  { -6, -9, -23, 12, 18, 14 },  { -8, -8, -23, 16, 16, 14 },  { -9, -6, -23, 18, 12, 14 },
        { -10, -6, -23, 16, 12, 14 }, { -8, -8, -23, 16, 16, 14 },  { -6, -11, -28, 3, 16, 19 },  { -8, -8, -23, 16, 16, 14 },
        { -11, -6, -28, 16, 5, 19 },  { -8, -8, -23, 16, 16, 14 },  { -6, -10, -23, 12, 16, 14 }, { -8, -8, -23, 16, 16, 14 },
        { -10, -6, -23, 16, 12, 14 }, { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -3, -10, -34, 3, 16, 27 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -13, -6, -34, 16, 5, 24 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -6, -10, -23, 12, 16, 14 }, { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },  { -6, -6, -23, 12, 12, 14 },
        { -10, -6, -34, 20, 12, 24 }, { -2, -3, -34, 3, 10, 29 },   { -13, -6, -34, 20, 5, 24 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -44, 5, 12, 34 },  { -10, -6, -44, 5, 12, 34 },  { -10, -6, -44, 5, 12, 34 },  { -10, -6, -44, 5, 12, 34 },
        { -2, 4, -34, 3, 10, 29 },    { -2, 4, -34, 3, 10, 29 },    { -2, 4, -34, 3, 10, 29 },    { -2, 4, -34, 3, 10, 29 },
        { -13, -6, -34, 20, 5, 24 },  { -13, -6, -34, 20, 5, 24 },  { -13, -6, -34, 20, 5, 24 },  { -13, -6, -34, 20, 5, 24 },
        { -6, -15, -23, 12, 10, 14 }, { -6, -15, -23, 12, 10, 14 }, { -6, -15, -23, 12, 10, 14 }, { -6, -15, -23, 12, 10, 14 },
        { -10, -6, -34, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -34, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -23, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -23, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -39, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -29, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },
        { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -8, -23, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -8, -6, -23, 16, 12, 14 },  { -8, -6, -23, 16, 12, 14 },  { -8, -8, -23, 16, 16, 14 },  { -6, -8, -23, 12, 16, 14 },
        { -6, -8, -23, 12, 16, 14 },  { -6, -8, -23, 12, 16, 14 },  { -8, -8, -23, 16, 16, 14 },  { -8, -6, -23, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -23, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x009921FC:
        { -19, -6, -28, 38, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -19, -28, 12, 38, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -19, -6, -28, 38, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -19, -28, 12, 38, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -15, -6, -28, 18, 12, 14 }, { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 28, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 28, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -15, -28, 12, 18, 14 }, { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },   { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -13, -6, -39, 16, 5, 24 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 20, 12, 24 }, { -2, -3, -39, 3, 10, 29 },   { -13, -6, -39, 20, 5, 24 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },   { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },     { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },   { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },  { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },     { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },       { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },     { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x00991CBC:
        { -24, -6, -28, 32, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -11, -28, 12, 32, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -11, -6, -28, 32, 12, 14 }, { -11, -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, { -6, -11, -28, 12, 22, 14 },
        { -6, -24, -28, 12, 32, 14 }, { -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11, -6, -28, 22, 12, 14 },
        { -15, -6, -28, 18, 12, 14 }, { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 28, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 28, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -9, -28, 12, 18, 14 },
        { -6, -15, -28, 12, 18, 14 }, { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },   { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },   { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -13, -6, -39, 16, 5, 24 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },   { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 20, 12, 24 }, { -2, -3, -39, 3, 10, 29 },   { -13, -6, -39, 20, 5, 24 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },   { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },     { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },   { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },  { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },    { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },     { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },       { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },     { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },     { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },   { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },   { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },   { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x0098F52C
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -13, -6, 1, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 3, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -13, -6, 3, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 1, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -18, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 12, 10, 15 },
        { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },
        { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098EFEC:
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },
        { -6, -10, 2, 12, 20, 14 },   { -6, -8, 1, 12, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -6, 1, 16, 12, 14 },
        { -10, -6, 2, 20, 12, 14 },   { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -8, 1, 12, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -6, 1, 16, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -10, 1, 12, 20, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -10, 1, 12, 20, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 12, 10, 15 },
        { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },
        { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -9, -6, 1, 18, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -9, 1, 12, 18, 14 },
        { -6, -10, 1, 12, 20, 14 },   { -6, -9, 1, 12, 18, 14 },    { -8, -8, 1, 16, 16, 14 },    { -9, -6, 1, 18, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098EAAC:
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 2, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -8, -8, 1, 16, 16, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 2, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -8, -8, 1, 16, 16, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -8, -8, 1, 16, 16, 14 },    { -6, -8, 1, 12, 16, 14 },    { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 6, 6, 15 },
        { -12, -12, -8, 6, 6, 15 },   { -12, -12, -8, 6, 6, 15 },   { -12, -12, -8, 6, 6, 15 },   { -12, -12, -8, 6, 6, 15 },
        { -12, -12, -8, 6, 6, 15 },   { -12, -6, -8, 6, 6, 15 },    { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },  { -10, -6, -15, 20, 12, 7 },  { -6, -10, -15, 12, 20, 7 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -8, -6, 1, 16, 12, 14 },    { -7, -6, 1, 14, 12, 14 },    { -6, -6, 1, 12, 12, 14 },    { -6, -7, 1, 12, 14, 14 },
        { -6, -8, 1, 12, 16, 14 },    { -6, -7, 1, 12, 14, 14 },    { -6, -6, 1, 12, 12, 14 },    { -7, -6, 1, 14, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098E56C:
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -6, 1, 6, 12, 14 },     { -8, -8, 1, 16, 16, 14 },    { -6, -3, 1, 12, 6, 14 },
        { -6, -3, 2, 12, 6, 14 },     { -6, -3, 1, 12, 6, 14 },     { -8, -8, 1, 16, 16, 14 },    { -3, -6, 1, 6, 12, 14 },
        { -3, -6, 2, 6, 12, 14 },     { -3, -6, 1, 6, 12, 14 },     { -8, -8, 1, 16, 16, 14 },    { -6, -3, 1, 12, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -6, -3, 1, 12, 6, 14 },     { -8, -8, 1, 16, 16, 14 },    { -3, -6, 1, 6, 12, 14 },
        { -3, -6, 1, 6, 12, 7 },      { -8, -8, 1, 16, 16, 7 },     { -6, -3, 1, 12, 6, 7 },      { -8, -8, 1, 16, 16, 7 },
        { -3, -6, 1, 6, 12, 7 },      { -8, -8, 1, 16, 16, 7 },     { -6, -3, 1, 12, 6, 7 },      { 0, 0, 1, 8, 8, 7 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -4, 10, 12, 7 },     { 0, -6, -4, 10, 12, 7 },     { 0, -6, -4, 10, 12, 7 },     { -6, -12, -4, 12, 10, 7 },
        { -6, -12, -4, 12, 10, 7 },   { -6, -12, -4, 12, 10, 7 },   { -6, -12, -4, 12, 10, 7 },   { -6, -12, -4, 12, 10, 7 },
        { -12, -6, -4, 10, 12, 7 },   { -12, -6, -4, 10, 12, 7 },   { -12, -6, -4, 10, 12, 7 },   { -6, 0, -4, 12, 10, 7 },
        { -6, 0, -4, 12, 10, 7 },     { -6, 0, -4, 12, 10, 7 },     { -6, 0, -4, 12, 10, 7 },     { -6, 0, -4, 12, 10, 7 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },    { -3, -6, -15, 6, 12, 6 },    { -6, -3, -15, 12, 6, 6 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -3, -6, 1, 6, 12, 14 },     { -3, -5, 1, 6, 10, 14 },     { -5, -5, 1, 10, 10, 14 },    { -5, -3, 1, 10, 6, 14 },
        { -6, -3, 1, 12, 6, 14 },     { -5, -3, 1, 10, 6, 14 },     { -5, -5, 1, 10, 10, 14 },    { -3, -5, 1, 6, 10, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x00990CFC:
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -11, -6, 1, 22, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -11, 3, 12, 22, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -11, -6, 3, 22, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -11, 1, 12, 22, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -12, 1, 12, 24, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -18, -6, 1, 24, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 24, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -12, -6, 5, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 5, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -18, -6, 5, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { 0, -6, -10, 14, 12, 24 },   { -6, -17, -10, 3, 14, 24 },  { -17, -6, -10, 14, 5, 24 },  { -6, 0, -10, 12, 14, 24 },
        { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },
        { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },
        { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },
        { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },
        { -14, -6, -10, 28, 12, 24 }, { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, -10, 12, 28, 24 },
        { -14, -6, 1, 28, 12, 14 },   { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, 1, 12, 28, 14 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -12, -6, 1, 24, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -11, 1, 12, 22, 14 },
        { -6, -12, 1, 12, 24, 14 },   { -6, -11, 1, 12, 22, 14 },   { -10, -10, 1, 20, 20, 14 },  { -11, -6, 1, 22, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0098FA6C:
        { -18, -6, 1, 36, 12, 11 },   { -17, -6, 1, 34, 12, 11 },   { -15, -15, 1, 30, 30, 11 },  { -6, -17, 1, 12, 34, 11 },
        { -6, -18, 1, 12, 36, 11 },   { -6, -17, 1, 12, 34, 11 },   { -15, -15, 1, 30, 30, 11 },  { -17, -6, 1, 34, 12, 11 },
        { -18, -6, 1, 36, 12, 11 },   { -17, -6, 1, 34, 12, 11 },   { -15, -15, 1, 30, 30, 11 },  { -6, -17, 1, 12, 34, 11 },
        { -6, -18, 1, 12, 36, 11 },   { -6, -17, 1, 12, 34, 11 },   { -15, -15, 1, 30, 30, 11 },  { -17, -6, 1, 34, 12, 11 },
        { -14, -6, 1, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 3, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 3, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -3, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -8, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { -8, -6, 5, 6, 12, 7 },      { -8, -6, 1, 16, 12, 7 },     { -8, -8, 1, 16, 16, 7 },     { -6, -8, 1, 12, 16, 7 },
        { -6, -3, 5, 12, 6, 7 },      { -6, -8, 1, 12, 16, 7 },     { -8, -8, 1, 16, 16, 7 },     { -8, -6, 1, 16, 12, 7 },
        { 0, -6, 5, 3, 12, 5 },       { -6, -13, 5, 3, 12, 5 },     { -13, -6, 5, 12, 5, 5 },     { -6, 0, 5, 12, 3, 5 },
        { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { 0, -6, -8, 10, 12, 15 },    { -6, -12, -8, 12, 10, 15 },
        { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },  { -6, -12, -8, 12, 10, 15 },
        { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -12, -6, -8, 10, 12, 15 },  { -6, 0, -8, 12, 10, 15 },
        { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },    { -6, 0, -8, 12, 10, 15 },
        { -3, -6, -4, 6, 12, 5 },     { -6, -13, -4, 3, 20, 5 },    { -13, -6, -4, 6, 5, 5 },     { -6, -3, -4, 12, 20, 5 },
        { -3, -6, 1, 6, 12, 6 },      { -6, -13, -10, 3, 6, 6 },    { -13, -6, -10, 6, 5, 6 },    { -6, -3, 1, 12, 6, 6 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -32, -32, 24, 4, 4, 14 },   { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -14, 1, 12, 28, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, 10, 12, 12, 14 },   { -6, -6, 10, 12, 12, 14 },
        { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },   { -6, -6, -12, 12, 12, 2 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x0099177C:
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -13, -6, 1, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 3, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -13, -6, 3, 26, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -13, 1, 12, 26, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { -8, -8, 1, 16, 16, 14 },
        { -18, -6, 1, 28, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -14, 1, 12, 28, 14 },   { 0, 0, 1, 8, 8, 14 },
        { -14, -6, 5, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -18, -6, 5, 28, 12, 14 },   { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 14 },   { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, -10, 28, 12, 24 }, { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, -10, 12, 28, 24 },
        { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },    { 0, -6, -7, 10, 12, 14 },
        { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },  { -6, -12, -7, 12, 10, 14 },
        { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },  { -12, -6, -7, 10, 12, 14 },
        { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },    { -6, 0, -7, 12, 10, 14 },
        { -14, -6, -10, 28, 12, 24 }, { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, -10, 12, 28, 24 },
        { -14, -6, 1, 28, 12, 14 },   { -6, -17, -10, 3, 28, 24 },  { -17, -6, -10, 28, 5, 24 },  { -6, -14, 1, 12, 28, 14 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },  { -14, -6, -15, 28, 12, 7 },  { -6, -14, -15, 12, 28, 7 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },  { -10, -10, 1, 20, 20, 14 },
        { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { -8, -8, 1, 16, 16, 14 },    { 8, 8, 1, 8, 8, 14 },
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -6, -16, 1, 12, 32, 8 },    { -5, -5, 1, 10, 10, 8 },     { -4, -4, 1, 8, 8, 8 },       { -5, -5, 1, 10, 10, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },    { -16, -6, 1, 32, 12, 8 },    { -6, -16, 1, 12, 32, 8 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 }, { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 }, { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, 1, 20, 12, 14 },   { -6, -10, 1, 12, 20, 14 },   { -10, -6, 1, 20, 12, 14 },   { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
        { -10, -6, -23, 20, 12, 14 }, { -6, -10, 1, 12, 20, 14 },   { -10, -6, -23, 20, 12, 14 }, { -6, -10, -23, 12, 20, 14 },
    },
    {
        // 0x009900FC:
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
    },
    {
        // 0x009901BC:
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
        { -8, -6, 11, 16, 12, 4 },    { -8, -6, 11, 16, 12, 4 },    { -8, -8, 11, 16, 16, 4 },    { -6, -8, 11, 12, 16, 4 },
        { -6, -8, 11, 12, 16, 4 },    { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, 11, 20, 12, 14 },  { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 }, { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -6, -10, 11, 12, 20, 14 },  { -10, -6, -28, 20, 12, 14 }, { -6, -10, -28, 12, 20, 14 },
    },
    {
        // 0x0098FFAC:
        { -3, -6, -1, 6, 12, 1 },     { -3, -5, -1, 6, 10, 1 },     { -5, -5, -1, 10, 10, 1 },    { -5, -3, -1, 10, 6, 1 },
        { -6, -3, -1, 12, 6, 1 },     { -5, -3, -1, 10, 6, 1 },     { -5, -5, -1, 10, 10, 1 },    { -3, -5, -1, 6, 10, 1 },
        { -3, -6, -1, 6, 12, 1 },     { -3, -5, -1, 6, 10, 1 },     { -5, -5, -1, 10, 10, 1 },    { -5, -3, -1, 10, 6, 1 },
        { -6, -3, -1, 12, 6, 1 },     { -5, -3, -1, 10, 6, 1 },     { -5, -5, -1, 10, 10, 1 },    { -3, -5, -1, 6, 10, 1 },
        { -3, -6, -8, 6, 12, 1 },     { -3, -6, -1, 6, 12, 1 },     { -8, -8, -1, 16, 16, 1 },    { -6, -3, -1, 12, 6, 1 },
        { -6, -3, 0, 12, 6, 1 },      { -6, -3, -1, 12, 6, 1 },     { -8, -8, -1, 16, 16, 1 },    { -3, -6, -1, 6, 12, 1 },
        { -3, -6, 0, 6, 12, 1 },      { -3, -6, -1, 6, 12, 1 },     { -8, -8, -1, 16, 16, 1 },    { -6, -3, -1, 12, 6, 1 },
        { -6, -3, -8, 12, 6, 1 },     { -6, -3, -1, 12, 6, 1 },     { -8, -8, -1, 16, 16, 1 },    { -3, -6, -1, 6, 12, 1 },
        { -3, -6, -10, 6, 12, 1 },    { -8, -8, -2, 16, 16, 1 },    { -6, -3, -2, 12, 6, 1 },     { -8, -8, -2, 16, 16, 1 },
        { -3, -6, -2, 6, 12, 1 },     { -8, -8, -2, 16, 16, 1 },    { -6, -3, -10, 12, 6, 1 },    { 0, 0, -2, 8, 8, 1 },
        { -3, -6, -12, 6, 12, 1 },    { -8, -6, -6, 16, 12, 1 },    { -8, -8, -6, 16, 16, 1 },    { -6, -8, -6, 12, 16, 1 },
        { -6, -3, -2, 12, 6, 1 },     { -6, -8, -6, 12, 16, 1 },    { -8, -8, -6, 16, 16, 1 },    { -8, -6, -6, 16, 12, 1 },
        { -3, -6, -2, 6, 12, 1 },     { -8, -6, -6, 16, 12, 1 },    { -8, -8, -6, 16, 16, 1 },    { -6, -8, -6, 12, 16, 1 },
        { -6, -3, -12, 12, 6, 1 },    { -6, -8, -6, 12, 16, 1 },    { -8, -8, -6, 16, 16, 1 },    { -8, -6, -6, 16, 12, 1 },
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -16, -6, 1, 32, 12, 14 },   { -12, -6, 1, 24, 12, 14 },   { -10, -10, 1, 20, 20, 14 },  { -6, -12, 1, 12, 24, 14 },
        { -6, -16, 1, 12, 32, 14 },   { -6, -12, 1, 12, 24, 14 },   { -10, -10, 1, 20, 20, 14 },  { -12, -6, 1, 24, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -14, -6, 5, 28, 12, 9 },    { -11, -6, 1, 22, 12, 14 },   { -8, -8, 1, 16, 16, 14 },    { -6, -11, 1, 12, 22, 14 },
        { -6, -14, 5, 12, 28, 9 },    { -6, -11, 1, 12, 22, 14 },   { -8, -8, 1, 16, 16, 14 },    { -11, -6, 1, 22, 12, 14 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },    { -6, -6, -4, 12, 12, 1 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -8, -6, -28, 16, 12, 14 },  { -8, -6, -28, 16, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -8, -28, 12, 16, 14 },
        { -6, -8, -28, 12, 16, 14 },  { -6, -8, -28, 12, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -6, -28, 16, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -9, -6, -28, 18, 12, 14 },  { -8, -8, -28, 16, 16, 14 },  { -6, -9, -28, 12, 18, 14 },
        { -6, -6, -28, 12, 12, 14 },  { -6, -9, -28, 12, 18, 14 },  { -8, -8, -28, 16, 16, 14 },  { -9, -6, -28, 18, 12, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -8, -8, -28, 16, 16, 14 },  { -6, -11, -33, 3, 16, 19 },  { -8, -8, -28, 16, 16, 14 },
        { -11, -6, -33, 16, 5, 19 },  { -8, -8, -28, 16, 16, 14 },  { -6, -10, -28, 12, 16, 14 }, { -8, -8, -28, 16, 16, 14 },
        { -10, -6, -28, 16, 12, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -3, -10, -39, 3, 16, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -39, 16, 3, 27 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -6, -10, -28, 12, 16, 14 }, { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },  { -6, -6, -28, 12, 12, 14 },
        { -10, -6, -28, 20, 12, 14 }, { -2, -3, -39, 3, 10, 29 },   { -3, -2, -39, 10, 3, 29 },   { -6, -10, -28, 12, 20, 14 },
        { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },  { -10, -6, -49, 5, 12, 34 },
        { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },    { -2, 4, -39, 3, 10, 29 },
        { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },  { -13, -6, -39, 20, 5, 24 },
        { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 }, { -6, -15, -28, 12, 10, 14 },
        { -10, -6, -39, 4, 12, 24 },  { -2, 4, -10, 3, 10, 24 },    { -3, -6, -39, 10, 5, 24 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -28, 3, 12, 14 },  { -6, 0, -10, 3, 10, 24 },    { -3, -6, -28, 10, 5, 14 },   { -6, -15, -10, 12, 10, 14 },
        { -10, -6, -44, 20, 12, 7 },  { -6, 0, -5, 12, 10, 7 },     { 0, -6, -34, 10, 12, 7 },    { -6, -15, -5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, 0, 5, 12, 10, 7 },      { 0, -6, 5, 10, 12, 7 },      { -6, -10, 5, 12, 10, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },    { -10, -6, 5, 20, 12, 7 },    { -6, -10, 5, 12, 20, 7 },
        { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },  { -8, -8, -28, 16, 16, 14 },
    },
    {
        // 0x0099273C:
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
        { -6, -6, 0, 12, 12, 31 },
    }
};

// Opposite Pitch values for reversed cars
const uint8_t PitchInvertTable[] = {
    0,                                                                              // Flat Track
    5,  6,  7,  8,  1,  2,  3,  4,                                                  // Slopes 1
    17, 18, 19, 20, 21, 22, 23, 16, 9,  10, 11, 12, 13, 14, 15,                     // Vertical Loop
    29, 30, 31, 32, 33, 24, 25, 26, 27, 28, 39, 40, 41, 42, 43, 34, 35, 36, 37, 38, // Corkscrews
    0,  0,  0,  0,  0,  0,                                                          // Helices
    53, 54, 55, 50, 51, 52,                                                         // Slopes 2
    56, 57, 58,                                                                     // Zero-G Rolls
    60, 59                                                                          // Spiral Lift Hills
};

// Opposite Bank values for reversed cars
const uint8_t BankInvertTable[] = { 0, 3, 4, 1, 2, 10, 11, 12, 13, 14, 5, 6, 7, 8, 9, 15, 18, 19, 16, 17 };

#pragma endregion

#pragma region VehiclePaintUtil

static void PaintVehicleRiders(
    PaintSession& session, const Vehicle* vehicle, const CarEntry* carEntry, uint32_t baseImageId, int32_t z,
    const VehicleBoundBox& bb)
{
    baseImageId += carEntry->NumCarImages;
    for (auto i = 0; i < 8; i++)
    {
        if (vehicle->num_peeps > (i * 2) && carEntry->no_seating_rows > i)
        {
            auto offsetImageId = baseImageId;
            if (i == 0 && (carEntry->flags & CAR_ENTRY_FLAG_RIDER_ANIMATION))
            {
                offsetImageId += (carEntry->NumCarImages * vehicle->animation_frame);
            }

            auto peepColour0 = vehicle->peep_tshirt_colours[i * 2];
            auto peepColour1 = vehicle->peep_tshirt_colours[(i * 2) + 1];
            auto imageId = ImageId(offsetImageId, peepColour0, peepColour1);
            if (vehicle->IsGhost())
            {
                imageId = ImageId(offsetImageId).WithRemap(FilterPaletteID::PaletteGhost);
            }

            PaintAddImageAsChild(
                session, imageId, { 0, 0, z },
                { { bb.offset_x, bb.offset_y, bb.offset_z + z }, { bb.length_x, bb.length_y, bb.length_z } });
            baseImageId += carEntry->NumCarImages;
        }
    }
}

// 6D5214
static void vehicle_sprite_paint(
    PaintSession& session, const Vehicle* vehicle, int32_t spriteNum, const VehicleBoundBox& bb, int32_t z,
    const CarEntry* carEntry)
{
    if (carEntry->draw_order >= std::size(VehicleBoundboxes))
    {
        return;
    }

    auto baseImageId = static_cast<uint32_t>(spriteNum);
    if (carEntry->flags & CAR_ENTRY_FLAG_SPINNING_ADDITIONAL_FRAMES)
    {
        baseImageId += (vehicle->spin_sprite / 8) & 31;
    }
    if (carEntry->flags & CAR_ENTRY_FLAG_VEHICLE_ANIMATION)
    {
        baseImageId += vehicle->animation_frame;
    }

    auto imageId = ImageId(baseImageId, vehicle->colours.Body, vehicle->colours.Trim, vehicle->colours.Tertiary);
    if (vehicle->IsGhost())
    {
        imageId = ImageId(baseImageId).WithRemap(FilterPaletteID::PaletteGhost);
    }
    PaintAddImageAsParent(
        session, imageId, { 0, 0, z },
        { { bb.offset_x, bb.offset_y, bb.offset_z + z }, { bb.length_x, bb.length_y, bb.length_z } });

    auto* dpi = &session.DPI;
    if (dpi->zoom_level < ZoomLevel{ 2 } && vehicle->num_peeps > 0 && carEntry->no_seating_rows > 0)
    {
        PaintVehicleRiders(session, vehicle, carEntry, baseImageId, z, bb);
    }
    VehicleVisualSplashEffect(session, z, vehicle, carEntry);
}

// 6D520E
static void VehicleSpritePaintWithSwinging(
    PaintSession& session, const Vehicle* vehicle, int32_t spriteNum, int32_t boundingBoxNum, int32_t z,
    const CarEntry* carEntry)
{
    vehicle_sprite_paint(
        session, vehicle, spriteNum + vehicle->SwingSprite, VehicleBoundboxes[carEntry->draw_order][boundingBoxNum], z,
        carEntry);
}

static void VehicleSpritePaintRestraints(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    int32_t boundingBoxNum = YawTo16(imageDirection);
    auto restraintFrame = ((vehicle->restraints_position - 64) / 64);
    auto spriteNum = carEntry->SpriteOffset(SpriteGroupType::RestraintAnimation, imageDirection, restraintFrame);
    vehicle_sprite_paint(session, vehicle, spriteNum, VehicleBoundboxes[carEntry->draw_order][boundingBoxNum], z, carEntry);
}

// Returns the opposite of the bank angle for reversed cars, normal bank angle otherwise
static uint8_t GetPaintBankRotation(const Vehicle* vehicle)
{
    return (vehicle->HasFlag(VehicleFlags::CarIsReversed)) ? BankInvertTable[vehicle->bank_rotation] : vehicle->bank_rotation;
}

#pragma endregion

#pragma region FlatSlope

// 6D51DE
static void VehiclePitchFlatUnbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // Restraint animations are only drawn for vehicles that are in a cardinal direction (north, east, south, west)
    if (vehicle->restraints_position >= 64 && carEntry->GroupEnabled(SpriteGroupType::RestraintAnimation)
        && (imageDirection & 7) == 0)
    {
        VehicleSpritePaintRestraints(session, vehicle, imageDirection, z, carEntry);
        return;
    }
    int32_t boundingBoxNum = YawTo16(imageDirection);
    auto spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopeFlat, imageDirection, 0);
    VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
}

// 6D4EE7
static void VehiclePitchFlatBankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4F34
static void VehiclePitchFlatBankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection) + 108;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4F0C
static void VehiclePitchFlatBankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4F5C
static void VehiclePitchFlatBankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked45))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection) ^ 8) + 108;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4F84
static void VehiclePitchFlatBankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked67))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 124;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked67, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4FE4
static void VehiclePitchFlatBankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked90))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 128;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D5055
static void VehiclePitchFlatBankedLeft112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 132;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D50C6
static void VehiclePitchFlatBankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 136;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D5137
static void VehiclePitchFlatBankedLeft157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 140;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 4);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4FB1
static void VehiclePitchFlatBankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked67))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 124;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked67, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D501B
static void VehiclePitchFlatBankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::FlatBanked90))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 128;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::FlatBanked90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D508C
static void VehiclePitchFlatBankedRight112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 132;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D50FD
static void VehiclePitchFlatBankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 136;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D516E
static void VehiclePitchFlatBankedRight157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 140;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::InlineTwists, imageDirection, 5);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4EE4
static void VehiclePitchUninvertedFlatBankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    carEntry--;
    VehiclePitchFlatBankedLeft22(session, vehicle, imageDirection, z, carEntry);
}

// 6D4F31
static void VehiclePitchUninvertedFlatBankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    carEntry--;
    VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
}

// 6D4F09
static void VehiclePitchUninvertedFlatBankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    carEntry--;
    VehiclePitchFlatBankedRight22(session, vehicle, imageDirection, z, carEntry);
}

// 6D4F59
static void VehiclePitchUninvertedFlatBankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    carEntry--;
    VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry);
}

// 6D51D7
static void VehiclePitchFlat(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // 0x009A3DE4:
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchFlatBankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchFlatBankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchFlatBankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 5:
            VehiclePitchFlatBankedLeft67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 6:
            VehiclePitchFlatBankedLeft90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 7:
            VehiclePitchFlatBankedLeft112(session, vehicle, imageDirection, z, carEntry);
            break;
        case 8:
            VehiclePitchFlatBankedLeft135(session, vehicle, imageDirection, z, carEntry);
            break;
        case 9:
            VehiclePitchFlatBankedLeft157(session, vehicle, imageDirection, z, carEntry);
            break;
        case 10:
            VehiclePitchFlatBankedRight67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 11:
            VehiclePitchFlatBankedRight90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 12:
            VehiclePitchFlatBankedRight112(session, vehicle, imageDirection, z, carEntry);
            break;
        case 13:
            VehiclePitchFlatBankedRight135(session, vehicle, imageDirection, z, carEntry);
            break;
        case 14:
            VehiclePitchFlatBankedRight157(session, vehicle, imageDirection, z, carEntry);
            break;
        case 15:
            // what is roll 15?
            VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 16:
            VehiclePitchUninvertedFlatBankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 17:
            VehiclePitchUninvertedFlatBankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 18:
            VehiclePitchUninvertedFlatBankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 19:
            VehiclePitchUninvertedFlatBankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}

#pragma endregion

#pragma region GentleSlopesUp

#pragma region SlopeUp12

// 6D4614
static void VehiclePitchUp12Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4662
static void VehiclePitchUp12BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D46DB
static void VehiclePitchUp12BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp12BankedLeft22(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D467D
static void VehiclePitchUp12BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D46FD
static void VehiclePitchUp12BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp12BankedRight22(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D460D
static void VehiclePitchUp12(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // 0x009A3C04:
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchUp12BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchUp12BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchUp12BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchUp12BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 16:
            VehiclePitchUp12BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 17:
            VehiclePitchUp12BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 18:
            VehiclePitchUp12BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 19:
            VehiclePitchUp12BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchUp12Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region SlopeUp25

// 6D4791
static void VehiclePitchUp25Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection)) + 16;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4833
static void VehiclePitchUp25BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection) + 16;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D48D6
static void VehiclePitchUp25BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxNum += 108;
        else
            boundingBoxNum += 16;

        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4858
static void VehiclePitchUp25BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection) + 16;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4910
static void VehiclePitchUp25BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxNum = (boundingBoxNum ^ 8) + 108;
        else
            boundingBoxNum += 16;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 124;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 128;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedLeft112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 132;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 136;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 4);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedLeft157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 140;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 8);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 124;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 128;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedRight112(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 132;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 136;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 5);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp25BankedRight157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 140;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 9);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D476C
static void VehiclePitchUp25(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // 0x009A3CA4:
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchUp25BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchUp25BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 5:
            VehiclePitchUp25BankedLeft67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 6:
            VehiclePitchUp25BankedLeft90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 7:
            VehiclePitchUp25BankedLeft112(session, vehicle, imageDirection, z, carEntry);
            break;
        case 8:
            VehiclePitchUp25BankedLeft135(session, vehicle, imageDirection, z, carEntry);
            break;
        case 9:
            VehiclePitchUp25BankedLeft157(session, vehicle, imageDirection, z, carEntry);
            break;
        case 10:
            VehiclePitchUp25BankedRight67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 11:
            VehiclePitchUp25BankedRight90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 12:
            VehiclePitchUp25BankedRight112(session, vehicle, imageDirection, z, carEntry);
            break;
        case 13:
            VehiclePitchUp25BankedRight135(session, vehicle, imageDirection, z, carEntry);
            break;
        case 14:
            VehiclePitchUp25BankedRight157(session, vehicle, imageDirection, z, carEntry);
            break;
        case 15:
            VehiclePitchUp25Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 16:
            VehiclePitchUp25BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 17:
            VehiclePitchUp25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 18:
            VehiclePitchUp25BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 19:
            VehiclePitchUp25BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}

#pragma endregion

#pragma endregion

#pragma region SteepSlopesUp

// 6D49DC
static void VehiclePitchUp42Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp42BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D49DC
static void VehiclePitchUp42(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchUp42BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchUp42BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchUp42BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchUp42BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 5:
            VehiclePitchUp42BankedLeft67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 6:
            VehiclePitchUp42BankedLeft90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 10:
            VehiclePitchUp42BankedRight67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 11:
            VehiclePitchUp42BankedRight90(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchUp42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4A31
static void VehiclePitchUp60Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection)) + 40;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes60, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp25(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp60BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection)) + 40;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp60BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection)) + 40;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp60(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchUp60BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchUp60BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchUp60Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region GentleSlopesDown

#pragma region SlopeDown12

// 6D463D
static void VehiclePitchDown12Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D469B
static void VehiclePitchDown12BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4722
static void VehiclePitchDown12BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown12BankedLeft22(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D46B9
static void VehiclePitchDown12BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4747
static void VehiclePitchDown12BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes12Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes12Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown12BankedRight22(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4636
static void VehiclePitchDown12(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // 0x009A3C54:
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchDown12BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchDown12BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchDown12BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchDown12BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 5:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 6:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 7:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 8:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 9:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 10:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 11:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 12:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 13:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 14:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 15:
            VehiclePitchDown12Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 16:
            VehiclePitchDown12BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 17:
            VehiclePitchDown12BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 18:
            VehiclePitchDown12BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 19:
            VehiclePitchDown12BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}
#pragma endregion

#pragma region Down25

#pragma endregion

#pragma region SlopeDown25

// 6D47E4
static void VehiclePitchDown25Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25))
    {
        int32_t boundingBoxNum = ((YawTo16(imageDirection)) ^ 8) + 16;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4880
static void VehiclePitchDown25BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        int32_t boundingBoxNum = ((YawTo16(imageDirection)) ^ 8) + 16;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4953
static void VehiclePitchDown25BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxNum += 108;
        else
            boundingBoxNum = (boundingBoxNum ^ 8) + 16;

        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D48AB
static void VehiclePitchDown25BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked22))
    {
        int32_t boundingBoxNum = ((YawTo16(imageDirection)) ^ 8) + 16;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4996
static void VehiclePitchDown25BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        if (carEntry->draw_order < 5)
            boundingBoxNum = (boundingBoxNum ^ 8) + 108;
        else
            boundingBoxNum = (boundingBoxNum ^ 8) + 16;

        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 124;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 128;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedLeft11BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 132;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedLeft135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 136;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 6);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedLeft157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = YawTo4(imageDirection) + 140;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 10);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked67))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 124;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked67, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25Banked90))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 128;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25Banked90, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedRight11BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 132;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedRight135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 136;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 7);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown25BankedRight157(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes25InlineTwists))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection) ^ 2) + 140;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes25InlineTwists, imageDirection, 11);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D47DD
static void VehiclePitchDown25(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // 0x009A3CF4:
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchDown25BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchDown25BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 5:
            VehiclePitchDown25BankedLeft67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 6:
            VehiclePitchDown25BankedLeft90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 7:
            VehiclePitchDown25BankedLeft11BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 8:
            VehiclePitchDown25BankedLeft135(session, vehicle, imageDirection, z, carEntry);
            break;
        case 9:
            VehiclePitchDown25BankedLeft157(session, vehicle, imageDirection, z, carEntry);
            break;
        case 10:
            VehiclePitchDown25BankedRight67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 11:
            VehiclePitchDown25BankedRight90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 12:
            VehiclePitchDown25BankedRight11BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 13:
            VehiclePitchDown25BankedRight135(session, vehicle, imageDirection, z, carEntry);
            break;
        case 14:
            VehiclePitchDown25BankedRight157(session, vehicle, imageDirection, z, carEntry);
            break;
        case 15:
            VehiclePitchDown25Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 16:
            VehiclePitchDown25BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 17:
            VehiclePitchDown25BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 18:
            VehiclePitchDown25BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 19:
            VehiclePitchDown25BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}

#pragma endregion

#pragma endregion

#pragma region SteepSlopesDown

// 6D4A05
static void VehiclePitchDown42Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42))
    {
        int32_t boundingBoxNum = ((YawTo8(imageDirection)) ^ 4) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked22))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked45))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedLeft67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedLeft90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedRight67(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked67))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked67, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42BankedRight90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes42Banked90))
    {
        int32_t boundingBoxNum = (YawTo8(imageDirection)) + 32;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes42Banked90, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown42(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchDown42BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchDown42BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchDown42BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchDown42BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 5:
            VehiclePitchDown42BankedLeft67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 6:
            VehiclePitchDown42BankedLeft90(session, vehicle, imageDirection, z, carEntry);
            break;
        case 10:
            VehiclePitchDown42BankedRight67(session, vehicle, imageDirection, z, carEntry);
            break;
        case 11:
            VehiclePitchDown42BankedRight90(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchDown42Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4A59
static void VehiclePitchDown60Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60))
    {
        int32_t boundingBoxNum = ((YawTo16(imageDirection)) ^ 8) + 40;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes60, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown25(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown60BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection)) + 40;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown60BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes60Banked22))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection)) + 40;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes60Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown60(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchDown60BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchDown60BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchDown60Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region VerticalSlopesUp

// 6D4A81
static void VehiclePitchUp75(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes75))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + 56;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes75, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4AE8
static void VehiclePitchUp90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        int32_t boundingBoxNum = (YawTo16(imageDirection)) + 60;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes90, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region LoopSlopesUp

// 6D4B57
static void VehiclePitchUp105(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + 76;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4BB7
static void VehiclePitchUp120(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + 80;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4C17
static void VehiclePitchUp135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + 84;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 4);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4C77
static void VehiclePitchUp150(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + 88;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 6);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4CD7
static void VehiclePitchUp165(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + 92;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 8);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region InvertedSlope

// 6D4D37
static void VehiclePitchInverted(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::SlopeInverted))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + 96;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopeInverted, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp60(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region VerticalSlopesDown

// 6D4AA3
static void VehiclePitchDown75(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        if (vehicle->GetTrackType() != TrackElemType::Down90ToDown60
            && (vehicle->GetTrackType()) != TrackElemType::Down60ToDown90)
        {
            carEntry--;
        }
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes75))
    {
        int32_t boundingBoxNum = ((YawTo4(imageDirection)) ^ 2) + 56;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes75, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4B0D
static void VehiclePitchDown90(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        if (vehicle->GetTrackType() != TrackElemType::Down90 && (vehicle->GetTrackType()) != TrackElemType::Down90ToDown60
            && (vehicle->GetTrackType()) != TrackElemType::Down60ToDown90)
        {
            carEntry--;
        }
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        int32_t boundingBoxNum = ((YawTo16(imageDirection)) ^ 8) + 60;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes90, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region LoopSlopesDown

// 6D4B80
static void VehiclePitchDown105(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        int32_t boundingBoxNum = ((YawTo4(imageDirection)) ^ 2) + 76;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4BE0
static void VehiclePitchDown120(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes90))
    {
        int32_t boundingBoxNum = ((YawTo4(imageDirection)) ^ 2) + 80;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4C40
static void VehiclePitchDown135(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = ((YawTo4(imageDirection)) ^ 2) + 84;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 5);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4CA0
static void VehiclePitchDown150(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = ((YawTo4(imageDirection)) ^ 2) + 88;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 7);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4D00
static void VehiclePitchDown165(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::SlopesLoop))
    {
        int32_t boundingBoxNum = ((YawTo4(imageDirection)) ^ 2) + 92;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::SlopesLoop, imageDirection, 9);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region CorkscrewSlopes

// 6D51A5
template<int32_t corkscrewFrame>
void VehiclePitchCorkscrew(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (vehicle->HasFlag(VehicleFlags::CarIsInverted))
    {
        carEntry--;
    }
    if (carEntry->GroupEnabled(SpriteGroupType::Corkscrews))
    {
        int32_t boundingBoxNum = (YawTo4(imageDirection)) + corkscrewFrame * 4 + 144;
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Corkscrews, imageDirection, corkscrewFrame);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlatUnbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma region DiagonalSlopesUp

#pragma region SlopeUp8

// 6D4D67
static void VehiclePitchUp8Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4DB5
static void VehiclePitchUp8BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4DD3
static void VehiclePitchUp8BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp8BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp8BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4D60
static void VehiclePitchUp8(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // 0x009A3D44:
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
        case 16:
            VehiclePitchUp8BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
        case 18:
            VehiclePitchUp8BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchUp8BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchUp8BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchUp8Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}

#pragma endregion

#pragma region SlopeUp16

// 6D4E3A
static void VehiclePitchUp16Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp16BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp16Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp16BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp16Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp16BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp16BankedLeft22(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp16BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchUp16BankedRight22(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchUp16(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchUp16Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchUp16BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchUp16BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchUp16BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchUp16BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchUp16Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}

#pragma endregion

#pragma region SlopeUp50

// 6D4E8F
static void VehiclePitchUp50(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes50, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma endregion

#pragma region DiagonalSlopesDown

#pragma region SlopeDown8

// 6D4D90
static void VehiclePitchDown8Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4DF4
static void VehiclePitchDown8BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4E15
static void VehiclePitchDown8BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown8BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown8BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes8Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes8Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

// 6D4D89
static void VehiclePitchDown8(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    // 0x009A3D94:
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchDown8Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
        case 16:
            VehiclePitchDown8BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
        case 18:
            VehiclePitchDown8BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchDown8BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchDown8BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchDown8Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}

#pragma endregion

#pragma region SlopeDown16

// 6D4E63
static void VehiclePitchDown16Unbanked(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown16BankedLeft22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown16Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown16BankedRight22(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked22))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked22, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown16Unbanked(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown16BankedLeft45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 2);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown16BankedLeft22(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown16BankedRight45(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes16Banked45))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes16Banked45, imageDirection, 3);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchDown16BankedRight22(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchDown16(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    switch (GetPaintBankRotation(vehicle))
    {
        case 0:
            VehiclePitchDown16Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
        case 1:
            VehiclePitchDown16BankedLeft22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 3:
            VehiclePitchDown16BankedRight22(session, vehicle, imageDirection, z, carEntry);
            break;
        case 2:
            VehiclePitchDown16BankedLeft45(session, vehicle, imageDirection, z, carEntry);
            break;
        case 4:
            VehiclePitchDown16BankedRight45(session, vehicle, imageDirection, z, carEntry);
            break;
        default:
            VehiclePitchDown16Unbanked(session, vehicle, imageDirection, z, carEntry);
            break;
    }
}

#pragma endregion

#pragma region SlopeDown50

// 6D4EB8
static void VehiclePitchDown50(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::Slopes50))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::Slopes50, imageDirection, 1);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

#pragma endregion

#pragma region InvertingSlopesDown

// 6D47DA
static void VehiclePitchInvertingDown25(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    carEntry--;
    VehiclePitchDown25(session, vehicle, imageDirection, z, carEntry);
}

// 6D4A02
static void VehiclePitchInvertingDown42(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    carEntry--;
    VehiclePitchDown42(session, vehicle, imageDirection, z, carEntry);
}

// 6D4A56
static void VehiclePitchInvertingDown60(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    carEntry--;
    VehiclePitchDown60(session, vehicle, imageDirection, z, carEntry);
}

#pragma endregion

#pragma region SpiralLiftSlopes

// 6D4773
static void VehiclePitchSpiralLiftUp(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::CurvedLiftHillUp))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::CurvedLiftHillUp, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

static void VehiclePitchSpiralLiftDown(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry)
{
    if (carEntry->GroupEnabled(SpriteGroupType::CurvedLiftHillDown))
    {
        int32_t boundingBoxNum = YawTo16(imageDirection);
        int32_t spriteNum = carEntry->SpriteOffset(SpriteGroupType::CurvedLiftHillDown, imageDirection, 0);
        VehicleSpritePaintWithSwinging(session, vehicle, spriteNum, boundingBoxNum, z, carEntry);
    }
    else
    {
        VehiclePitchFlat(session, vehicle, imageDirection, z, carEntry);
    }
}

#pragma endregion

// 0x009A3B14:
using vehicle_sprite_func = void (*)(
    PaintSession& session, const Vehicle* vehicle, int32_t imageDirection, int32_t z, const CarEntry* carEntry);

// clang-format off
static constexpr vehicle_sprite_func PaintFunctionsByPitch[] = {
    VehiclePitchFlat,
    VehiclePitchUp12,
    VehiclePitchUp25,
    VehiclePitchUp42,
    VehiclePitchUp60,
    VehiclePitchDown12,
    VehiclePitchDown25,
    VehiclePitchDown42,
    VehiclePitchDown60,
    VehiclePitchUp75,
    VehiclePitchUp90,
    VehiclePitchUp105,
    VehiclePitchUp120,
    VehiclePitchUp135,
    VehiclePitchUp150,
    VehiclePitchUp165,
    VehiclePitchInverted,
    VehiclePitchDown75,
    VehiclePitchDown90,
    VehiclePitchDown105,
    VehiclePitchDown120,
    VehiclePitchDown135,
    VehiclePitchDown150,
    VehiclePitchDown165,
    VehiclePitchCorkscrew<0>,
    VehiclePitchCorkscrew<1>,
    VehiclePitchCorkscrew<2>,
    VehiclePitchCorkscrew<3>,
    VehiclePitchCorkscrew<4>,
    VehiclePitchCorkscrew<5>,
    VehiclePitchCorkscrew<6>,
    VehiclePitchCorkscrew<7>,
    VehiclePitchCorkscrew<8>,
    VehiclePitchCorkscrew<9>,
    VehiclePitchCorkscrew<10>,
    VehiclePitchCorkscrew<11>,
    VehiclePitchCorkscrew<12>,
    VehiclePitchCorkscrew<13>,
    VehiclePitchCorkscrew<14>,
    VehiclePitchCorkscrew<15>,
    VehiclePitchCorkscrew<16>,
    VehiclePitchCorkscrew<17>,
    VehiclePitchCorkscrew<18>,
    VehiclePitchCorkscrew<19>,
    VehiclePitchFlat, // Half Helix Up Large
    VehiclePitchFlat, // Half Helix Up Small
    VehiclePitchFlat, // Half Helix Down Large
    VehiclePitchFlat, // Half Helix Down Small
    VehiclePitchFlat, // Quarter Helix Up
    VehiclePitchFlat, // Quarter Helix Down
    VehiclePitchUp8,
    VehiclePitchUp16,
    VehiclePitchUp50,
    VehiclePitchDown8,
    VehiclePitchDown16,
    VehiclePitchDown50,
    VehiclePitchInvertingDown25,
    VehiclePitchInvertingDown42,
    VehiclePitchInvertingDown60,
    VehiclePitchSpiralLiftUp,
    VehiclePitchSpiralLiftDown,
};
// clang-format on

#pragma region SplashEffects

/**
 *
 *  rct2: 0x006D5600
 */
static void vehicle_visual_splash1_effect(PaintSession& session, int32_t z, const Vehicle* vehicle)
{
    if (vehicle->GetTrackType() != TrackElemType::Watersplash)
    {
        return;
    }
    if (vehicle->track_progress < 48)
    {
        return;
    }
    if (vehicle->track_progress >= 112)
    {
        return;
    }
    if (vehicle->TrainHead()->velocity <= 5.0_mph)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_1_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((GetGameState().CurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 0, 0, 0 } });
}

/**
 *
 *  rct2: 0x006D5696
 */
static void vehicle_visual_splash2_effect(PaintSession& session, int32_t z, const Vehicle* vehicle)
{
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->Pitch != 0)
    {
        return;
    }
    if (vehicle->velocity <= 5.0_mph)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_3_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((GetGameState().CurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 0, 0, 0 } });
}

/**
 *
 *  rct2: 0x006D57EE
 */
static void vehicle_visual_splash3_effect(PaintSession& session, int32_t z, const Vehicle* vehicle)
{
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->Pitch != 0)
    {
        return;
    }
    if (vehicle->velocity <= 5.0_mph)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_1_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((GetGameState().CurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 0, 0, 0 } });
}

/**
 *
 *  rct2: 0x006D5783
 */
static void vehicle_visual_splash4_effect(PaintSession& session, int32_t z, const Vehicle* vehicle)
{
    Vehicle* vehicle2 = GetEntity<Vehicle>(vehicle->prev_vehicle_on_ride);
    if (vehicle2 == nullptr)
    {
        return;
    }
    if (vehicle2->velocity <= 5.0_mph)
    {
        return;
    }
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->Pitch != 0)
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_5_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((GetGameState().CurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 1, 1, 0 } });
}

/**
 *
 *  rct2: 0x006D5701
 */
static void vehicle_visual_splash5_effect(PaintSession& session, int32_t z, const Vehicle* vehicle)
{
    Vehicle* vehicle2 = GetEntity<Vehicle>(vehicle->prev_vehicle_on_ride);
    if (vehicle2 == nullptr)
    {
        return;
    }
    if (vehicle2->velocity <= 5.0_mph)
    {
        return;
    }
    if (vehicle->Orientation & 7)
    {
        return;
    }
    if (vehicle->Pitch != 0)
    {
        return;
    }
    if (!TrackElementIsCovered(vehicle->GetTrackType()))
    {
        return;
    }
    int32_t image_id = SPR_SPLASH_EFFECT_5_NE_0 + ((((vehicle->Orientation / 8) + session.CurrentRotation) & 3) * 8)
        + ((GetGameState().CurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, ImageId(image_id), { 0, 0, z }, { { 0, 0, z }, { 1, 1, 0 } });
}

void VehicleVisualSplashEffect(PaintSession& session, int32_t z, const Vehicle* vehicle, const CarEntry* carEntry)
{
    switch (carEntry->effect_visual)
    {
        case VEHICLE_VISUAL_SPLASH1_EFFECT:
            vehicle_visual_splash1_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH2_EFFECT:
            vehicle_visual_splash2_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH3_EFFECT:
            vehicle_visual_splash3_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH4_EFFECT:
            vehicle_visual_splash4_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH5_EFFECT:
            vehicle_visual_splash5_effect(session, z, vehicle);
            break;
    }
}

#pragma endregion

/**
 *
 *  rct2: 0x006D45F8
 */
void VehicleVisualDefault(
    PaintSession& session, int32_t imageDirection, int32_t z, const Vehicle* vehicle, const CarEntry* carEntry)
{
    if (vehicle->Pitch < std::size(PaintFunctionsByPitch))
    {
        if (vehicle->HasFlag(VehicleFlags::CarIsReversed))
        {
            auto imagePitch = PitchInvertTable[vehicle->Pitch];
            auto imageYaw = (imageDirection + (OpenRCT2::Entity::Yaw::BaseRotation / 2))
                & (OpenRCT2::Entity::Yaw::BaseRotation - 1);
            PaintFunctionsByPitch[imagePitch](session, vehicle, imageYaw, z, carEntry);
        }
        else
        {
            PaintFunctionsByPitch[vehicle->Pitch](session, vehicle, imageDirection, z, carEntry);
        }
    }
}

void Vehicle::Paint(PaintSession& session, int32_t imageDirection) const
{
    const CarEntry* carEntry;

    if (HasFlag(VehicleFlags::Crashed))
    {
        PaintAddImageAsParent(
            session, ImageId(SPR_WATER_PARTICLES_DENSE_0 + animation_frame), { 0, 0, z }, { { 0, 0, z + 2 }, { 1, 1, 0 } });
        return;
    }

    int32_t zOffset = 0;
    if (IsCableLift())
    {
        carEntry = &CableLiftVehicle;
    }
    else
    {
        auto rideEntry = GetRideEntry();
        if (rideEntry == nullptr)
        {
            return;
        }

        auto carEntryIndex = vehicle_type;
        if (HasFlag(VehicleFlags::CarIsInverted))
        {
            carEntryIndex++;
            zOffset += 16;
        }

        if (carEntryIndex >= std::size(rideEntry->Cars))
        {
            return;
        }
        carEntry = &rideEntry->Cars[carEntryIndex];
    }

    switch (carEntry->PaintStyle)
    {
        case VEHICLE_VISUAL_DEFAULT:
            VehicleVisualDefault(session, imageDirection, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_LAUNCHED_FREEFALL:
            VehicleVisualLaunchedFreefall(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_OBSERVATION_TOWER:
            VehicleVisualObservationTower(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_RIVER_RAPIDS:
            VehicleVisualRiverRapids(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_MINI_GOLF_PLAYER:
            VehicleVisualMiniGolfPlayer(session, x, imageDirection, y, z + zOffset, this);
            break;
        case VEHICLE_VISUAL_MINI_GOLF_BALL:
            VehicleVisualMiniGolfBall(session, x, imageDirection, y, z + zOffset, this);
            break;
        case VEHICLE_VISUAL_REVERSER:
            VehicleVisualReverser(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_SPLASH_BOATS_OR_WATER_COASTER:
            VehicleVisualSplashBoatsOrWaterCoaster(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_ROTO_DROP:
            VehicleVisualRotoDrop(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_VIRGINIA_REEL:
            VehicleVisualVirginiaReel(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
        case VEHICLE_VISUAL_SUBMARINE:
            VehicleVisualSubmarine(session, x, imageDirection, y, z + zOffset, this, carEntry);
            break;
    }
}
