package test;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class MyLogger {

	public static void main(String[] args) {

		Logger logger = Logger.getLogger("MyLog");
		FileHandler fh;

		try {

			String logName = "MyLogFile.log";
			// This block configure the logger with handler and formatter
			fh = new FileHandler(logName, true);
			logger.addHandler(fh);
			logger.setLevel(Level.ALL);
			SimpleFormatter formatter = new SimpleFormatter();
			fh.setFormatter(formatter);

			// the following statement is used to log any messages
			logger.log(Level.WARNING, "My first log");

			deleteFile(logName);

		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}// END: main

	public static void deleteFile(String filename) {

		File f = new File(filename);

		// Make sure the file or directory exists and isn't write protected
		if (!f.exists()) {
			throw new IllegalArgumentException(
					"Delete: no such file or directory: " + filename);
		}

		if (!f.canWrite()) {
			throw new IllegalArgumentException("Delete: write protected: "
					+ filename);
		}

		// If it is a directory, make sure it is empty
		if (f.isDirectory()) {
			String[] files = f.list();
			if (files.length > 0)
				throw new IllegalArgumentException(
						"Delete: directory not empty: " + filename);
		}

		// Attempt to delete it
		boolean success = f.delete();

		if (!success) {
			throw new IllegalArgumentException("Delete: deletion failed");
		}

	}// END: deleteFile

}// END: class