/*
 * AAC data
 * Copyright (c) 2005-2006 Oded Shimon ( ods15 ods15 dyndns org )
 * Copyright (c) 2006-2007 Maxim Gavrilov ( maxim.gavrilov gmail com )
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file
 * AAC data
 * @author Oded Shimon  ( ods15 ods15 dyndns org )
 * @author Maxim Gavrilov ( maxim.gavrilov gmail com )
 */

#include "libavutil/mem.h"
#include "aac.h"
#include "aac_tablegen.h"

#include <stdint.h>

DECLARE_ALIGNED(32, float,  ff_aac_kbd_long_1024)[1024];
DECLARE_ALIGNED(32, float,  ff_aac_kbd_short_128)[128];

const uint8_t ff_aac_num_swb_1024[] = {
    41, 41, 47, 49, 49, 51, 47, 47, 43, 43, 43, 40, 40
};

const uint8_t ff_aac_num_swb_512[] = {
     0,  0,  0, 36, 36, 37, 31, 31,  0,  0,  0,  0,  0
};

const uint8_t ff_aac_num_swb_128[] = {
    12, 12, 12, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15
};

const uint8_t ff_aac_pred_sfb_max[] = {
    33, 33, 38, 40, 40, 40, 41, 41, 37, 37, 37, 34, 34
};

const uint32_t ff_aac_scalefactor_code[121] = {
    0x3ffe8, 0x3ffe6, 0x3ffe7, 0x3ffe5, 0x7fff5, 0x7fff1, 0x7ffed, 0x7fff6,
    0x7ffee, 0x7ffef, 0x7fff0, 0x7fffc, 0x7fffd, 0x7ffff, 0x7fffe, 0x7fff7,
    0x7fff8, 0x7fffb, 0x7fff9, 0x3ffe4, 0x7fffa, 0x3ffe3, 0x1ffef, 0x1fff0,
    0x0fff5, 0x1ffee, 0x0fff2, 0x0fff3, 0x0fff4, 0x0fff1, 0x07ff6, 0x07ff7,
    0x03ff9, 0x03ff5, 0x03ff7, 0x03ff3, 0x03ff6, 0x03ff2, 0x01ff7, 0x01ff5,
    0x00ff9, 0x00ff7, 0x00ff6, 0x007f9, 0x00ff4, 0x007f8, 0x003f9, 0x003f7,
    0x003f5, 0x001f8, 0x001f7, 0x000fa, 0x000f8, 0x000f6, 0x00079, 0x0003a,
    0x00038, 0x0001a, 0x0000b, 0x00004, 0x00000, 0x0000a, 0x0000c, 0x0001b,
    0x00039, 0x0003b, 0x00078, 0x0007a, 0x000f7, 0x000f9, 0x001f6, 0x001f9,
    0x003f4, 0x003f6, 0x003f8, 0x007f5, 0x007f4, 0x007f6, 0x007f7, 0x00ff5,
    0x00ff8, 0x01ff4, 0x01ff6, 0x01ff8, 0x03ff8, 0x03ff4, 0x0fff0, 0x07ff4,
    0x0fff6, 0x07ff5, 0x3ffe2, 0x7ffd9, 0x7ffda, 0x7ffdb, 0x7ffdc, 0x7ffdd,
    0x7ffde, 0x7ffd8, 0x7ffd2, 0x7ffd3, 0x7ffd4, 0x7ffd5, 0x7ffd6, 0x7fff2,
    0x7ffdf, 0x7ffe7, 0x7ffe8, 0x7ffe9, 0x7ffea, 0x7ffeb, 0x7ffe6, 0x7ffe0,
    0x7ffe1, 0x7ffe2, 0x7ffe3, 0x7ffe4, 0x7ffe5, 0x7ffd7, 0x7ffec, 0x7fff4,
    0x7fff3,
};

const uint8_t ff_aac_scalefactor_bits[121] = {
    18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 18, 19, 18, 17, 17, 16, 17, 16, 16, 16, 16, 15, 15,
    14, 14, 14, 14, 14, 14, 13, 13, 12, 12, 12, 11, 12, 11, 10, 10,
    10,  9,  9,  8,  8,  8,  7,  6,  6,  5,  4,  3,  1,  4,  4,  5,
     6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 10, 11, 11, 11, 11, 12,
    12, 13, 13, 13, 14, 14, 16, 15, 16, 15, 18, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19,
};

static const uint16_t codes1[81] = {
    0x7f8, 0x1f1, 0x7fd, 0x3f5, 0x068, 0x3f0, 0x7f7, 0x1ec,
    0x7f5, 0x3f1, 0x072, 0x3f4, 0x074, 0x011, 0x076, 0x1eb,
    0x06c, 0x3f6, 0x7fc, 0x1e1, 0x7f1, 0x1f0, 0x061, 0x1f6,
    0x7f2, 0x1ea, 0x7fb, 0x1f2, 0x069, 0x1ed, 0x077, 0x017,
    0x06f, 0x1e6, 0x064, 0x1e5, 0x067, 0x015, 0x062, 0x012,
    0x000, 0x014, 0x065, 0x016, 0x06d, 0x1e9, 0x063, 0x1e4,
    0x06b, 0x013, 0x071, 0x1e3, 0x070, 0x1f3, 0x7fe, 0x1e7,
    0x7f3, 0x1ef, 0x060, 0x1ee, 0x7f0, 0x1e2, 0x7fa, 0x3f3,
    0x06a, 0x1e8, 0x075, 0x010, 0x073, 0x1f4, 0x06e, 0x3f7,
    0x7f6, 0x1e0, 0x7f9, 0x3f2, 0x066, 0x1f5, 0x7ff, 0x1f7,
    0x7f4,
};

static const uint8_t bits1[81] = {
    11,  9, 11, 10,  7, 10, 11,  9, 11, 10,  7, 10,  7,  5,  7,  9,
     7, 10, 11,  9, 11,  9,  7,  9, 11,  9, 11,  9,  7,  9,  7,  5,
     7,  9,  7,  9,  7,  5,  7,  5,  1,  5,  7,  5,  7,  9,  7,  9,
     7,  5,  7,  9,  7,  9, 11,  9, 11,  9,  7,  9, 11,  9, 11, 10,
     7,  9,  7,  5,  7,  9,  7, 10, 11,  9, 11, 10,  7,  9, 11,  9,
    11,
};

static const uint16_t codes2[81] = {
    0x1f3, 0x06f, 0x1fd, 0x0eb, 0x023, 0x0ea, 0x1f7, 0x0e8,
    0x1fa, 0x0f2, 0x02d, 0x070, 0x020, 0x006, 0x02b, 0x06e,
    0x028, 0x0e9, 0x1f9, 0x066, 0x0f8, 0x0e7, 0x01b, 0x0f1,
    0x1f4, 0x06b, 0x1f5, 0x0ec, 0x02a, 0x06c, 0x02c, 0x00a,
    0x027, 0x067, 0x01a, 0x0f5, 0x024, 0x008, 0x01f, 0x009,
    0x000, 0x007, 0x01d, 0x00b, 0x030, 0x0ef, 0x01c, 0x064,
    0x01e, 0x00c, 0x029, 0x0f3, 0x02f, 0x0f0, 0x1fc, 0x071,
    0x1f2, 0x0f4, 0x021, 0x0e6, 0x0f7, 0x068, 0x1f8, 0x0ee,
    0x022, 0x065, 0x031, 0x002, 0x026, 0x0ed, 0x025, 0x06a,
    0x1fb, 0x072, 0x1fe, 0x069, 0x02e, 0x0f6, 0x1ff, 0x06d,
    0x1f6,
};

static const uint8_t bits2[81] = {
    9, 7, 9, 8, 6, 8, 9, 8, 9, 8, 6, 7, 6, 5, 6, 7,
    6, 8, 9, 7, 8, 8, 6, 8, 9, 7, 9, 8, 6, 7, 6, 5,
    6, 7, 6, 8, 6, 5, 6, 5, 3, 5, 6, 5, 6, 8, 6, 7,
    6, 5, 6, 8, 6, 8, 9, 7, 9, 8, 6, 8, 8, 7, 9, 8,
    6, 7, 6, 4, 6, 8, 6, 7, 9, 7, 9, 7, 6, 8, 9, 7,
    9,
};

static const uint16_t codes3[81] = {
    0x0000, 0x0009, 0x00ef, 0x000b, 0x0019, 0x00f0, 0x01eb, 0x01e6,
    0x03f2, 0x000a, 0x0035, 0x01ef, 0x0034, 0x0037, 0x01e9, 0x01ed,
    0x01e7, 0x03f3, 0x01ee, 0x03ed, 0x1ffa, 0x01ec, 0x01f2, 0x07f9,
    0x07f8, 0x03f8, 0x0ff8, 0x0008, 0x0038, 0x03f6, 0x0036, 0x0075,
    0x03f1, 0x03eb, 0x03ec, 0x0ff4, 0x0018, 0x0076, 0x07f4, 0x0039,
    0x0074, 0x03ef, 0x01f3, 0x01f4, 0x07f6, 0x01e8, 0x03ea, 0x1ffc,
    0x00f2, 0x01f1, 0x0ffb, 0x03f5, 0x07f3, 0x0ffc, 0x00ee, 0x03f7,
    0x7ffe, 0x01f0, 0x07f5, 0x7ffd, 0x1ffb, 0x3ffa, 0xffff, 0x00f1,
    0x03f0, 0x3ffc, 0x01ea, 0x03ee, 0x3ffb, 0x0ff6, 0x0ffa, 0x7ffc,
    0x07f2, 0x0ff5, 0xfffe, 0x03f4, 0x07f7, 0x7ffb, 0x0ff7, 0x0ff9,
    0x7ffa,
};

static const uint8_t bits3[81] = {
     1,  4,  8,  4,  5,  8,  9,  9, 10,  4,  6,  9,  6,  6,  9,  9,
     9, 10,  9, 10, 13,  9,  9, 11, 11, 10, 12,  4,  6, 10,  6,  7,
    10, 10, 10, 12,  5,  7, 11,  6,  7, 10,  9,  9, 11,  9, 10, 13,
     8,  9, 12, 10, 11, 12,  8, 10, 15,  9, 11, 15, 13, 14, 16,  8,
    10, 14,  9, 10, 14, 12, 12, 15, 11, 12, 16, 10, 11, 15, 12, 12,
    15,
};

static const uint16_t codes4[81] = {
    0x007, 0x016, 0x0f6, 0x018, 0x008, 0x0ef, 0x1ef, 0x0f3,
    0x7f8, 0x019, 0x017, 0x0ed, 0x015, 0x001, 0x0e2, 0x0f0,
    0x070, 0x3f0, 0x1ee, 0x0f1, 0x7fa, 0x0ee, 0x0e4, 0x3f2,
    0x7f6, 0x3ef, 0x7fd, 0x005, 0x014, 0x0f2, 0x009, 0x004,
    0x0e5, 0x0f4, 0x0e8, 0x3f4, 0x006, 0x002, 0x0e7, 0x003,
    0x000, 0x06b, 0x0e3, 0x069, 0x1f3, 0x0eb, 0x0e6, 0x3f6,
    0x06e, 0x06a, 0x1f4, 0x3ec, 0x1f0, 0x3f9, 0x0f5, 0x0ec,
    0x7fb, 0x0ea, 0x06f, 0x3f7, 0x7f9, 0x3f3, 0xfff, 0x0e9,
    0x06d, 0x3f8, 0x06c, 0x068, 0x1f5, 0x3ee, 0x1f2, 0x7f4,
    0x7f7, 0x3f1, 0xffe, 0x3ed, 0x1f1, 0x7f5, 0x7fe, 0x3f5,
    0x7fc,
};

static const uint8_t bits4[81] = {
     4,  5,  8,  5,  4,  8,  9,  8, 11,  5,  5,  8,  5,  4,  8,  8,
     7, 10,  9,  8, 11,  8,  8, 10, 11, 10, 11,  4,  5,  8,  4,  4,
     8,  8,  8, 10,  4,  4,  8,  4,  4,  7,  8,  7,  9,  8,  8, 10,
     7,  7,  9, 10,  9, 10,  8,  8, 11,  8,  7, 10, 11, 10, 12,  8,
     7, 10,  7,  7,  9, 10,  9, 11, 11, 10, 12, 10,  9, 11, 11, 10,
    11,
};

static const uint16_t codes5[81] = {
    0x1fff, 0x0ff7, 0x07f4, 0x07e8, 0x03f1, 0x07ee, 0x07f9, 0x0ff8,
    0x1ffd, 0x0ffd, 0x07f1, 0x03e8, 0x01e8, 0x00f0, 0x01ec, 0x03ee,
    0x07f2, 0x0ffa, 0x0ff4, 0x03ef, 0x01f2, 0x00e8, 0x0070, 0x00ec,
    0x01f0, 0x03ea, 0x07f3, 0x07eb, 0x01eb, 0x00ea, 0x001a, 0x0008,
    0x0019, 0x00ee, 0x01ef, 0x07ed, 0x03f0, 0x00f2, 0x0073, 0x000b,
    0x0000, 0x000a, 0x0071, 0x00f3, 0x07e9, 0x07ef, 0x01ee, 0x00ef,
    0x0018, 0x0009, 0x001b, 0x00eb, 0x01e9, 0x07ec, 0x07f6, 0x03eb,
    0x01f3, 0x00ed, 0x0072, 0x00e9, 0x01f1, 0x03ed, 0x07f7, 0x0ff6,
    0x07f0, 0x03e9, 0x01ed, 0x00f1, 0x01ea, 0x03ec, 0x07f8, 0x0ff9,
    0x1ffc, 0x0ffc, 0x0ff5, 0x07ea, 0x03f3, 0x03f2, 0x07f5, 0x0ffb,
    0x1ffe,
};

static const uint8_t bits5[81] = {
    13, 12, 11, 11, 10, 11, 11, 12, 13, 12, 11, 10,  9,  8,  9, 10,
    11, 12, 12, 10,  9,  8,  7,  8,  9, 10, 11, 11,  9,  8,  5,  4,
     5,  8,  9, 11, 10,  8,  7,  4,  1,  4,  7,  8, 11, 11,  9,  8,
     5,  4,  5,  8,  9, 11, 11, 10,  9,  8,  7,  8,  9, 10, 11, 12,
    11, 10,  9,  8,  9, 10, 11, 12, 13, 12, 12, 11, 10, 10, 11, 12,
    13,
};

static const uint16_t codes6[81] = {
    0x7fe, 0x3fd, 0x1f1, 0x1eb, 0x1f4, 0x1ea, 0x1f0, 0x3fc,
    0x7fd, 0x3f6, 0x1e5, 0x0ea, 0x06c, 0x071, 0x068, 0x0f0,
    0x1e6, 0x3f7, 0x1f3, 0x0ef, 0x032, 0x027, 0x028, 0x026,
    0x031, 0x0eb, 0x1f7, 0x1e8, 0x06f, 0x02e, 0x008, 0x004,
    0x006, 0x029, 0x06b, 0x1ee, 0x1ef, 0x072, 0x02d, 0x002,
    0x000, 0x003, 0x02f, 0x073, 0x1fa, 0x1e7, 0x06e, 0x02b,
    0x007, 0x001, 0x005, 0x02c, 0x06d, 0x1ec, 0x1f9, 0x0ee,
    0x030, 0x024, 0x02a, 0x025, 0x033, 0x0ec, 0x1f2, 0x3f8,
    0x1e4, 0x0ed, 0x06a, 0x070, 0x069, 0x074, 0x0f1, 0x3fa,
    0x7ff, 0x3f9, 0x1f6, 0x1ed, 0x1f8, 0x1e9, 0x1f5, 0x3fb,
    0x7fc,
};

static const uint8_t bits6[81] = {
    11, 10,  9,  9,  9,  9,  9, 10, 11, 10,  9,  8,  7,  7,  7,  8,
     9, 10,  9,  8,  6,  6,  6,  6,  6,  8,  9,  9,  7,  6,  4,  4,
     4,  6,  7,  9,  9,  7,  6,  4,  4,  4,  6,  7,  9,  9,  7,  6,
     4,  4,  4,  6,  7,  9,  9,  8,  6,  6,  6,  6,  6,  8,  9, 10,
     9,  8,  7,  7,  7,  7,  8, 10, 11, 10,  9,  9,  9,  9,  9, 10,
    11,
};

static const uint16_t codes7[64] = {
    0x000, 0x005, 0x037, 0x074, 0x0f2, 0x1eb, 0x3ed, 0x7f7,
    0x004, 0x00c, 0x035, 0x071, 0x0ec, 0x0ee, 0x1ee, 0x1f5,
    0x036, 0x034, 0x072, 0x0ea, 0x0f1, 0x1e9, 0x1f3, 0x3f5,
    0x073, 0x070, 0x0eb, 0x0f0, 0x1f1, 0x1f0, 0x3ec, 0x3fa,
    0x0f3, 0x0ed, 0x1e8, 0x1ef, 0x3ef, 0x3f1, 0x3f9, 0x7fb,
    0x1ed, 0x0ef, 0x1ea, 0x1f2, 0x3f3, 0x3f8, 0x7f9, 0x7fc,
    0x3ee, 0x1ec, 0x1f4, 0x3f4, 0x3f7, 0x7f8, 0xffd, 0xffe,
    0x7f6, 0x3f0, 0x3f2, 0x3f6, 0x7fa, 0x7fd, 0xffc, 0xfff,
};

static const uint8_t bits7[64] = {
     1,  3,  6,  7,  8,  9, 10, 11,  3,  4,  6,  7,  8,  8,  9,  9,
     6,  6,  7,  8,  8,  9,  9, 10,  7,  7,  8,  8,  9,  9, 10, 10,
     8,  8,  9,  9, 10, 10, 10, 11,  9,  8,  9,  9, 10, 10, 11, 11,
    10,  9,  9, 10, 10, 11, 12, 12, 11, 10, 10, 10, 11, 11, 12, 12,
};

static const uint16_t codes8[64] = {
    0x00e, 0x005, 0x010, 0x030, 0x06f, 0x0f1, 0x1fa, 0x3fe,
    0x003, 0x000, 0x004, 0x012, 0x02c, 0x06a, 0x075, 0x0f8,
    0x00f, 0x002, 0x006, 0x014, 0x02e, 0x069, 0x072, 0x0f5,
    0x02f, 0x011, 0x013, 0x02a, 0x032, 0x06c, 0x0ec, 0x0fa,
    0x071, 0x02b, 0x02d, 0x031, 0x06d, 0x070, 0x0f2, 0x1f9,
    0x0ef, 0x068, 0x033, 0x06b, 0x06e, 0x0ee, 0x0f9, 0x3fc,
    0x1f8, 0x074, 0x073, 0x0ed, 0x0f0, 0x0f6, 0x1f6, 0x1fd,
    0x3fd, 0x0f3, 0x0f4, 0x0f7, 0x1f7, 0x1fb, 0x1fc, 0x3ff,
};

static const uint8_t bits8[64] = {
     5,  4,  5,  6,  7,  8,  9, 10,  4,  3,  4,  5,  6,  7,  7,  8,
     5,  4,  4,  5,  6,  7,  7,  8,  6,  5,  5,  6,  6,  7,  8,  8,
     7,  6,  6,  6,  7,  7,  8,  9,  8,  7,  6,  7,  7,  8,  8, 10,
     9,  7,  7,  8,  8,  8,  9,  9, 10,  8,  8,  8,  9,  9,  9, 10,
};

static const uint16_t codes9[169] = {
    0x0000, 0x0005, 0x0037, 0x00e7, 0x01de, 0x03ce, 0x03d9, 0x07c8,
    0x07cd, 0x0fc8, 0x0fdd, 0x1fe4, 0x1fec, 0x0004, 0x000c, 0x0035,
    0x0072, 0x00ea, 0x00ed, 0x01e2, 0x03d1, 0x03d3, 0x03e0, 0x07d8,
    0x0fcf, 0x0fd5, 0x0036, 0x0034, 0x0071, 0x00e8, 0x00ec, 0x01e1,
    0x03cf, 0x03dd, 0x03db, 0x07d0, 0x0fc7, 0x0fd4, 0x0fe4, 0x00e6,
    0x0070, 0x00e9, 0x01dd, 0x01e3, 0x03d2, 0x03dc, 0x07cc, 0x07ca,
    0x07de, 0x0fd8, 0x0fea, 0x1fdb, 0x01df, 0x00eb, 0x01dc, 0x01e6,
    0x03d5, 0x03de, 0x07cb, 0x07dd, 0x07dc, 0x0fcd, 0x0fe2, 0x0fe7,
    0x1fe1, 0x03d0, 0x01e0, 0x01e4, 0x03d6, 0x07c5, 0x07d1, 0x07db,
    0x0fd2, 0x07e0, 0x0fd9, 0x0feb, 0x1fe3, 0x1fe9, 0x07c4, 0x01e5,
    0x03d7, 0x07c6, 0x07cf, 0x07da, 0x0fcb, 0x0fda, 0x0fe3, 0x0fe9,
    0x1fe6, 0x1ff3, 0x1ff7, 0x07d3, 0x03d8, 0x03e1, 0x07d4, 0x07d9,
    0x0fd3, 0x0fde, 0x1fdd, 0x1fd9, 0x1fe2, 0x1fea, 0x1ff1, 0x1ff6,
    0x07d2, 0x03d4, 0x03da, 0x07c7, 0x07d7, 0x07e2, 0x0fce, 0x0fdb,
    0x1fd8, 0x1fee, 0x3ff0, 0x1ff4, 0x3ff2, 0x07e1, 0x03df, 0x07c9,
    0x07d6, 0x0fca, 0x0fd0, 0x0fe5, 0x0fe6, 0x1feb, 0x1fef, 0x3ff3,
    0x3ff4, 0x3ff5, 0x0fe0, 0x07ce, 0x07d5, 0x0fc6, 0x0fd1, 0x0fe1,
    0x1fe0, 0x1fe8, 0x1ff0, 0x3ff1, 0x3ff8, 0x3ff6, 0x7ffc, 0x0fe8,
    0x07df, 0x0fc9, 0x0fd7, 0x0fdc, 0x1fdc, 0x1fdf, 0x1fed, 0x1ff5,
    0x3ff9, 0x3ffb, 0x7ffd, 0x7ffe, 0x1fe7, 0x0fcc, 0x0fd6, 0x0fdf,
    0x1fde, 0x1fda, 0x1fe5, 0x1ff2, 0x3ffa, 0x3ff7, 0x3ffc, 0x3ffd,
    0x7fff,
};

static const uint8_t bits9[169] = {
     1,  3,  6,  8,  9, 10, 10, 11, 11, 12, 12, 13, 13,  3,  4,  6,
     7,  8,  8,  9, 10, 10, 10, 11, 12, 12,  6,  6,  7,  8,  8,  9,
    10, 10, 10, 11, 12, 12, 12,  8,  7,  8,  9,  9, 10, 10, 11, 11,
    11, 12, 12, 13,  9,  8,  9,  9, 10, 10, 11, 11, 11, 12, 12, 12,
    13, 10,  9,  9, 10, 11, 11, 11, 12, 11, 12, 12, 13, 13, 11,  9,
    10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 11, 10, 10, 11, 11,
    12, 12, 13, 13, 13, 13, 13, 13, 11, 10, 10, 11, 11, 11, 12, 12,
    13, 13, 14, 13, 14, 11, 10, 11, 11, 12, 12, 12, 12, 13, 13, 14,
    14, 14, 12, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 12,
    11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15, 13, 12, 12, 12,
    13, 13, 13, 13, 14, 14, 14, 14, 15,
};

static const uint16_t codes10[169] = {
    0x022, 0x008, 0x01d, 0x026, 0x05f, 0x0d3, 0x1cf, 0x3d0,
    0x3d7, 0x3ed, 0x7f0, 0x7f6, 0xffd, 0x007, 0x000, 0x001,
    0x009, 0x020, 0x054, 0x060, 0x0d5, 0x0dc, 0x1d4, 0x3cd,
    0x3de, 0x7e7, 0x01c, 0x002, 0x006, 0x00c, 0x01e, 0x028,
    0x05b, 0x0cd, 0x0d9, 0x1ce, 0x1dc, 0x3d9, 0x3f1, 0x025,
    0x00b, 0x00a, 0x00d, 0x024, 0x057, 0x061, 0x0cc, 0x0dd,
    0x1cc, 0x1de, 0x3d3, 0x3e7, 0x05d, 0x021, 0x01f, 0x023,
    0x027, 0x059, 0x064, 0x0d8, 0x0df, 0x1d2, 0x1e2, 0x3dd,
    0x3ee, 0x0d1, 0x055, 0x029, 0x056, 0x058, 0x062, 0x0ce,
    0x0e0, 0x0e2, 0x1da, 0x3d4, 0x3e3, 0x7eb, 0x1c9, 0x05e,
    0x05a, 0x05c, 0x063, 0x0ca, 0x0da, 0x1c7, 0x1ca, 0x1e0,
    0x3db, 0x3e8, 0x7ec, 0x1e3, 0x0d2, 0x0cb, 0x0d0, 0x0d7,
    0x0db, 0x1c6, 0x1d5, 0x1d8, 0x3ca, 0x3da, 0x7ea, 0x7f1,
    0x1e1, 0x0d4, 0x0cf, 0x0d6, 0x0de, 0x0e1, 0x1d0, 0x1d6,
    0x3d1, 0x3d5, 0x3f2, 0x7ee, 0x7fb, 0x3e9, 0x1cd, 0x1c8,
    0x1cb, 0x1d1, 0x1d7, 0x1df, 0x3cf, 0x3e0, 0x3ef, 0x7e6,
    0x7f8, 0xffa, 0x3eb, 0x1dd, 0x1d3, 0x1d9, 0x1db, 0x3d2,
    0x3cc, 0x3dc, 0x3ea, 0x7ed, 0x7f3, 0x7f9, 0xff9, 0x7f2,
    0x3ce, 0x1e4, 0x3cb, 0x3d8, 0x3d6, 0x3e2, 0x3e5, 0x7e8,
    0x7f4, 0x7f5, 0x7f7, 0xffb, 0x7fa, 0x3ec, 0x3df, 0x3e1,
    0x3e4, 0x3e6, 0x3f0, 0x7e9, 0x7ef, 0xff8, 0xffe, 0xffc,
    0xfff,
};

static const uint8_t bits10[169] = {
     6,  5,  6,  6,  7,  8,  9, 10, 10, 10, 11, 11, 12,  5,  4,  4,
     5,  6,  7,  7,  8,  8,  9, 10, 10, 11,  6,  4,  5,  5,  6,  6,
     7,  8,  8,  9,  9, 10, 10,  6,  5,  5,  5,  6,  7,  7,  8,  8,
     9,  9, 10, 10,  7,  6,  6,  6,  6,  7,  7,  8,  8,  9,  9, 10,
    10,  8,  7,  6,  7,  7,  7,  8,  8,  8,  9, 10, 10, 11,  9,  7,
     7,  7,  7,  8,  8,  9,  9,  9, 10, 10, 11,  9,  8,  8,  8,  8,
     8,  9,  9,  9, 10, 10, 11, 11,  9,  8,  8,  8,  8,  8,  9,  9,
    10, 10, 10, 11, 11, 10,  9,  9,  9,  9,  9,  9, 10, 10, 10, 11,
    11, 12, 10,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11, 12, 11,
    10,  9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 12, 11, 10, 10, 10,
    10, 10, 10, 11, 11, 12, 12, 12, 12,
};

static const uint16_t codes11[289] = {
    0x000, 0x006, 0x019, 0x03d, 0x09c, 0x0c6, 0x1a7, 0x390,
    0x3c2, 0x3df, 0x7e6, 0x7f3, 0xffb, 0x7ec, 0xffa, 0xffe,
    0x38e, 0x005, 0x001, 0x008, 0x014, 0x037, 0x042, 0x092,
    0x0af, 0x191, 0x1a5, 0x1b5, 0x39e, 0x3c0, 0x3a2, 0x3cd,
    0x7d6, 0x0ae, 0x017, 0x007, 0x009, 0x018, 0x039, 0x040,
    0x08e, 0x0a3, 0x0b8, 0x199, 0x1ac, 0x1c1, 0x3b1, 0x396,
    0x3be, 0x3ca, 0x09d, 0x03c, 0x015, 0x016, 0x01a, 0x03b,
    0x044, 0x091, 0x0a5, 0x0be, 0x196, 0x1ae, 0x1b9, 0x3a1,
    0x391, 0x3a5, 0x3d5, 0x094, 0x09a, 0x036, 0x038, 0x03a,
    0x041, 0x08c, 0x09b, 0x0b0, 0x0c3, 0x19e, 0x1ab, 0x1bc,
    0x39f, 0x38f, 0x3a9, 0x3cf, 0x093, 0x0bf, 0x03e, 0x03f,
    0x043, 0x045, 0x09e, 0x0a7, 0x0b9, 0x194, 0x1a2, 0x1ba,
    0x1c3, 0x3a6, 0x3a7, 0x3bb, 0x3d4, 0x09f, 0x1a0, 0x08f,
    0x08d, 0x090, 0x098, 0x0a6, 0x0b6, 0x0c4, 0x19f, 0x1af,
    0x1bf, 0x399, 0x3bf, 0x3b4, 0x3c9, 0x3e7, 0x0a8, 0x1b6,
    0x0ab, 0x0a4, 0x0aa, 0x0b2, 0x0c2, 0x0c5, 0x198, 0x1a4,
    0x1b8, 0x38c, 0x3a4, 0x3c4, 0x3c6, 0x3dd, 0x3e8, 0x0ad,
    0x3af, 0x192, 0x0bd, 0x0bc, 0x18e, 0x197, 0x19a, 0x1a3,
    0x1b1, 0x38d, 0x398, 0x3b7, 0x3d3, 0x3d1, 0x3db, 0x7dd,
    0x0b4, 0x3de, 0x1a9, 0x19b, 0x19c, 0x1a1, 0x1aa, 0x1ad,
    0x1b3, 0x38b, 0x3b2, 0x3b8, 0x3ce, 0x3e1, 0x3e0, 0x7d2,
    0x7e5, 0x0b7, 0x7e3, 0x1bb, 0x1a8, 0x1a6, 0x1b0, 0x1b2,
    0x1b7, 0x39b, 0x39a, 0x3ba, 0x3b5, 0x3d6, 0x7d7, 0x3e4,
    0x7d8, 0x7ea, 0x0ba, 0x7e8, 0x3a0, 0x1bd, 0x1b4, 0x38a,
    0x1c4, 0x392, 0x3aa, 0x3b0, 0x3bc, 0x3d7, 0x7d4, 0x7dc,
    0x7db, 0x7d5, 0x7f0, 0x0c1, 0x7fb, 0x3c8, 0x3a3, 0x395,
    0x39d, 0x3ac, 0x3ae, 0x3c5, 0x3d8, 0x3e2, 0x3e6, 0x7e4,
    0x7e7, 0x7e0, 0x7e9, 0x7f7, 0x190, 0x7f2, 0x393, 0x1be,
    0x1c0, 0x394, 0x397, 0x3ad, 0x3c3, 0x3c1, 0x3d2, 0x7da,
    0x7d9, 0x7df, 0x7eb, 0x7f4, 0x7fa, 0x195, 0x7f8, 0x3bd,
    0x39c, 0x3ab, 0x3a8, 0x3b3, 0x3b9, 0x3d0, 0x3e3, 0x3e5,
    0x7e2, 0x7de, 0x7ed, 0x7f1, 0x7f9, 0x7fc, 0x193, 0xffd,
    0x3dc, 0x3b6, 0x3c7, 0x3cc, 0x3cb, 0x3d9, 0x3da, 0x7d3,
    0x7e1, 0x7ee, 0x7ef, 0x7f5, 0x7f6, 0xffc, 0xfff, 0x19d,
    0x1c2, 0x0b5, 0x0a1, 0x096, 0x097, 0x095, 0x099, 0x0a0,
    0x0a2, 0x0ac, 0x0a9, 0x0b1, 0x0b3, 0x0bb, 0x0c0, 0x18f,
    0x004,
};

static const uint8_t bits11[289] = {
     4,  5,  6,  7,  8,  8,  9, 10, 10, 10, 11, 11, 12, 11, 12, 12,
    10,  5,  4,  5,  6,  7,  7,  8,  8,  9,  9,  9, 10, 10, 10, 10,
    11,  8,  6,  5,  5,  6,  7,  7,  8,  8,  8,  9,  9,  9, 10, 10,
    10, 10,  8,  7,  6,  6,  6,  7,  7,  8,  8,  8,  9,  9,  9, 10,
    10, 10, 10,  8,  8,  7,  7,  7,  7,  8,  8,  8,  8,  9,  9,  9,
    10, 10, 10, 10,  8,  8,  7,  7,  7,  7,  8,  8,  8,  9,  9,  9,
     9, 10, 10, 10, 10,  8,  9,  8,  8,  8,  8,  8,  8,  8,  9,  9,
     9, 10, 10, 10, 10, 10,  8,  9,  8,  8,  8,  8,  8,  8,  9,  9,
     9, 10, 10, 10, 10, 10, 10,  8, 10,  9,  8,  8,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 10, 11,  8, 10,  9,  9,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 10, 11, 11,  8, 11,  9,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 11, 10, 11, 11,  8, 11, 10,  9,  9, 10,
     9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,  8, 11, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,  9, 11, 10,  9,
     9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11,  9, 11, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11,  9, 12,
    10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12,  9,
     9,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  9,
     5,
};

const uint16_t * const ff_aac_spectral_codes[11] = {
    codes1,  codes2,  codes3, codes4, codes5, codes6, codes7, codes8,
    codes9, codes10, codes11,
};

const uint8_t * const ff_aac_spectral_bits[11] = {
    bits1,  bits2,  bits3, bits4, bits5, bits6, bits7, bits8,
    bits9, bits10, bits11,
};

const uint16_t ff_aac_spectral_sizes[11] = {
    81, 81, 81, 81, 81, 81, 64, 64, 169, 169, 289,
};

/* NOTE:
 * 64.0f is a special value indicating the existence of an escape code in the
 * bitstream.
 */
static const DECLARE_ALIGNED(16, float, codebook_vector0)[324] = {
 -1.0000000, -1.0000000, -1.0000000, -1.0000000,
 -1.0000000, -1.0000000, -1.0000000,  0.0000000,
 -1.0000000, -1.0000000, -1.0000000,  1.0000000,
 -1.0000000, -1.0000000,  0.0000000, -1.0000000,
 -1.0000000, -1.0000000,  0.0000000,  0.0000000,
 -1.0000000, -1.0000000,  0.0000000,  1.0000000,
 -1.0000000, -1.0000000,  1.0000000, -1.0000000,
 -1.0000000, -1.0000000,  1.0000000,  0.0000000,
 -1.0000000, -1.0000000,  1.0000000,  1.0000000,
 -1.0000000,  0.0000000, -1.0000000, -1.0000000,
 -1.0000000,  0.0000000, -1.0000000,  0.0000000,
 -1.0000000,  0.0000000, -1.0000000,  1.0000000,
 -1.0000000,  0.0000000,  0.0000000, -1.0000000,
 -1.0000000,  0.0000000,  0.0000000,  0.0000000,
 -1.0000000,  0.0000000,  0.0000000,  1.0000000,
 -1.0000000,  0.0000000,  1.0000000, -1.0000000,
 -1.0000000,  0.0000000,  1.0000000,  0.0000000,
 -1.0000000,  0.0000000,  1.0000000,  1.0000000,
 -1.0000000,  1.0000000, -1.0000000, -1.0000000,
 -1.0000000,  1.0000000, -1.0000000,  0.0000000,
 -1.0000000,  1.0000000, -1.0000000,  1.0000000,
 -1.0000000,  1.0000000,  0.0000000, -1.0000000,
 -1.0000000,  1.0000000,  0.0000000,  0.0000000,
 -1.0000000,  1.0000000,  0.0000000,  1.0000000,
 -1.0000000,  1.0000000,  1.0000000, -1.0000000,
 -1.0000000,  1.0000000,  1.0000000,  0.0000000,
 -1.0000000,  1.0000000,  1.0000000,  1.0000000,
  0.0000000, -1.0000000, -1.0000000, -1.0000000,
  0.0000000, -1.0000000, -1.0000000,  0.0000000,
  0.0000000, -1.0000000, -1.0000000,  1.0000000,
  0.0000000, -1.0000000,  0.0000000, -1.0000000,
  0.0000000, -1.0000000,  0.0000000,  0.0000000,
  0.0000000, -1.0000000,  0.0000000,  1.0000000,
  0.0000000, -1.0000000,  1.0000000, -1.0000000,
  0.0000000, -1.0000000,  1.0000000,  0.0000000,
  0.0000000, -1.0000000,  1.0000000,  1.0000000,
  0.0000000,  0.0000000, -1.0000000, -1.0000000,
  0.0000000,  0.0000000, -1.0000000,  0.0000000,
  0.0000000,  0.0000000, -1.0000000,  1.0000000,
  0.0000000,  0.0000000,  0.0000000, -1.0000000,
  0.0000000,  0.0000000,  0.0000000,  0.0000000,
  0.0000000,  0.0000000,  0.0000000,  1.0000000,
  0.0000000,  0.0000000,  1.0000000, -1.0000000,
  0.0000000,  0.0000000,  1.0000000,  0.0000000,
  0.0000000,  0.0000000,  1.0000000,  1.0000000,
  0.0000000,  1.0000000, -1.0000000, -1.0000000,
  0.0000000,  1.0000000, -1.0000000,  0.0000000,
  0.0000000,  1.0000000, -1.0000000,  1.0000000,
  0.0000000,  1.0000000,  0.0000000, -1.0000000,
  0.0000000,  1.0000000,  0.0000000,  0.0000000,
  0.0000000,  1.0000000,  0.0000000,  1.0000000,
  0.0000000,  1.0000000,  1.0000000, -1.0000000,
  0.0000000,  1.0000000,  1.0000000,  0.0000000,
  0.0000000,  1.0000000,  1.0000000,  1.0000000,
  1.0000000, -1.0000000, -1.0000000, -1.0000000,
  1.0000000, -1.0000000, -1.0000000,  0.0000000,
  1.0000000, -1.0000000, -1.0000000,  1.0000000,
  1.0000000, -1.0000000,  0.0000000, -1.0000000,
  1.0000000, -1.0000000,  0.0000000,  0.0000000,
  1.0000000, -1.0000000,  0.0000000,  1.0000000,
  1.0000000, -1.0000000,  1.0000000, -1.0000000,
  1.0000000, -1.0000000,  1.0000000,  0.0000000,
  1.0000000, -1.0000000,  1.0000000,  1.0000000,
  1.0000000,  0.0000000, -1.0000000, -1.0000000,
  1.0000000,  0.0000000, -1.0000000,  0.0000000,
  1.0000000,  0.0000000, -1.0000000,  1.0000000,
  1.0000000,  0.0000000,  0.0000000, -1.0000000,
  1.0000000,  0.0000000,  0.0000000,  0.0000000,
  1.0000000,  0.0000000,  0.0000000,  1.0000000,
  1.0000000,  0.0000000,  1.0000000, -1.0000000,
  1.0000000,  0.0000000,  1.0000000,  0.0000000,
  1.0000000,  0.0000000,  1.0000000,  1.0000000,
  1.0000000,  1.0000000, -1.0000000, -1.0000000,
  1.0000000,  1.0000000, -1.0000000,  0.0000000,
  1.0000000,  1.0000000, -1.0000000,  1.0000000,
  1.0000000,  1.0000000,  0.0000000, -1.0000000,
  1.0000000,  1.0000000,  0.0000000,  0.0000000,
  1.0000000,  1.0000000,  0.0000000,  1.0000000,
  1.0000000,  1.0000000,  1.0000000, -1.0000000,
  1.0000000,  1.0000000,  1.0000000,  0.0000000,
  1.0000000,  1.0000000,  1.0000000,  1.0000000,
};

static const DECLARE_ALIGNED(16, float, codebook_vector2)[324] = {
  0.0000000,  0.0000000,  0.0000000,  0.0000000,
  0.0000000,  0.0000000,  0.0000000,  1.0000000,
  0.0000000,  0.0000000,  0.0000000,  2.5198421,
  0.0000000,  0.0000000,  1.0000000,  0.0000000,
  0.0000000,  0.0000000,  1.0000000,  1.0000000,
  0.0000000,  0.0000000,  1.0000000,  2.5198421,
  0.0000000,  0.0000000,  2.5198421,  0.0000000,
  0.0000000,  0.0000000,  2.5198421,  1.0000000,
  0.0000000,  0.0000000,  2.5198421,  2.5198421,
  0.0000000,  1.0000000,  0.0000000,  0.0000000,
  0.0000000,  1.0000000,  0.0000000,  1.0000000,
  0.0000000,  1.0000000,  0.0000000,  2.5198421,
  0.0000000,  1.0000000,  1.0000000,  0.0000000,
  0.0000000,  1.0000000,  1.0000000,  1.0000000,
  0.0000000,  1.0000000,  1.0000000,  2.5198421,
  0.0000000,  1.0000000,  2.5198421,  0.0000000,
  0.0000000,  1.0000000,  2.5198421,  1.0000000,
  0.0000000,  1.0000000,  2.5198421,  2.5198421,
  0.0000000,  2.5198421,  0.0000000,  0.0000000,
  0.0000000,  2.5198421,  0.0000000,  1.0000000,
  0.0000000,  2.5198421,  0.0000000,  2.5198421,
  0.0000000,  2.5198421,  1.0000000,  0.0000000,
  0.0000000,  2.5198421,  1.0000000,  1.0000000,
  0.0000000,  2.5198421,  1.0000000,  2.5198421,
  0.0000000,  2.5198421,  2.5198421,  0.0000000,
  0.0000000,  2.5198421,  2.5198421,  1.0000000,
  0.0000000,  2.5198421,  2.5198421,  2.5198421,
  1.0000000,  0.0000000,  0.0000000,  0.0000000,
  1.0000000,  0.0000000,  0.0000000,  1.0000000,
  1.0000000,  0.0000000,  0.0000000,  2.5198421,
  1.0000000,  0.0000000,  1.0000000,  0.0000000,
  1.0000000,  0.0000000,  1.0000000,  1.0000000,
  1.0000000,  0.0000000,  1.0000000,  2.5198421,
  1.0000000,  0.0000000,  2.5198421,  0.0000000,
  1.0000000,  0.0000000,  2.5198421,  1.0000000,
  1.0000000,  0.0000000,  2.5198421,  2.5198421,
  1.0000000,  1.0000000,  0.0000000,  0.0000000,
  1.0000000,  1.0000000,  0.0000000,  1.0000000,
  1.0000000,  1.0000000,  0.0000000,  2.5198421,
  1.0000000,  1.0000000,  1.0000000,  0.0000000,
  1.0000000,  1.0000000,  1.0000000,  1.0000000,
  1.0000000,  1.0000000,  1.0000000,  2.5198421,
  1.0000000,  1.0000000,  2.5198421,  0.0000000,
  1.0000000,  1.0000000,  2.5198421,  1.0000000,
  1.0000000,  1.0000000,  2.5198421,  2.5198421,
  1.0000000,  2.5198421,  0.0000000,  0.0000000,
  1.0000000,  2.5198421,  0.0000000,  1.0000000,
  1.0000000,  2.5198421,  0.0000000,  2.5198421,
  1.0000000,  2.5198421,  1.0000000,  0.0000000,
  1.0000000,  2.5198421,  1.0000000,  1.0000000,
  1.0000000,  2.5198421,  1.0000000,  2.5198421,
  1.0000000,  2.5198421,  2.5198421,  0.0000000,
  1.0000000,  2.5198421,  2.5198421,  1.0000000,
  1.0000000,  2.5198421,  2.5198421,  2.5198421,
  2.5198421,  0.0000000,  0.0000000,  0.0000000,
  2.5198421,  0.0000000,  0.0000000,  1.0000000,
  2.5198421,  0.0000000,  0.0000000,  2.5198421,
  2.5198421,  0.0000000,  1.0000000,  0.0000000,
  2.5198421,  0.0000000,  1.0000000,  1.0000000,
  2.5198421,  0.0000000,  1.0000000,  2.5198421,
  2.5198421,  0.0000000,  2.5198421,  0.0000000,
  2.5198421,  0.0000000,  2.5198421,  1.0000000,
  2.5198421,  0.0000000,  2.5198421,  2.5198421,
  2.5198421,  1.0000000,  0.0000000,  0.0000000,
  2.5198421,  1.0000000,  0.0000000,  1.0000000,
  2.5198421,  1.0000000,  0.0000000,  2.5198421,
  2.5198421,  1.0000000,  1.0000000,  0.0000000,
  2.5198421,  1.0000000,  1.0000000,  1.0000000,
  2.5198421,  1.0000000,  1.0000000,  2.5198421,
  2.5198421,  1.0000000,  2.5198421,  0.0000000,
  2.5198421,  1.0000000,  2.5198421,  1.0000000,
  2.5198421,  1.0000000,  2.5198421,  2.5198421,
  2.5198421,  2.5198421,  0.0000000,  0.0000000,
  2.5198421,  2.5198421,  0.0000000,  1.0000000,
  2.5198421,  2.5198421,  0.0000000,  2.5198421,
  2.5198421,  2.5198421,  1.0000000,  0.0000000,
  2.5198421,  2.5198421,  1.0000000,  1.0000000,
  2.5198421,  2.5198421,  1.0000000,  2.5198421,
  2.5198421,  2.5198421,  2.5198421,  0.0000000,
  2.5198421,  2.5198421,  2.5198421,  1.0000000,
  2.5198421,  2.5198421,  2.5198421,  2.5198421,
};

static const DECLARE_ALIGNED(16, float, codebook_vector4)[162] = {
 -6.3496042, -6.3496042, -6.3496042, -4.3267487,
 -6.3496042, -2.5198421, -6.3496042, -1.0000000,
 -6.3496042,  0.0000000, -6.3496042,  1.0000000,
 -6.3496042,  2.5198421, -6.3496042,  4.3267487,
 -6.3496042,  6.3496042, -4.3267487, -6.3496042,
 -4.3267487, -4.3267487, -4.3267487, -2.5198421,
 -4.3267487, -1.0000000, -4.3267487,  0.0000000,
 -4.3267487,  1.0000000, -4.3267487,  2.5198421,
 -4.3267487,  4.3267487, -4.3267487,  6.3496042,
 -2.5198421, -6.3496042, -2.5198421, -4.3267487,
 -2.5198421, -2.5198421, -2.5198421, -1.0000000,
 -2.5198421,  0.0000000, -2.5198421,  1.0000000,
 -2.5198421,  2.5198421, -2.5198421,  4.3267487,
 -2.5198421,  6.3496042, -1.0000000, -6.3496042,
 -1.0000000, -4.3267487, -1.0000000, -2.5198421,
 -1.0000000, -1.0000000, -1.0000000,  0.0000000,
 -1.0000000,  1.0000000, -1.0000000,  2.5198421,
 -1.0000000,  4.3267487, -1.0000000,  6.3496042,
  0.0000000, -6.3496042,  0.0000000, -4.3267487,
  0.0000000, -2.5198421,  0.0000000, -1.0000000,
  0.0000000,  0.0000000,  0.0000000,  1.0000000,
  0.0000000,  2.5198421,  0.0000000,  4.3267487,
  0.0000000,  6.3496042,  1.0000000, -6.3496042,
  1.0000000, -4.3267487,  1.0000000, -2.5198421,
  1.0000000, -1.0000000,  1.0000000,  0.0000000,
  1.0000000,  1.0000000,  1.0000000,  2.5198421,
  1.0000000,  4.3267487,  1.0000000,  6.3496042,
  2.5198421, -6.3496042,  2.5198421, -4.3267487,
  2.5198421, -2.5198421,  2.5198421, -1.0000000,
  2.5198421,  0.0000000,  2.5198421,  1.0000000,
  2.5198421,  2.5198421,  2.5198421,  4.3267487,
  2.5198421,  6.3496042,  4.3267487, -6.3496042,
  4.3267487, -4.3267487,  4.3267487, -2.5198421,
  4.3267487, -1.0000000,  4.3267487,  0.0000000,
  4.3267487,  1.0000000,  4.3267487,  2.5198421,
  4.3267487,  4.3267487,  4.3267487,  6.3496042,
  6.3496042, -6.3496042,  6.3496042, -4.3267487,
  6.3496042, -2.5198421,  6.3496042, -1.0000000,
  6.3496042,  0.0000000,  6.3496042,  1.0000000,
  6.3496042,  2.5198421,  6.3496042,  4.3267487,
  6.3496042,  6.3496042,
};

static const DECLARE_ALIGNED(16, float, codebook_vector6)[128] = {
  0.0000000,  0.0000000,  0.0000000,  1.0000000,
  0.0000000,  2.5198421,  0.0000000,  4.3267487,
  0.0000000,  6.3496042,  0.0000000,  8.5498797,
  0.0000000, 10.9027236,  0.0000000, 13.3905183,
  1.0000000,  0.0000000,  1.0000000,  1.0000000,
  1.0000000,  2.5198421,  1.0000000,  4.3267487,
  1.0000000,  6.3496042,  1.0000000,  8.5498797,
  1.0000000, 10.9027236,  1.0000000, 13.3905183,
  2.5198421,  0.0000000,  2.5198421,  1.0000000,
  2.5198421,  2.5198421,  2.5198421,  4.3267487,
  2.5198421,  6.3496042,  2.5198421,  8.5498797,
  2.5198421, 10.9027236,  2.5198421, 13.3905183,
  4.3267487,  0.0000000,  4.3267487,  1.0000000,
  4.3267487,  2.5198421,  4.3267487,  4.3267487,
  4.3267487,  6.3496042,  4.3267487,  8.5498797,
  4.3267487, 10.9027236,  4.3267487, 13.3905183,
  6.3496042,  0.0000000,  6.3496042,  1.0000000,
  6.3496042,  2.5198421,  6.3496042,  4.3267487,
  6.3496042,  6.3496042,  6.3496042,  8.5498797,
  6.3496042, 10.9027236,  6.3496042, 13.3905183,
  8.5498797,  0.0000000,  8.5498797,  1.0000000,
  8.5498797,  2.5198421,  8.5498797,  4.3267487,
  8.5498797,  6.3496042,  8.5498797,  8.5498797,
  8.5498797, 10.9027236,  8.5498797, 13.3905183,
 10.9027236,  0.0000000, 10.9027236,  1.0000000,
 10.9027236,  2.5198421, 10.9027236,  4.3267487,
 10.9027236,  6.3496042, 10.9027236,  8.5498797,
 10.9027236, 10.9027236, 10.9027236, 13.3905183,
 13.3905183,  0.0000000, 13.3905183,  1.0000000,
 13.3905183,  2.5198421, 13.3905183,  4.3267487,
 13.3905183,  6.3496042, 13.3905183,  8.5498797,
 13.3905183, 10.9027236, 13.3905183, 13.3905183,
};

static const DECLARE_ALIGNED(16, float, codebook_vector8)[338] = {
  0.0000000,  0.0000000,  0.0000000,  1.0000000,
  0.0000000,  2.5198421,  0.0000000,  4.3267487,
  0.0000000,  6.3496042,  0.0000000,  8.5498797,
  0.0000000, 10.9027236,  0.0000000, 13.3905183,
  0.0000000, 16.0000000,  0.0000000, 18.7207544,
  0.0000000, 21.5443469,  0.0000000, 24.4637810,
  0.0000000, 27.4731418,  1.0000000,  0.0000000,
  1.0000000,  1.0000000,  1.0000000,  2.5198421,
  1.0000000,  4.3267487,  1.0000000,  6.3496042,
  1.0000000,  8.5498797,  1.0000000, 10.9027236,
  1.0000000, 13.3905183,  1.0000000, 16.0000000,
  1.0000000, 18.7207544,  1.0000000, 21.5443469,
  1.0000000, 24.4637810,  1.0000000, 27.4731418,
  2.5198421,  0.0000000,  2.5198421,  1.0000000,
  2.5198421,  2.5198421,  2.5198421,  4.3267487,
  2.5198421,  6.3496042,  2.5198421,  8.5498797,
  2.5198421, 10.9027236,  2.5198421, 13.3905183,
  2.5198421, 16.0000000,  2.5198421, 18.7207544,
  2.5198421, 21.5443469,  2.5198421, 24.4637810,
  2.5198421, 27.4731418,  4.3267487,  0.0000000,
  4.3267487,  1.0000000,  4.3267487,  2.5198421,
  4.3267487,  4.3267487,  4.3267487,  6.3496042,
  4.3267487,  8.5498797,  4.3267487, 10.9027236,
  4.3267487, 13.3905183,  4.3267487, 16.0000000,
  4.3267487, 18.7207544,  4.3267487, 21.5443469,
  4.3267487, 24.4637810,  4.3267487, 27.4731418,
  6.3496042,  0.0000000,  6.3496042,  1.0000000,
  6.3496042,  2.5198421,  6.3496042,  4.3267487,
  6.3496042,  6.3496042,  6.3496042,  8.5498797,
  6.3496042, 10.9027236,  6.3496042, 13.3905183,
  6.3496042, 16.0000000,  6.3496042, 18.7207544,
  6.3496042, 21.5443469,  6.3496042, 24.4637810,
  6.3496042, 27.4731418,  8.5498797,  0.0000000,
  8.5498797,  1.0000000,  8.5498797,  2.5198421,
  8.5498797,  4.3267487,  8.5498797,  6.3496042,
  8.5498797,  8.5498797,  8.5498797, 10.9027236,
  8.5498797, 13.3905183,  8.5498797, 16.0000000,
  8.5498797, 18.7207544,  8.5498797, 21.5443469,
  8.5498797, 24.4637810,  8.5498797, 27.4731418,
 10.9027236,  0.0000000, 10.9027236,  1.0000000,
 10.9027236,  2.5198421, 10.9027236,  4.3267487,
 10.9027236,  6.3496042, 10.9027236,  8.5498797,
 10.9027236, 10.9027236, 10.9027236, 13.3905183,
 10.9027236, 16.0000000, 10.9027236, 18.7207544,
 10.9027236, 21.5443469, 10.9027236, 24.4637810,
 10.9027236, 27.4731418, 13.3905183,  0.0000000,
 13.3905183,  1.0000000, 13.3905183,  2.5198421,
 13.3905183,  4.3267487, 13.3905183,  6.3496042,
 13.3905183,  8.5498797, 13.3905183, 10.9027236,
 13.3905183, 13.3905183, 13.3905183, 16.0000000,
 13.3905183, 18.7207544, 13.3905183, 21.5443469,
 13.3905183, 24.4637810, 13.3905183, 27.4731418,
 16.0000000,  0.0000000, 16.0000000,  1.0000000,
 16.0000000,  2.5198421, 16.0000000,  4.3267487,
 16.0000000,  6.3496042, 16.0000000,  8.5498797,
 16.0000000, 10.9027236, 16.0000000, 13.3905183,
 16.0000000, 16.0000000, 16.0000000, 18.7207544,
 16.0000000, 21.5443469, 16.0000000, 24.4637810,
 16.0000000, 27.4731418, 18.7207544,  0.0000000,
 18.7207544,  1.0000000, 18.7207544,  2.5198421,
 18.7207544,  4.3267487, 18.7207544,  6.3496042,
 18.7207544,  8.5498797, 18.7207544, 10.9027236,
 18.7207544, 13.3905183, 18.7207544, 16.0000000,
 18.7207544, 18.7207544, 18.7207544, 21.5443469,
 18.7207544, 24.4637810, 18.7207544, 27.4731418,
 21.5443469,  0.0000000, 21.5443469,  1.0000000,
 21.5443469,  2.5198421, 21.5443469,  4.3267487,
 21.5443469,  6.3496042, 21.5443469,  8.5498797,
 21.5443469, 10.9027236, 21.5443469, 13.3905183,
 21.5443469, 16.0000000, 21.5443469, 18.7207544,
 21.5443469, 21.5443469, 21.5443469, 24.4637810,
 21.5443469, 27.4731418, 24.4637810,  0.0000000,
 24.4637810,  1.0000000, 24.4637810,  2.5198421,
 24.4637810,  4.3267487, 24.4637810,  6.3496042,
 24.4637810,  8.5498797, 24.4637810, 10.9027236,
 24.4637810, 13.3905183, 24.4637810, 16.0000000,
 24.4637810, 18.7207544, 24.4637810, 21.5443469,
 24.4637810, 24.4637810, 24.4637810, 27.4731418,
 27.4731418,  0.0000000, 27.4731418,  1.0000000,
 27.4731418,  2.5198421, 27.4731418,  4.3267487,
 27.4731418,  6.3496042, 27.4731418,  8.5498797,
 27.4731418, 10.9027236, 27.4731418, 13.3905183,
 27.4731418, 16.0000000, 27.4731418, 18.7207544,
 27.4731418, 21.5443469, 27.4731418, 24.4637810,
 27.4731418, 27.4731418,
};

static const DECLARE_ALIGNED(16, float, codebook_vector10)[578] = {
  0.0000000,  0.0000000,  0.0000000,  1.0000000,
  0.0000000,  2.5198421,  0.0000000,  4.3267487,
  0.0000000,  6.3496042,  0.0000000,  8.5498797,
  0.0000000, 10.9027236,  0.0000000, 13.3905183,
  0.0000000, 16.0000000,  0.0000000, 18.7207544,
  0.0000000, 21.5443469,  0.0000000, 24.4637810,
  0.0000000, 27.4731418,  0.0000000, 30.5673509,
  0.0000000, 33.7419917,  0.0000000, 36.9931811,
  0.0000000,      64.0f,  1.0000000,  0.0000000,
  1.0000000,  1.0000000,  1.0000000,  2.5198421,
  1.0000000,  4.3267487,  1.0000000,  6.3496042,
  1.0000000,  8.5498797,  1.0000000, 10.9027236,
  1.0000000, 13.3905183,  1.0000000, 16.0000000,
  1.0000000, 18.7207544,  1.0000000, 21.5443469,
  1.0000000, 24.4637810,  1.0000000, 27.4731418,
  1.0000000, 30.5673509,  1.0000000, 33.7419917,
  1.0000000, 36.9931811,  1.0000000,      64.0f,
  2.5198421,  0.0000000,  2.5198421,  1.0000000,
  2.5198421,  2.5198421,  2.5198421,  4.3267487,
  2.5198421,  6.3496042,  2.5198421,  8.5498797,
  2.5198421, 10.9027236,  2.5198421, 13.3905183,
  2.5198421, 16.0000000,  2.5198421, 18.7207544,
  2.5198421, 21.5443469,  2.5198421, 24.4637810,
  2.5198421, 27.4731418,  2.5198421, 30.5673509,
  2.5198421, 33.7419917,  2.5198421, 36.9931811,
  2.5198421,      64.0f,  4.3267487,  0.0000000,
  4.3267487,  1.0000000,  4.3267487,  2.5198421,
  4.3267487,  4.3267487,  4.3267487,  6.3496042,
  4.3267487,  8.5498797,  4.3267487, 10.9027236,
  4.3267487, 13.3905183,  4.3267487, 16.0000000,
  4.3267487, 18.7207544,  4.3267487, 21.5443469,
  4.3267487, 24.4637810,  4.3267487, 27.4731418,
  4.3267487, 30.5673509,  4.3267487, 33.7419917,
  4.3267487, 36.9931811,  4.3267487,      64.0f,
  6.3496042,  0.0000000,  6.3496042,  1.0000000,
  6.3496042,  2.5198421,  6.3496042,  4.3267487,
  6.3496042,  6.3496042,  6.3496042,  8.5498797,
  6.3496042, 10.9027236,  6.3496042, 13.3905183,
  6.3496042, 16.0000000,  6.3496042, 18.7207544,
  6.3496042, 21.5443469,  6.3496042, 24.4637810,
  6.3496042, 27.4731418,  6.3496042, 30.5673509,
  6.3496042, 33.7419917,  6.3496042, 36.9931811,
  6.3496042,      64.0f,  8.5498797,  0.0000000,
  8.5498797,  1.0000000,  8.5498797,  2.5198421,
  8.5498797,  4.3267487,  8.5498797,  6.3496042,
  8.5498797,  8.5498797,  8.5498797, 10.9027236,
  8.5498797, 13.3905183,  8.5498797, 16.0000000,
  8.5498797, 18.7207544,  8.5498797, 21.5443469,
  8.5498797, 24.4637810,  8.5498797, 27.4731418,
  8.5498797, 30.5673509,  8.5498797, 33.7419917,
  8.5498797, 36.9931811,  8.5498797,      64.0f,
 10.9027236,  0.0000000, 10.9027236,  1.0000000,
 10.9027236,  2.5198421, 10.9027236,  4.3267487,
 10.9027236,  6.3496042, 10.9027236,  8.5498797,
 10.9027236, 10.9027236, 10.9027236, 13.3905183,
 10.9027236, 16.0000000, 10.9027236, 18.7207544,
 10.9027236, 21.5443469, 10.9027236, 24.4637810,
 10.9027236, 27.4731418, 10.9027236, 30.5673509,
 10.9027236, 33.7419917, 10.9027236, 36.9931811,
 10.9027236,      64.0f, 13.3905183,  0.0000000,
 13.3905183,  1.0000000, 13.3905183,  2.5198421,
 13.3905183,  4.3267487, 13.3905183,  6.3496042,
 13.3905183,  8.5498797, 13.3905183, 10.9027236,
 13.3905183, 13.3905183, 13.3905183, 16.0000000,
 13.3905183, 18.7207544, 13.3905183, 21.5443469,
 13.3905183, 24.4637810, 13.3905183, 27.4731418,
 13.3905183, 30.5673509, 13.3905183, 33.7419917,
 13.3905183, 36.9931811, 13.3905183,      64.0f,
 16.0000000,  0.0000000, 16.0000000,  1.0000000,
 16.0000000,  2.5198421, 16.0000000,  4.3267487,
 16.0000000,  6.3496042, 16.0000000,  8.5498797,
 16.0000000, 10.9027236, 16.0000000, 13.3905183,
 16.0000000, 16.0000000, 16.0000000, 18.7207544,
 16.0000000, 21.5443469, 16.0000000, 24.4637810,
 16.0000000, 27.4731418, 16.0000000, 30.5673509,
 16.0000000, 33.7419917, 16.0000000, 36.9931811,
 16.0000000,      64.0f, 18.7207544,  0.0000000,
 18.7207544,  1.0000000, 18.7207544,  2.5198421,
 18.7207544,  4.3267487, 18.7207544,  6.3496042,
 18.7207544,  8.5498797, 18.7207544, 10.9027236,
 18.7207544, 13.3905183, 18.7207544, 16.0000000,
 18.7207544, 18.7207544, 18.7207544, 21.5443469,
 18.7207544, 24.4637810, 18.7207544, 27.4731418,
 18.7207544, 30.5673509, 18.7207544, 33.7419917,
 18.7207544, 36.9931811, 18.7207544,      64.0f,
 21.5443469,  0.0000000, 21.5443469,  1.0000000,
 21.5443469,  2.5198421, 21.5443469,  4.3267487,
 21.5443469,  6.3496042, 21.5443469,  8.5498797,
 21.5443469, 10.9027236, 21.5443469, 13.3905183,
 21.5443469, 16.0000000, 21.5443469, 18.7207544,
 21.5443469, 21.5443469, 21.5443469, 24.4637810,
 21.5443469, 27.4731418, 21.5443469, 30.5673509,
 21.5443469, 33.7419917, 21.5443469, 36.9931811,
 21.5443469,      64.0f, 24.4637810,  0.0000000,
 24.4637810,  1.0000000, 24.4637810,  2.5198421,
 24.4637810,  4.3267487, 24.4637810,  6.3496042,
 24.4637810,  8.5498797, 24.4637810, 10.9027236,
 24.4637810, 13.3905183, 24.4637810, 16.0000000,
 24.4637810, 18.7207544, 24.4637810, 21.5443469,
 24.4637810, 24.4637810, 24.4637810, 27.4731418,
 24.4637810, 30.5673509, 24.4637810, 33.7419917,
 24.4637810, 36.9931811, 24.4637810,      64.0f,
 27.4731418,  0.0000000, 27.4731418,  1.0000000,
 27.4731418,  2.5198421, 27.4731418,  4.3267487,
 27.4731418,  6.3496042, 27.4731418,  8.5498797,
 27.4731418, 10.9027236, 27.4731418, 13.3905183,
 27.4731418, 16.0000000, 27.4731418, 18.7207544,
 27.4731418, 21.5443469, 27.4731418, 24.4637810,
 27.4731418, 27.4731418, 27.4731418, 30.5673509,
 27.4731418, 33.7419917, 27.4731418, 36.9931811,
 27.4731418,      64.0f, 30.5673509,  0.0000000,
 30.5673509,  1.0000000, 30.5673509,  2.5198421,
 30.5673509,  4.3267487, 30.5673509,  6.3496042,
 30.5673509,  8.5498797, 30.5673509, 10.9027236,
 30.5673509, 13.3905183, 30.5673509, 16.0000000,
 30.5673509, 18.7207544, 30.5673509, 21.5443469,
 30.5673509, 24.4637810, 30.5673509, 27.4731418,
 30.5673509, 30.5673509, 30.5673509, 33.7419917,
 30.5673509, 36.9931811, 30.5673509,      64.0f,
 33.7419917,  0.0000000, 33.7419917,  1.0000000,
 33.7419917,  2.5198421, 33.7419917,  4.3267487,
 33.7419917,  6.3496042, 33.7419917,  8.5498797,
 33.7419917, 10.9027236, 33.7419917, 13.3905183,
 33.7419917, 16.0000000, 33.7419917, 18.7207544,
 33.7419917, 21.5443469, 33.7419917, 24.4637810,
 33.7419917, 27.4731418, 33.7419917, 30.5673509,
 33.7419917, 33.7419917, 33.7419917, 36.9931811,
 33.7419917,      64.0f, 36.9931811,  0.0000000,
 36.9931811,  1.0000000, 36.9931811,  2.5198421,
 36.9931811,  4.3267487, 36.9931811,  6.3496042,
 36.9931811,  8.5498797, 36.9931811, 10.9027236,
 36.9931811, 13.3905183, 36.9931811, 16.0000000,
 36.9931811, 18.7207544, 36.9931811, 21.5443469,
 36.9931811, 24.4637810, 36.9931811, 27.4731418,
 36.9931811, 30.5673509, 36.9931811, 33.7419917,
 36.9931811, 36.9931811, 36.9931811,      64.0f,
      64.0f,  0.0000000,      64.0f,  1.0000000,
      64.0f,  2.5198421,      64.0f,  4.3267487,
      64.0f,  6.3496042,      64.0f,  8.5498797,
      64.0f, 10.9027236,      64.0f, 13.3905183,
      64.0f, 16.0000000,      64.0f, 18.7207544,
      64.0f, 21.5443469,      64.0f, 24.4637810,
      64.0f, 27.4731418,      64.0f, 30.5673509,
      64.0f, 33.7419917,      64.0f, 36.9931811,
      64.0f,      64.0f,
};

const float * const ff_aac_codebook_vectors[] = {
    codebook_vector0, codebook_vector0, codebook_vector2,
    codebook_vector2, codebook_vector4, codebook_vector4,
    codebook_vector6, codebook_vector6, codebook_vector8,
    codebook_vector8, codebook_vector10,
};

static const float codebook_vector0_vals[] = {
   -1.0000000,  0.0000000,  1.0000000
};

/*
 * bits  0:1, 2:3, 4:5, 6:7  index into _vals array
 *       8:11                number of non-zero values
 *      12:15                bit mask of non-zero values
 */
static const uint16_t codebook_vector02_idx[] = {
    0x0000, 0x8140, 0x8180, 0x4110, 0xc250, 0xc290, 0x4120, 0xc260, 0xc2a0,
    0x2104, 0xa244, 0xa284, 0x6214, 0xe354, 0xe394, 0x6224, 0xe364, 0xe3a4,
    0x2108, 0xa248, 0xa288, 0x6218, 0xe358, 0xe398, 0x6228, 0xe368, 0xe3a8,
    0x1101, 0x9241, 0x9281, 0x5211, 0xd351, 0xd391, 0x5221, 0xd361, 0xd3a1,
    0x3205, 0xb345, 0xb385, 0x7315, 0xf455, 0xf495, 0x7325, 0xf465, 0xf4a5,
    0x3209, 0xb349, 0xb389, 0x7319, 0xf459, 0xf499, 0x7329, 0xf469, 0xf4a9,
    0x1102, 0x9242, 0x9282, 0x5212, 0xd352, 0xd392, 0x5222, 0xd362, 0xd3a2,
    0x3206, 0xb346, 0xb386, 0x7316, 0xf456, 0xf496, 0x7326, 0xf466, 0xf4a6,
    0x320a, 0xb34a, 0xb38a, 0x731a, 0xf45a, 0xf49a, 0x732a, 0xf46a, 0xf4aa,
};

static const float codebook_vector4_vals[] = {
   -6.3496042, -4.3267487,
   -2.5198421, -1.0000000,
    0.0000000,  1.0000000,
    2.5198421,  4.3267487,
    6.3496042,
};

/*
 * bits  0:3, 4:7  index into _vals array
 */
static const uint16_t codebook_vector4_idx[] = {
    0x0000, 0x0010, 0x0020, 0x0030, 0x0040, 0x0050, 0x0060, 0x0070, 0x0080,
    0x0001, 0x0011, 0x0021, 0x0031, 0x0041, 0x0051, 0x0061, 0x0071, 0x0081,
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072, 0x0082,
    0x0003, 0x0013, 0x0023, 0x0033, 0x0043, 0x0053, 0x0063, 0x0073, 0x0083,
    0x0004, 0x0014, 0x0024, 0x0034, 0x0044, 0x0054, 0x0064, 0x0074, 0x0084,
    0x0005, 0x0015, 0x0025, 0x0035, 0x0045, 0x0055, 0x0065, 0x0075, 0x0085,
    0x0006, 0x0016, 0x0026, 0x0036, 0x0046, 0x0056, 0x0066, 0x0076, 0x0086,
    0x0007, 0x0017, 0x0027, 0x0037, 0x0047, 0x0057, 0x0067, 0x0077, 0x0087,
    0x0008, 0x0018, 0x0028, 0x0038, 0x0048, 0x0058, 0x0068, 0x0078, 0x0088,
};

/*
 * bits  0:3, 4:7  index into _vals array
 *       8:11      number of non-zero values
 *      12:15      1: only second value non-zero
 *                 0: other cases
 */
static const uint16_t codebook_vector6_idx[] = {
    0x0000, 0x0110, 0x0120, 0x0130, 0x0140, 0x0150, 0x0160, 0x0170,
    0x1101, 0x0211, 0x0221, 0x0231, 0x0241, 0x0251, 0x0261, 0x0271,
    0x1102, 0x0212, 0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272,
    0x1103, 0x0213, 0x0223, 0x0233, 0x0243, 0x0253, 0x0263, 0x0273,
    0x1104, 0x0214, 0x0224, 0x0234, 0x0244, 0x0254, 0x0264, 0x0274,
    0x1105, 0x0215, 0x0225, 0x0235, 0x0245, 0x0255, 0x0265, 0x0275,
    0x1106, 0x0216, 0x0226, 0x0236, 0x0246, 0x0256, 0x0266, 0x0276,
    0x1107, 0x0217, 0x0227, 0x0237, 0x0247, 0x0257, 0x0267, 0x0277,
};

/*
 * bits  0:3, 4:7  index into _vals array
 *       8:11      number of non-zero values
 *      12:15      1: only second value non-zero
 *                 0: other cases
 */
static const uint16_t codebook_vector8_idx[] = {
  0x0000, 0x0110, 0x0120, 0x0130, 0x0140, 0x0150, 0x0160,
  0x0170, 0x0180, 0x0190, 0x01a0, 0x01b0, 0x01c0,
  0x1101, 0x0211, 0x0221, 0x0231, 0x0241, 0x0251, 0x0261,
  0x0271, 0x0281, 0x0291, 0x02a1, 0x02b1, 0x02c1,
  0x1102, 0x0212, 0x0222, 0x0232, 0x0242, 0x0252, 0x0262,
  0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2, 0x02c2,
  0x1103, 0x0213, 0x0223, 0x0233, 0x0243, 0x0253, 0x0263,
  0x0273, 0x0283, 0x0293, 0x02a3, 0x02b3, 0x02c3,
  0x1104, 0x0214, 0x0224, 0x0234, 0x0244, 0x0254, 0x0264,
  0x0274, 0x0284, 0x0294, 0x02a4, 0x02b4, 0x02c4,
  0x1105, 0x0215, 0x0225, 0x0235, 0x0245, 0x0255, 0x0265,
  0x0275, 0x0285, 0x0295, 0x02a5, 0x02b5, 0x02c5,
  0x1106, 0x0216, 0x0226, 0x0236, 0x0246, 0x0256, 0x0266,
  0x0276, 0x0286, 0x0296, 0x02a6, 0x02b6, 0x02c6,
  0x1107, 0x0217, 0x0227, 0x0237, 0x0247, 0x0257, 0x0267,
  0x0277, 0x0287, 0x0297, 0x02a7, 0x02b7, 0x02c7,
  0x1108, 0x0218, 0x0228, 0x0238, 0x0248, 0x0258, 0x0268,
  0x0278, 0x0288, 0x0298, 0x02a8, 0x02b8, 0x02c8,
  0x1109, 0x0219, 0x0229, 0x0239, 0x0249, 0x0259, 0x0269,
  0x0279, 0x0289, 0x0299, 0x02a9, 0x02b9, 0x02c9,
  0x110a, 0x021a, 0x022a, 0x023a, 0x024a, 0x025a, 0x026a,
  0x027a, 0x028a, 0x029a, 0x02aa, 0x02ba, 0x02ca,
  0x110b, 0x021b, 0x022b, 0x023b, 0x024b, 0x025b, 0x026b,
  0x027b, 0x028b, 0x029b, 0x02ab, 0x02bb, 0x02cb,
  0x110c, 0x021c, 0x022c, 0x023c, 0x024c, 0x025c, 0x026c,
  0x027c, 0x028c, 0x029c, 0x02ac, 0x02bc, 0x02cc,
};

static const float codebook_vector10_vals[] = {
     0.0000000,  1.0000000,
     2.5198421,  4.3267487,
     6.3496042,  8.5498797,
    10.9027236, 13.3905183,
    16.0000000, 18.7207544,
    21.5443469, 24.4637810,
    27.4731418, 30.5673509,
    33.7419917, 36.9931811,
};

/*
 * bits  0:3, 4:7  index into _vals array
 *       8:9       bit mask of escape-coded entries
 *      12:15      number of non-zero values
 */
static const uint16_t codebook_vector10_idx[] = {
    0x0000, 0x1010, 0x1020, 0x1030, 0x1040, 0x1050, 0x1060, 0x1070,
    0x1080, 0x1090, 0x10a0, 0x10b0, 0x10c0, 0x10d0, 0x10e0, 0x10f0, 0x1200,
    0x1001, 0x2011, 0x2021, 0x2031, 0x2041, 0x2051, 0x2061, 0x2071,
    0x2081, 0x2091, 0x20a1, 0x20b1, 0x20c1, 0x20d1, 0x20e1, 0x20f1, 0x2201,
    0x1002, 0x2012, 0x2022, 0x2032, 0x2042, 0x2052, 0x2062, 0x2072,
    0x2082, 0x2092, 0x20a2, 0x20b2, 0x20c2, 0x20d2, 0x20e2, 0x20f2, 0x2202,
    0x1003, 0x2013, 0x2023, 0x2033, 0x2043, 0x2053, 0x2063, 0x2073,
    0x2083, 0x2093, 0x20a3, 0x20b3, 0x20c3, 0x20d3, 0x20e3, 0x20f3, 0x2203,
    0x1004, 0x2014, 0x2024, 0x2034, 0x2044, 0x2054, 0x2064, 0x2074,
    0x2084, 0x2094, 0x20a4, 0x20b4, 0x20c4, 0x20d4, 0x20e4, 0x20f4, 0x2204,
    0x1005, 0x2015, 0x2025, 0x2035, 0x2045, 0x2055, 0x2065, 0x2075,
    0x2085, 0x2095, 0x20a5, 0x20b5, 0x20c5, 0x20d5, 0x20e5, 0x20f5, 0x2205,
    0x1006, 0x2016, 0x2026, 0x2036, 0x2046, 0x2056, 0x2066, 0x2076,
    0x2086, 0x2096, 0x20a6, 0x20b6, 0x20c6, 0x20d6, 0x20e6, 0x20f6, 0x2206,
    0x1007, 0x2017, 0x2027, 0x2037, 0x2047, 0x2057, 0x2067, 0x2077,
    0x2087, 0x2097, 0x20a7, 0x20b7, 0x20c7, 0x20d7, 0x20e7, 0x20f7, 0x2207,
    0x1008, 0x2018, 0x2028, 0x2038, 0x2048, 0x2058, 0x2068, 0x2078,
    0x2088, 0x2098, 0x20a8, 0x20b8, 0x20c8, 0x20d8, 0x20e8, 0x20f8, 0x2208,
    0x1009, 0x2019, 0x2029, 0x2039, 0x2049, 0x2059, 0x2069, 0x2079,
    0x2089, 0x2099, 0x20a9, 0x20b9, 0x20c9, 0x20d9, 0x20e9, 0x20f9, 0x2209,
    0x100a, 0x201a, 0x202a, 0x203a, 0x204a, 0x205a, 0x206a, 0x207a,
    0x208a, 0x209a, 0x20aa, 0x20ba, 0x20ca, 0x20da, 0x20ea, 0x20fa, 0x220a,
    0x100b, 0x201b, 0x202b, 0x203b, 0x204b, 0x205b, 0x206b, 0x207b,
    0x208b, 0x209b, 0x20ab, 0x20bb, 0x20cb, 0x20db, 0x20eb, 0x20fb, 0x220b,
    0x100c, 0x201c, 0x202c, 0x203c, 0x204c, 0x205c, 0x206c, 0x207c,
    0x208c, 0x209c, 0x20ac, 0x20bc, 0x20cc, 0x20dc, 0x20ec, 0x20fc, 0x220c,
    0x100d, 0x201d, 0x202d, 0x203d, 0x204d, 0x205d, 0x206d, 0x207d,
    0x208d, 0x209d, 0x20ad, 0x20bd, 0x20cd, 0x20dd, 0x20ed, 0x20fd, 0x220d,
    0x100e, 0x201e, 0x202e, 0x203e, 0x204e, 0x205e, 0x206e, 0x207e,
    0x208e, 0x209e, 0x20ae, 0x20be, 0x20ce, 0x20de, 0x20ee, 0x20fe, 0x220e,
    0x100f, 0x201f, 0x202f, 0x203f, 0x204f, 0x205f, 0x206f, 0x207f,
    0x208f, 0x209f, 0x20af, 0x20bf, 0x20cf, 0x20df, 0x20ef, 0x20ff, 0x220f,
    0x1100, 0x2110, 0x2120, 0x2130, 0x2140, 0x2150, 0x2160, 0x2170,
    0x2180, 0x2190, 0x21a0, 0x21b0, 0x21c0, 0x21d0, 0x21e0, 0x21f0, 0x2300,
};

const float *const ff_aac_codebook_vector_vals[] = {
    codebook_vector0_vals,  codebook_vector0_vals,
    codebook_vector10_vals, codebook_vector10_vals,
    codebook_vector4_vals,  codebook_vector4_vals,
    codebook_vector10_vals, codebook_vector10_vals,
    codebook_vector10_vals, codebook_vector10_vals,
    codebook_vector10_vals,
};

const uint16_t *const ff_aac_codebook_vector_idx[] = {
    codebook_vector02_idx, codebook_vector02_idx,
    codebook_vector02_idx, codebook_vector02_idx,
    codebook_vector4_idx,  codebook_vector4_idx,
    codebook_vector6_idx,  codebook_vector6_idx,
    codebook_vector8_idx,  codebook_vector8_idx,
    codebook_vector10_idx,
};

/* @name swb_offsets
 * Sample offset into the window indicating the beginning of a scalefactor
 * window band
 *
 * scalefactor window band - term for scalefactor bands within a window,
 * given in Table 4.110 to Table 4.128.
 *
 * scalefactor band - a set of spectral coefficients which are scaled by one
 * scalefactor. In case of EIGHT_SHORT_SEQUENCE and grouping a scalefactor band
 * may contain several scalefactor window bands of corresponding frequency. For
 * all other window_sequences scalefactor bands and scalefactor window bands are
 * identical.
 * @{
 */

static const uint16_t swb_offset_1024_96[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  44,  48,  52,  56,  64,
     72,  80,  88,  96, 108, 120, 132, 144,
    156, 172, 188, 212, 240, 276, 320, 384,
    448, 512, 576, 640, 704, 768, 832, 896,
    960, 1024
};

static const uint16_t swb_offset_128_96[] = {
    0, 4, 8, 12, 16, 20, 24, 32, 40, 48, 64, 92, 128
};

static const uint16_t swb_offset_1024_64[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  44,  48,  52,  56,  64,
     72,  80,  88, 100, 112, 124, 140, 156,
    172, 192, 216, 240, 268, 304, 344, 384,
    424, 464, 504, 544, 584, 624, 664, 704,
    744, 784, 824, 864, 904, 944, 984, 1024
};

static const uint16_t swb_offset_1024_48[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  48,  56,  64,  72,  80,
     88,  96, 108, 120, 132, 144, 160, 176,
    196, 216, 240, 264, 292, 320, 352, 384,
    416, 448, 480, 512, 544, 576, 608, 640,
    672, 704, 736, 768, 800, 832, 864, 896,
    928, 1024
};

static const uint16_t swb_offset_512_48[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  44,  48,  52,  56,  60,
     68,  76,  84,  92, 100, 112, 124, 136,
    148, 164, 184, 208, 236, 268, 300, 332,
    364, 396, 428, 460, 512
};

static const uint16_t swb_offset_128_48[] = {
     0,   4,   8,  12,  16,  20,  28,  36,
    44,  56,  68,  80,  96, 112, 128
};

static const uint16_t swb_offset_1024_32[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  48,  56,  64,  72,  80,
     88,  96, 108, 120, 132, 144, 160, 176,
    196, 216, 240, 264, 292, 320, 352, 384,
    416, 448, 480, 512, 544, 576, 608, 640,
    672, 704, 736, 768, 800, 832, 864, 896,
    928, 960, 992, 1024
};

static const uint16_t swb_offset_512_32[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  44,  48,  52,  56,  64,
     72,  80,  88,  96, 108, 120, 132, 144,
    160, 176, 192, 212, 236, 260, 288, 320,
    352, 384, 416, 448, 480, 512
};

static const uint16_t swb_offset_1024_24[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  44,  52,  60,  68,  76,
     84,  92, 100, 108, 116, 124, 136, 148,
    160, 172, 188, 204, 220, 240, 260, 284,
    308, 336, 364, 396, 432, 468, 508, 552,
    600, 652, 704, 768, 832, 896, 960, 1024
};

static const uint16_t swb_offset_512_24[] = {
      0,   4,   8,  12,  16,  20,  24,  28,
     32,  36,  40,  44,  52,  60,  68,  80,
     92, 104, 120, 140, 164, 192, 224, 256,
    288, 320, 352, 384, 416, 448, 480, 512,
};

static const uint16_t swb_offset_128_24[] = {
     0,   4,   8,  12,  16,  20,  24,  28,
    36,  44,  52,  64,  76,  92, 108, 128
};

static const uint16_t swb_offset_1024_16[] = {
      0,   8,  16,  24,  32,  40,  48,  56,
     64,  72,  80,  88, 100, 112, 124, 136,
    148, 160, 172, 184, 196, 212, 228, 244,
    260, 280, 300, 320, 344, 368, 396, 424,
    456, 492, 532, 572, 616, 664, 716, 772,
    832, 896, 960, 1024
};

static const uint16_t swb_offset_128_16[] = {
     0,   4,   8,  12,  16,  20,  24,  28,
    32,  40,  48,  60,  72,  88, 108, 128
};

static const uint16_t swb_offset_1024_8[] = {
      0,  12,  24,  36,  48,  60,  72,  84,
     96, 108, 120, 132, 144, 156, 172, 188,
    204, 220, 236, 252, 268, 288, 308, 328,
    348, 372, 396, 420, 448, 476, 508, 544,
    580, 620, 664, 712, 764, 820, 880, 944,
    1024
};

static const uint16_t swb_offset_128_8[] = {
     0,   4,   8,  12,  16,  20,  24,  28,
    36,  44,  52,  60,  72,  88, 108, 128
};

const uint16_t * const ff_swb_offset_1024[] = {
    swb_offset_1024_96, swb_offset_1024_96, swb_offset_1024_64,
    swb_offset_1024_48, swb_offset_1024_48, swb_offset_1024_32,
    swb_offset_1024_24, swb_offset_1024_24, swb_offset_1024_16,
    swb_offset_1024_16, swb_offset_1024_16, swb_offset_1024_8,
    swb_offset_1024_8
};

const uint16_t * const ff_swb_offset_512[] = {
    NULL,               NULL,               NULL,
    swb_offset_512_48,  swb_offset_512_48,  swb_offset_512_32,
    swb_offset_512_24,  swb_offset_512_24,  NULL,
    NULL,               NULL,               NULL,
    NULL
};

const uint16_t * const ff_swb_offset_128[] = {
    /* The last entry on the following row is swb_offset_128_64 but is a
       duplicate of swb_offset_128_96. */
    swb_offset_128_96, swb_offset_128_96, swb_offset_128_96,
    swb_offset_128_48, swb_offset_128_48, swb_offset_128_48,
    swb_offset_128_24, swb_offset_128_24, swb_offset_128_16,
    swb_offset_128_16, swb_offset_128_16, swb_offset_128_8,
    swb_offset_128_8
};

// @}

/* @name ff_tns_max_bands
 * The maximum number of scalefactor bands on which TNS can operate for the long
 * and short transforms respectively. The index to these tables is related to
 * the sample rate of the audio.
 * @{
 */
const uint8_t ff_tns_max_bands_1024[] = {
    31, 31, 34, 40, 42, 51, 46, 46, 42, 42, 42, 39, 39
};

const uint8_t ff_tns_max_bands_512[] = {
    0, 0, 0, 31, 32, 37, 31, 31, 0, 0, 0, 0, 0
};

const uint8_t ff_tns_max_bands_128[] = {
    9, 9, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
};
// @}

const DECLARE_ALIGNED(32, float, ff_aac_eld_window)[1920] = {
     0.00338834,  0.00567745,  0.00847677,  0.01172641,
     0.01532555,  0.01917664,  0.02318809,  0.02729259,
     0.03144503,  0.03560261,  0.03972499,  0.04379783,
     0.04783094,  0.05183357,  0.05581342,  0.05977723,
     0.06373173,  0.06768364,  0.07163937,  0.07559976,
     0.07956096,  0.08352024,  0.08747623,  0.09143035,
     0.09538618,  0.09934771,  0.10331917,  0.10730456,
     0.11130697,  0.11532867,  0.11937133,  0.12343922,
     0.12753911,  0.13167705,  0.13585812,  0.14008529,
     0.14435986,  0.14868291,  0.15305531,  0.15747594,
     0.16194193,  0.16645070,  0.17099991,  0.17558633,
     0.18020600,  0.18485548,  0.18953191,  0.19423322,
     0.19895800,  0.20370512,  0.20847374,  0.21326312,
     0.21807244,  0.22290083,  0.22774742,  0.23261210,
     0.23749542,  0.24239767,  0.24731889,  0.25225887,
     0.25721719,  0.26219330,  0.26718648,  0.27219630,
     0.27722262,  0.28226514,  0.28732336,  0.29239628,
     0.29748247,  0.30258055,  0.30768914,  0.31280508,
     0.31792385,  0.32304172,  0.32815579,  0.33326397,
     0.33836470,  0.34345661,  0.34853868,  0.35361188,
     0.35867865,  0.36374072,  0.36879900,  0.37385347,
     0.37890349,  0.38394836,  0.38898730,  0.39401912,
     0.39904236,  0.40405575,  0.40905820,  0.41404819,
     0.41902398,  0.42398423,  0.42892805,  0.43385441,
     0.43876210,  0.44365014,  0.44851786,  0.45336632,
     0.45819759,  0.46301302,  0.46781309,  0.47259722,
     0.47736435,  0.48211365,  0.48684450,  0.49155594,
     0.49624679,  0.50091636,  0.50556440,  0.51019132,
     0.51479771,  0.51938391,  0.52394998,  0.52849587,
     0.53302151,  0.53752680,  0.54201160,  0.54647575,
     0.55091916,  0.55534181,  0.55974376,  0.56412513,
     0.56848615,  0.57282710,  0.57714834,  0.58145030,
     0.58492489,  0.58918511,  0.59342326,  0.59763936,
     0.60183347,  0.60600561,  0.61015581,  0.61428412,
     0.61839056,  0.62247517,  0.62653799,  0.63057912,
     0.63459872,  0.63859697,  0.64257403,  0.64653001,
     0.65046495,  0.65437887,  0.65827181,  0.66214383,
     0.66599499,  0.66982535,  0.67363499,  0.67742394,
     0.68119219,  0.68493972,  0.68866653,  0.69237258,
     0.69605778,  0.69972207,  0.70336537,  0.70698758,
     0.71058862,  0.71416837,  0.71772674,  0.72126361,
     0.72477889,  0.72827246,  0.73174419,  0.73519392,
     0.73862141,  0.74202643,  0.74540874,  0.74876817,
     0.75210458,  0.75541785,  0.75870785,  0.76197437,
     0.76521709,  0.76843570,  0.77162988,  0.77479939,
     0.77794403,  0.78106359,  0.78415789,  0.78722670,
     0.79026979,  0.79328694,  0.79627791,  0.79924244,
     0.80218027,  0.80509112,  0.80797472,  0.81083081,
     0.81365915,  0.81645949,  0.81923160,  0.82197528,
     0.82469037,  0.82737673,  0.83003419,  0.83266262,
     0.83526186,  0.83783176,  0.84037217,  0.84288297,
     0.84536401,  0.84781517,  0.85023632,  0.85262739,
     0.85498836,  0.85731921,  0.85961993,  0.86189052,
     0.86413101,  0.86634140,  0.86852173,  0.87067211,
     0.87279275,  0.87488384,  0.87694559,  0.87897824,
     0.88098206,  0.88295729,  0.88490423,  0.88682332,
     0.88871519,  0.89058048,  0.89241983,  0.89423391,
     0.89602338,  0.89778893,  0.89953126,  0.90125142,
     0.90295086,  0.90463104,  0.90629341,  0.90793946,
     0.90957067,  0.91118856,  0.91279464,  0.91439073,
     0.91597898,  0.91756153,  0.91914049,  0.92071690,
     0.92229070,  0.92386182,  0.92542993,  0.92698946,
     0.92852960,  0.93003929,  0.93150727,  0.93291739,
     0.93424863,  0.93547974,  0.93658982,  0.93756587,
     0.93894072,  0.93922780,  0.93955477,  0.93991290,
     0.94029104,  0.94067794,  0.94106258,  0.94144084,
     0.94181549,  0.94218963,  0.94256628,  0.94294662,
     0.94332998,  0.94371562,  0.94410280,  0.94449122,
     0.94488106,  0.94527249,  0.94566568,  0.94606074,
     0.94645772,  0.94685665,  0.94725759,  0.94766054,
     0.94806547,  0.94847234,  0.94888115,  0.94929190,
     0.94970469,  0.95011960,  0.95053672,  0.95095604,
     0.95137751,  0.95180105,  0.95222658,  0.95265413,
     0.95308380,  0.95351571,  0.95394994,  0.95438653,
     0.95482538,  0.95526643,  0.95570958,  0.95615486,
     0.95660234,  0.95705214,  0.95750433,  0.95795892,
     0.95841582,  0.95887493,  0.95933616,  0.95979949,
     0.96026500,  0.96073277,  0.96120286,  0.96167526,
     0.96214986,  0.96262655,  0.96310522,  0.96358586,
     0.96406853,  0.96455330,  0.96504026,  0.96552936,
     0.96602051,  0.96651360,  0.96700850,  0.96750520,
     0.96800376,  0.96850424,  0.96900670,  0.96951112,
     0.97001738,  0.97052533,  0.97103488,  0.97154597,
     0.97205867,  0.97257304,  0.97308915,  0.97360694,
     0.97412631,  0.97464711,  0.97516923,  0.97569262,
     0.97621735,  0.97674350,  0.97727111,  0.97780016,
     0.97833051,  0.97886205,  0.97939463,  0.97992823,
     0.98046291,  0.98099875,  0.98153580,  0.98207405,
     0.98261337,  0.98315364,  0.98369474,  0.98423664,
     0.98477941,  0.98532311,  0.98586780,  0.98641348,
     0.98696003,  0.98750734,  0.98805530,  0.98860389,
     0.98915320,  0.98970328,  0.99025423,  0.99080602,
     0.99135855,  0.99191171,  0.99246541,  0.99301962,
     0.99357443,  0.99412992,  0.99468617,  0.99524320,
     0.99580092,  0.99635926,  0.99691814,  0.99747748,
     0.99803721,  0.99859725,  0.99915752,  0.99971793,
     1.00028215,  1.00084319,  1.00140472,  1.00196665,
     1.00252889,  1.00309139,  1.00365404,  1.00421679,
     1.00477954,  1.00534221,  1.00590474,  1.00646713,
     1.00702945,  1.00759179,  1.00815424,  1.00871678,
     1.00927930,  1.00984169,  1.01040384,  1.01096575,
     1.01152747,  1.01208910,  1.01265070,  1.01321226,
     1.01377365,  1.01433478,  1.01489551,  1.01545584,
     1.01601582,  1.01657553,  1.01713502,  1.01769427,
     1.01825316,  1.01881154,  1.01936929,  1.01992639,
     1.02048289,  1.02103888,  1.02159441,  1.02214945,
     1.02270387,  1.02325751,  1.02381025,  1.02436204,
     1.02491295,  1.02546304,  1.02601238,  1.02656092,
     1.02710853,  1.02765508,  1.02820041,  1.02874449,
     1.02928737,  1.02982913,  1.03036981,  1.03090937,
     1.03144768,  1.03198460,  1.03252000,  1.03305384,
     1.03358617,  1.03411707,  1.03464659,  1.03517470,
     1.03570128,  1.03622620,  1.03674934,  1.03727066,
     1.03779024,  1.03830815,  1.03882446,  1.03933914,
     1.03985206,  1.04036312,  1.04087217,  1.04137920,
     1.04188428,  1.04238748,  1.04288888,  1.04338845,
     1.04388610,  1.04438170,  1.04487515,  1.04536645,
     1.04585569,  1.04634297,  1.04682838,  1.04731192,
     1.04779350,  1.04827303,  1.04875042,  1.04922568,
     1.04969891,  1.05017022,  1.05063974,  1.05110746,
     1.05157332,  1.05203721,  1.05249907,  1.05295889,
     1.05341676,  1.05387277,  1.05432700,  1.05477948,
     1.05523018,  1.05567906,  1.05612608,  1.05657124,
     1.05701459,  1.05745616,  1.05789601,  1.05833426,
     1.05877109,  1.05920669,  1.05964125,  1.06007444,
     1.06050542,  1.06093335,  1.06135746,  1.06177909,
     1.06220164,  1.06262858,  1.06306309,  1.06350050,
     1.06392837,  1.06433391,  1.06470443,  1.06502996,
     1.06481076,  1.06469765,  1.06445004,  1.06408002,
     1.06361382,  1.06307719,  1.06249453,  1.06188365,
     1.06125612,  1.06062291,  1.05999418,  1.05937132,
     1.05874726,  1.05811486,  1.05746728,  1.05680000,
     1.05611070,  1.05539715,  1.05465735,  1.05389329,
     1.05311083,  1.05231578,  1.05151372,  1.05070811,
     1.04990044,  1.04909210,  1.04828434,  1.04747647,
     1.04666590,  1.04585003,  1.04502628,  1.04419009,
     1.04333499,  1.04245452,  1.04154244,  1.04059452,
     1.03960846,  1.03858207,  1.03751326,  1.03640189,
     1.03524976,  1.03405868,  1.03283047,  1.03156812,
     1.03027574,  1.02895743,  1.02761717,  1.02625804,
     1.02488222,  1.02349184,  1.02208892,  1.02067450,
     1.01924861,  1.01781123,  1.01636229,  1.01490045,
     1.01342315,  1.01192778,  1.01041175,  1.00887284,
     1.00730915,  1.00571882,  1.00409996,  1.00245032,
     1.00076734,  0.99904842,  0.99729101,  0.99549380,
     0.99365664,  0.99177946,  0.98986234,  0.98791024,
     0.98593294,  0.98394037,  0.98194226,  0.97994532,
     0.97795324,  0.97596955,  0.97399748,  0.97203326,
     0.97006624,  0.96808546,  0.96608018,  0.96404416,
     0.96197556,  0.95987276,  0.95773420,  0.95556018,
     0.95335291,  0.95111462,  0.94884764,  0.94655663,
     0.94424858,  0.94193055,  0.93960953,  0.93729154,
     0.93498157,  0.93268456,  0.93040503,  0.92813771,
     0.92586755,  0.92357910,  0.92125731,  0.91889642,
     0.91649998,  0.91407191,  0.91161623,  0.90913975,
     0.90665202,  0.90416271,  0.90168115,  0.89920934,
     0.89674189,  0.89427312,  0.89179743,  0.88931147,
     0.88681415,  0.88430445,  0.88178141,  0.87924528,
     0.87669753,  0.87413966,  0.87157318,  0.86899958,
     0.86642037,  0.86383703,  0.86125106,  0.85866393,
     0.85604236,  0.85344385,  0.85083093,  0.84820550,
     0.84556943,  0.84292458,  0.84027278,  0.83761586,
     0.83495565,  0.83229393,  0.82963243,  0.82697135,
     0.82430933,  0.82164496,  0.81897669,  0.81630017,
     0.81360822,  0.81089355,  0.80814924,  0.80537741,
     0.80258920,  0.79979611,  0.79700954,  0.79423813,
     0.79148780,  0.78876432,  0.78607290,  0.78340590,
     0.78074288,  0.77806279,  0.77534514,  0.77258187,
     0.76977737,  0.76693654,  0.76406441,  0.76116851,
     0.75825892,  0.75534582,  0.75243924,  0.74954634,
     0.74667135,  0.74381840,  0.74099145,  0.73819147,
     0.73541641,  0.73266408,  0.72993193,  0.72720913,
     0.72447661,  0.72171494,  0.71890515,  0.71603932,
     0.71312056,  0.71015250,  0.70713900,  0.70409084,
     0.70102565,  0.69796137,  0.69491556,  0.69189772,
     0.68890931,  0.68595141,  0.68302498,  0.68012852,
     0.67725801,  0.67440936,  0.67157841,  0.66876081,
     0.66595195,  0.66314722,  0.66034194,  0.65753027,
     0.65470525,  0.65185984,  0.64898709,  0.64608214,
     0.64314221,  0.64016460,  0.63714680,  0.63409034,
     0.63100082,  0.62788400,  0.62474577,  0.62159473,
     0.61844225,  0.61529977,  0.61217866,  0.60908811,
     0.60603510,  0.60302654,  0.60006916,  0.59716588,
     0.59431580,  0.59151787,  0.58877068,  0.58606495,
     0.58338353,  0.58070891,  0.57802356,  0.57530864,
     0.57254404,  0.56970958,  0.56678577,  0.56376860,
     0.56066951,  0.55750064,  0.55427451,  0.55101301,
     0.54774732,  0.54450907,  0.54132936,  0.53822744,
     0.53521072,  0.53228613,  0.52945979,  0.52671997,
     0.52403708,  0.52138072,  0.51872085,  0.51603570,
     0.51331170,  0.51053560,  0.50769466,  0.50478931,
     0.50183308,  0.49884001,  0.49582406,  0.49279905,
     0.48985748,  0.48679641,  0.48379429,  0.48085363,
     0.47796576,  0.47512151,  0.47231151,  0.46952402,
     0.46674486,  0.46395978,  0.46115496,  0.45832607,
     0.45547830,  0.45261727,  0.44974866,  0.44688011,
     0.44402125,  0.44118178,  0.43837094,  0.43558772,
     0.43282082,  0.43005847,  0.42728913,  0.42450572,
     0.42170567,  0.41888658,  0.41604633,  0.41318897,
     0.41032472,  0.40746405,  0.40461724,  0.40178943,
     0.39898066,  0.39619073,  0.39341940,  0.39066519,
     0.38792536,  0.38519713,  0.38247773,  0.37976476,
     0.37705620,  0.37435006,  0.37164438,  0.36893869,
     0.36623396,  0.36353124,  0.36083153,  0.35813533,
     0.35544262,  0.35275338,  0.35006755,  0.34738530,
     0.34470699,  0.34203296,  0.33936359,  0.33669922,
     0.33404027,  0.33138711,  0.32874013,  0.32609944,
     0.32346493,  0.32083645,  0.31821388,  0.31559703,
     0.31298573,  0.31037987,  0.30777941,  0.30518446,
     0.30259525,  0.30001202,  0.29743499,  0.29486428,
     0.29229989,  0.28974179,  0.28718997,  0.28464452,
     0.28210562,  0.27957346,  0.27704820,  0.27452992,
     0.27201854,  0.26951399,  0.26701622,  0.26452533,
     0.26204158,  0.25956526,  0.25709662,  0.25463583,
     0.25218294,  0.24973798,  0.24730100,  0.24487207,
     0.24245133,  0.24003893,  0.23763500,  0.23523959,
     0.23285262,  0.23047401,  0.22810369,  0.22574170,
     0.22338818,  0.22104329,  0.21870719,  0.21637986,
     0.21406117,  0.21175095,  0.20944904,  0.20715535,
     0.20486987,  0.20259261,  0.20032356,  0.19806259,
     0.19580944,  0.19356385,  0.19132556,  0.18909442,
     0.18687040,  0.18465350,  0.18244372,  0.18024164,
     0.17804841,  0.17586521,  0.17369322,  0.17153360,
     0.16938755,  0.16725622,  0.16514081,  0.16304247,
     0.16098974,  0.15896561,  0.15696026,  0.15497259,
     0.15300151,  0.15104590,  0.14910466,  0.14717666,
     0.14526081,  0.14335599,  0.14146111,  0.13957570,
     0.13769993,  0.13583399,  0.13397806,  0.13213229,
     0.13029682,  0.12847178,  0.12665729,  0.12485353,
     0.12306074,  0.12127916,  0.11950900,  0.11775043,
     0.11600347,  0.11426820,  0.11254464,  0.11083292,
     0.10913318,  0.10744559,  0.10577028,  0.10410733,
     0.10245672,  0.10081842,  0.09919240,  0.09757872,
     0.09597750,  0.09438884,  0.09281288,  0.09124964,
     0.08969907,  0.08816111,  0.08663570,  0.08512288,
     0.08362274,  0.08213540,  0.08066096,  0.07919944,
     0.07775076,  0.07631484,  0.07489161,  0.07348108,
     0.07208335,  0.07069851,  0.06932666,  0.06796781,
     0.06662187,  0.06528874,  0.06396833,  0.06266065,
     0.06136578,  0.06008380,  0.05881480,  0.05755876,
     0.05631557,  0.05508511,  0.05386728,  0.05266206,
     0.05146951,  0.05028971,  0.04912272,  0.04796855,
     0.04682709,  0.04569825,  0.04458194,  0.04347817,
     0.04238704,  0.04130868,  0.04024318,  0.03919056,
     0.03815071,  0.03712352,  0.03610890,  0.03510679,
     0.03411720,  0.03314013,  0.03217560,  0.03122343,
     0.03028332,  0.02935494,  0.02843799,  0.02753230,
     0.02663788,  0.02575472,  0.02488283,  0.02402232,
     0.02317341,  0.02233631,  0.02151124,  0.02069866,
     0.01989922,  0.01911359,  0.01834241,  0.01758563,
     0.01684248,  0.01611219,  0.01539397,  0.01468726,
     0.01399167,  0.01330687,  0.01263250,  0.01196871,
     0.01131609,  0.01067527,  0.01004684,  0.00943077,
     0.00882641,  0.00823307,  0.00765011,  0.00707735,
     0.00651513,  0.00596377,  0.00542364,  0.00489514,
     0.00437884,  0.00387530,  0.00338509,  0.00290795,
     0.00244282,  0.00198860,  0.00154417,  0.00110825,
     0.00067934,  0.00025589, -0.00016357, -0.00057897,
    -0.00098865, -0.00139089, -0.00178397, -0.00216547,
    -0.00253230, -0.00288133, -0.00320955, -0.00351626,
    -0.00380315, -0.00407198, -0.00432457, -0.00456373,
    -0.00479326, -0.00501699, -0.00523871, -0.00546066,
    -0.00568360, -0.00590821, -0.00613508, -0.00636311,
    -0.00658944, -0.00681117, -0.00702540, -0.00722982,
    -0.00742268, -0.00760226, -0.00776687, -0.00791580,
    -0.00804933, -0.00816774, -0.00827139, -0.00836122,
    -0.00843882, -0.00850583, -0.00856383, -0.00861430,
    -0.00865853, -0.00869781, -0.00873344, -0.00876633,
    -0.00879707, -0.00882622, -0.00885433, -0.00888132,
    -0.00890652, -0.00892925, -0.00894881, -0.00896446,
    -0.00897541, -0.00898088, -0.00898010, -0.00897234,
    -0.00895696, -0.00893330, -0.00890076, -0.00885914,
    -0.00880875, -0.00874987, -0.00868282, -0.00860825,
    -0.00852716, -0.00844055, -0.00834941, -0.00825485,
    -0.00815807, -0.00806025, -0.00796253, -0.00786519,
    -0.00776767, -0.00766937, -0.00756971, -0.00746790,
    -0.00736305, -0.00725422, -0.00714055, -0.00702161,
    -0.00689746, -0.00676816, -0.00663381, -0.00649489,
    -0.00635230, -0.00620694, -0.00605969, -0.00591116,
    -0.00576167, -0.00561155, -0.00546110, -0.00531037,
    -0.00515917, -0.00500732, -0.00485462, -0.00470075,
    -0.00454530, -0.00438786, -0.00422805, -0.00406594,
    -0.00390204, -0.00373686, -0.00357091, -0.00340448,
    -0.00323770, -0.00307066, -0.00290344, -0.00273610,
    -0.00256867, -0.00240117, -0.00223365, -0.00206614,
    -0.00189866, -0.00173123, -0.00156390, -0.00139674,
    -0.00122989, -0.00106351, -0.00089772, -0.00073267,
    -0.00056849, -0.00040530, -0.00024324, -0.00008241,
     0.00008214,  0.00024102,  0.00039922,  0.00055660,
     0.00071299,  0.00086826,  0.00102224,  0.00117480,
     0.00132579,  0.00147507,  0.00162252,  0.00176804,
     0.00191161,  0.00205319,  0.00219277,  0.00233029,
     0.00246567,  0.00259886,  0.00272975,  0.00285832,
     0.00298453,  0.00310839,  0.00322990,  0.00334886,
     0.00346494,  0.00357778,  0.00368706,  0.00379273,
     0.00389501,  0.00399411,  0.00409020,  0.00418350,
     0.00427419,  0.00436249,  0.00444858,  0.00453250,
     0.00461411,  0.00469328,  0.00476988,  0.00484356,
     0.00491375,  0.00497987,  0.00504139,  0.00509806,
     0.00514990,  0.00519693,  0.00523920,  0.00527700,
     0.00531083,  0.00534122,  0.00536864,  0.00539357,
     0.00541649,  0.00543785,  0.00545809,  0.00547713,
     0.00549441,  0.00550936,  0.00552146,  0.00553017,
     0.00553494,  0.00553524,  0.00553058,  0.00552065,
     0.00550536,  0.00548459,  0.00545828,  0.00542662,
     0.00539007,  0.00534910,  0.00530415,  0.00525568,
     0.00520417,  0.00515009,  0.00509387,  0.00503595,
     0.00497674,  0.00491665,  0.00485605,  0.00479503,
     0.00473336,  0.00467082,  0.00460721,  0.00454216,
     0.00447517,  0.00440575,  0.00433344,  0.00425768,
     0.00417786,  0.00409336,  0.00400363,  0.00390837,
     0.00380759,  0.00370130,  0.00358952,  0.00347268,
     0.00335157,  0.00322699,  0.00309975,  0.00297088,
     0.00284164,  0.00271328,  0.00258700,  0.00246328,
     0.00234195,  0.00222281,  0.00210562,  0.00198958,
     0.00187331,  0.00175546,  0.00163474,  0.00151020,
     0.00138130,  0.00124750,  0.00110831,  0.00096411,
     0.00081611,  0.00066554,  0.00051363,  0.00036134,
     0.00020940,  0.00005853, -0.00009058, -0.00023783,
    -0.00038368, -0.00052861, -0.00067310, -0.00081757,
    -0.00096237, -0.00110786, -0.00125442, -0.00140210,
    -0.00155065, -0.00169984, -0.00184940, -0.00199910,
    -0.00214872, -0.00229798, -0.00244664, -0.00259462,
    -0.00274205, -0.00288912, -0.00303596, -0.00318259,
    -0.00332890, -0.00347480, -0.00362024, -0.00376519,
    -0.00390962, -0.00405345, -0.00419658, -0.00433902,
    -0.00448085, -0.00462219, -0.00476309, -0.00490357,
    -0.00504361, -0.00518321, -0.00532243, -0.00546132,
    -0.00559988, -0.00573811, -0.00587602, -0.00601363,
    -0.00615094, -0.00628795, -0.00642466, -0.00656111,
    -0.00669737, -0.00683352, -0.00696963, -0.00710578,
    -0.00724208, -0.00737862, -0.00751554, -0.00765295,
    -0.00779098, -0.00792976, -0.00806941, -0.00821006,
    -0.00835183, -0.00849485, -0.00863926, -0.00878522,
    -0.00893293, -0.00908260, -0.00923444, -0.00938864,
    -0.00954537, -0.00970482, -0.00986715, -0.01003173,
    -0.01019711, -0.01036164, -0.01052357, -0.01068184,
    -0.01083622, -0.01098652, -0.01113252, -0.01127409,
    -0.01141114, -0.01154358, -0.01167135, -0.01179439,
    -0.01191268, -0.01202619, -0.01213493, -0.01223891,
    -0.01233817, -0.01243275, -0.01252272, -0.01260815,
    -0.01268915, -0.01276583, -0.01283832, -0.01290685,
    -0.01297171, -0.01303320, -0.01309168, -0.01314722,
    -0.01319969, -0.01324889, -0.01329466, -0.01333693,
    -0.01337577, -0.01341125, -0.01344345, -0.01347243,
    -0.01349823, -0.01352089, -0.01354045, -0.01355700,
    -0.01357068, -0.01358164, -0.01359003, -0.01359587,
    -0.01359901, -0.01359931, -0.01359661, -0.01359087,
    -0.01358219, -0.01357065, -0.01355637, -0.01353935,
    -0.01351949, -0.01349670, -0.01347088, -0.01344214,
    -0.01341078, -0.01337715, -0.01334158, -0.01330442,
    -0.01326601, -0.01322671, -0.01318689, -0.01314692,
    -0.01310123, -0.01306470, -0.01302556, -0.01298381,
    -0.01293948, -0.01289255, -0.01284305, -0.01279095,
    -0.01273625, -0.01267893, -0.01261897, -0.01255632,
    -0.01249096, -0.01242283, -0.01235190, -0.01227827,
    -0.01220213, -0.01212366, -0.01204304, -0.01196032,
    -0.01187543, -0.01178829, -0.01169884, -0.01160718,
    -0.01151352, -0.01141809, -0.01132111, -0.01122272,
    -0.01112304, -0.01102217, -0.01092022, -0.01081730,
    -0.01071355, -0.01060912, -0.01050411, -0.01039854,
    -0.01029227, -0.01018521, -0.01007727, -0.00996859,
    -0.00985959, -0.00975063, -0.00964208, -0.00953420,
    -0.00942723, -0.00932135, -0.00921677, -0.00911364,
    -0.00901208, -0.00891220, -0.00881412, -0.00871792,
    -0.00862369, -0.00853153, -0.00844149, -0.00835360,
    -0.00826785, -0.00818422, -0.00810267, -0.00802312,
    -0.00794547, -0.00786959, -0.00779533, -0.00772165,
    -0.00764673, -0.00756886, -0.00748649, -0.00739905,
    -0.00730681, -0.00721006, -0.00710910, -0.00700419,
    -0.00689559, -0.00678354, -0.00666829, -0.00655007,
    -0.00642916, -0.00630579, -0.00618022, -0.00605267,
    -0.00592333, -0.00579240, -0.00566006, -0.00552651,
    -0.00539194, -0.00525653, -0.00512047, -0.00498390,
    -0.00484693, -0.00470969, -0.00457228, -0.00443482,
    -0.00429746, -0.00416034, -0.00402359, -0.00388738,
    -0.00375185, -0.00361718, -0.00348350, -0.00335100,
    -0.00321991, -0.00309043, -0.00296276, -0.00283698,
    -0.00271307, -0.00259098, -0.00247066, -0.00235210,
    -0.00223531, -0.00212030, -0.00200709, -0.00189576,
    -0.00178647, -0.00167936, -0.00157457, -0.00147216,
    -0.00137205, -0.00127418, -0.00117849, -0.00108498,
    -0.00099375, -0.00090486, -0.00081840, -0.00073444,
    -0.00065309, -0.00057445, -0.00049860, -0.00042551,
    -0.00035503, -0.00028700, -0.00022125, -0.00015761,
    -0.00009588, -0.00003583,  0.00002272,  0.00007975,
     0.00013501,  0.00018828,  0.00023933,  0.00028784,
     0.00033342,  0.00037572,  0.00041438,  0.00044939,
     0.00048103,  0.00050958,  0.00053533,  0.00055869,
     0.00058015,  0.00060022,  0.00061935,  0.00063781,
     0.00065568,  0.00067303,  0.00068991,  0.00070619,
     0.00072155,  0.00073567,  0.00074826,  0.00075912,
     0.00076811,  0.00077509,  0.00077997,  0.00078275,
     0.00078351,  0.00078237,  0.00077943,  0.00077484,
     0.00076884,  0.00076160,  0.00075335,  0.00074423,
     0.00073442,  0.00072404,  0.00071323,  0.00070209,
     0.00069068,  0.00067906,  0.00066728,  0.00065534,
     0.00064321,  0.00063086,  0.00061824,  0.00060534,
     0.00059211,  0.00057855,  0.00056462,  0.00055033,
     0.00053566,  0.00052063,  0.00050522,  0.00048949,
     0.00047349,  0.00045728,  0.00044092,  0.00042447,
     0.00040803,  0.00039166,  0.00037544,  0.00035943,
     0.00034371,  0.00032833,  0.00031333,  0.00029874,
     0.00028452,  0.00027067,  0.00025715,  0.00024395,
     0.00023104,  0.00021842,  0.00020606,  0.00019398,
     0.00018218,  0.00017069,  0.00015953,  0.00014871,
     0.00013827,  0.00012823,  0.00011861,  0.00010942,
     0.00010067,  0.00009236,  0.00008448,  0.00007703,
     0.00006999,  0.00006337,  0.00005714,  0.00005129,
     0.00004583,  0.00004072,  0.00003597,  0.00003157,
     0.00002752,  0.00002380,  0.00002042,  0.00001736,
     0.00001461,  0.00001215,  0.00000998,  0.00000807,
     0.00000641,  0.00000499,  0.00000378,  0.00000278,
     0.00000196,  0.00000132,  0.00000082,  0.00000046,
     0.00000020,  0.00000005, -0.00000003, -0.00000006,
    -0.00000004, -0.00000001,  0.00000001,  0.00000001,
     0.00000001,  0.00000001, -0.00000001, -0.00000004,
    -0.00000005, -0.00000003,  0.00000005,  0.00000020,
     0.00000043,  0.00000077,  0.00000123,  0.00000183,
     0.00000257,  0.00000348,  0.00000455,  0.00000581,
     0.00000727,  0.00000893,  0.00001080,  0.00001290,
     0.00001522,  0.00001778,  0.00002057,  0.00002362,
     0.00002691,  0.00003044,  0.00003422,  0.00003824,
     0.00004250,  0.00004701,  0.00005176,  0.00005676,
     0.00006200,  0.00006749,  0.00007322,  0.00007920,
     0.00008541,  0.00009186,  0.00009854,  0.00010543,
     0.00011251,  0.00011975,  0.00012714,  0.00013465,
     0.00014227,  0.00014997,  0.00015775,  0.00016558,
     0.00017348,  0.00018144,  0.00018947,  0.00019756,
     0.00020573,  0.00021399,  0.00022233,  0.00023076,
     0.00023924,  0.00024773,  0.00025621,  0.00026462,
     0.00027293,  0.00028108,  0.00028904,  0.00029675,
     0.00030419,  0.00031132,  0.00031810,  0.00032453,
     0.00033061,  0.00033632,  0.00034169,  0.00034672,
     0.00035142,  0.00035580,  0.00035988,  0.00036369,
     0.00036723,  0.00037053,  0.00037361,  0.00037647,
     0.00037909,  0.00038145,  0.00038352,  0.00038527,
     0.00038663,  0.00038757,  0.00038801,  0.00038790,
     0.00038717,  0.00038572,  0.00038350,  0.00038044,
     0.00037651,  0.00037170,  0.00036597,  0.00035936,
     0.00035191,  0.00034370,  0.00033480,  0.00032531,
     0.00031537,  0.00030512,  0.00029470,  0.00028417,
     0.00027354,  0.00026279,  0.00025191,  0.00024081,
     0.00022933,  0.00021731,  0.00020458,  0.00019101,
     0.00017654,  0.00016106,  0.00014452,  0.00012694,
     0.00010848,  0.00008929,  0.00006953,  0.00004935,
     0.00002884,  0.00000813, -0.00001268, -0.00003357,
    -0.00005457, -0.00007574, -0.00009714, -0.00011882,
    -0.00014082, -0.00016318, -0.00018595, -0.00020912,
    -0.00023265, -0.00025650, -0.00028060, -0.00030492,
    -0.00032941, -0.00035400, -0.00037865, -0.00040333,
    -0.00042804, -0.00045279, -0.00047759, -0.00050243,
    -0.00052728, -0.00055209, -0.00057685, -0.00060153,
    -0.00062611, -0.00065056, -0.00067485, -0.00069895,
    -0.00072287, -0.00074660, -0.00077013, -0.00079345,
    -0.00081653, -0.00083936, -0.00086192, -0.00088421,
    -0.00090619, -0.00092786, -0.00094919, -0.00097017,
    -0.00099077, -0.00101098, -0.00103077, -0.00105012,
    -0.00106904, -0.00108750, -0.00110549, -0.00112301,
    -0.00114005, -0.00115660, -0.00117265, -0.00118821,
    -0.00120325, -0.00121779, -0.00123180, -0.00124528,
    -0.00125822, -0.00127061, -0.00128243, -0.00129368,
    -0.00130435, -0.00131445, -0.00132395, -0.00133285,
    -0.00134113, -0.00134878, -0.00135577, -0.00136215,
    -0.00136797, -0.00137333, -0.00137834, -0.00138305,
    -0.00138748, -0.00139163, -0.00139551, -0.00139913,
    -0.00140249, -0.00140559, -0.00140844, -0.00141102,
    -0.00141334, -0.00141538, -0.00141714, -0.00141861,
    -0.00141978, -0.00142064, -0.00142117, -0.00142138,
    -0.00142125, -0.00142077, -0.00141992, -0.00141870,
    -0.00141710, -0.00141510, -0.00141268, -0.00140986,
    -0.00140663, -0.00140301, -0.00139900, -0.00139460,
    -0.00138981, -0.00138464, -0.00137908, -0.00137313,
    -0.00136680, -0.00136010, -0.00135301, -0.00134555,
    -0.00133772, -0.00132952, -0.00132095, -0.00131201,
    -0.00130272, -0.00129307, -0.00128309, -0.00127277,
    -0.00126211, -0.00125113, -0.00123981, -0.00122817,
    -0.00121622, -0.00120397, -0.00119141, -0.00117859,
    -0.00116552, -0.00115223, -0.00113877, -0.00112517,
    -0.00111144, -0.00109764, -0.00108377, -0.00106989,
};
