// Autogenerated code. Do not edit.

// This source code is dual-licensed under the Apache License, version
// 2.0, and the Mozilla Public License, version 1.1.
//
// The APL v2.0:
//
//---------------------------------------------------------------------------
//   Copyright (C) 2007-2010 LShift Ltd., Cohesive Financial
//   Technologies LLC., and Rabbit Technologies Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//---------------------------------------------------------------------------
//
// The MPL v1.1:
//
//---------------------------------------------------------------------------
//   The contents of this file are subject to the Mozilla Public License
//   Version 1.1 (the "License"); you may not use this file except in
//   compliance with the License. You may obtain a copy of the License at
//   http://www.rabbitmq.com/mpl.html
//
//   Software distributed under the License is distributed on an "AS IS"
//   basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
//   License for the specific language governing rights and limitations
//   under the License.
//
//   The Original Code is The RabbitMQ .NET Client.
//
//   The Initial Developers of the Original Code are LShift Ltd,
//   Cohesive Financial Technologies LLC, and Rabbit Technologies Ltd.
//
//   Portions created before 22-Nov-2008 00:00:00 GMT by LShift Ltd,
//   Cohesive Financial Technologies LLC, or Rabbit Technologies Ltd
//   are Copyright (C) 2007-2008 LShift Ltd, Cohesive Financial
//   Technologies LLC, and Rabbit Technologies Ltd.
//
//   Portions created by LShift Ltd are Copyright (C) 2007-2010 LShift
//   Ltd. Portions created by Cohesive Financial Technologies LLC are
//   Copyright (C) 2007-2010 Cohesive Financial Technologies
//   LLC. Portions created by Rabbit Technologies Ltd are Copyright
//   (C) 2007-2010 Rabbit Technologies Ltd.
//
//   All Rights Reserved.
//
//   Contributor(s): ______________________________________.
//
//---------------------------------------------------------------------------

using RabbitMQ.Client;
using RabbitMQ.Client.Exceptions;

namespace RabbitMQ.Client.Framing.v0_9 {
  public class Protocol: RabbitMQ.Client.Framing.Impl.v0_9.ProtocolBase {
    ///<summary>Protocol major version (= 0)</summary>
    public override int MajorVersion { get { return 0; } }
    ///<summary>Protocol minor version (= 9)</summary>
    public override int MinorVersion { get { return 9; } }
    ///<summary>Protocol API name (= AMQP_0_9)</summary>
    public override string ApiName { get { return "AMQP_0_9"; } }
    ///<summary>Default TCP port (= 5672)</summary>
    public override int DefaultPort { get { return 5672; } }

    public override RabbitMQ.Client.Impl.MethodBase DecodeMethodFrom(RabbitMQ.Util.NetworkBinaryReader reader) {
      ushort classId = reader.ReadUInt16();
      ushort methodId = reader.ReadUInt16();

      switch (classId) {
        case 10: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionStart result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionStart();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionStartOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionStartOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionSecure result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionSecure();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionSecureOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionSecureOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionTune result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionTune();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionTuneOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionTuneOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionOpen result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionOpen();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionOpenOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionOpenOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 42: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionRedirect result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionRedirect();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionClose result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionClose();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 51: {
              RabbitMQ.Client.Framing.Impl.v0_9.ConnectionCloseOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ConnectionCloseOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 20: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelOpen result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelOpen();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelOpenOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelOpenOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelFlow result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelFlow();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelFlowOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelFlowOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelClose result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelClose();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelCloseOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelCloseOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelResume result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelResume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelPing result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelPing();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 70: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelPong result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelPong();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 80: {
              RabbitMQ.Client.Framing.Impl.v0_9.ChannelOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ChannelOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 30: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.AccessRequest result = new RabbitMQ.Client.Framing.Impl.v0_9.AccessRequest();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.AccessRequestOk result = new RabbitMQ.Client.Framing.Impl.v0_9.AccessRequestOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 40: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDeclare result = new RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDeclare();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDeclareOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDeclareOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDelete result = new RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDelete();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDeleteOk result = new RabbitMQ.Client.Framing.Impl.v0_9.ExchangeDeleteOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 50: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueDeclare result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueDeclare();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueDeclareOk result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueDeclareOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueBind result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueBind();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueBindOk result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueBindOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueUnbind result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueUnbind();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 51: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueUnbindOk result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueUnbindOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueuePurge result = new RabbitMQ.Client.Framing.Impl.v0_9.QueuePurge();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueuePurgeOk result = new RabbitMQ.Client.Framing.Impl.v0_9.QueuePurgeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueDelete result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueDelete();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_9.QueueDeleteOk result = new RabbitMQ.Client.Framing.Impl.v0_9.QueueDeleteOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 60: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicQos result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicQos();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicQosOk result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicQosOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicConsume result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicConsume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicConsumeOk result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicConsumeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicCancel result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicCancel();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicCancelOk result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicCancelOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicPublish result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicPublish();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicReturn result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicReturn();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicDeliver result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicDeliver();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 70: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicGet result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicGet();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 71: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicGetOk result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicGetOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 72: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicGetEmpty result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicGetEmpty();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 80: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicAck result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicAck();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 90: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicReject result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicReject();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 100: {
              RabbitMQ.Client.Framing.Impl.v0_9.BasicRecover result = new RabbitMQ.Client.Framing.Impl.v0_9.BasicRecover();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 70: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileQos result = new RabbitMQ.Client.Framing.Impl.v0_9.FileQos();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileQosOk result = new RabbitMQ.Client.Framing.Impl.v0_9.FileQosOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileConsume result = new RabbitMQ.Client.Framing.Impl.v0_9.FileConsume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileConsumeOk result = new RabbitMQ.Client.Framing.Impl.v0_9.FileConsumeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileCancel result = new RabbitMQ.Client.Framing.Impl.v0_9.FileCancel();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileCancelOk result = new RabbitMQ.Client.Framing.Impl.v0_9.FileCancelOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileOpen result = new RabbitMQ.Client.Framing.Impl.v0_9.FileOpen();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 41: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileOpenOk result = new RabbitMQ.Client.Framing.Impl.v0_9.FileOpenOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileStage result = new RabbitMQ.Client.Framing.Impl.v0_9.FileStage();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_9.FilePublish result = new RabbitMQ.Client.Framing.Impl.v0_9.FilePublish();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 70: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileReturn result = new RabbitMQ.Client.Framing.Impl.v0_9.FileReturn();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 80: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileDeliver result = new RabbitMQ.Client.Framing.Impl.v0_9.FileDeliver();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 90: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileAck result = new RabbitMQ.Client.Framing.Impl.v0_9.FileAck();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 100: {
              RabbitMQ.Client.Framing.Impl.v0_9.FileReject result = new RabbitMQ.Client.Framing.Impl.v0_9.FileReject();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 80: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamQos result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamQos();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamQosOk result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamQosOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamConsume result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamConsume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamConsumeOk result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamConsumeOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamCancel result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamCancel();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamCancelOk result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamCancelOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamPublish result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamPublish();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamReturn result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamReturn();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_9.StreamDeliver result = new RabbitMQ.Client.Framing.Impl.v0_9.StreamDeliver();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 90: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.TxSelect result = new RabbitMQ.Client.Framing.Impl.v0_9.TxSelect();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.TxSelectOk result = new RabbitMQ.Client.Framing.Impl.v0_9.TxSelectOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.TxCommit result = new RabbitMQ.Client.Framing.Impl.v0_9.TxCommit();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.TxCommitOk result = new RabbitMQ.Client.Framing.Impl.v0_9.TxCommitOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_9.TxRollback result = new RabbitMQ.Client.Framing.Impl.v0_9.TxRollback();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 31: {
              RabbitMQ.Client.Framing.Impl.v0_9.TxRollbackOk result = new RabbitMQ.Client.Framing.Impl.v0_9.TxRollbackOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 100: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.DtxSelect result = new RabbitMQ.Client.Framing.Impl.v0_9.DtxSelect();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 11: {
              RabbitMQ.Client.Framing.Impl.v0_9.DtxSelectOk result = new RabbitMQ.Client.Framing.Impl.v0_9.DtxSelectOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.DtxStart result = new RabbitMQ.Client.Framing.Impl.v0_9.DtxStart();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 21: {
              RabbitMQ.Client.Framing.Impl.v0_9.DtxStartOk result = new RabbitMQ.Client.Framing.Impl.v0_9.DtxStartOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 110: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.TunnelRequest result = new RabbitMQ.Client.Framing.Impl.v0_9.TunnelRequest();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        case 120: {
          switch (methodId) {
            case 10: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageTransfer result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageTransfer();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 20: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageConsume result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageConsume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 30: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageCancel result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageCancel();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 40: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageGet result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageGet();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 50: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageRecover result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageRecover();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 60: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageOpen result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageOpen();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 70: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageClose result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageClose();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 80: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageAppend result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageAppend();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 90: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageCheckpoint result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageCheckpoint();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 100: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageResume result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageResume();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 110: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageQos result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageQos();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 500: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageOk result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageOk();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 510: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageEmpty result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageEmpty();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 520: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageReject result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageReject();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            case 530: {
              RabbitMQ.Client.Framing.Impl.v0_9.MessageOffset result = new RabbitMQ.Client.Framing.Impl.v0_9.MessageOffset();
              result.ReadArgumentsFrom(new RabbitMQ.Client.Impl.MethodArgumentReader(reader));
              return result;
            }
            default: break;
          }
          break;
        }
        default: break;
      }
      throw new RabbitMQ.Client.Impl.UnknownClassOrMethodException(classId, methodId);
    }

    public override RabbitMQ.Client.Impl.ContentHeaderBase DecodeContentHeaderFrom(RabbitMQ.Util.NetworkBinaryReader reader) {
      ushort classId = reader.ReadUInt16();

      switch (classId) {
        case 60: return new BasicProperties();
        case 70: return new FileProperties();
        case 80: return new StreamProperties();
        case 110: return new TunnelProperties();
        default: break;
      }
      throw new RabbitMQ.Client.Impl.UnknownClassOrMethodException(classId, 0);
    }
  }
  public class Constants {
    ///<summary>(= 1)</summary>
    public const int FrameMethod = 1;
    ///<summary>(= 2)</summary>
    public const int FrameHeader = 2;
    ///<summary>(= 3)</summary>
    public const int FrameBody = 3;
    ///<summary>(= 4)</summary>
    public const int FrameOobMethod = 4;
    ///<summary>(= 5)</summary>
    public const int FrameOobHeader = 5;
    ///<summary>(= 6)</summary>
    public const int FrameOobBody = 6;
    ///<summary>(= 7)</summary>
    public const int FrameTrace = 7;
    ///<summary>(= 8)</summary>
    public const int FrameHeartbeat = 8;
    ///<summary>(= 4096)</summary>
    public const int FrameMinSize = 4096;
    ///<summary>(= 206)</summary>
    public const int FrameEnd = 206;
    ///<summary>(= 200)</summary>
    public const int ReplySuccess = 200;
    ///<summary>(= 310)</summary>
    public const int NotDelivered = 310;
    ///<summary>(= 311)</summary>
    public const int ContentTooLarge = 311;
    ///<summary>(= 312)</summary>
    public const int NoRoute = 312;
    ///<summary>(= 313)</summary>
    public const int NoConsumers = 313;
    ///<summary>(= 320)</summary>
    public const int ConnectionForced = 320;
    ///<summary>(= 402)</summary>
    public const int InvalidPath = 402;
    ///<summary>(= 403)</summary>
    public const int AccessRefused = 403;
    ///<summary>(= 404)</summary>
    public const int NotFound = 404;
    ///<summary>(= 405)</summary>
    public const int ResourceLocked = 405;
    ///<summary>(= 406)</summary>
    public const int PreconditionFailed = 406;
    ///<summary>(= 501)</summary>
    public const int FrameError = 501;
    ///<summary>(= 502)</summary>
    public const int SyntaxError = 502;
    ///<summary>(= 503)</summary>
    public const int CommandInvalid = 503;
    ///<summary>(= 504)</summary>
    public const int ChannelError = 504;
    ///<summary>(= 506)</summary>
    public const int ResourceError = 506;
    ///<summary>(= 530)</summary>
    public const int NotAllowed = 530;
    ///<summary>(= 540)</summary>
    public const int NotImplemented = 540;
    ///<summary>(= 541)</summary>
    public const int InternalError = 541;
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.start".</summary>
  public interface IConnectionStart: IMethod {
    byte VersionMajor { get; }
    byte VersionMinor { get; }
    System.Collections.IDictionary ServerProperties { get; }
    byte[] Mechanisms { get; }
    byte[] Locales { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.start-ok".</summary>
  public interface IConnectionStartOk: IMethod {
    System.Collections.IDictionary ClientProperties { get; }
    string Mechanism { get; }
    byte[] Response { get; }
    string Locale { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.secure".</summary>
  public interface IConnectionSecure: IMethod {
    byte[] Challenge { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.secure-ok".</summary>
  public interface IConnectionSecureOk: IMethod {
    byte[] Response { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.tune".</summary>
  public interface IConnectionTune: IMethod {
    ushort ChannelMax { get; }
    uint FrameMax { get; }
    ushort Heartbeat { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.tune-ok".</summary>
  public interface IConnectionTuneOk: IMethod {
    ushort ChannelMax { get; }
    uint FrameMax { get; }
    ushort Heartbeat { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.open".</summary>
  public interface IConnectionOpen: IMethod {
    string VirtualHost { get; }
    string Capabilities { get; }
    bool Insist { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.open-ok".</summary>
  public interface IConnectionOpenOk: IMethod {
    string KnownHosts { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.redirect".</summary>
  public interface IConnectionRedirect: IMethod {
    string Host { get; }
    string KnownHosts { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.close".</summary>
  public interface IConnectionClose: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    ushort ClassId { get; }
    ushort MethodId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "connection.close-ok".</summary>
  public interface IConnectionCloseOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.open".</summary>
  public interface IChannelOpen: IMethod {
    string OutOfBand { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.open-ok".</summary>
  public interface IChannelOpenOk: IMethod {
    byte[] ChannelId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.flow".</summary>
  public interface IChannelFlow: IMethod {
    bool Active { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.flow-ok".</summary>
  public interface IChannelFlowOk: IMethod {
    bool Active { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.close".</summary>
  public interface IChannelClose: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    ushort ClassId { get; }
    ushort MethodId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.close-ok".</summary>
  public interface IChannelCloseOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.resume".</summary>
  public interface IChannelResume: IMethod {
    byte[] ChannelId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.ping".</summary>
  public interface IChannelPing: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.pong".</summary>
  public interface IChannelPong: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "channel.ok".</summary>
  public interface IChannelOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "access.request".</summary>
  public interface IAccessRequest: IMethod {
    string Realm { get; }
    bool Exclusive { get; }
    bool Passive { get; }
    bool Active { get; }
    bool Write { get; }
    bool Read { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "access.request-ok".</summary>
  public interface IAccessRequestOk: IMethod {
    ushort Ticket { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.declare".</summary>
  public interface IExchangeDeclare: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string Type { get; }
    bool Passive { get; }
    bool Durable { get; }
    bool AutoDelete { get; }
    bool Internal { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Arguments { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.declare-ok".</summary>
  public interface IExchangeDeclareOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.delete".</summary>
  public interface IExchangeDelete: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    bool IfUnused { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "exchange.delete-ok".</summary>
  public interface IExchangeDeleteOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.declare".</summary>
  public interface IQueueDeclare: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool Passive { get; }
    bool Durable { get; }
    bool Exclusive { get; }
    bool AutoDelete { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Arguments { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.declare-ok".</summary>
  public interface IQueueDeclareOk: IMethod {
    string Queue { get; }
    uint MessageCount { get; }
    uint ConsumerCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.bind".</summary>
  public interface IQueueBind: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Arguments { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.bind-ok".</summary>
  public interface IQueueBindOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.unbind".</summary>
  public interface IQueueUnbind: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    System.Collections.IDictionary Arguments { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.unbind-ok".</summary>
  public interface IQueueUnbindOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.purge".</summary>
  public interface IQueuePurge: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.purge-ok".</summary>
  public interface IQueuePurgeOk: IMethod {
    uint MessageCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.delete".</summary>
  public interface IQueueDelete: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool IfUnused { get; }
    bool IfEmpty { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "queue.delete-ok".</summary>
  public interface IQueueDeleteOk: IMethod {
    uint MessageCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.qos".</summary>
  public interface IBasicQos: IMethod {
    uint PrefetchSize { get; }
    ushort PrefetchCount { get; }
    bool Global { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.qos-ok".</summary>
  public interface IBasicQosOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.consume".</summary>
  public interface IBasicConsume: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string ConsumerTag { get; }
    bool NoLocal { get; }
    bool NoAck { get; }
    bool Exclusive { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Filter { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.consume-ok".</summary>
  public interface IBasicConsumeOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.cancel".</summary>
  public interface IBasicCancel: IMethod {
    string ConsumerTag { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.cancel-ok".</summary>
  public interface IBasicCancelOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.publish".</summary>
  public interface IBasicPublish: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Mandatory { get; }
    bool Immediate { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.return".</summary>
  public interface IBasicReturn: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.deliver".</summary>
  public interface IBasicDeliver: IMethod {
    string ConsumerTag { get; }
    ulong DeliveryTag { get; }
    bool Redelivered { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.get".</summary>
  public interface IBasicGet: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    bool NoAck { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.get-ok".</summary>
  public interface IBasicGetOk: IMethod {
    ulong DeliveryTag { get; }
    bool Redelivered { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    uint MessageCount { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.get-empty".</summary>
  public interface IBasicGetEmpty: IMethod {
    string ClusterId { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.ack".</summary>
  public interface IBasicAck: IMethod {
    ulong DeliveryTag { get; }
    bool Multiple { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.reject".</summary>
  public interface IBasicReject: IMethod {
    ulong DeliveryTag { get; }
    bool Requeue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "basic.recover".</summary>
  public interface IBasicRecover: IMethod {
    bool Requeue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.qos".</summary>
  public interface IFileQos: IMethod {
    uint PrefetchSize { get; }
    ushort PrefetchCount { get; }
    bool Global { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.qos-ok".</summary>
  public interface IFileQosOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "file.consume".</summary>
  public interface IFileConsume: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string ConsumerTag { get; }
    bool NoLocal { get; }
    bool NoAck { get; }
    bool Exclusive { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Filter { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.consume-ok".</summary>
  public interface IFileConsumeOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.cancel".</summary>
  public interface IFileCancel: IMethod {
    string ConsumerTag { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.cancel-ok".</summary>
  public interface IFileCancelOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.open".</summary>
  public interface IFileOpen: IMethod {
    string Identifier { get; }
    ulong ContentSize { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.open-ok".</summary>
  public interface IFileOpenOk: IMethod {
    ulong StagedSize { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.stage".</summary>
  public interface IFileStage: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "file.publish".</summary>
  public interface IFilePublish: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Mandatory { get; }
    bool Immediate { get; }
    string Identifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.return".</summary>
  public interface IFileReturn: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.deliver".</summary>
  public interface IFileDeliver: IMethod {
    string ConsumerTag { get; }
    ulong DeliveryTag { get; }
    bool Redelivered { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    string Identifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.ack".</summary>
  public interface IFileAck: IMethod {
    ulong DeliveryTag { get; }
    bool Multiple { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "file.reject".</summary>
  public interface IFileReject: IMethod {
    ulong DeliveryTag { get; }
    bool Requeue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.qos".</summary>
  public interface IStreamQos: IMethod {
    uint PrefetchSize { get; }
    ushort PrefetchCount { get; }
    uint ConsumeRate { get; }
    bool Global { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.qos-ok".</summary>
  public interface IStreamQosOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.consume".</summary>
  public interface IStreamConsume: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string ConsumerTag { get; }
    bool NoLocal { get; }
    bool Exclusive { get; }
    bool Nowait { get; }
    System.Collections.IDictionary Filter { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.consume-ok".</summary>
  public interface IStreamConsumeOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.cancel".</summary>
  public interface IStreamCancel: IMethod {
    string ConsumerTag { get; }
    bool Nowait { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.cancel-ok".</summary>
  public interface IStreamCancelOk: IMethod {
    string ConsumerTag { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.publish".</summary>
  public interface IStreamPublish: IMethod {
    ushort Ticket { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    bool Mandatory { get; }
    bool Immediate { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.return".</summary>
  public interface IStreamReturn: IMethod {
    ushort ReplyCode { get; }
    string ReplyText { get; }
    string Exchange { get; }
    string RoutingKey { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "stream.deliver".</summary>
  public interface IStreamDeliver: IMethod {
    string ConsumerTag { get; }
    ulong DeliveryTag { get; }
    string Exchange { get; }
    string Queue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.select".</summary>
  public interface ITxSelect: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.select-ok".</summary>
  public interface ITxSelectOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.commit".</summary>
  public interface ITxCommit: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.commit-ok".</summary>
  public interface ITxCommitOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.rollback".</summary>
  public interface ITxRollback: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tx.rollback-ok".</summary>
  public interface ITxRollbackOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.select".</summary>
  public interface IDtxSelect: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.select-ok".</summary>
  public interface IDtxSelectOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.start".</summary>
  public interface IDtxStart: IMethod {
    string DtxIdentifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "dtx.start-ok".</summary>
  public interface IDtxStartOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "tunnel.request".</summary>
  public interface ITunnelRequest: IMethod {
    System.Collections.IDictionary MetaData { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.transfer".</summary>
  public interface IMessageTransfer: IMethod {
    ushort Ticket { get; }
    string Destination { get; }
    bool Redelivered { get; }
    bool Immediate { get; }
    ulong Ttl { get; }
    byte Priority { get; }
    AmqpTimestamp Timestamp { get; }
    byte DeliveryMode { get; }
    AmqpTimestamp Expiration { get; }
    string Exchange { get; }
    string RoutingKey { get; }
    string MessageId { get; }
    string CorrelationId { get; }
    string ReplyTo { get; }
    string ContentType { get; }
    string ContentEncoding { get; }
    string UserId { get; }
    string AppId { get; }
    string TransactionId { get; }
    byte[] SecurityToken { get; }
    System.Collections.IDictionary ApplicationHeaders { get; }
    byte[] Body { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.consume".</summary>
  public interface IMessageConsume: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string Destination { get; }
    bool NoLocal { get; }
    bool NoAck { get; }
    bool Exclusive { get; }
    System.Collections.IDictionary Filter { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.cancel".</summary>
  public interface IMessageCancel: IMethod {
    string Destination { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.get".</summary>
  public interface IMessageGet: IMethod {
    ushort Ticket { get; }
    string Queue { get; }
    string Destination { get; }
    bool NoAck { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.recover".</summary>
  public interface IMessageRecover: IMethod {
    bool Requeue { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.open".</summary>
  public interface IMessageOpen: IMethod {
    byte[] Reference { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.close".</summary>
  public interface IMessageClose: IMethod {
    byte[] Reference { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.append".</summary>
  public interface IMessageAppend: IMethod {
    byte[] Reference { get; }
    byte[] Bytes { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.checkpoint".</summary>
  public interface IMessageCheckpoint: IMethod {
    byte[] Reference { get; }
    string Identifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.resume".</summary>
  public interface IMessageResume: IMethod {
    byte[] Reference { get; }
    string Identifier { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.qos".</summary>
  public interface IMessageQos: IMethod {
    uint PrefetchSize { get; }
    ushort PrefetchCount { get; }
    bool Global { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.ok".</summary>
  public interface IMessageOk: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "message.empty".</summary>
  public interface IMessageEmpty: IMethod {
  }
  /// <summary>Autogenerated type. AMQP specification method "message.reject".</summary>
  public interface IMessageReject: IMethod {
    ushort Code { get; }
    string Text { get; }
  }
  /// <summary>Autogenerated type. AMQP specification method "message.offset".</summary>
  public interface IMessageOffset: IMethod {
    ulong Value { get; }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "basic"</summary>
  public class BasicProperties: RabbitMQ.Client.Impl.BasicProperties {
    private string m_contentType;
    private string m_contentEncoding;
    private System.Collections.IDictionary m_headers;
    private byte m_deliveryMode;
    private byte m_priority;
    private string m_correlationId;
    private string m_replyTo;
    private string m_expiration;
    private string m_messageId;
    private AmqpTimestamp m_timestamp;
    private string m_type;
    private string m_userId;
    private string m_appId;
    private string m_clusterId;

    private bool m_contentType_present = false;
    private bool m_contentEncoding_present = false;
    private bool m_headers_present = false;
    private bool m_deliveryMode_present = false;
    private bool m_priority_present = false;
    private bool m_correlationId_present = false;
    private bool m_replyTo_present = false;
    private bool m_expiration_present = false;
    private bool m_messageId_present = false;
    private bool m_timestamp_present = false;
    private bool m_type_present = false;
    private bool m_userId_present = false;
    private bool m_appId_present = false;
    private bool m_clusterId_present = false;

    public override string ContentType {
      get {
        return m_contentType;
      }
      set {
        m_contentType_present = true;
        m_contentType = value;
      }
    }
    public override string ContentEncoding {
      get {
        return m_contentEncoding;
      }
      set {
        m_contentEncoding_present = true;
        m_contentEncoding = value;
      }
    }
    public override System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        m_headers_present = true;
        m_headers = value;
      }
    }
    public override byte DeliveryMode {
      get {
        return m_deliveryMode;
      }
      set {
        m_deliveryMode_present = true;
        m_deliveryMode = value;
      }
    }
    public override byte Priority {
      get {
        return m_priority;
      }
      set {
        m_priority_present = true;
        m_priority = value;
      }
    }
    public override string CorrelationId {
      get {
        return m_correlationId;
      }
      set {
        m_correlationId_present = true;
        m_correlationId = value;
      }
    }
    public override string ReplyTo {
      get {
        return m_replyTo;
      }
      set {
        m_replyTo_present = true;
        m_replyTo = value;
      }
    }
    public override string Expiration {
      get {
        return m_expiration;
      }
      set {
        m_expiration_present = true;
        m_expiration = value;
      }
    }
    public override string MessageId {
      get {
        return m_messageId;
      }
      set {
        m_messageId_present = true;
        m_messageId = value;
      }
    }
    public override AmqpTimestamp Timestamp {
      get {
        return m_timestamp;
      }
      set {
        m_timestamp_present = true;
        m_timestamp = value;
      }
    }
    public override string Type {
      get {
        return m_type;
      }
      set {
        m_type_present = true;
        m_type = value;
      }
    }
    public override string UserId {
      get {
        return m_userId;
      }
      set {
        m_userId_present = true;
        m_userId = value;
      }
    }
    public override string AppId {
      get {
        return m_appId;
      }
      set {
        m_appId_present = true;
        m_appId = value;
      }
    }
    public override string ClusterId {
      get {
        return m_clusterId;
      }
      set {
        m_clusterId_present = true;
        m_clusterId = value;
      }
    }

    public override void ClearContentType() { m_contentType_present = false; }
    public override void ClearContentEncoding() { m_contentEncoding_present = false; }
    public override void ClearHeaders() { m_headers_present = false; }
    public override void ClearDeliveryMode() { m_deliveryMode_present = false; }
    public override void ClearPriority() { m_priority_present = false; }
    public override void ClearCorrelationId() { m_correlationId_present = false; }
    public override void ClearReplyTo() { m_replyTo_present = false; }
    public override void ClearExpiration() { m_expiration_present = false; }
    public override void ClearMessageId() { m_messageId_present = false; }
    public override void ClearTimestamp() { m_timestamp_present = false; }
    public override void ClearType() { m_type_present = false; }
    public override void ClearUserId() { m_userId_present = false; }
    public override void ClearAppId() { m_appId_present = false; }
    public override void ClearClusterId() { m_clusterId_present = false; }

    public override bool IsContentTypePresent() { return m_contentType_present; }
    public override bool IsContentEncodingPresent() { return m_contentEncoding_present; }
    public override bool IsHeadersPresent() { return m_headers_present; }
    public override bool IsDeliveryModePresent() { return m_deliveryMode_present; }
    public override bool IsPriorityPresent() { return m_priority_present; }
    public override bool IsCorrelationIdPresent() { return m_correlationId_present; }
    public override bool IsReplyToPresent() { return m_replyTo_present; }
    public override bool IsExpirationPresent() { return m_expiration_present; }
    public override bool IsMessageIdPresent() { return m_messageId_present; }
    public override bool IsTimestampPresent() { return m_timestamp_present; }
    public override bool IsTypePresent() { return m_type_present; }
    public override bool IsUserIdPresent() { return m_userId_present; }
    public override bool IsAppIdPresent() { return m_appId_present; }
    public override bool IsClusterIdPresent() { return m_clusterId_present; }

    public BasicProperties() {}
    public override int ProtocolClassId { get { return 60; } }
    public override string ProtocolClassName { get { return "basic"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      m_contentType_present = reader.ReadPresence();
      m_contentEncoding_present = reader.ReadPresence();
      m_headers_present = reader.ReadPresence();
      m_deliveryMode_present = reader.ReadPresence();
      m_priority_present = reader.ReadPresence();
      m_correlationId_present = reader.ReadPresence();
      m_replyTo_present = reader.ReadPresence();
      m_expiration_present = reader.ReadPresence();
      m_messageId_present = reader.ReadPresence();
      m_timestamp_present = reader.ReadPresence();
      m_type_present = reader.ReadPresence();
      m_userId_present = reader.ReadPresence();
      m_appId_present = reader.ReadPresence();
      m_clusterId_present = reader.ReadPresence();
      reader.FinishPresence();
      if (m_contentType_present) { m_contentType = reader.ReadShortstr(); }
      if (m_contentEncoding_present) { m_contentEncoding = reader.ReadShortstr(); }
      if (m_headers_present) { m_headers = reader.ReadTable(); }
      if (m_deliveryMode_present) { m_deliveryMode = reader.ReadOctet(); }
      if (m_priority_present) { m_priority = reader.ReadOctet(); }
      if (m_correlationId_present) { m_correlationId = reader.ReadShortstr(); }
      if (m_replyTo_present) { m_replyTo = reader.ReadShortstr(); }
      if (m_expiration_present) { m_expiration = reader.ReadShortstr(); }
      if (m_messageId_present) { m_messageId = reader.ReadShortstr(); }
      if (m_timestamp_present) { m_timestamp = reader.ReadTimestamp(); }
      if (m_type_present) { m_type = reader.ReadShortstr(); }
      if (m_userId_present) { m_userId = reader.ReadShortstr(); }
      if (m_appId_present) { m_appId = reader.ReadShortstr(); }
      if (m_clusterId_present) { m_clusterId = reader.ReadShortstr(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(m_contentType_present);
      writer.WritePresence(m_contentEncoding_present);
      writer.WritePresence(m_headers_present);
      writer.WritePresence(m_deliveryMode_present);
      writer.WritePresence(m_priority_present);
      writer.WritePresence(m_correlationId_present);
      writer.WritePresence(m_replyTo_present);
      writer.WritePresence(m_expiration_present);
      writer.WritePresence(m_messageId_present);
      writer.WritePresence(m_timestamp_present);
      writer.WritePresence(m_type_present);
      writer.WritePresence(m_userId_present);
      writer.WritePresence(m_appId_present);
      writer.WritePresence(m_clusterId_present);
      writer.FinishPresence();
      if (m_contentType_present) { writer.WriteShortstr(m_contentType); }
      if (m_contentEncoding_present) { writer.WriteShortstr(m_contentEncoding); }
      if (m_headers_present) { writer.WriteTable(m_headers); }
      if (m_deliveryMode_present) { writer.WriteOctet(m_deliveryMode); }
      if (m_priority_present) { writer.WriteOctet(m_priority); }
      if (m_correlationId_present) { writer.WriteShortstr(m_correlationId); }
      if (m_replyTo_present) { writer.WriteShortstr(m_replyTo); }
      if (m_expiration_present) { writer.WriteShortstr(m_expiration); }
      if (m_messageId_present) { writer.WriteShortstr(m_messageId); }
      if (m_timestamp_present) { writer.WriteTimestamp(m_timestamp); }
      if (m_type_present) { writer.WriteShortstr(m_type); }
      if (m_userId_present) { writer.WriteShortstr(m_userId); }
      if (m_appId_present) { writer.WriteShortstr(m_appId); }
      if (m_clusterId_present) { writer.WriteShortstr(m_clusterId); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("content-type="); sb.Append(m_contentType_present ? (m_contentType == null ? "(null)" : m_contentType.ToString()) : "_"); sb.Append(", ");
      sb.Append("content-encoding="); sb.Append(m_contentEncoding_present ? (m_contentEncoding == null ? "(null)" : m_contentEncoding.ToString()) : "_"); sb.Append(", ");
      sb.Append("headers="); sb.Append(m_headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("delivery-mode="); sb.Append(m_deliveryMode_present ? m_deliveryMode.ToString() : "_"); sb.Append(", ");
      sb.Append("priority="); sb.Append(m_priority_present ? m_priority.ToString() : "_"); sb.Append(", ");
      sb.Append("correlation-id="); sb.Append(m_correlationId_present ? (m_correlationId == null ? "(null)" : m_correlationId.ToString()) : "_"); sb.Append(", ");
      sb.Append("reply-to="); sb.Append(m_replyTo_present ? (m_replyTo == null ? "(null)" : m_replyTo.ToString()) : "_"); sb.Append(", ");
      sb.Append("expiration="); sb.Append(m_expiration_present ? (m_expiration == null ? "(null)" : m_expiration.ToString()) : "_"); sb.Append(", ");
      sb.Append("message-id="); sb.Append(m_messageId_present ? (m_messageId == null ? "(null)" : m_messageId.ToString()) : "_"); sb.Append(", ");
      sb.Append("timestamp="); sb.Append(m_timestamp_present ? m_timestamp.ToString() : "_"); sb.Append(", ");
      sb.Append("type="); sb.Append(m_type_present ? (m_type == null ? "(null)" : m_type.ToString()) : "_"); sb.Append(", ");
      sb.Append("user-id="); sb.Append(m_userId_present ? (m_userId == null ? "(null)" : m_userId.ToString()) : "_"); sb.Append(", ");
      sb.Append("app-id="); sb.Append(m_appId_present ? (m_appId == null ? "(null)" : m_appId.ToString()) : "_"); sb.Append(", ");
      sb.Append("cluster-id="); sb.Append(m_clusterId_present ? (m_clusterId == null ? "(null)" : m_clusterId.ToString()) : "_");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "file"</summary>
  public class FileProperties: RabbitMQ.Client.Impl.FileProperties {
    private string m_contentType;
    private string m_contentEncoding;
    private System.Collections.IDictionary m_headers;
    private byte m_priority;
    private string m_replyTo;
    private string m_messageId;
    private string m_filename;
    private AmqpTimestamp m_timestamp;
    private string m_clusterId;

    private bool m_contentType_present = false;
    private bool m_contentEncoding_present = false;
    private bool m_headers_present = false;
    private bool m_priority_present = false;
    private bool m_replyTo_present = false;
    private bool m_messageId_present = false;
    private bool m_filename_present = false;
    private bool m_timestamp_present = false;
    private bool m_clusterId_present = false;

    public override string ContentType {
      get {
        return m_contentType;
      }
      set {
        m_contentType_present = true;
        m_contentType = value;
      }
    }
    public override string ContentEncoding {
      get {
        return m_contentEncoding;
      }
      set {
        m_contentEncoding_present = true;
        m_contentEncoding = value;
      }
    }
    public override System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        m_headers_present = true;
        m_headers = value;
      }
    }
    public override byte Priority {
      get {
        return m_priority;
      }
      set {
        m_priority_present = true;
        m_priority = value;
      }
    }
    public override string ReplyTo {
      get {
        return m_replyTo;
      }
      set {
        m_replyTo_present = true;
        m_replyTo = value;
      }
    }
    public override string MessageId {
      get {
        return m_messageId;
      }
      set {
        m_messageId_present = true;
        m_messageId = value;
      }
    }
    public override string Filename {
      get {
        return m_filename;
      }
      set {
        m_filename_present = true;
        m_filename = value;
      }
    }
    public override AmqpTimestamp Timestamp {
      get {
        return m_timestamp;
      }
      set {
        m_timestamp_present = true;
        m_timestamp = value;
      }
    }
    public override string ClusterId {
      get {
        return m_clusterId;
      }
      set {
        m_clusterId_present = true;
        m_clusterId = value;
      }
    }

    public override void ClearContentType() { m_contentType_present = false; }
    public override void ClearContentEncoding() { m_contentEncoding_present = false; }
    public override void ClearHeaders() { m_headers_present = false; }
    public override void ClearPriority() { m_priority_present = false; }
    public override void ClearReplyTo() { m_replyTo_present = false; }
    public override void ClearMessageId() { m_messageId_present = false; }
    public override void ClearFilename() { m_filename_present = false; }
    public override void ClearTimestamp() { m_timestamp_present = false; }
    public override void ClearClusterId() { m_clusterId_present = false; }

    public override bool IsContentTypePresent() { return m_contentType_present; }
    public override bool IsContentEncodingPresent() { return m_contentEncoding_present; }
    public override bool IsHeadersPresent() { return m_headers_present; }
    public override bool IsPriorityPresent() { return m_priority_present; }
    public override bool IsReplyToPresent() { return m_replyTo_present; }
    public override bool IsMessageIdPresent() { return m_messageId_present; }
    public override bool IsFilenamePresent() { return m_filename_present; }
    public override bool IsTimestampPresent() { return m_timestamp_present; }
    public override bool IsClusterIdPresent() { return m_clusterId_present; }

    public FileProperties() {}
    public override int ProtocolClassId { get { return 70; } }
    public override string ProtocolClassName { get { return "file"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      m_contentType_present = reader.ReadPresence();
      m_contentEncoding_present = reader.ReadPresence();
      m_headers_present = reader.ReadPresence();
      m_priority_present = reader.ReadPresence();
      m_replyTo_present = reader.ReadPresence();
      m_messageId_present = reader.ReadPresence();
      m_filename_present = reader.ReadPresence();
      m_timestamp_present = reader.ReadPresence();
      m_clusterId_present = reader.ReadPresence();
      reader.FinishPresence();
      if (m_contentType_present) { m_contentType = reader.ReadShortstr(); }
      if (m_contentEncoding_present) { m_contentEncoding = reader.ReadShortstr(); }
      if (m_headers_present) { m_headers = reader.ReadTable(); }
      if (m_priority_present) { m_priority = reader.ReadOctet(); }
      if (m_replyTo_present) { m_replyTo = reader.ReadShortstr(); }
      if (m_messageId_present) { m_messageId = reader.ReadShortstr(); }
      if (m_filename_present) { m_filename = reader.ReadShortstr(); }
      if (m_timestamp_present) { m_timestamp = reader.ReadTimestamp(); }
      if (m_clusterId_present) { m_clusterId = reader.ReadShortstr(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(m_contentType_present);
      writer.WritePresence(m_contentEncoding_present);
      writer.WritePresence(m_headers_present);
      writer.WritePresence(m_priority_present);
      writer.WritePresence(m_replyTo_present);
      writer.WritePresence(m_messageId_present);
      writer.WritePresence(m_filename_present);
      writer.WritePresence(m_timestamp_present);
      writer.WritePresence(m_clusterId_present);
      writer.FinishPresence();
      if (m_contentType_present) { writer.WriteShortstr(m_contentType); }
      if (m_contentEncoding_present) { writer.WriteShortstr(m_contentEncoding); }
      if (m_headers_present) { writer.WriteTable(m_headers); }
      if (m_priority_present) { writer.WriteOctet(m_priority); }
      if (m_replyTo_present) { writer.WriteShortstr(m_replyTo); }
      if (m_messageId_present) { writer.WriteShortstr(m_messageId); }
      if (m_filename_present) { writer.WriteShortstr(m_filename); }
      if (m_timestamp_present) { writer.WriteTimestamp(m_timestamp); }
      if (m_clusterId_present) { writer.WriteShortstr(m_clusterId); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("content-type="); sb.Append(m_contentType_present ? (m_contentType == null ? "(null)" : m_contentType.ToString()) : "_"); sb.Append(", ");
      sb.Append("content-encoding="); sb.Append(m_contentEncoding_present ? (m_contentEncoding == null ? "(null)" : m_contentEncoding.ToString()) : "_"); sb.Append(", ");
      sb.Append("headers="); sb.Append(m_headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("priority="); sb.Append(m_priority_present ? m_priority.ToString() : "_"); sb.Append(", ");
      sb.Append("reply-to="); sb.Append(m_replyTo_present ? (m_replyTo == null ? "(null)" : m_replyTo.ToString()) : "_"); sb.Append(", ");
      sb.Append("message-id="); sb.Append(m_messageId_present ? (m_messageId == null ? "(null)" : m_messageId.ToString()) : "_"); sb.Append(", ");
      sb.Append("filename="); sb.Append(m_filename_present ? (m_filename == null ? "(null)" : m_filename.ToString()) : "_"); sb.Append(", ");
      sb.Append("timestamp="); sb.Append(m_timestamp_present ? m_timestamp.ToString() : "_"); sb.Append(", ");
      sb.Append("cluster-id="); sb.Append(m_clusterId_present ? (m_clusterId == null ? "(null)" : m_clusterId.ToString()) : "_");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "stream"</summary>
  public class StreamProperties: RabbitMQ.Client.Impl.StreamProperties {
    private string m_contentType;
    private string m_contentEncoding;
    private System.Collections.IDictionary m_headers;
    private byte m_priority;
    private AmqpTimestamp m_timestamp;

    private bool m_contentType_present = false;
    private bool m_contentEncoding_present = false;
    private bool m_headers_present = false;
    private bool m_priority_present = false;
    private bool m_timestamp_present = false;

    public override string ContentType {
      get {
        return m_contentType;
      }
      set {
        m_contentType_present = true;
        m_contentType = value;
      }
    }
    public override string ContentEncoding {
      get {
        return m_contentEncoding;
      }
      set {
        m_contentEncoding_present = true;
        m_contentEncoding = value;
      }
    }
    public override System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        m_headers_present = true;
        m_headers = value;
      }
    }
    public override byte Priority {
      get {
        return m_priority;
      }
      set {
        m_priority_present = true;
        m_priority = value;
      }
    }
    public override AmqpTimestamp Timestamp {
      get {
        return m_timestamp;
      }
      set {
        m_timestamp_present = true;
        m_timestamp = value;
      }
    }

    public override void ClearContentType() { m_contentType_present = false; }
    public override void ClearContentEncoding() { m_contentEncoding_present = false; }
    public override void ClearHeaders() { m_headers_present = false; }
    public override void ClearPriority() { m_priority_present = false; }
    public override void ClearTimestamp() { m_timestamp_present = false; }

    public override bool IsContentTypePresent() { return m_contentType_present; }
    public override bool IsContentEncodingPresent() { return m_contentEncoding_present; }
    public override bool IsHeadersPresent() { return m_headers_present; }
    public override bool IsPriorityPresent() { return m_priority_present; }
    public override bool IsTimestampPresent() { return m_timestamp_present; }

    public StreamProperties() {}
    public override int ProtocolClassId { get { return 80; } }
    public override string ProtocolClassName { get { return "stream"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      m_contentType_present = reader.ReadPresence();
      m_contentEncoding_present = reader.ReadPresence();
      m_headers_present = reader.ReadPresence();
      m_priority_present = reader.ReadPresence();
      m_timestamp_present = reader.ReadPresence();
      reader.FinishPresence();
      if (m_contentType_present) { m_contentType = reader.ReadShortstr(); }
      if (m_contentEncoding_present) { m_contentEncoding = reader.ReadShortstr(); }
      if (m_headers_present) { m_headers = reader.ReadTable(); }
      if (m_priority_present) { m_priority = reader.ReadOctet(); }
      if (m_timestamp_present) { m_timestamp = reader.ReadTimestamp(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(m_contentType_present);
      writer.WritePresence(m_contentEncoding_present);
      writer.WritePresence(m_headers_present);
      writer.WritePresence(m_priority_present);
      writer.WritePresence(m_timestamp_present);
      writer.FinishPresence();
      if (m_contentType_present) { writer.WriteShortstr(m_contentType); }
      if (m_contentEncoding_present) { writer.WriteShortstr(m_contentEncoding); }
      if (m_headers_present) { writer.WriteTable(m_headers); }
      if (m_priority_present) { writer.WriteOctet(m_priority); }
      if (m_timestamp_present) { writer.WriteTimestamp(m_timestamp); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("content-type="); sb.Append(m_contentType_present ? (m_contentType == null ? "(null)" : m_contentType.ToString()) : "_"); sb.Append(", ");
      sb.Append("content-encoding="); sb.Append(m_contentEncoding_present ? (m_contentEncoding == null ? "(null)" : m_contentEncoding.ToString()) : "_"); sb.Append(", ");
      sb.Append("headers="); sb.Append(m_headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("priority="); sb.Append(m_priority_present ? m_priority.ToString() : "_"); sb.Append(", ");
      sb.Append("timestamp="); sb.Append(m_timestamp_present ? m_timestamp.ToString() : "_");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. AMQP specification content header properties for content class "tunnel"</summary>
  public class TunnelProperties: RabbitMQ.Client.Impl.ContentHeaderBase {
    private System.Collections.IDictionary m_headers;
    private string m_proxyName;
    private string m_dataName;
    private byte m_durable;
    private byte m_broadcast;

    private bool m_headers_present = false;
    private bool m_proxyName_present = false;
    private bool m_dataName_present = false;
    private bool m_durable_present = false;
    private bool m_broadcast_present = false;

    public System.Collections.IDictionary Headers {
      get {
        return m_headers;
      }
      set {
        m_headers_present = true;
        m_headers = value;
      }
    }
    public string ProxyName {
      get {
        return m_proxyName;
      }
      set {
        m_proxyName_present = true;
        m_proxyName = value;
      }
    }
    public string DataName {
      get {
        return m_dataName;
      }
      set {
        m_dataName_present = true;
        m_dataName = value;
      }
    }
    public byte Durable {
      get {
        return m_durable;
      }
      set {
        m_durable_present = true;
        m_durable = value;
      }
    }
    public byte Broadcast {
      get {
        return m_broadcast;
      }
      set {
        m_broadcast_present = true;
        m_broadcast = value;
      }
    }

    public void ClearHeaders() { m_headers_present = false; }
    public void ClearProxyName() { m_proxyName_present = false; }
    public void ClearDataName() { m_dataName_present = false; }
    public void ClearDurable() { m_durable_present = false; }
    public void ClearBroadcast() { m_broadcast_present = false; }

    public bool IsHeadersPresent() { return m_headers_present; }
    public bool IsProxyNamePresent() { return m_proxyName_present; }
    public bool IsDataNamePresent() { return m_dataName_present; }
    public bool IsDurablePresent() { return m_durable_present; }
    public bool IsBroadcastPresent() { return m_broadcast_present; }

    public TunnelProperties() {}
    public override int ProtocolClassId { get { return 110; } }
    public override string ProtocolClassName { get { return "tunnel"; } }

    public override void ReadPropertiesFrom(RabbitMQ.Client.Impl.ContentHeaderPropertyReader reader) {
      m_headers_present = reader.ReadPresence();
      m_proxyName_present = reader.ReadPresence();
      m_dataName_present = reader.ReadPresence();
      m_durable_present = reader.ReadPresence();
      m_broadcast_present = reader.ReadPresence();
      reader.FinishPresence();
      if (m_headers_present) { m_headers = reader.ReadTable(); }
      if (m_proxyName_present) { m_proxyName = reader.ReadShortstr(); }
      if (m_dataName_present) { m_dataName = reader.ReadShortstr(); }
      if (m_durable_present) { m_durable = reader.ReadOctet(); }
      if (m_broadcast_present) { m_broadcast = reader.ReadOctet(); }
    }

    public override void WritePropertiesTo(RabbitMQ.Client.Impl.ContentHeaderPropertyWriter writer) {
      writer.WritePresence(m_headers_present);
      writer.WritePresence(m_proxyName_present);
      writer.WritePresence(m_dataName_present);
      writer.WritePresence(m_durable_present);
      writer.WritePresence(m_broadcast_present);
      writer.FinishPresence();
      if (m_headers_present) { writer.WriteTable(m_headers); }
      if (m_proxyName_present) { writer.WriteShortstr(m_proxyName); }
      if (m_dataName_present) { writer.WriteShortstr(m_dataName); }
      if (m_durable_present) { writer.WriteOctet(m_durable); }
      if (m_broadcast_present) { writer.WriteOctet(m_broadcast); }
    }

    public override void AppendPropertyDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append("headers="); sb.Append(m_headers_present ? (m_headers == null ? "(null)" : m_headers.ToString()) : "_"); sb.Append(", ");
      sb.Append("proxy-name="); sb.Append(m_proxyName_present ? (m_proxyName == null ? "(null)" : m_proxyName.ToString()) : "_"); sb.Append(", ");
      sb.Append("data-name="); sb.Append(m_dataName_present ? (m_dataName == null ? "(null)" : m_dataName.ToString()) : "_"); sb.Append(", ");
      sb.Append("durable="); sb.Append(m_durable_present ? m_durable.ToString() : "_"); sb.Append(", ");
      sb.Append("broadcast="); sb.Append(m_broadcast_present ? m_broadcast.ToString() : "_");
      sb.Append(")");
    }
  }
}
namespace RabbitMQ.Client.Framing.Impl.v0_9 {
  using RabbitMQ.Client.Framing.v0_9;
  public enum ClassId {
    Connection = 10,
    Channel = 20,
    Access = 30,
    Exchange = 40,
    Queue = 50,
    Basic = 60,
    File = 70,
    Stream = 80,
    Tx = 90,
    Dtx = 100,
    Tunnel = 110,
    Message = 120,
    Invalid = -1
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionStart: RabbitMQ.Client.Impl.MethodBase, IConnectionStart {
    public const int ClassId = 10;
    public const int MethodId = 10;

    public byte m_versionMajor;
    public byte m_versionMinor;
    public System.Collections.IDictionary m_serverProperties;
    public byte[] m_mechanisms;
    public byte[] m_locales;

    byte IConnectionStart.VersionMajor { get { return m_versionMajor; } }
    byte IConnectionStart.VersionMinor { get { return m_versionMinor; } }
    System.Collections.IDictionary IConnectionStart.ServerProperties { get { return m_serverProperties; } }
    byte[] IConnectionStart.Mechanisms { get { return m_mechanisms; } }
    byte[] IConnectionStart.Locales { get { return m_locales; } }

    public ConnectionStart() {}
    public ConnectionStart(
      byte initVersionMajor,
      byte initVersionMinor,
      System.Collections.IDictionary initServerProperties,
      byte[] initMechanisms,
      byte[] initLocales)
    {
      m_versionMajor = initVersionMajor;
      m_versionMinor = initVersionMinor;
      m_serverProperties = initServerProperties;
      m_mechanisms = initMechanisms;
      m_locales = initLocales;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "connection.start"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_versionMajor = reader.ReadOctet();
      m_versionMinor = reader.ReadOctet();
      m_serverProperties = reader.ReadTable();
      m_mechanisms = reader.ReadLongstr();
      m_locales = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteOctet(m_versionMajor);
      writer.WriteOctet(m_versionMinor);
      writer.WriteTable(m_serverProperties);
      writer.WriteLongstr(m_mechanisms);
      writer.WriteLongstr(m_locales);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_versionMajor); sb.Append(",");
      sb.Append(m_versionMinor); sb.Append(",");
      sb.Append(m_serverProperties); sb.Append(",");
      sb.Append(m_mechanisms); sb.Append(",");
      sb.Append(m_locales);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionStartOk: RabbitMQ.Client.Impl.MethodBase, IConnectionStartOk {
    public const int ClassId = 10;
    public const int MethodId = 11;

    public System.Collections.IDictionary m_clientProperties;
    public string m_mechanism;
    public byte[] m_response;
    public string m_locale;

    System.Collections.IDictionary IConnectionStartOk.ClientProperties { get { return m_clientProperties; } }
    string IConnectionStartOk.Mechanism { get { return m_mechanism; } }
    byte[] IConnectionStartOk.Response { get { return m_response; } }
    string IConnectionStartOk.Locale { get { return m_locale; } }

    public ConnectionStartOk() {}
    public ConnectionStartOk(
      System.Collections.IDictionary initClientProperties,
      string initMechanism,
      byte[] initResponse,
      string initLocale)
    {
      m_clientProperties = initClientProperties;
      m_mechanism = initMechanism;
      m_response = initResponse;
      m_locale = initLocale;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "connection.start-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_clientProperties = reader.ReadTable();
      m_mechanism = reader.ReadShortstr();
      m_response = reader.ReadLongstr();
      m_locale = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteTable(m_clientProperties);
      writer.WriteShortstr(m_mechanism);
      writer.WriteLongstr(m_response);
      writer.WriteShortstr(m_locale);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_clientProperties); sb.Append(",");
      sb.Append(m_mechanism); sb.Append(",");
      sb.Append(m_response); sb.Append(",");
      sb.Append(m_locale);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionSecure: RabbitMQ.Client.Impl.MethodBase, IConnectionSecure {
    public const int ClassId = 10;
    public const int MethodId = 20;

    public byte[] m_challenge;

    byte[] IConnectionSecure.Challenge { get { return m_challenge; } }

    public ConnectionSecure() {}
    public ConnectionSecure(
      byte[] initChallenge)
    {
      m_challenge = initChallenge;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "connection.secure"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_challenge = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_challenge);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_challenge);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionSecureOk: RabbitMQ.Client.Impl.MethodBase, IConnectionSecureOk {
    public const int ClassId = 10;
    public const int MethodId = 21;

    public byte[] m_response;

    byte[] IConnectionSecureOk.Response { get { return m_response; } }

    public ConnectionSecureOk() {}
    public ConnectionSecureOk(
      byte[] initResponse)
    {
      m_response = initResponse;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "connection.secure-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_response = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_response);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_response);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionTune: RabbitMQ.Client.Impl.MethodBase, IConnectionTune {
    public const int ClassId = 10;
    public const int MethodId = 30;

    public ushort m_channelMax;
    public uint m_frameMax;
    public ushort m_heartbeat;

    ushort IConnectionTune.ChannelMax { get { return m_channelMax; } }
    uint IConnectionTune.FrameMax { get { return m_frameMax; } }
    ushort IConnectionTune.Heartbeat { get { return m_heartbeat; } }

    public ConnectionTune() {}
    public ConnectionTune(
      ushort initChannelMax,
      uint initFrameMax,
      ushort initHeartbeat)
    {
      m_channelMax = initChannelMax;
      m_frameMax = initFrameMax;
      m_heartbeat = initHeartbeat;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "connection.tune"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_channelMax = reader.ReadShort();
      m_frameMax = reader.ReadLong();
      m_heartbeat = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_channelMax);
      writer.WriteLong(m_frameMax);
      writer.WriteShort(m_heartbeat);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_channelMax); sb.Append(",");
      sb.Append(m_frameMax); sb.Append(",");
      sb.Append(m_heartbeat);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionTuneOk: RabbitMQ.Client.Impl.MethodBase, IConnectionTuneOk {
    public const int ClassId = 10;
    public const int MethodId = 31;

    public ushort m_channelMax;
    public uint m_frameMax;
    public ushort m_heartbeat;

    ushort IConnectionTuneOk.ChannelMax { get { return m_channelMax; } }
    uint IConnectionTuneOk.FrameMax { get { return m_frameMax; } }
    ushort IConnectionTuneOk.Heartbeat { get { return m_heartbeat; } }

    public ConnectionTuneOk() {}
    public ConnectionTuneOk(
      ushort initChannelMax,
      uint initFrameMax,
      ushort initHeartbeat)
    {
      m_channelMax = initChannelMax;
      m_frameMax = initFrameMax;
      m_heartbeat = initHeartbeat;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "connection.tune-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_channelMax = reader.ReadShort();
      m_frameMax = reader.ReadLong();
      m_heartbeat = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_channelMax);
      writer.WriteLong(m_frameMax);
      writer.WriteShort(m_heartbeat);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_channelMax); sb.Append(",");
      sb.Append(m_frameMax); sb.Append(",");
      sb.Append(m_heartbeat);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionOpen: RabbitMQ.Client.Impl.MethodBase, IConnectionOpen {
    public const int ClassId = 10;
    public const int MethodId = 40;

    public string m_virtualHost;
    public string m_capabilities;
    public bool m_insist;

    string IConnectionOpen.VirtualHost { get { return m_virtualHost; } }
    string IConnectionOpen.Capabilities { get { return m_capabilities; } }
    bool IConnectionOpen.Insist { get { return m_insist; } }

    public ConnectionOpen() {}
    public ConnectionOpen(
      string initVirtualHost,
      string initCapabilities,
      bool initInsist)
    {
      m_virtualHost = initVirtualHost;
      m_capabilities = initCapabilities;
      m_insist = initInsist;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "connection.open"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_virtualHost = reader.ReadShortstr();
      m_capabilities = reader.ReadShortstr();
      m_insist = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_virtualHost);
      writer.WriteShortstr(m_capabilities);
      writer.WriteBit(m_insist);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_virtualHost); sb.Append(",");
      sb.Append(m_capabilities); sb.Append(",");
      sb.Append(m_insist);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionOpenOk: RabbitMQ.Client.Impl.MethodBase, IConnectionOpenOk {
    public const int ClassId = 10;
    public const int MethodId = 41;

    public string m_knownHosts;

    string IConnectionOpenOk.KnownHosts { get { return m_knownHosts; } }

    public ConnectionOpenOk() {}
    public ConnectionOpenOk(
      string initKnownHosts)
    {
      m_knownHosts = initKnownHosts;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "connection.open-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_knownHosts = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_knownHosts);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_knownHosts);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionRedirect: RabbitMQ.Client.Impl.MethodBase, IConnectionRedirect {
    public const int ClassId = 10;
    public const int MethodId = 42;

    public string m_host;
    public string m_knownHosts;

    string IConnectionRedirect.Host { get { return m_host; } }
    string IConnectionRedirect.KnownHosts { get { return m_knownHosts; } }

    public ConnectionRedirect() {}
    public ConnectionRedirect(
      string initHost,
      string initKnownHosts)
    {
      m_host = initHost;
      m_knownHosts = initKnownHosts;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 42; } }
    public override string ProtocolMethodName { get { return "connection.redirect"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_host = reader.ReadShortstr();
      m_knownHosts = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_host);
      writer.WriteShortstr(m_knownHosts);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_host); sb.Append(",");
      sb.Append(m_knownHosts);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionClose: RabbitMQ.Client.Impl.MethodBase, IConnectionClose {
    public const int ClassId = 10;
    public const int MethodId = 50;

    public ushort m_replyCode;
    public string m_replyText;
    public ushort m_classId;
    public ushort m_methodId;

    ushort IConnectionClose.ReplyCode { get { return m_replyCode; } }
    string IConnectionClose.ReplyText { get { return m_replyText; } }
    ushort IConnectionClose.ClassId { get { return m_classId; } }
    ushort IConnectionClose.MethodId { get { return m_methodId; } }

    public ConnectionClose() {}
    public ConnectionClose(
      ushort initReplyCode,
      string initReplyText,
      ushort initClassId,
      ushort initMethodId)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_classId = initClassId;
      m_methodId = initMethodId;
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "connection.close"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_classId = reader.ReadShort();
      m_methodId = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShort(m_classId);
      writer.WriteShort(m_methodId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_classId); sb.Append(",");
      sb.Append(m_methodId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ConnectionCloseOk: RabbitMQ.Client.Impl.MethodBase, IConnectionCloseOk {
    public const int ClassId = 10;
    public const int MethodId = 51;



    public ConnectionCloseOk(
)
    {
    }

    public override int ProtocolClassId { get { return 10; } }
    public override int ProtocolMethodId { get { return 51; } }
    public override string ProtocolMethodName { get { return "connection.close-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelOpen: RabbitMQ.Client.Impl.MethodBase, IChannelOpen {
    public const int ClassId = 20;
    public const int MethodId = 10;

    public string m_outOfBand;

    string IChannelOpen.OutOfBand { get { return m_outOfBand; } }

    public ChannelOpen() {}
    public ChannelOpen(
      string initOutOfBand)
    {
      m_outOfBand = initOutOfBand;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "channel.open"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_outOfBand = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_outOfBand);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_outOfBand);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelOpenOk: RabbitMQ.Client.Impl.MethodBase, IChannelOpenOk {
    public const int ClassId = 20;
    public const int MethodId = 11;

    public byte[] m_channelId;

    byte[] IChannelOpenOk.ChannelId { get { return m_channelId; } }

    public ChannelOpenOk() {}
    public ChannelOpenOk(
      byte[] initChannelId)
    {
      m_channelId = initChannelId;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "channel.open-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_channelId = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_channelId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_channelId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelFlow: RabbitMQ.Client.Impl.MethodBase, IChannelFlow {
    public const int ClassId = 20;
    public const int MethodId = 20;

    public bool m_active;

    bool IChannelFlow.Active { get { return m_active; } }

    public ChannelFlow() {}
    public ChannelFlow(
      bool initActive)
    {
      m_active = initActive;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "channel.flow"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_active = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteBit(m_active);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_active);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelFlowOk: RabbitMQ.Client.Impl.MethodBase, IChannelFlowOk {
    public const int ClassId = 20;
    public const int MethodId = 21;

    public bool m_active;

    bool IChannelFlowOk.Active { get { return m_active; } }

    public ChannelFlowOk() {}
    public ChannelFlowOk(
      bool initActive)
    {
      m_active = initActive;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "channel.flow-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_active = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteBit(m_active);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_active);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelClose: RabbitMQ.Client.Impl.MethodBase, IChannelClose {
    public const int ClassId = 20;
    public const int MethodId = 40;

    public ushort m_replyCode;
    public string m_replyText;
    public ushort m_classId;
    public ushort m_methodId;

    ushort IChannelClose.ReplyCode { get { return m_replyCode; } }
    string IChannelClose.ReplyText { get { return m_replyText; } }
    ushort IChannelClose.ClassId { get { return m_classId; } }
    ushort IChannelClose.MethodId { get { return m_methodId; } }

    public ChannelClose() {}
    public ChannelClose(
      ushort initReplyCode,
      string initReplyText,
      ushort initClassId,
      ushort initMethodId)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_classId = initClassId;
      m_methodId = initMethodId;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "channel.close"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_classId = reader.ReadShort();
      m_methodId = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShort(m_classId);
      writer.WriteShort(m_methodId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_classId); sb.Append(",");
      sb.Append(m_methodId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelCloseOk: RabbitMQ.Client.Impl.MethodBase, IChannelCloseOk {
    public const int ClassId = 20;
    public const int MethodId = 41;



    public ChannelCloseOk(
)
    {
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "channel.close-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelResume: RabbitMQ.Client.Impl.MethodBase, IChannelResume {
    public const int ClassId = 20;
    public const int MethodId = 50;

    public byte[] m_channelId;

    byte[] IChannelResume.ChannelId { get { return m_channelId; } }

    public ChannelResume() {}
    public ChannelResume(
      byte[] initChannelId)
    {
      m_channelId = initChannelId;
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "channel.resume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_channelId = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_channelId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_channelId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelPing: RabbitMQ.Client.Impl.MethodBase, IChannelPing {
    public const int ClassId = 20;
    public const int MethodId = 60;



    public ChannelPing(
)
    {
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "channel.ping"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelPong: RabbitMQ.Client.Impl.MethodBase, IChannelPong {
    public const int ClassId = 20;
    public const int MethodId = 70;



    public ChannelPong(
)
    {
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 70; } }
    public override string ProtocolMethodName { get { return "channel.pong"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ChannelOk: RabbitMQ.Client.Impl.MethodBase, IChannelOk {
    public const int ClassId = 20;
    public const int MethodId = 80;



    public ChannelOk(
)
    {
    }

    public override int ProtocolClassId { get { return 20; } }
    public override int ProtocolMethodId { get { return 80; } }
    public override string ProtocolMethodName { get { return "channel.ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class AccessRequest: RabbitMQ.Client.Impl.MethodBase, IAccessRequest {
    public const int ClassId = 30;
    public const int MethodId = 10;

    public string m_realm;
    public bool m_exclusive;
    public bool m_passive;
    public bool m_active;
    public bool m_write;
    public bool m_read;

    string IAccessRequest.Realm { get { return m_realm; } }
    bool IAccessRequest.Exclusive { get { return m_exclusive; } }
    bool IAccessRequest.Passive { get { return m_passive; } }
    bool IAccessRequest.Active { get { return m_active; } }
    bool IAccessRequest.Write { get { return m_write; } }
    bool IAccessRequest.Read { get { return m_read; } }

    public AccessRequest() {}
    public AccessRequest(
      string initRealm,
      bool initExclusive,
      bool initPassive,
      bool initActive,
      bool initWrite,
      bool initRead)
    {
      m_realm = initRealm;
      m_exclusive = initExclusive;
      m_passive = initPassive;
      m_active = initActive;
      m_write = initWrite;
      m_read = initRead;
    }

    public override int ProtocolClassId { get { return 30; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "access.request"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_realm = reader.ReadShortstr();
      m_exclusive = reader.ReadBit();
      m_passive = reader.ReadBit();
      m_active = reader.ReadBit();
      m_write = reader.ReadBit();
      m_read = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_realm);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_passive);
      writer.WriteBit(m_active);
      writer.WriteBit(m_write);
      writer.WriteBit(m_read);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_realm); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_passive); sb.Append(",");
      sb.Append(m_active); sb.Append(",");
      sb.Append(m_write); sb.Append(",");
      sb.Append(m_read);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class AccessRequestOk: RabbitMQ.Client.Impl.MethodBase, IAccessRequestOk {
    public const int ClassId = 30;
    public const int MethodId = 11;

    public ushort m_ticket;

    ushort IAccessRequestOk.Ticket { get { return m_ticket; } }

    public AccessRequestOk() {}
    public AccessRequestOk(
      ushort initTicket)
    {
      m_ticket = initTicket;
    }

    public override int ProtocolClassId { get { return 30; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "access.request-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDeclare: RabbitMQ.Client.Impl.MethodBase, IExchangeDeclare {
    public const int ClassId = 40;
    public const int MethodId = 10;

    public ushort m_ticket;
    public string m_exchange;
    public string m_type;
    public bool m_passive;
    public bool m_durable;
    public bool m_autoDelete;
    public bool m_internal;
    public bool m_nowait;
    public System.Collections.IDictionary m_arguments;

    ushort IExchangeDeclare.Ticket { get { return m_ticket; } }
    string IExchangeDeclare.Exchange { get { return m_exchange; } }
    string IExchangeDeclare.Type { get { return m_type; } }
    bool IExchangeDeclare.Passive { get { return m_passive; } }
    bool IExchangeDeclare.Durable { get { return m_durable; } }
    bool IExchangeDeclare.AutoDelete { get { return m_autoDelete; } }
    bool IExchangeDeclare.Internal { get { return m_internal; } }
    bool IExchangeDeclare.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IExchangeDeclare.Arguments { get { return m_arguments; } }

    public ExchangeDeclare() {}
    public ExchangeDeclare(
      ushort initTicket,
      string initExchange,
      string initType,
      bool initPassive,
      bool initDurable,
      bool initAutoDelete,
      bool initInternal,
      bool initNowait,
      System.Collections.IDictionary initArguments)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_type = initType;
      m_passive = initPassive;
      m_durable = initDurable;
      m_autoDelete = initAutoDelete;
      m_internal = initInternal;
      m_nowait = initNowait;
      m_arguments = initArguments;
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "exchange.declare"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_type = reader.ReadShortstr();
      m_passive = reader.ReadBit();
      m_durable = reader.ReadBit();
      m_autoDelete = reader.ReadBit();
      m_internal = reader.ReadBit();
      m_nowait = reader.ReadBit();
      m_arguments = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_type);
      writer.WriteBit(m_passive);
      writer.WriteBit(m_durable);
      writer.WriteBit(m_autoDelete);
      writer.WriteBit(m_internal);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_arguments);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_type); sb.Append(",");
      sb.Append(m_passive); sb.Append(",");
      sb.Append(m_durable); sb.Append(",");
      sb.Append(m_autoDelete); sb.Append(",");
      sb.Append(m_internal); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_arguments);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDeclareOk: RabbitMQ.Client.Impl.MethodBase, IExchangeDeclareOk {
    public const int ClassId = 40;
    public const int MethodId = 11;



    public ExchangeDeclareOk(
)
    {
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "exchange.declare-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDelete: RabbitMQ.Client.Impl.MethodBase, IExchangeDelete {
    public const int ClassId = 40;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_exchange;
    public bool m_ifUnused;
    public bool m_nowait;

    ushort IExchangeDelete.Ticket { get { return m_ticket; } }
    string IExchangeDelete.Exchange { get { return m_exchange; } }
    bool IExchangeDelete.IfUnused { get { return m_ifUnused; } }
    bool IExchangeDelete.Nowait { get { return m_nowait; } }

    public ExchangeDelete() {}
    public ExchangeDelete(
      ushort initTicket,
      string initExchange,
      bool initIfUnused,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_ifUnused = initIfUnused;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "exchange.delete"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_ifUnused = reader.ReadBit();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteBit(m_ifUnused);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_ifUnused); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class ExchangeDeleteOk: RabbitMQ.Client.Impl.MethodBase, IExchangeDeleteOk {
    public const int ClassId = 40;
    public const int MethodId = 21;



    public ExchangeDeleteOk(
)
    {
    }

    public override int ProtocolClassId { get { return 40; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "exchange.delete-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDeclare: RabbitMQ.Client.Impl.MethodBase, IQueueDeclare {
    public const int ClassId = 50;
    public const int MethodId = 10;

    public ushort m_ticket;
    public string m_queue;
    public bool m_passive;
    public bool m_durable;
    public bool m_exclusive;
    public bool m_autoDelete;
    public bool m_nowait;
    public System.Collections.IDictionary m_arguments;

    ushort IQueueDeclare.Ticket { get { return m_ticket; } }
    string IQueueDeclare.Queue { get { return m_queue; } }
    bool IQueueDeclare.Passive { get { return m_passive; } }
    bool IQueueDeclare.Durable { get { return m_durable; } }
    bool IQueueDeclare.Exclusive { get { return m_exclusive; } }
    bool IQueueDeclare.AutoDelete { get { return m_autoDelete; } }
    bool IQueueDeclare.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IQueueDeclare.Arguments { get { return m_arguments; } }

    public QueueDeclare() {}
    public QueueDeclare(
      ushort initTicket,
      string initQueue,
      bool initPassive,
      bool initDurable,
      bool initExclusive,
      bool initAutoDelete,
      bool initNowait,
      System.Collections.IDictionary initArguments)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_passive = initPassive;
      m_durable = initDurable;
      m_exclusive = initExclusive;
      m_autoDelete = initAutoDelete;
      m_nowait = initNowait;
      m_arguments = initArguments;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "queue.declare"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_passive = reader.ReadBit();
      m_durable = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_autoDelete = reader.ReadBit();
      m_nowait = reader.ReadBit();
      m_arguments = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_passive);
      writer.WriteBit(m_durable);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_autoDelete);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_arguments);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_passive); sb.Append(",");
      sb.Append(m_durable); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_autoDelete); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_arguments);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDeclareOk: RabbitMQ.Client.Impl.MethodBase, IQueueDeclareOk {
    public const int ClassId = 50;
    public const int MethodId = 11;

    public string m_queue;
    public uint m_messageCount;
    public uint m_consumerCount;

    string IQueueDeclareOk.Queue { get { return m_queue; } }
    uint IQueueDeclareOk.MessageCount { get { return m_messageCount; } }
    uint IQueueDeclareOk.ConsumerCount { get { return m_consumerCount; } }

    public QueueDeclareOk() {}
    public QueueDeclareOk(
      string initQueue,
      uint initMessageCount,
      uint initConsumerCount)
    {
      m_queue = initQueue;
      m_messageCount = initMessageCount;
      m_consumerCount = initConsumerCount;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "queue.declare-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_queue = reader.ReadShortstr();
      m_messageCount = reader.ReadLong();
      m_consumerCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_queue);
      writer.WriteLong(m_messageCount);
      writer.WriteLong(m_consumerCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_messageCount); sb.Append(",");
      sb.Append(m_consumerCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueBind: RabbitMQ.Client.Impl.MethodBase, IQueueBind {
    public const int ClassId = 50;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_exchange;
    public string m_routingKey;
    public bool m_nowait;
    public System.Collections.IDictionary m_arguments;

    ushort IQueueBind.Ticket { get { return m_ticket; } }
    string IQueueBind.Queue { get { return m_queue; } }
    string IQueueBind.Exchange { get { return m_exchange; } }
    string IQueueBind.RoutingKey { get { return m_routingKey; } }
    bool IQueueBind.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IQueueBind.Arguments { get { return m_arguments; } }

    public QueueBind() {}
    public QueueBind(
      ushort initTicket,
      string initQueue,
      string initExchange,
      string initRoutingKey,
      bool initNowait,
      System.Collections.IDictionary initArguments)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_nowait = initNowait;
      m_arguments = initArguments;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "queue.bind"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
      m_arguments = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_arguments);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_arguments);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueBindOk: RabbitMQ.Client.Impl.MethodBase, IQueueBindOk {
    public const int ClassId = 50;
    public const int MethodId = 21;



    public QueueBindOk(
)
    {
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "queue.bind-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueUnbind: RabbitMQ.Client.Impl.MethodBase, IQueueUnbind {
    public const int ClassId = 50;
    public const int MethodId = 50;

    public ushort m_ticket;
    public string m_queue;
    public string m_exchange;
    public string m_routingKey;
    public System.Collections.IDictionary m_arguments;

    ushort IQueueUnbind.Ticket { get { return m_ticket; } }
    string IQueueUnbind.Queue { get { return m_queue; } }
    string IQueueUnbind.Exchange { get { return m_exchange; } }
    string IQueueUnbind.RoutingKey { get { return m_routingKey; } }
    System.Collections.IDictionary IQueueUnbind.Arguments { get { return m_arguments; } }

    public QueueUnbind() {}
    public QueueUnbind(
      ushort initTicket,
      string initQueue,
      string initExchange,
      string initRoutingKey,
      System.Collections.IDictionary initArguments)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_arguments = initArguments;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "queue.unbind"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_arguments = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteTable(m_arguments);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_arguments);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueUnbindOk: RabbitMQ.Client.Impl.MethodBase, IQueueUnbindOk {
    public const int ClassId = 50;
    public const int MethodId = 51;



    public QueueUnbindOk(
)
    {
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 51; } }
    public override string ProtocolMethodName { get { return "queue.unbind-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueuePurge: RabbitMQ.Client.Impl.MethodBase, IQueuePurge {
    public const int ClassId = 50;
    public const int MethodId = 30;

    public ushort m_ticket;
    public string m_queue;
    public bool m_nowait;

    ushort IQueuePurge.Ticket { get { return m_ticket; } }
    string IQueuePurge.Queue { get { return m_queue; } }
    bool IQueuePurge.Nowait { get { return m_nowait; } }

    public QueuePurge() {}
    public QueuePurge(
      ushort initTicket,
      string initQueue,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "queue.purge"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueuePurgeOk: RabbitMQ.Client.Impl.MethodBase, IQueuePurgeOk {
    public const int ClassId = 50;
    public const int MethodId = 31;

    public uint m_messageCount;

    uint IQueuePurgeOk.MessageCount { get { return m_messageCount; } }

    public QueuePurgeOk() {}
    public QueuePurgeOk(
      uint initMessageCount)
    {
      m_messageCount = initMessageCount;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "queue.purge-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_messageCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_messageCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_messageCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDelete: RabbitMQ.Client.Impl.MethodBase, IQueueDelete {
    public const int ClassId = 50;
    public const int MethodId = 40;

    public ushort m_ticket;
    public string m_queue;
    public bool m_ifUnused;
    public bool m_ifEmpty;
    public bool m_nowait;

    ushort IQueueDelete.Ticket { get { return m_ticket; } }
    string IQueueDelete.Queue { get { return m_queue; } }
    bool IQueueDelete.IfUnused { get { return m_ifUnused; } }
    bool IQueueDelete.IfEmpty { get { return m_ifEmpty; } }
    bool IQueueDelete.Nowait { get { return m_nowait; } }

    public QueueDelete() {}
    public QueueDelete(
      ushort initTicket,
      string initQueue,
      bool initIfUnused,
      bool initIfEmpty,
      bool initNowait)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_ifUnused = initIfUnused;
      m_ifEmpty = initIfEmpty;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "queue.delete"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_ifUnused = reader.ReadBit();
      m_ifEmpty = reader.ReadBit();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_ifUnused);
      writer.WriteBit(m_ifEmpty);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_ifUnused); sb.Append(",");
      sb.Append(m_ifEmpty); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class QueueDeleteOk: RabbitMQ.Client.Impl.MethodBase, IQueueDeleteOk {
    public const int ClassId = 50;
    public const int MethodId = 41;

    public uint m_messageCount;

    uint IQueueDeleteOk.MessageCount { get { return m_messageCount; } }

    public QueueDeleteOk() {}
    public QueueDeleteOk(
      uint initMessageCount)
    {
      m_messageCount = initMessageCount;
    }

    public override int ProtocolClassId { get { return 50; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "queue.delete-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_messageCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_messageCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_messageCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicQos: RabbitMQ.Client.Impl.MethodBase, IBasicQos {
    public const int ClassId = 60;
    public const int MethodId = 10;

    public uint m_prefetchSize;
    public ushort m_prefetchCount;
    public bool m_global;

    uint IBasicQos.PrefetchSize { get { return m_prefetchSize; } }
    ushort IBasicQos.PrefetchCount { get { return m_prefetchCount; } }
    bool IBasicQos.Global { get { return m_global; } }

    public BasicQos() {}
    public BasicQos(
      uint initPrefetchSize,
      ushort initPrefetchCount,
      bool initGlobal)
    {
      m_prefetchSize = initPrefetchSize;
      m_prefetchCount = initPrefetchCount;
      m_global = initGlobal;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "basic.qos"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_prefetchSize = reader.ReadLong();
      m_prefetchCount = reader.ReadShort();
      m_global = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_prefetchSize);
      writer.WriteShort(m_prefetchCount);
      writer.WriteBit(m_global);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_prefetchSize); sb.Append(",");
      sb.Append(m_prefetchCount); sb.Append(",");
      sb.Append(m_global);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicQosOk: RabbitMQ.Client.Impl.MethodBase, IBasicQosOk {
    public const int ClassId = 60;
    public const int MethodId = 11;



    public BasicQosOk(
)
    {
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "basic.qos-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicConsume: RabbitMQ.Client.Impl.MethodBase, IBasicConsume {
    public const int ClassId = 60;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_consumerTag;
    public bool m_noLocal;
    public bool m_noAck;
    public bool m_exclusive;
    public bool m_nowait;
    public System.Collections.IDictionary m_filter;

    ushort IBasicConsume.Ticket { get { return m_ticket; } }
    string IBasicConsume.Queue { get { return m_queue; } }
    string IBasicConsume.ConsumerTag { get { return m_consumerTag; } }
    bool IBasicConsume.NoLocal { get { return m_noLocal; } }
    bool IBasicConsume.NoAck { get { return m_noAck; } }
    bool IBasicConsume.Exclusive { get { return m_exclusive; } }
    bool IBasicConsume.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IBasicConsume.Filter { get { return m_filter; } }

    public BasicConsume() {}
    public BasicConsume(
      ushort initTicket,
      string initQueue,
      string initConsumerTag,
      bool initNoLocal,
      bool initNoAck,
      bool initExclusive,
      bool initNowait,
      System.Collections.IDictionary initFilter)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_consumerTag = initConsumerTag;
      m_noLocal = initNoLocal;
      m_noAck = initNoAck;
      m_exclusive = initExclusive;
      m_nowait = initNowait;
      m_filter = initFilter;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "basic.consume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_consumerTag = reader.ReadShortstr();
      m_noLocal = reader.ReadBit();
      m_noAck = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_nowait = reader.ReadBit();
      m_filter = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_noLocal);
      writer.WriteBit(m_noAck);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_filter);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_noLocal); sb.Append(",");
      sb.Append(m_noAck); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_filter);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicConsumeOk: RabbitMQ.Client.Impl.MethodBase, IBasicConsumeOk {
    public const int ClassId = 60;
    public const int MethodId = 21;

    public string m_consumerTag;

    string IBasicConsumeOk.ConsumerTag { get { return m_consumerTag; } }

    public BasicConsumeOk() {}
    public BasicConsumeOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "basic.consume-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicCancel: RabbitMQ.Client.Impl.MethodBase, IBasicCancel {
    public const int ClassId = 60;
    public const int MethodId = 30;

    public string m_consumerTag;
    public bool m_nowait;

    string IBasicCancel.ConsumerTag { get { return m_consumerTag; } }
    bool IBasicCancel.Nowait { get { return m_nowait; } }

    public BasicCancel() {}
    public BasicCancel(
      string initConsumerTag,
      bool initNowait)
    {
      m_consumerTag = initConsumerTag;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "basic.cancel"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicCancelOk: RabbitMQ.Client.Impl.MethodBase, IBasicCancelOk {
    public const int ClassId = 60;
    public const int MethodId = 31;

    public string m_consumerTag;

    string IBasicCancelOk.ConsumerTag { get { return m_consumerTag; } }

    public BasicCancelOk() {}
    public BasicCancelOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "basic.cancel-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicPublish: RabbitMQ.Client.Impl.MethodBase, IBasicPublish {
    public const int ClassId = 60;
    public const int MethodId = 40;

    public ushort m_ticket;
    public string m_exchange;
    public string m_routingKey;
    public bool m_mandatory;
    public bool m_immediate;

    ushort IBasicPublish.Ticket { get { return m_ticket; } }
    string IBasicPublish.Exchange { get { return m_exchange; } }
    string IBasicPublish.RoutingKey { get { return m_routingKey; } }
    bool IBasicPublish.Mandatory { get { return m_mandatory; } }
    bool IBasicPublish.Immediate { get { return m_immediate; } }

    public BasicPublish() {}
    public BasicPublish(
      ushort initTicket,
      string initExchange,
      string initRoutingKey,
      bool initMandatory,
      bool initImmediate)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_mandatory = initMandatory;
      m_immediate = initImmediate;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "basic.publish"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_mandatory = reader.ReadBit();
      m_immediate = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_mandatory);
      writer.WriteBit(m_immediate);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_mandatory); sb.Append(",");
      sb.Append(m_immediate);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicReturn: RabbitMQ.Client.Impl.MethodBase, IBasicReturn {
    public const int ClassId = 60;
    public const int MethodId = 50;

    public ushort m_replyCode;
    public string m_replyText;
    public string m_exchange;
    public string m_routingKey;

    ushort IBasicReturn.ReplyCode { get { return m_replyCode; } }
    string IBasicReturn.ReplyText { get { return m_replyText; } }
    string IBasicReturn.Exchange { get { return m_exchange; } }
    string IBasicReturn.RoutingKey { get { return m_routingKey; } }

    public BasicReturn() {}
    public BasicReturn(
      ushort initReplyCode,
      string initReplyText,
      string initExchange,
      string initRoutingKey)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "basic.return"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicDeliver: RabbitMQ.Client.Impl.MethodBase, IBasicDeliver {
    public const int ClassId = 60;
    public const int MethodId = 60;

    public string m_consumerTag;
    public ulong m_deliveryTag;
    public bool m_redelivered;
    public string m_exchange;
    public string m_routingKey;

    string IBasicDeliver.ConsumerTag { get { return m_consumerTag; } }
    ulong IBasicDeliver.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicDeliver.Redelivered { get { return m_redelivered; } }
    string IBasicDeliver.Exchange { get { return m_exchange; } }
    string IBasicDeliver.RoutingKey { get { return m_routingKey; } }

    public BasicDeliver() {}
    public BasicDeliver(
      string initConsumerTag,
      ulong initDeliveryTag,
      bool initRedelivered,
      string initExchange,
      string initRoutingKey)
    {
      m_consumerTag = initConsumerTag;
      m_deliveryTag = initDeliveryTag;
      m_redelivered = initRedelivered;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "basic.deliver"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_deliveryTag = reader.ReadLonglong();
      m_redelivered = reader.ReadBit();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_redelivered);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_redelivered); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicGet: RabbitMQ.Client.Impl.MethodBase, IBasicGet {
    public const int ClassId = 60;
    public const int MethodId = 70;

    public ushort m_ticket;
    public string m_queue;
    public bool m_noAck;

    ushort IBasicGet.Ticket { get { return m_ticket; } }
    string IBasicGet.Queue { get { return m_queue; } }
    bool IBasicGet.NoAck { get { return m_noAck; } }

    public BasicGet() {}
    public BasicGet(
      ushort initTicket,
      string initQueue,
      bool initNoAck)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_noAck = initNoAck;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 70; } }
    public override string ProtocolMethodName { get { return "basic.get"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_noAck = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteBit(m_noAck);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_noAck);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicGetOk: RabbitMQ.Client.Impl.MethodBase, IBasicGetOk {
    public const int ClassId = 60;
    public const int MethodId = 71;

    public ulong m_deliveryTag;
    public bool m_redelivered;
    public string m_exchange;
    public string m_routingKey;
    public uint m_messageCount;

    ulong IBasicGetOk.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicGetOk.Redelivered { get { return m_redelivered; } }
    string IBasicGetOk.Exchange { get { return m_exchange; } }
    string IBasicGetOk.RoutingKey { get { return m_routingKey; } }
    uint IBasicGetOk.MessageCount { get { return m_messageCount; } }

    public BasicGetOk() {}
    public BasicGetOk(
      ulong initDeliveryTag,
      bool initRedelivered,
      string initExchange,
      string initRoutingKey,
      uint initMessageCount)
    {
      m_deliveryTag = initDeliveryTag;
      m_redelivered = initRedelivered;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_messageCount = initMessageCount;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 71; } }
    public override string ProtocolMethodName { get { return "basic.get-ok"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_redelivered = reader.ReadBit();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_messageCount = reader.ReadLong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_redelivered);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteLong(m_messageCount);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_redelivered); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_messageCount);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicGetEmpty: RabbitMQ.Client.Impl.MethodBase, IBasicGetEmpty {
    public const int ClassId = 60;
    public const int MethodId = 72;

    public string m_clusterId;

    string IBasicGetEmpty.ClusterId { get { return m_clusterId; } }

    public BasicGetEmpty() {}
    public BasicGetEmpty(
      string initClusterId)
    {
      m_clusterId = initClusterId;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 72; } }
    public override string ProtocolMethodName { get { return "basic.get-empty"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_clusterId = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_clusterId);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_clusterId);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicAck: RabbitMQ.Client.Impl.MethodBase, IBasicAck {
    public const int ClassId = 60;
    public const int MethodId = 80;

    public ulong m_deliveryTag;
    public bool m_multiple;

    ulong IBasicAck.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicAck.Multiple { get { return m_multiple; } }

    public BasicAck() {}
    public BasicAck(
      ulong initDeliveryTag,
      bool initMultiple)
    {
      m_deliveryTag = initDeliveryTag;
      m_multiple = initMultiple;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 80; } }
    public override string ProtocolMethodName { get { return "basic.ack"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_multiple = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_multiple);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_multiple);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicReject: RabbitMQ.Client.Impl.MethodBase, IBasicReject {
    public const int ClassId = 60;
    public const int MethodId = 90;

    public ulong m_deliveryTag;
    public bool m_requeue;

    ulong IBasicReject.DeliveryTag { get { return m_deliveryTag; } }
    bool IBasicReject.Requeue { get { return m_requeue; } }

    public BasicReject() {}
    public BasicReject(
      ulong initDeliveryTag,
      bool initRequeue)
    {
      m_deliveryTag = initDeliveryTag;
      m_requeue = initRequeue;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 90; } }
    public override string ProtocolMethodName { get { return "basic.reject"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_requeue = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_requeue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_requeue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class BasicRecover: RabbitMQ.Client.Impl.MethodBase, IBasicRecover {
    public const int ClassId = 60;
    public const int MethodId = 100;

    public bool m_requeue;

    bool IBasicRecover.Requeue { get { return m_requeue; } }

    public BasicRecover() {}
    public BasicRecover(
      bool initRequeue)
    {
      m_requeue = initRequeue;
    }

    public override int ProtocolClassId { get { return 60; } }
    public override int ProtocolMethodId { get { return 100; } }
    public override string ProtocolMethodName { get { return "basic.recover"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_requeue = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteBit(m_requeue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_requeue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileQos: RabbitMQ.Client.Impl.MethodBase, IFileQos {
    public const int ClassId = 70;
    public const int MethodId = 10;

    public uint m_prefetchSize;
    public ushort m_prefetchCount;
    public bool m_global;

    uint IFileQos.PrefetchSize { get { return m_prefetchSize; } }
    ushort IFileQos.PrefetchCount { get { return m_prefetchCount; } }
    bool IFileQos.Global { get { return m_global; } }

    public FileQos() {}
    public FileQos(
      uint initPrefetchSize,
      ushort initPrefetchCount,
      bool initGlobal)
    {
      m_prefetchSize = initPrefetchSize;
      m_prefetchCount = initPrefetchCount;
      m_global = initGlobal;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "file.qos"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_prefetchSize = reader.ReadLong();
      m_prefetchCount = reader.ReadShort();
      m_global = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_prefetchSize);
      writer.WriteShort(m_prefetchCount);
      writer.WriteBit(m_global);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_prefetchSize); sb.Append(",");
      sb.Append(m_prefetchCount); sb.Append(",");
      sb.Append(m_global);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileQosOk: RabbitMQ.Client.Impl.MethodBase, IFileQosOk {
    public const int ClassId = 70;
    public const int MethodId = 11;



    public FileQosOk(
)
    {
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "file.qos-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileConsume: RabbitMQ.Client.Impl.MethodBase, IFileConsume {
    public const int ClassId = 70;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_consumerTag;
    public bool m_noLocal;
    public bool m_noAck;
    public bool m_exclusive;
    public bool m_nowait;
    public System.Collections.IDictionary m_filter;

    ushort IFileConsume.Ticket { get { return m_ticket; } }
    string IFileConsume.Queue { get { return m_queue; } }
    string IFileConsume.ConsumerTag { get { return m_consumerTag; } }
    bool IFileConsume.NoLocal { get { return m_noLocal; } }
    bool IFileConsume.NoAck { get { return m_noAck; } }
    bool IFileConsume.Exclusive { get { return m_exclusive; } }
    bool IFileConsume.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IFileConsume.Filter { get { return m_filter; } }

    public FileConsume() {}
    public FileConsume(
      ushort initTicket,
      string initQueue,
      string initConsumerTag,
      bool initNoLocal,
      bool initNoAck,
      bool initExclusive,
      bool initNowait,
      System.Collections.IDictionary initFilter)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_consumerTag = initConsumerTag;
      m_noLocal = initNoLocal;
      m_noAck = initNoAck;
      m_exclusive = initExclusive;
      m_nowait = initNowait;
      m_filter = initFilter;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "file.consume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_consumerTag = reader.ReadShortstr();
      m_noLocal = reader.ReadBit();
      m_noAck = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_nowait = reader.ReadBit();
      m_filter = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_noLocal);
      writer.WriteBit(m_noAck);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_filter);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_noLocal); sb.Append(",");
      sb.Append(m_noAck); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_filter);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileConsumeOk: RabbitMQ.Client.Impl.MethodBase, IFileConsumeOk {
    public const int ClassId = 70;
    public const int MethodId = 21;

    public string m_consumerTag;

    string IFileConsumeOk.ConsumerTag { get { return m_consumerTag; } }

    public FileConsumeOk() {}
    public FileConsumeOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "file.consume-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileCancel: RabbitMQ.Client.Impl.MethodBase, IFileCancel {
    public const int ClassId = 70;
    public const int MethodId = 30;

    public string m_consumerTag;
    public bool m_nowait;

    string IFileCancel.ConsumerTag { get { return m_consumerTag; } }
    bool IFileCancel.Nowait { get { return m_nowait; } }

    public FileCancel() {}
    public FileCancel(
      string initConsumerTag,
      bool initNowait)
    {
      m_consumerTag = initConsumerTag;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "file.cancel"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileCancelOk: RabbitMQ.Client.Impl.MethodBase, IFileCancelOk {
    public const int ClassId = 70;
    public const int MethodId = 31;

    public string m_consumerTag;

    string IFileCancelOk.ConsumerTag { get { return m_consumerTag; } }

    public FileCancelOk() {}
    public FileCancelOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "file.cancel-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileOpen: RabbitMQ.Client.Impl.MethodBase, IFileOpen {
    public const int ClassId = 70;
    public const int MethodId = 40;

    public string m_identifier;
    public ulong m_contentSize;

    string IFileOpen.Identifier { get { return m_identifier; } }
    ulong IFileOpen.ContentSize { get { return m_contentSize; } }

    public FileOpen() {}
    public FileOpen(
      string initIdentifier,
      ulong initContentSize)
    {
      m_identifier = initIdentifier;
      m_contentSize = initContentSize;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "file.open"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_identifier = reader.ReadShortstr();
      m_contentSize = reader.ReadLonglong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_identifier);
      writer.WriteLonglong(m_contentSize);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_identifier); sb.Append(",");
      sb.Append(m_contentSize);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileOpenOk: RabbitMQ.Client.Impl.MethodBase, IFileOpenOk {
    public const int ClassId = 70;
    public const int MethodId = 41;

    public ulong m_stagedSize;

    ulong IFileOpenOk.StagedSize { get { return m_stagedSize; } }

    public FileOpenOk() {}
    public FileOpenOk(
      ulong initStagedSize)
    {
      m_stagedSize = initStagedSize;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 41; } }
    public override string ProtocolMethodName { get { return "file.open-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_stagedSize = reader.ReadLonglong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_stagedSize);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_stagedSize);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileStage: RabbitMQ.Client.Impl.MethodBase, IFileStage {
    public const int ClassId = 70;
    public const int MethodId = 50;



    public FileStage(
)
    {
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "file.stage"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FilePublish: RabbitMQ.Client.Impl.MethodBase, IFilePublish {
    public const int ClassId = 70;
    public const int MethodId = 60;

    public ushort m_ticket;
    public string m_exchange;
    public string m_routingKey;
    public bool m_mandatory;
    public bool m_immediate;
    public string m_identifier;

    ushort IFilePublish.Ticket { get { return m_ticket; } }
    string IFilePublish.Exchange { get { return m_exchange; } }
    string IFilePublish.RoutingKey { get { return m_routingKey; } }
    bool IFilePublish.Mandatory { get { return m_mandatory; } }
    bool IFilePublish.Immediate { get { return m_immediate; } }
    string IFilePublish.Identifier { get { return m_identifier; } }

    public FilePublish() {}
    public FilePublish(
      ushort initTicket,
      string initExchange,
      string initRoutingKey,
      bool initMandatory,
      bool initImmediate,
      string initIdentifier)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_mandatory = initMandatory;
      m_immediate = initImmediate;
      m_identifier = initIdentifier;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "file.publish"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_mandatory = reader.ReadBit();
      m_immediate = reader.ReadBit();
      m_identifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_mandatory);
      writer.WriteBit(m_immediate);
      writer.WriteShortstr(m_identifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_mandatory); sb.Append(",");
      sb.Append(m_immediate); sb.Append(",");
      sb.Append(m_identifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileReturn: RabbitMQ.Client.Impl.MethodBase, IFileReturn {
    public const int ClassId = 70;
    public const int MethodId = 70;

    public ushort m_replyCode;
    public string m_replyText;
    public string m_exchange;
    public string m_routingKey;

    ushort IFileReturn.ReplyCode { get { return m_replyCode; } }
    string IFileReturn.ReplyText { get { return m_replyText; } }
    string IFileReturn.Exchange { get { return m_exchange; } }
    string IFileReturn.RoutingKey { get { return m_routingKey; } }

    public FileReturn() {}
    public FileReturn(
      ushort initReplyCode,
      string initReplyText,
      string initExchange,
      string initRoutingKey)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 70; } }
    public override string ProtocolMethodName { get { return "file.return"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileDeliver: RabbitMQ.Client.Impl.MethodBase, IFileDeliver {
    public const int ClassId = 70;
    public const int MethodId = 80;

    public string m_consumerTag;
    public ulong m_deliveryTag;
    public bool m_redelivered;
    public string m_exchange;
    public string m_routingKey;
    public string m_identifier;

    string IFileDeliver.ConsumerTag { get { return m_consumerTag; } }
    ulong IFileDeliver.DeliveryTag { get { return m_deliveryTag; } }
    bool IFileDeliver.Redelivered { get { return m_redelivered; } }
    string IFileDeliver.Exchange { get { return m_exchange; } }
    string IFileDeliver.RoutingKey { get { return m_routingKey; } }
    string IFileDeliver.Identifier { get { return m_identifier; } }

    public FileDeliver() {}
    public FileDeliver(
      string initConsumerTag,
      ulong initDeliveryTag,
      bool initRedelivered,
      string initExchange,
      string initRoutingKey,
      string initIdentifier)
    {
      m_consumerTag = initConsumerTag;
      m_deliveryTag = initDeliveryTag;
      m_redelivered = initRedelivered;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_identifier = initIdentifier;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 80; } }
    public override string ProtocolMethodName { get { return "file.deliver"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_deliveryTag = reader.ReadLonglong();
      m_redelivered = reader.ReadBit();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_identifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_redelivered);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteShortstr(m_identifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_redelivered); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_identifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileAck: RabbitMQ.Client.Impl.MethodBase, IFileAck {
    public const int ClassId = 70;
    public const int MethodId = 90;

    public ulong m_deliveryTag;
    public bool m_multiple;

    ulong IFileAck.DeliveryTag { get { return m_deliveryTag; } }
    bool IFileAck.Multiple { get { return m_multiple; } }

    public FileAck() {}
    public FileAck(
      ulong initDeliveryTag,
      bool initMultiple)
    {
      m_deliveryTag = initDeliveryTag;
      m_multiple = initMultiple;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 90; } }
    public override string ProtocolMethodName { get { return "file.ack"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_multiple = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_multiple);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_multiple);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class FileReject: RabbitMQ.Client.Impl.MethodBase, IFileReject {
    public const int ClassId = 70;
    public const int MethodId = 100;

    public ulong m_deliveryTag;
    public bool m_requeue;

    ulong IFileReject.DeliveryTag { get { return m_deliveryTag; } }
    bool IFileReject.Requeue { get { return m_requeue; } }

    public FileReject() {}
    public FileReject(
      ulong initDeliveryTag,
      bool initRequeue)
    {
      m_deliveryTag = initDeliveryTag;
      m_requeue = initRequeue;
    }

    public override int ProtocolClassId { get { return 70; } }
    public override int ProtocolMethodId { get { return 100; } }
    public override string ProtocolMethodName { get { return "file.reject"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_deliveryTag = reader.ReadLonglong();
      m_requeue = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteBit(m_requeue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_requeue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamQos: RabbitMQ.Client.Impl.MethodBase, IStreamQos {
    public const int ClassId = 80;
    public const int MethodId = 10;

    public uint m_prefetchSize;
    public ushort m_prefetchCount;
    public uint m_consumeRate;
    public bool m_global;

    uint IStreamQos.PrefetchSize { get { return m_prefetchSize; } }
    ushort IStreamQos.PrefetchCount { get { return m_prefetchCount; } }
    uint IStreamQos.ConsumeRate { get { return m_consumeRate; } }
    bool IStreamQos.Global { get { return m_global; } }

    public StreamQos() {}
    public StreamQos(
      uint initPrefetchSize,
      ushort initPrefetchCount,
      uint initConsumeRate,
      bool initGlobal)
    {
      m_prefetchSize = initPrefetchSize;
      m_prefetchCount = initPrefetchCount;
      m_consumeRate = initConsumeRate;
      m_global = initGlobal;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "stream.qos"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_prefetchSize = reader.ReadLong();
      m_prefetchCount = reader.ReadShort();
      m_consumeRate = reader.ReadLong();
      m_global = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_prefetchSize);
      writer.WriteShort(m_prefetchCount);
      writer.WriteLong(m_consumeRate);
      writer.WriteBit(m_global);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_prefetchSize); sb.Append(",");
      sb.Append(m_prefetchCount); sb.Append(",");
      sb.Append(m_consumeRate); sb.Append(",");
      sb.Append(m_global);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamQosOk: RabbitMQ.Client.Impl.MethodBase, IStreamQosOk {
    public const int ClassId = 80;
    public const int MethodId = 11;



    public StreamQosOk(
)
    {
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "stream.qos-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamConsume: RabbitMQ.Client.Impl.MethodBase, IStreamConsume {
    public const int ClassId = 80;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_consumerTag;
    public bool m_noLocal;
    public bool m_exclusive;
    public bool m_nowait;
    public System.Collections.IDictionary m_filter;

    ushort IStreamConsume.Ticket { get { return m_ticket; } }
    string IStreamConsume.Queue { get { return m_queue; } }
    string IStreamConsume.ConsumerTag { get { return m_consumerTag; } }
    bool IStreamConsume.NoLocal { get { return m_noLocal; } }
    bool IStreamConsume.Exclusive { get { return m_exclusive; } }
    bool IStreamConsume.Nowait { get { return m_nowait; } }
    System.Collections.IDictionary IStreamConsume.Filter { get { return m_filter; } }

    public StreamConsume() {}
    public StreamConsume(
      ushort initTicket,
      string initQueue,
      string initConsumerTag,
      bool initNoLocal,
      bool initExclusive,
      bool initNowait,
      System.Collections.IDictionary initFilter)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_consumerTag = initConsumerTag;
      m_noLocal = initNoLocal;
      m_exclusive = initExclusive;
      m_nowait = initNowait;
      m_filter = initFilter;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "stream.consume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_consumerTag = reader.ReadShortstr();
      m_noLocal = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_nowait = reader.ReadBit();
      m_filter = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_noLocal);
      writer.WriteBit(m_exclusive);
      writer.WriteBit(m_nowait);
      writer.WriteTable(m_filter);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_noLocal); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_nowait); sb.Append(",");
      sb.Append(m_filter);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamConsumeOk: RabbitMQ.Client.Impl.MethodBase, IStreamConsumeOk {
    public const int ClassId = 80;
    public const int MethodId = 21;

    public string m_consumerTag;

    string IStreamConsumeOk.ConsumerTag { get { return m_consumerTag; } }

    public StreamConsumeOk() {}
    public StreamConsumeOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "stream.consume-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamCancel: RabbitMQ.Client.Impl.MethodBase, IStreamCancel {
    public const int ClassId = 80;
    public const int MethodId = 30;

    public string m_consumerTag;
    public bool m_nowait;

    string IStreamCancel.ConsumerTag { get { return m_consumerTag; } }
    bool IStreamCancel.Nowait { get { return m_nowait; } }

    public StreamCancel() {}
    public StreamCancel(
      string initConsumerTag,
      bool initNowait)
    {
      m_consumerTag = initConsumerTag;
      m_nowait = initNowait;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "stream.cancel"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_nowait = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteBit(m_nowait);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_nowait);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamCancelOk: RabbitMQ.Client.Impl.MethodBase, IStreamCancelOk {
    public const int ClassId = 80;
    public const int MethodId = 31;

    public string m_consumerTag;

    string IStreamCancelOk.ConsumerTag { get { return m_consumerTag; } }

    public StreamCancelOk() {}
    public StreamCancelOk(
      string initConsumerTag)
    {
      m_consumerTag = initConsumerTag;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "stream.cancel-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamPublish: RabbitMQ.Client.Impl.MethodBase, IStreamPublish {
    public const int ClassId = 80;
    public const int MethodId = 40;

    public ushort m_ticket;
    public string m_exchange;
    public string m_routingKey;
    public bool m_mandatory;
    public bool m_immediate;

    ushort IStreamPublish.Ticket { get { return m_ticket; } }
    string IStreamPublish.Exchange { get { return m_exchange; } }
    string IStreamPublish.RoutingKey { get { return m_routingKey; } }
    bool IStreamPublish.Mandatory { get { return m_mandatory; } }
    bool IStreamPublish.Immediate { get { return m_immediate; } }

    public StreamPublish() {}
    public StreamPublish(
      ushort initTicket,
      string initExchange,
      string initRoutingKey,
      bool initMandatory,
      bool initImmediate)
    {
      m_ticket = initTicket;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_mandatory = initMandatory;
      m_immediate = initImmediate;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "stream.publish"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_mandatory = reader.ReadBit();
      m_immediate = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteBit(m_mandatory);
      writer.WriteBit(m_immediate);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_mandatory); sb.Append(",");
      sb.Append(m_immediate);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamReturn: RabbitMQ.Client.Impl.MethodBase, IStreamReturn {
    public const int ClassId = 80;
    public const int MethodId = 50;

    public ushort m_replyCode;
    public string m_replyText;
    public string m_exchange;
    public string m_routingKey;

    ushort IStreamReturn.ReplyCode { get { return m_replyCode; } }
    string IStreamReturn.ReplyText { get { return m_replyText; } }
    string IStreamReturn.Exchange { get { return m_exchange; } }
    string IStreamReturn.RoutingKey { get { return m_routingKey; } }

    public StreamReturn() {}
    public StreamReturn(
      ushort initReplyCode,
      string initReplyText,
      string initExchange,
      string initRoutingKey)
    {
      m_replyCode = initReplyCode;
      m_replyText = initReplyText;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "stream.return"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_replyCode = reader.ReadShort();
      m_replyText = reader.ReadShortstr();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_replyCode);
      writer.WriteShortstr(m_replyText);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_replyCode); sb.Append(",");
      sb.Append(m_replyText); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class StreamDeliver: RabbitMQ.Client.Impl.MethodBase, IStreamDeliver {
    public const int ClassId = 80;
    public const int MethodId = 60;

    public string m_consumerTag;
    public ulong m_deliveryTag;
    public string m_exchange;
    public string m_queue;

    string IStreamDeliver.ConsumerTag { get { return m_consumerTag; } }
    ulong IStreamDeliver.DeliveryTag { get { return m_deliveryTag; } }
    string IStreamDeliver.Exchange { get { return m_exchange; } }
    string IStreamDeliver.Queue { get { return m_queue; } }

    public StreamDeliver() {}
    public StreamDeliver(
      string initConsumerTag,
      ulong initDeliveryTag,
      string initExchange,
      string initQueue)
    {
      m_consumerTag = initConsumerTag;
      m_deliveryTag = initDeliveryTag;
      m_exchange = initExchange;
      m_queue = initQueue;
    }

    public override int ProtocolClassId { get { return 80; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "stream.deliver"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_consumerTag = reader.ReadShortstr();
      m_deliveryTag = reader.ReadLonglong();
      m_exchange = reader.ReadShortstr();
      m_queue = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_consumerTag);
      writer.WriteLonglong(m_deliveryTag);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_queue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_consumerTag); sb.Append(",");
      sb.Append(m_deliveryTag); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_queue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxSelect: RabbitMQ.Client.Impl.MethodBase, ITxSelect {
    public const int ClassId = 90;
    public const int MethodId = 10;



    public TxSelect(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "tx.select"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxSelectOk: RabbitMQ.Client.Impl.MethodBase, ITxSelectOk {
    public const int ClassId = 90;
    public const int MethodId = 11;



    public TxSelectOk(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "tx.select-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxCommit: RabbitMQ.Client.Impl.MethodBase, ITxCommit {
    public const int ClassId = 90;
    public const int MethodId = 20;



    public TxCommit(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "tx.commit"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxCommitOk: RabbitMQ.Client.Impl.MethodBase, ITxCommitOk {
    public const int ClassId = 90;
    public const int MethodId = 21;



    public TxCommitOk(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "tx.commit-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxRollback: RabbitMQ.Client.Impl.MethodBase, ITxRollback {
    public const int ClassId = 90;
    public const int MethodId = 30;



    public TxRollback(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "tx.rollback"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TxRollbackOk: RabbitMQ.Client.Impl.MethodBase, ITxRollbackOk {
    public const int ClassId = 90;
    public const int MethodId = 31;



    public TxRollbackOk(
)
    {
    }

    public override int ProtocolClassId { get { return 90; } }
    public override int ProtocolMethodId { get { return 31; } }
    public override string ProtocolMethodName { get { return "tx.rollback-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxSelect: RabbitMQ.Client.Impl.MethodBase, IDtxSelect {
    public const int ClassId = 100;
    public const int MethodId = 10;



    public DtxSelect(
)
    {
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "dtx.select"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxSelectOk: RabbitMQ.Client.Impl.MethodBase, IDtxSelectOk {
    public const int ClassId = 100;
    public const int MethodId = 11;



    public DtxSelectOk(
)
    {
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 11; } }
    public override string ProtocolMethodName { get { return "dtx.select-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxStart: RabbitMQ.Client.Impl.MethodBase, IDtxStart {
    public const int ClassId = 100;
    public const int MethodId = 20;

    public string m_dtxIdentifier;

    string IDtxStart.DtxIdentifier { get { return m_dtxIdentifier; } }

    public DtxStart() {}
    public DtxStart(
      string initDtxIdentifier)
    {
      m_dtxIdentifier = initDtxIdentifier;
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "dtx.start"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_dtxIdentifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_dtxIdentifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_dtxIdentifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class DtxStartOk: RabbitMQ.Client.Impl.MethodBase, IDtxStartOk {
    public const int ClassId = 100;
    public const int MethodId = 21;



    public DtxStartOk(
)
    {
    }

    public override int ProtocolClassId { get { return 100; } }
    public override int ProtocolMethodId { get { return 21; } }
    public override string ProtocolMethodName { get { return "dtx.start-ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class TunnelRequest: RabbitMQ.Client.Impl.MethodBase, ITunnelRequest {
    public const int ClassId = 110;
    public const int MethodId = 10;

    public System.Collections.IDictionary m_metaData;

    System.Collections.IDictionary ITunnelRequest.MetaData { get { return m_metaData; } }

    public TunnelRequest() {}
    public TunnelRequest(
      System.Collections.IDictionary initMetaData)
    {
      m_metaData = initMetaData;
    }

    public override int ProtocolClassId { get { return 110; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "tunnel.request"; } }
    public override bool HasContent { get { return true; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_metaData = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteTable(m_metaData);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_metaData);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageTransfer: RabbitMQ.Client.Impl.MethodBase, IMessageTransfer {
    public const int ClassId = 120;
    public const int MethodId = 10;

    public ushort m_ticket;
    public string m_destination;
    public bool m_redelivered;
    public bool m_immediate;
    public ulong m_ttl;
    public byte m_priority;
    public AmqpTimestamp m_timestamp;
    public byte m_deliveryMode;
    public AmqpTimestamp m_expiration;
    public string m_exchange;
    public string m_routingKey;
    public string m_messageId;
    public string m_correlationId;
    public string m_replyTo;
    public string m_contentType;
    public string m_contentEncoding;
    public string m_userId;
    public string m_appId;
    public string m_transactionId;
    public byte[] m_securityToken;
    public System.Collections.IDictionary m_applicationHeaders;
    public byte[] m_body;

    ushort IMessageTransfer.Ticket { get { return m_ticket; } }
    string IMessageTransfer.Destination { get { return m_destination; } }
    bool IMessageTransfer.Redelivered { get { return m_redelivered; } }
    bool IMessageTransfer.Immediate { get { return m_immediate; } }
    ulong IMessageTransfer.Ttl { get { return m_ttl; } }
    byte IMessageTransfer.Priority { get { return m_priority; } }
    AmqpTimestamp IMessageTransfer.Timestamp { get { return m_timestamp; } }
    byte IMessageTransfer.DeliveryMode { get { return m_deliveryMode; } }
    AmqpTimestamp IMessageTransfer.Expiration { get { return m_expiration; } }
    string IMessageTransfer.Exchange { get { return m_exchange; } }
    string IMessageTransfer.RoutingKey { get { return m_routingKey; } }
    string IMessageTransfer.MessageId { get { return m_messageId; } }
    string IMessageTransfer.CorrelationId { get { return m_correlationId; } }
    string IMessageTransfer.ReplyTo { get { return m_replyTo; } }
    string IMessageTransfer.ContentType { get { return m_contentType; } }
    string IMessageTransfer.ContentEncoding { get { return m_contentEncoding; } }
    string IMessageTransfer.UserId { get { return m_userId; } }
    string IMessageTransfer.AppId { get { return m_appId; } }
    string IMessageTransfer.TransactionId { get { return m_transactionId; } }
    byte[] IMessageTransfer.SecurityToken { get { return m_securityToken; } }
    System.Collections.IDictionary IMessageTransfer.ApplicationHeaders { get { return m_applicationHeaders; } }
    byte[] IMessageTransfer.Body { get { return m_body; } }

    public MessageTransfer() {}
    public MessageTransfer(
      ushort initTicket,
      string initDestination,
      bool initRedelivered,
      bool initImmediate,
      ulong initTtl,
      byte initPriority,
      AmqpTimestamp initTimestamp,
      byte initDeliveryMode,
      AmqpTimestamp initExpiration,
      string initExchange,
      string initRoutingKey,
      string initMessageId,
      string initCorrelationId,
      string initReplyTo,
      string initContentType,
      string initContentEncoding,
      string initUserId,
      string initAppId,
      string initTransactionId,
      byte[] initSecurityToken,
      System.Collections.IDictionary initApplicationHeaders,
      byte[] initBody)
    {
      m_ticket = initTicket;
      m_destination = initDestination;
      m_redelivered = initRedelivered;
      m_immediate = initImmediate;
      m_ttl = initTtl;
      m_priority = initPriority;
      m_timestamp = initTimestamp;
      m_deliveryMode = initDeliveryMode;
      m_expiration = initExpiration;
      m_exchange = initExchange;
      m_routingKey = initRoutingKey;
      m_messageId = initMessageId;
      m_correlationId = initCorrelationId;
      m_replyTo = initReplyTo;
      m_contentType = initContentType;
      m_contentEncoding = initContentEncoding;
      m_userId = initUserId;
      m_appId = initAppId;
      m_transactionId = initTransactionId;
      m_securityToken = initSecurityToken;
      m_applicationHeaders = initApplicationHeaders;
      m_body = initBody;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 10; } }
    public override string ProtocolMethodName { get { return "message.transfer"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_destination = reader.ReadShortstr();
      m_redelivered = reader.ReadBit();
      m_immediate = reader.ReadBit();
      m_ttl = reader.ReadLonglong();
      m_priority = reader.ReadOctet();
      m_timestamp = reader.ReadTimestamp();
      m_deliveryMode = reader.ReadOctet();
      m_expiration = reader.ReadTimestamp();
      m_exchange = reader.ReadShortstr();
      m_routingKey = reader.ReadShortstr();
      m_messageId = reader.ReadShortstr();
      m_correlationId = reader.ReadShortstr();
      m_replyTo = reader.ReadShortstr();
      m_contentType = reader.ReadShortstr();
      m_contentEncoding = reader.ReadShortstr();
      m_userId = reader.ReadShortstr();
      m_appId = reader.ReadShortstr();
      m_transactionId = reader.ReadShortstr();
      m_securityToken = reader.ReadLongstr();
      m_applicationHeaders = reader.ReadTable();
      m_body = reader.ReadContent();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_destination);
      writer.WriteBit(m_redelivered);
      writer.WriteBit(m_immediate);
      writer.WriteLonglong(m_ttl);
      writer.WriteOctet(m_priority);
      writer.WriteTimestamp(m_timestamp);
      writer.WriteOctet(m_deliveryMode);
      writer.WriteTimestamp(m_expiration);
      writer.WriteShortstr(m_exchange);
      writer.WriteShortstr(m_routingKey);
      writer.WriteShortstr(m_messageId);
      writer.WriteShortstr(m_correlationId);
      writer.WriteShortstr(m_replyTo);
      writer.WriteShortstr(m_contentType);
      writer.WriteShortstr(m_contentEncoding);
      writer.WriteShortstr(m_userId);
      writer.WriteShortstr(m_appId);
      writer.WriteShortstr(m_transactionId);
      writer.WriteLongstr(m_securityToken);
      writer.WriteTable(m_applicationHeaders);
      writer.WriteContent(m_body);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_destination); sb.Append(",");
      sb.Append(m_redelivered); sb.Append(",");
      sb.Append(m_immediate); sb.Append(",");
      sb.Append(m_ttl); sb.Append(",");
      sb.Append(m_priority); sb.Append(",");
      sb.Append(m_timestamp); sb.Append(",");
      sb.Append(m_deliveryMode); sb.Append(",");
      sb.Append(m_expiration); sb.Append(",");
      sb.Append(m_exchange); sb.Append(",");
      sb.Append(m_routingKey); sb.Append(",");
      sb.Append(m_messageId); sb.Append(",");
      sb.Append(m_correlationId); sb.Append(",");
      sb.Append(m_replyTo); sb.Append(",");
      sb.Append(m_contentType); sb.Append(",");
      sb.Append(m_contentEncoding); sb.Append(",");
      sb.Append(m_userId); sb.Append(",");
      sb.Append(m_appId); sb.Append(",");
      sb.Append(m_transactionId); sb.Append(",");
      sb.Append(m_securityToken); sb.Append(",");
      sb.Append(m_applicationHeaders); sb.Append(",");
      sb.Append(m_body);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageConsume: RabbitMQ.Client.Impl.MethodBase, IMessageConsume {
    public const int ClassId = 120;
    public const int MethodId = 20;

    public ushort m_ticket;
    public string m_queue;
    public string m_destination;
    public bool m_noLocal;
    public bool m_noAck;
    public bool m_exclusive;
    public System.Collections.IDictionary m_filter;

    ushort IMessageConsume.Ticket { get { return m_ticket; } }
    string IMessageConsume.Queue { get { return m_queue; } }
    string IMessageConsume.Destination { get { return m_destination; } }
    bool IMessageConsume.NoLocal { get { return m_noLocal; } }
    bool IMessageConsume.NoAck { get { return m_noAck; } }
    bool IMessageConsume.Exclusive { get { return m_exclusive; } }
    System.Collections.IDictionary IMessageConsume.Filter { get { return m_filter; } }

    public MessageConsume() {}
    public MessageConsume(
      ushort initTicket,
      string initQueue,
      string initDestination,
      bool initNoLocal,
      bool initNoAck,
      bool initExclusive,
      System.Collections.IDictionary initFilter)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_destination = initDestination;
      m_noLocal = initNoLocal;
      m_noAck = initNoAck;
      m_exclusive = initExclusive;
      m_filter = initFilter;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 20; } }
    public override string ProtocolMethodName { get { return "message.consume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_destination = reader.ReadShortstr();
      m_noLocal = reader.ReadBit();
      m_noAck = reader.ReadBit();
      m_exclusive = reader.ReadBit();
      m_filter = reader.ReadTable();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_destination);
      writer.WriteBit(m_noLocal);
      writer.WriteBit(m_noAck);
      writer.WriteBit(m_exclusive);
      writer.WriteTable(m_filter);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_destination); sb.Append(",");
      sb.Append(m_noLocal); sb.Append(",");
      sb.Append(m_noAck); sb.Append(",");
      sb.Append(m_exclusive); sb.Append(",");
      sb.Append(m_filter);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageCancel: RabbitMQ.Client.Impl.MethodBase, IMessageCancel {
    public const int ClassId = 120;
    public const int MethodId = 30;

    public string m_destination;

    string IMessageCancel.Destination { get { return m_destination; } }

    public MessageCancel() {}
    public MessageCancel(
      string initDestination)
    {
      m_destination = initDestination;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 30; } }
    public override string ProtocolMethodName { get { return "message.cancel"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_destination = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShortstr(m_destination);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_destination);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageGet: RabbitMQ.Client.Impl.MethodBase, IMessageGet {
    public const int ClassId = 120;
    public const int MethodId = 40;

    public ushort m_ticket;
    public string m_queue;
    public string m_destination;
    public bool m_noAck;

    ushort IMessageGet.Ticket { get { return m_ticket; } }
    string IMessageGet.Queue { get { return m_queue; } }
    string IMessageGet.Destination { get { return m_destination; } }
    bool IMessageGet.NoAck { get { return m_noAck; } }

    public MessageGet() {}
    public MessageGet(
      ushort initTicket,
      string initQueue,
      string initDestination,
      bool initNoAck)
    {
      m_ticket = initTicket;
      m_queue = initQueue;
      m_destination = initDestination;
      m_noAck = initNoAck;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 40; } }
    public override string ProtocolMethodName { get { return "message.get"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_ticket = reader.ReadShort();
      m_queue = reader.ReadShortstr();
      m_destination = reader.ReadShortstr();
      m_noAck = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_ticket);
      writer.WriteShortstr(m_queue);
      writer.WriteShortstr(m_destination);
      writer.WriteBit(m_noAck);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_ticket); sb.Append(",");
      sb.Append(m_queue); sb.Append(",");
      sb.Append(m_destination); sb.Append(",");
      sb.Append(m_noAck);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageRecover: RabbitMQ.Client.Impl.MethodBase, IMessageRecover {
    public const int ClassId = 120;
    public const int MethodId = 50;

    public bool m_requeue;

    bool IMessageRecover.Requeue { get { return m_requeue; } }

    public MessageRecover() {}
    public MessageRecover(
      bool initRequeue)
    {
      m_requeue = initRequeue;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 50; } }
    public override string ProtocolMethodName { get { return "message.recover"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_requeue = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteBit(m_requeue);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_requeue);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageOpen: RabbitMQ.Client.Impl.MethodBase, IMessageOpen {
    public const int ClassId = 120;
    public const int MethodId = 60;

    public byte[] m_reference;

    byte[] IMessageOpen.Reference { get { return m_reference; } }

    public MessageOpen() {}
    public MessageOpen(
      byte[] initReference)
    {
      m_reference = initReference;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 60; } }
    public override string ProtocolMethodName { get { return "message.open"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_reference = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_reference);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_reference);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageClose: RabbitMQ.Client.Impl.MethodBase, IMessageClose {
    public const int ClassId = 120;
    public const int MethodId = 70;

    public byte[] m_reference;

    byte[] IMessageClose.Reference { get { return m_reference; } }

    public MessageClose() {}
    public MessageClose(
      byte[] initReference)
    {
      m_reference = initReference;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 70; } }
    public override string ProtocolMethodName { get { return "message.close"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_reference = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_reference);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_reference);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageAppend: RabbitMQ.Client.Impl.MethodBase, IMessageAppend {
    public const int ClassId = 120;
    public const int MethodId = 80;

    public byte[] m_reference;
    public byte[] m_bytes;

    byte[] IMessageAppend.Reference { get { return m_reference; } }
    byte[] IMessageAppend.Bytes { get { return m_bytes; } }

    public MessageAppend() {}
    public MessageAppend(
      byte[] initReference,
      byte[] initBytes)
    {
      m_reference = initReference;
      m_bytes = initBytes;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 80; } }
    public override string ProtocolMethodName { get { return "message.append"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_reference = reader.ReadLongstr();
      m_bytes = reader.ReadLongstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_reference);
      writer.WriteLongstr(m_bytes);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_reference); sb.Append(",");
      sb.Append(m_bytes);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageCheckpoint: RabbitMQ.Client.Impl.MethodBase, IMessageCheckpoint {
    public const int ClassId = 120;
    public const int MethodId = 90;

    public byte[] m_reference;
    public string m_identifier;

    byte[] IMessageCheckpoint.Reference { get { return m_reference; } }
    string IMessageCheckpoint.Identifier { get { return m_identifier; } }

    public MessageCheckpoint() {}
    public MessageCheckpoint(
      byte[] initReference,
      string initIdentifier)
    {
      m_reference = initReference;
      m_identifier = initIdentifier;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 90; } }
    public override string ProtocolMethodName { get { return "message.checkpoint"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_reference = reader.ReadLongstr();
      m_identifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_reference);
      writer.WriteShortstr(m_identifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_reference); sb.Append(",");
      sb.Append(m_identifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageResume: RabbitMQ.Client.Impl.MethodBase, IMessageResume {
    public const int ClassId = 120;
    public const int MethodId = 100;

    public byte[] m_reference;
    public string m_identifier;

    byte[] IMessageResume.Reference { get { return m_reference; } }
    string IMessageResume.Identifier { get { return m_identifier; } }

    public MessageResume() {}
    public MessageResume(
      byte[] initReference,
      string initIdentifier)
    {
      m_reference = initReference;
      m_identifier = initIdentifier;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 100; } }
    public override string ProtocolMethodName { get { return "message.resume"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_reference = reader.ReadLongstr();
      m_identifier = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLongstr(m_reference);
      writer.WriteShortstr(m_identifier);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_reference); sb.Append(",");
      sb.Append(m_identifier);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageQos: RabbitMQ.Client.Impl.MethodBase, IMessageQos {
    public const int ClassId = 120;
    public const int MethodId = 110;

    public uint m_prefetchSize;
    public ushort m_prefetchCount;
    public bool m_global;

    uint IMessageQos.PrefetchSize { get { return m_prefetchSize; } }
    ushort IMessageQos.PrefetchCount { get { return m_prefetchCount; } }
    bool IMessageQos.Global { get { return m_global; } }

    public MessageQos() {}
    public MessageQos(
      uint initPrefetchSize,
      ushort initPrefetchCount,
      bool initGlobal)
    {
      m_prefetchSize = initPrefetchSize;
      m_prefetchCount = initPrefetchCount;
      m_global = initGlobal;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 110; } }
    public override string ProtocolMethodName { get { return "message.qos"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_prefetchSize = reader.ReadLong();
      m_prefetchCount = reader.ReadShort();
      m_global = reader.ReadBit();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLong(m_prefetchSize);
      writer.WriteShort(m_prefetchCount);
      writer.WriteBit(m_global);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_prefetchSize); sb.Append(",");
      sb.Append(m_prefetchCount); sb.Append(",");
      sb.Append(m_global);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageOk: RabbitMQ.Client.Impl.MethodBase, IMessageOk {
    public const int ClassId = 120;
    public const int MethodId = 500;



    public MessageOk(
)
    {
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 500; } }
    public override string ProtocolMethodName { get { return "message.ok"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageEmpty: RabbitMQ.Client.Impl.MethodBase, IMessageEmpty {
    public const int ClassId = 120;
    public const int MethodId = 510;



    public MessageEmpty(
)
    {
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 510; } }
    public override string ProtocolMethodName { get { return "message.empty"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageReject: RabbitMQ.Client.Impl.MethodBase, IMessageReject {
    public const int ClassId = 120;
    public const int MethodId = 520;

    public ushort m_code;
    public string m_text;

    ushort IMessageReject.Code { get { return m_code; } }
    string IMessageReject.Text { get { return m_text; } }

    public MessageReject() {}
    public MessageReject(
      ushort initCode,
      string initText)
    {
      m_code = initCode;
      m_text = initText;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 520; } }
    public override string ProtocolMethodName { get { return "message.reject"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_code = reader.ReadShort();
      m_text = reader.ReadShortstr();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteShort(m_code);
      writer.WriteShortstr(m_text);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_code); sb.Append(",");
      sb.Append(m_text);
      sb.Append(")");
    }
  }
  /// <summary>Autogenerated type. Private implementation class - do not use directly.</summary>
  public class MessageOffset: RabbitMQ.Client.Impl.MethodBase, IMessageOffset {
    public const int ClassId = 120;
    public const int MethodId = 530;

    public ulong m_value;

    ulong IMessageOffset.Value { get { return m_value; } }

    public MessageOffset() {}
    public MessageOffset(
      ulong initValue)
    {
      m_value = initValue;
    }

    public override int ProtocolClassId { get { return 120; } }
    public override int ProtocolMethodId { get { return 530; } }
    public override string ProtocolMethodName { get { return "message.offset"; } }
    public override bool HasContent { get { return false; } }

    public override void ReadArgumentsFrom(RabbitMQ.Client.Impl.MethodArgumentReader reader) {
      m_value = reader.ReadLonglong();
    }

    public override void WriteArgumentsTo(RabbitMQ.Client.Impl.MethodArgumentWriter writer) {
      writer.WriteLonglong(m_value);
    }

    public override void AppendArgumentDebugStringTo(System.Text.StringBuilder sb) {
      sb.Append("(");
      sb.Append(m_value);
      sb.Append(")");
    }
  }

  public class Model: RabbitMQ.Client.Impl.ModelBase {
    public Model(RabbitMQ.Client.Impl.ISession session): base(session) {}
    public override void _Private_BasicPublish(
      System.String @exchange,
      System.String @routingKey,
      System.Boolean @mandatory,
      System.Boolean @immediate,
      RabbitMQ.Client.IBasicProperties @basicProperties,
      System.Byte[] @body)
    {
      BasicPublish __req = new BasicPublish();
      __req.m_exchange = @exchange;
      __req.m_routingKey = @routingKey;
      __req.m_mandatory = @mandatory;
      __req.m_immediate = @immediate;
      ModelSend(__req, (BasicProperties) basicProperties,body);
    }
    public override void _Private_BasicConsume(
      System.String @queue,
      System.String @consumerTag,
      System.Boolean @noLocal,
      System.Boolean @noAck,
      System.Boolean @exclusive,
      System.Boolean @nowait,
      System.Collections.IDictionary @filter)
    {
      BasicConsume __req = new BasicConsume();
      __req.m_queue = @queue;
      __req.m_consumerTag = @consumerTag;
      __req.m_noLocal = @noLocal;
      __req.m_noAck = @noAck;
      __req.m_exclusive = @exclusive;
      __req.m_nowait = @nowait;
      __req.m_filter = @filter;
      ModelSend(__req,null,null);
    }
    public override void _Private_BasicCancel(
      System.String @consumerTag,
      System.Boolean @nowait)
    {
      BasicCancel __req = new BasicCancel();
      __req.m_consumerTag = @consumerTag;
      __req.m_nowait = @nowait;
      ModelSend(__req,null,null);
    }
    public override void _Private_ChannelOpen(
      System.String @outOfBand)
    {
      ChannelOpen __req = new ChannelOpen();
      __req.m_outOfBand = @outOfBand;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ChannelOpenOk __rep = __repBase as ChannelOpenOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void _Private_ChannelCloseOk()
    {
      ChannelCloseOk __req = new ChannelCloseOk();
      ModelSend(__req,null,null);
    }
    public override void _Private_ChannelClose(
      System.UInt16 @replyCode,
      System.String @replyText,
      System.UInt16 @classId,
      System.UInt16 @methodId)
    {
      ChannelClose __req = new ChannelClose();
      __req.m_replyCode = @replyCode;
      __req.m_replyText = @replyText;
      __req.m_classId = @classId;
      __req.m_methodId = @methodId;
      ModelSend(__req,null,null);
    }
    public override void _Private_BasicGet(
      System.String @queue,
      System.Boolean @noAck)
    {
      BasicGet __req = new BasicGet();
      __req.m_queue = @queue;
      __req.m_noAck = @noAck;
      ModelSend(__req,null,null);
    }
    public override void _Private_ChannelFlowOk()
    {
      ChannelFlowOk __req = new ChannelFlowOk();
      ModelSend(__req,null,null);
    }
    public override RabbitMQ.Client.Impl.ConnectionTuneDetails ConnectionStartOk(
      System.Collections.IDictionary @clientProperties,
      System.String @mechanism,
      System.Byte[] @response,
      System.String @locale)
    {
      ConnectionStartOk __req = new ConnectionStartOk();
      __req.m_clientProperties = @clientProperties;
      __req.m_mechanism = @mechanism;
      __req.m_response = @response;
      __req.m_locale = @locale;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ConnectionTune __rep = __repBase as ConnectionTune;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      RabbitMQ.Client.Impl.ConnectionTuneDetails __result = new RabbitMQ.Client.Impl.ConnectionTuneDetails();
      __result.m_channelMax = __rep.m_channelMax;
      __result.m_frameMax = __rep.m_frameMax;
      __result.m_heartbeat = __rep.m_heartbeat;
      return __result;
    }
    public override void ConnectionTuneOk(
      System.UInt16 @channelMax,
      System.UInt32 @frameMax,
      System.UInt16 @heartbeat)
    {
      ConnectionTuneOk __req = new ConnectionTuneOk();
      __req.m_channelMax = @channelMax;
      __req.m_frameMax = @frameMax;
      __req.m_heartbeat = @heartbeat;
      ModelSend(__req,null,null);
    }
    public override void _Private_ConnectionOpen(
      System.String @virtualHost,
      System.String @capabilities,
      System.Boolean @insist)
    {
      ConnectionOpen __req = new ConnectionOpen();
      __req.m_virtualHost = @virtualHost;
      __req.m_capabilities = @capabilities;
      __req.m_insist = @insist;
      ModelSend(__req,null,null);
    }
    public override void _Private_ConnectionClose(
      System.UInt16 @replyCode,
      System.String @replyText,
      System.UInt16 @classId,
      System.UInt16 @methodId)
    {
      ConnectionClose __req = new ConnectionClose();
      __req.m_replyCode = @replyCode;
      __req.m_replyText = @replyText;
      __req.m_classId = @classId;
      __req.m_methodId = @methodId;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ConnectionCloseOk __rep = __repBase as ConnectionCloseOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void _Private_ConnectionCloseOk()
    {
      ConnectionCloseOk __req = new ConnectionCloseOk();
      ModelSend(__req,null,null);
    }
    public override RabbitMQ.Client.IBasicProperties CreateBasicProperties()
    {
      return new BasicProperties();
    }
    public override RabbitMQ.Client.IFileProperties CreateFileProperties()
    {
      return new FileProperties();
    }
    public override RabbitMQ.Client.IStreamProperties CreateStreamProperties()
    {
      return new StreamProperties();
    }
    public override void ChannelFlow(
      System.Boolean @active)
    {
      ChannelFlow __req = new ChannelFlow();
      __req.m_active = @active;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ChannelFlowOk __rep = __repBase as ChannelFlowOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void ExchangeDeclare(
      System.String @exchange,
      System.String @type,
      System.Boolean @passive,
      System.Boolean @durable,
      System.Boolean @autoDelete,
      System.Boolean @internal,
      System.Boolean @nowait,
      System.Collections.IDictionary @arguments)
    {
      ExchangeDeclare __req = new ExchangeDeclare();
      __req.m_exchange = @exchange;
      __req.m_type = @type;
      __req.m_passive = @passive;
      __req.m_durable = @durable;
      __req.m_autoDelete = @autoDelete;
      __req.m_internal = @internal;
      __req.m_nowait = @nowait;
      __req.m_arguments = @arguments;
      if (nowait) {
        ModelSend(__req,null,null);
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ExchangeDeclareOk __rep = __repBase as ExchangeDeclareOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void ExchangeDelete(
      System.String @exchange,
      System.Boolean @ifUnused,
      System.Boolean @nowait)
    {
      ExchangeDelete __req = new ExchangeDelete();
      __req.m_exchange = @exchange;
      __req.m_ifUnused = @ifUnused;
      __req.m_nowait = @nowait;
      if (nowait) {
        ModelSend(__req,null,null);
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      ExchangeDeleteOk __rep = __repBase as ExchangeDeleteOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override System.String QueueDeclare(
      System.String @queue,
      System.Boolean @passive,
      System.Boolean @durable,
      System.Boolean @exclusive,
      System.Boolean @autoDelete,
      System.Boolean @nowait,
      System.Collections.IDictionary @arguments)
    {
      QueueDeclare __req = new QueueDeclare();
      __req.m_queue = @queue;
      __req.m_passive = @passive;
      __req.m_durable = @durable;
      __req.m_exclusive = @exclusive;
      __req.m_autoDelete = @autoDelete;
      __req.m_nowait = @nowait;
      __req.m_arguments = @arguments;
      if (nowait) {
        ModelSend(__req,null,null);
        return null;
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueueDeclareOk __rep = __repBase as QueueDeclareOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      return __rep.m_queue;
    }
    public override void QueueBind(
      System.String @queue,
      System.String @exchange,
      System.String @routingKey,
      System.Boolean @nowait,
      System.Collections.IDictionary @arguments)
    {
      QueueBind __req = new QueueBind();
      __req.m_queue = @queue;
      __req.m_exchange = @exchange;
      __req.m_routingKey = @routingKey;
      __req.m_nowait = @nowait;
      __req.m_arguments = @arguments;
      if (nowait) {
        ModelSend(__req,null,null);
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueueBindOk __rep = __repBase as QueueBindOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void QueueUnbind(
      System.String @queue,
      System.String @exchange,
      System.String @routingKey,
      System.Collections.IDictionary @arguments)
    {
      QueueUnbind __req = new QueueUnbind();
      __req.m_queue = @queue;
      __req.m_exchange = @exchange;
      __req.m_routingKey = @routingKey;
      __req.m_arguments = @arguments;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueueUnbindOk __rep = __repBase as QueueUnbindOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override System.UInt32 QueuePurge(
      System.String @queue,
      System.Boolean @nowait)
    {
      QueuePurge __req = new QueuePurge();
      __req.m_queue = @queue;
      __req.m_nowait = @nowait;
      if (nowait) {
        ModelSend(__req,null,null);
        return 0xFFFFFFFF;
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueuePurgeOk __rep = __repBase as QueuePurgeOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      return __rep.m_messageCount;
    }
    public override System.UInt32 QueueDelete(
      System.String @queue,
      System.Boolean @ifUnused,
      System.Boolean @ifEmpty,
      System.Boolean @nowait)
    {
      QueueDelete __req = new QueueDelete();
      __req.m_queue = @queue;
      __req.m_ifUnused = @ifUnused;
      __req.m_ifEmpty = @ifEmpty;
      __req.m_nowait = @nowait;
      if (nowait) {
        ModelSend(__req,null,null);
        return 0xFFFFFFFF;
      }
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      QueueDeleteOk __rep = __repBase as QueueDeleteOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
      return __rep.m_messageCount;
    }
    public override void BasicQos(
      System.UInt32 @prefetchSize,
      System.UInt16 @prefetchCount,
      System.Boolean @global)
    {
      BasicQos __req = new BasicQos();
      __req.m_prefetchSize = @prefetchSize;
      __req.m_prefetchCount = @prefetchCount;
      __req.m_global = @global;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      BasicQosOk __rep = __repBase as BasicQosOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void BasicAck(
      System.UInt64 @deliveryTag,
      System.Boolean @multiple)
    {
      BasicAck __req = new BasicAck();
      __req.m_deliveryTag = @deliveryTag;
      __req.m_multiple = @multiple;
      ModelSend(__req,null,null);
    }
    public override void BasicReject(
      System.UInt64 @deliveryTag,
      System.Boolean @requeue)
    {
      BasicReject __req = new BasicReject();
      __req.m_deliveryTag = @deliveryTag;
      __req.m_requeue = @requeue;
      ModelSend(__req,null,null);
    }
    public override void BasicRecover(
      System.Boolean @requeue)
    {
      BasicRecover __req = new BasicRecover();
      __req.m_requeue = @requeue;
      ModelSend(__req,null,null);
    }
    public override void TxSelect()
    {
      TxSelect __req = new TxSelect();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      TxSelectOk __rep = __repBase as TxSelectOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void TxCommit()
    {
      TxCommit __req = new TxCommit();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      TxCommitOk __rep = __repBase as TxCommitOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void TxRollback()
    {
      TxRollback __req = new TxRollback();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      TxRollbackOk __rep = __repBase as TxRollbackOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void DtxSelect()
    {
      DtxSelect __req = new DtxSelect();
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      DtxSelectOk __rep = __repBase as DtxSelectOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override void DtxStart(
      System.String @dtxIdentifier)
    {
      DtxStart __req = new DtxStart();
      __req.m_dtxIdentifier = @dtxIdentifier;
      RabbitMQ.Client.Impl.MethodBase __repBase = ModelRpc(__req,null,null);
      DtxStartOk __rep = __repBase as DtxStartOk;
      if (__rep == null) throw new UnexpectedMethodException(__repBase);
    }
    public override bool DispatchAsynchronous(RabbitMQ.Client.Impl.Command cmd) {
      RabbitMQ.Client.Impl.MethodBase __method = (RabbitMQ.Client.Impl.MethodBase) cmd.Method;
      switch ((__method.ProtocolClassId << 16) | __method.ProtocolMethodId) {
        case 3932181: {
          BasicConsumeOk __impl = (BasicConsumeOk) __method;
          HandleBasicConsumeOk(
            __impl.m_consumerTag);
          return true;
        }
        case 3932191: {
          BasicCancelOk __impl = (BasicCancelOk) __method;
          HandleBasicCancelOk(
            __impl.m_consumerTag);
          return true;
        }
        case 3932231: {
          BasicGetOk __impl = (BasicGetOk) __method;
          HandleBasicGetOk(
            __impl.m_deliveryTag,
            __impl.m_redelivered,
            __impl.m_exchange,
            __impl.m_routingKey,
            __impl.m_messageCount,
            (RabbitMQ.Client.IBasicProperties) cmd.Header,
            cmd.Body);
          return true;
        }
        case 3932232: {
          HandleBasicGetEmpty();
          return true;
        }
        case 3932220: {
          BasicDeliver __impl = (BasicDeliver) __method;
          HandleBasicDeliver(
            __impl.m_consumerTag,
            __impl.m_deliveryTag,
            __impl.m_redelivered,
            __impl.m_exchange,
            __impl.m_routingKey,
            (RabbitMQ.Client.IBasicProperties) cmd.Header,
            cmd.Body);
          return true;
        }
        case 3932210: {
          BasicReturn __impl = (BasicReturn) __method;
          HandleBasicReturn(
            __impl.m_replyCode,
            __impl.m_replyText,
            __impl.m_exchange,
            __impl.m_routingKey,
            (RabbitMQ.Client.IBasicProperties) cmd.Header,
            cmd.Body);
          return true;
        }
        case 1310740: {
          ChannelFlow __impl = (ChannelFlow) __method;
          HandleChannelFlow(
            __impl.m_active);
          return true;
        }
        case 1310760: {
          ChannelClose __impl = (ChannelClose) __method;
          HandleChannelClose(
            __impl.m_replyCode,
            __impl.m_replyText,
            __impl.m_classId,
            __impl.m_methodId);
          return true;
        }
        case 1310761: {
          HandleChannelCloseOk();
          return true;
        }
        case 655370: {
          ConnectionStart __impl = (ConnectionStart) __method;
          HandleConnectionStart(
            __impl.m_versionMajor,
            __impl.m_versionMinor,
            __impl.m_serverProperties,
            __impl.m_mechanisms,
            __impl.m_locales);
          return true;
        }
        case 655401: {
          ConnectionOpenOk __impl = (ConnectionOpenOk) __method;
          HandleConnectionOpenOk(
            __impl.m_knownHosts);
          return true;
        }
        case 655402: {
          ConnectionRedirect __impl = (ConnectionRedirect) __method;
          HandleConnectionRedirect(
            __impl.m_host,
            __impl.m_knownHosts);
          return true;
        }
        case 655410: {
          ConnectionClose __impl = (ConnectionClose) __method;
          HandleConnectionClose(
            __impl.m_replyCode,
            __impl.m_replyText,
            __impl.m_classId,
            __impl.m_methodId);
          return true;
        }
        default: return false;
      }
    }
  }
}
