/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;

/**
 * This class is for unit testing HttpClient and HttpServer.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class MessageHeaderTest
	extends junit.framework.TestCase
{
	public MessageHeaderTest(String name) {
		super(name);
	}

	public void testParam()
		throws IOException
	{
		try {
			MessageHeader.parse(null);
			fail("null input");
		} catch (IllegalArgumentException e) {
		}
		try {
			new MessageHeader(null, "bob");
			fail("null input");
		} catch (IllegalArgumentException e) {
		}
		try {
			new MessageHeader("bob", null);
			fail("null input");
		} catch (IllegalArgumentException e) {
		}
		try {
			MessageHeader.parse("franky");
			fail("no colon");
		} catch (HttpException e) {
		}
		try {
			MessageHeader.parse("???:!!!");
			fail("bad token: field name");
		} catch (HttpException e) {
		}
	}

	public void testHeadersIn()
		throws IOException
	{
		String resp = 
			"Content-Length:0" + HttpUtil.CRLF + 
			"Bob-Length: XYZ    " + HttpUtil.CRLF + 
			HttpUtil.CRLF;
		ByteArrayInputStream testin = new ByteArrayInputStream(resp.getBytes());
		MessageHeaders headers = MessageHeaders.readHeaders(testin);
		assertEquals("Two header", 2, headers.count());
		assertEquals("0 in content-length", "0", headers.getFieldContent("content-length"));
		assertEquals("XYZ in Bob", "XYZ", headers.getFieldContent("bob-length"));
		MessageHeader bob = new MessageHeader("BoB-LENgth", "XYZ");
		MessageHeader bob2 = (MessageHeader) headers.asList().get(1);
		assertEquals("BOB mixed case", headers.asList().get(1), bob);
		assertEquals("BOB hash", bob2.hashCode(), bob.hashCode());
		assertEquals("BOB string", bob2.toString(), bob.toString());
		assertEquals("BOB same", bob, bob);
		assertTrue("BOB string", !bob.equals("XYZ"));
		
		MessageHeader.parse("foo:");
	}

	public void testHeadersCont() throws IOException {
		String resp = 
			"Foo:" + HttpUtil.CRLF + 
			"\tbar" + HttpUtil.CRLF + 
			" baz" + HttpUtil.CRLF +
			HttpUtil.CRLF;
		ByteArrayInputStream testin = new ByteArrayInputStream(resp.getBytes());
		MessageHeaders headers = MessageHeaders.readHeaders(testin);
		assertEquals(1, headers.count());
		assertEquals("bar baz", headers.getFieldContent("foo"));
		
		resp = 
			" bad header:" + HttpUtil.CRLF + 
			HttpUtil.CRLF;
		try {
    		testin = new ByteArrayInputStream(resp.getBytes());
			MessageHeaders.readHeaders(testin);
			fail("bad header");
		} catch (IOException e) {
		}
		
		resp = 
			"header:" + HttpUtil.CRLF + 
			"cont:a" + HttpUtil.CRLF + 
			" b" + HttpUtil.CRLF + 
			"cont2:z" + HttpUtil.CRLF + 
			HttpUtil.CRLF;
		testin = new ByteArrayInputStream(resp.getBytes());
		headers = MessageHeaders.readHeaders(testin);
		assertEquals("a b", headers.getFieldContent("cont"));
		assertEquals("z", headers.getFieldContent("cont2"));
	}
}
