/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _VECTOR_EDITOR_P_H_
#define _VECTOR_EDITOR_P_H_

#include <QWidget>

class Ui_VectorEditor;

class VectorEditor : public QWidget
{
  Q_OBJECT
  public:
    VectorEditor(QWidget* parent, int number);
    ~VectorEditor();
  public slots:
    void setMinimum( const QList<double>& val);
    void setMaximum( const QList<double>& val);
    void setValues( const QList<double>& val);
  signals:
    void valuesChanged( const QList<double>& val);
  private slots:
    void spinBoxChanged();
  private:
    Ui_VectorEditor* m_vectorEditor;
    int m_number;
};

#endif
