/*
 * JTypeSafeTester.java - Test application for classes in typesafe package.
 *
 * Copyright (c) 2004-2011 Gregory Kotsaftis
 * gregkotsaftis@yahoo.com
 * http://zeus-jscl.sourceforge.net/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package gr.zeus.tests;

import gr.zeus.ui.typesafe.SwingConfigurationManager;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class JTypeSafeTester extends JFrame {


    public JTypeSafeTester()
    {
        initComponents();

        // the focus sequence depends on the placement
        // of the components in the array
        Component[] focusable_components = {tf_firstname, tf_balance,
                ftf_birthdate, tf_age, ta_info1, tp_info2, ep_info3, jButton1
                /*, tf_noFocus*/};

        try
        {
            //SwingConfigurationManager mng = new SwingConfigurationManager(
            //    ResourceBundle.getBundle("gr.zeus.tests.mygui"));

            SwingConfigurationManager mng = new SwingConfigurationManager(
                "mygui.properties");

            mng.configComponent("name_field", tf_firstname);
            mng.configComponent("date_field", ftf_birthdate);
            mng.configComponent("age_field", tf_age);
            mng.configComponent("real_number", tf_balance);
            mng.configComponent("general_text", ta_info1, tp_info2, ep_info3);

            mng.applyFocus(this, focusable_components);
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents()
    {

        javax.swing.JLabel infoLabel = new javax.swing.JLabel();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        tf_firstname = new javax.swing.JTextField();
        javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
        tf_age = new javax.swing.JTextField();
        javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
        ftf_birthdate = new javax.swing.JFormattedTextField();
        javax.swing.JLabel jLabel4 = new javax.swing.JLabel();
        tf_balance = new javax.swing.JTextField();
        javax.swing.JLabel jLabel5 = new javax.swing.JLabel();
        tf_noFocus = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        javax.swing.JPanel jPanel1 = new javax.swing.JPanel();
        ta_info1 = new javax.swing.JTextArea();
        tp_info2 = new javax.swing.JTextPane();
        ep_info3 = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().setLayout(null);

        infoLabel.setForeground(new java.awt.Color(204, 0, 51));
        infoLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLabel.setText("Modify mygui.properties and restart application to test the functionality");
        getContentPane().add(infoLabel);
        infoLabel.setBounds(10, 10, 490, 14);

        jLabel1.setText("Name");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(10, 40, 50, 20);

        tf_firstname.setToolTipText("This is a JTextField, use TAB and SHIFT+TAB for focus traversal.");
        getContentPane().add(tf_firstname);
        tf_firstname.setBounds(60, 40, 320, 20);

        jLabel2.setText("Age");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(10, 70, 50, 20);

        tf_age.setToolTipText("This is a JTextField, use TAB and SHIFT+TAB for focus traversal.");
        getContentPane().add(tf_age);
        tf_age.setBounds(60, 70, 70, 20);

        jLabel3.setText("Birthdate");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(190, 70, 60, 20);

        ftf_birthdate.setToolTipText("This is a JFormattedTextField, use TAB and SHIFT+TAB for focus traversal.");
        getContentPane().add(ftf_birthdate);
        ftf_birthdate.setBounds(250, 70, 130, 21);

        jLabel4.setText("Balance");
        getContentPane().add(jLabel4);
        jLabel4.setBounds(10, 100, 50, 20);

        tf_balance.setToolTipText("This is a JTextField, use TAB and SHIFT+TAB for focus traversal.");
        getContentPane().add(tf_balance);
        tf_balance.setBounds(60, 100, 70, 20);

        jLabel5.setText("No Focus");
        getContentPane().add(jLabel5);
        jLabel5.setBounds(190, 100, 60, 20);

        tf_noFocus.setToolTipText("no focus for me...");
        getContentPane().add(tf_noFocus);
        tf_noFocus.setBounds(250, 100, 130, 20);

        jButton1.setText("Hi");
        getContentPane().add(jButton1);
        jButton1.setBounds(390, 40, 110, 80);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("This is another JPanel"));
        jPanel1.setLayout(null);

        ta_info1.setBackground(new java.awt.Color(255, 255, 204));
        ta_info1.setLineWrap(true);
        ta_info1.setText("This is a JTextArea, use TAB and SHIFT+TAB for focus traversal; instead of CTRL+TAB and SHIFT+CTRL+TAB which are the standard Sun's traversal keys for JTextAreas.");
        ta_info1.setToolTipText("This is a JTextArea, use TAB and SHIFT+TAB for focus traversal.");
        ta_info1.setWrapStyleWord(true);
        jPanel1.add(ta_info1);
        ta_info1.setBounds(10, 20, 150, 130);

        tp_info2.setBackground(new java.awt.Color(204, 255, 204));
        tp_info2.setText("This is a JTextPane, use TAB and SHIFT+TAB for focus traversal; instead of CTRL+TAB and SHIFT+CTRL+TAB which are the standard Sun's traversal keys for JTextPanes.");
        tp_info2.setToolTipText("This is a JTextPane, use TAB and SHIFT+TAB for focus traversal.");
        jPanel1.add(tp_info2);
        tp_info2.setBounds(170, 20, 150, 130);

        ep_info3.setBackground(new java.awt.Color(255, 204, 204));
        ep_info3.setText("This is a JEditorPane, use TAB and SHIFT+TAB for focus traversal; instead of CTRL+TAB and SHIFT+CTRL+TAB which are the standard Sun's traversal keys for JEditorPanes.");
        ep_info3.setToolTipText("This is a JEditorPane, use TAB and SHIFT+TAB for focus traversal.");
        jPanel1.add(ep_info3);
        ep_info3.setBounds(330, 20, 150, 130);

        getContentPane().add(jPanel1);
        jPanel1.setBounds(10, 130, 490, 160);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-516)/2, (screenSize.height-330)/2, 516, 330);
    }// </editor-fold>//GEN-END:initComponents


    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        try
        {
            UIManager.setLookAndFeel(
                    UIManager.getSystemLookAndFeelClassName() );
        }
        catch( Exception e )
        {
            e.printStackTrace();
        }

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run()
            {
                new JTypeSafeTester().setVisible(true);
            }
        });
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane ep_info3;
    private javax.swing.JFormattedTextField ftf_birthdate;
    private javax.swing.JButton jButton1;
    private javax.swing.JTextArea ta_info1;
    private javax.swing.JTextField tf_age;
    private javax.swing.JTextField tf_balance;
    private javax.swing.JTextField tf_firstname;
    private javax.swing.JTextField tf_noFocus;
    private javax.swing.JTextPane tp_info2;
    // End of variables declaration//GEN-END:variables

}
