<?php // $Id: lilie.php 399 2011-10-12 15:22:35Z fl $
/**
 * IMPORTATION CARTABLE
 * 
 * Importe dans une base MySQL l'extraction standard : "listeEleves.csv"
 *
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package SCONET
 */

class CARENT_PROFS {
	
	/**
	* RNE de l'tablissement
	* @var String	
	*/
	public $RNE;
	
	/**
	* Tableau des lves de l'tablissement RNE
	* @var array
	*/
	public $professeurs = array(); 

	/**
	* Modle de donnes SQL
	* @var Modele
	*/
	public $modele;
	
	
	/**
	* Constructeur 
	*
	* Initialisation des lves ou des classes depuis un tableau ($csv)  
	*
	* @param string $rne
	* @param string $csv
	* @param lilieModele &$modele
	*/
	public function CARENT_PROFS($rne, $profsCSV, $modele){
		$args = get_defined_vars();

		$this->RNE = $rne;
		$this->professeurs = $profsCSV;
		$this->modele = $modele;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $this );
	}
	
	/**
	* Tableau des eleves sortants
	* Difference $this->elevesEtablissement - $this->eleves
	*
	* @return array
	*/
	private function professeursAnciens(){
		$args = get_defined_vars();

		$Pi = $this->modele->sconetProfs($this->RNE); // AFAIRE : modele->sconetProfs
		$Pf = $this->professeurs;

		$return = array_diff_key($Pi,$Pf);
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );

		return $return;
	}
	
	/**
	* Insre les lves et les classes dans la base de donnes
	*
	* Vide les tables au pralable
	*
	* TRANSACTION - Ncessite que le moteur de stockage des tables Sconet soient en InnoDB
	*
	* @see $modele->PDO, $modele->videTableSconet
	* @param boolean $debug 
	* @return string
	* 
	*/
	public function toMySQL( $trans = true ){
		$args = get_defined_vars();

		$html = ""; //"<h1>".$this->RNE."</h1>";
		
		// Gestionnaire d'erreur en mode exception
		$this->modele->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		
		// Dbuter la transaction 
		$this->modele->PDO->beginTransaction();
		try { // on essaye ...
			
			// d'intgrer les nouveaux professeurs
			foreach($this->professeurs as $P){
				//$P['login'] = $this->getLogin($E['prenom'], $E['nom']);
				$html .= $this->modele->storeProf($P); // AFAIRE : modele->storeProf
				// Mise  jour ventuelle de la table profs
				$this->modele->storeProfSiBalado($P, 'profs');
			}
			
			// de retirer les anciens professeurs
			foreach($this->professeursAnciens() as $id => $A){
				$html .= $this->modele->ancienProf($id, $A, 'profs_reserve'); // AFAIRE : modele->ancienProf
			}
			
			// de mettre  jour les donnes du gestionnaire de l'tablissement
			$this->modele->gestionnaire( $this->RNE );
			
			// tout s'est bien pass ! on valide :
			if( $trans ){
				// tout s'est bien pass ! on valide :
				$this->modele->PDO->commit();
			} else {
				// tout s'est bien pass ! On demande  l'utilisateur de valider
				$this->modele->PDO->rollBack();
			}
			// sinon une exception a eu lieu ...
		}
		catch(Exception $e){
			// ... on annule les modifications
			$this->modele->PDO->rollBack();
			$html .= utf8_encode("<h2 class='erreur'>La base PROFESSEURS n'a pu &ecirc;tre mise &agrave; jour !</h2>");
			$html .= utf8_encode("<p class='ui-state-error'>".$e->getMessage()."</p>");
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $html );
		return $html;	
	}
	
	/**
	* Retourne une chaine normalisee (pas d'accent, pas d'espace, pas de quot,...) de longueur maximale donne
	* @param string $string
	* @param int $long = 50
	* @return string
	*/
	private function normalize ($string, $long = 50) {
		$args = get_defined_vars();

    	$string=strtolower($string);
		$old="-'";
		$new="aaaaaaceeeeiiiinooooouuuuyy000";	
		$string=str_replace(' ','',$string);
		$string=substr(strtolower(strtr($string,$old,$new)),0,$long);
		$string=str_replace('0','',$string);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $string );
		return $string;
	}
	
	/**
	* Retourne le login d'un eleve pnom unique
	* @param string $prenom
	* @param string $nom
	* @param int $i
	* @return string
	*/
	private function getLogin($prenom,$nom){
		$args = get_defined_vars();

		$nom = $this->normalize ($nom, 10);
		$login = strtolower($prenom[0].$nom);
		$sql= "SELECT login  FROM (";
		$sql.="SELECT login FROM sconet where rne='".$this->RNE."' ";
		$sql.=" UNION ";
		$sql.=" SELECT login FROM profs ) AS temp1 where login LIKE '".$login."%'";
		$trouve = false;
		
		$res = $this->modele->PDO->query($sql);
		$dat = $res->fetchAll(PDO::FETCH_ASSOC);
		$tab_login[] = 0;
		
		foreach ($dat as $log) {
			$trouve = true;
			$num = str_replace($login,'',$log["login"]);
			$tab_login[] = $num;
		}
		if($trouve){
			$max = max($tab_login)+1;
			$return = $login.$max;
		}
		else{
			$return = $login;
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
		return $return;
	} 
	
	public function reponse(){
		$args = get_defined_vars();

		// Celia : comme Lilie ?
		// Lilie : Profil;Etat;Identifiant;Sconet;Nom;Prnom;Niveau;Mef;Classe
		// Cart. : CLASSE;NOM;PRENOM;LOGIN;MOT DE PASSE;NUMERO ELEVE;INE
		$br = "<br/>"; $hr = "<hr/>";
		ob_start();
		foreach($this->eleves as $id => $eleve){
			echo $id.$br;
			echo $eleve['id_cas'].$br;
			echo $eleve['nom'].$br;
			echo $eleve['prenom'].$br;
			echo $eleve['classe'].$br.$hr;
		}
		$reponse = ob_get_contents();
		ob_end_clean();

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $reponse );
		return $reponse;
	}
			
}

?>