<?php // $Id: uploadCartableCSV.php 399 2011-10-12 15:22:35Z fl $
/**
* IMPORT
* 
* Importation d'un  tablissement
*  
* @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
* @author Franois L. <FL@ac-creteil.fr>
* @version 0.9
* @package CARTABLE
* @subpackage Import
*/

/** 
* Dtermination des "racines" depuis un niveau
* @param String $url 
* @param Integer $niveau profondeur / rpertoire racine de l'appli balado
*/
function remonte($url, $niveau){ 
	$tab = explode("/", $url);
	array_splice( $tab, count($tab)-1-$niveau);
	return implode("/",$tab);	 
}

define('_ROOT_', remonte($_SERVER['SCRIPT_FILENAME'],1)); 
require(_ROOT_.'/imports/connexion.php');
require(_ROOT_.'/imports/modele.php');
require(_ROOT_.'/imports/cartable.php');

// SUPPRESSION DE TOUS LES ESPACES
function strim ($string) {
    $swap = array(" "=>"");
    return strtr(utf8_encode($string), $swap);
}

$msg = "";

// Chargement du modle de donnes
$cartable = Modele::chargement('sconetModele'); 

$rne = '0941025D'; // de l'tablissement  importer

// Tableau des lves de l'tablissement  construire 
// sur le modle

$eleves = array( 

'1111090941025' => array(
	'id' => 1111090941025,
	'id_cas' => 'tciboulette',
	'id_sconet' => 0,
	'nom' => 'CIBOULETTE',
	'prenom' => 'Tartempion',
	'classe' => '3a',
	'rne' => '0941025D'
	),

'2222090941025' => array(
  'id' => 2222090941025,
  'id_cas' => 'sberland',
  'id_sconet' => 0,
  'nom' => 'BERLAND',
  'prenom' => 'Salom',
  'classe' => '3b',
  'rne' => '0941025D'
  )
);

/* o depuis une exportation CSV comportant les colonnes 'LOGIN', 'NUMERO ELEVE', 'NOM', 'PRENOM', 'CLASSE'
Nous avions construit :
        ID : (integer) $eleve[$colonnes['NUMERO ELEVE']].substr($rne,0,-1);
    ID_CAS : $eleve[$colonnes['LOGIN']]; 
 ID_SCONET : 0;
       NOM : $eleve[$colonnes['NOM']];
    PRENOM : $eleve[$colonnes['PRENOM']],
    CLASSE : strim($eleve[$colonnes['CLASSE']]), 
       RNE : $rne;
*/

// OBJET CARTABLE
$cartableENVOL = new CARTABLE($rne, $eleves, $cartable);
      
// SANS MISE A JOUR : MODIFICATIONS DETECTEES  
// $msg = utf8_encode( stripslashes( $cartableENVOL->toMySQL( false ))); si besoin
$msg = stripslashes( $cartableENVOL->toMySQL( false ));

// MISE A JOUR
// $msg = utf8_encode( stripslashes( $cartableENVOL->toMySQL( true ))); si besoin
$msg = stripslashes( $cartableENVOL->toMySQL( true ));

__LXF__('__IMPORT__ELEVES__', get_defined_vars(), $msg );

echo $msg?$msg:'AUCUNE MODIFICATION';

include ("majBase.php");

?>