<?php // $Id: uploadCartableCSV.php 399 2011-10-12 15:22:35Z fl $
/**
* IMPORT
* 
* Importation d'un  tablissement
*  
* @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
* @author Franois L. <FL@ac-creteil.fr>
* @version 0.9
* @package CARTABLE
* @subpackage Import
*/

/** 
* Dtermination des "racines" depuis un niveau
* @param String $url 
* @param Integer $niveau profondeur / rpertoire racine de l'appli balado
*/
function remonte($url, $niveau){ 
	$tab = explode("/", $url);
	array_splice( $tab, count($tab)-1-$niveau);
	return implode("/",$tab);	 
}

define('_ROOT_', remonte($_SERVER['SCRIPT_FILENAME'],1)); 
require(_ROOT_.'/imports/connexion.php');
require(_ROOT_.'/imports/modele.php');
require(_ROOT_.'/imports/carent_profs.php');

// SUPPRESSION DE TOUS LES ESPACES
function strim ($string) {
    $swap = array(" "=>"");
    return strtr(utf8_encode($string), $swap);
}

$msg = "";

// Chargement du modle de donnes
$cartableProfs = Modele::chargement('profsModele'); 

$rne = '0941025D'; // de l'tablissement  importer

// Tableau des lves de l'tablissement  construire 
// sur le modle

$professeurs = array( 

'jswift0941025' => array(
  'id' => 'jswift0941025',
  'nom' => 'SWIFT',
  'prenom' => 'JONATHAN',
  'rne' => '0941025D'
  ),

'lgulliver0941025' => array(
  'id' => 'lgulliver0941025',
  'nom' => 'GULLIVER',
  'prenom' => 'LEMUEL',
  'rne' => '0941025D'
  ),

'tjoufflineau0941025' => array(
  'id' => 'tjoufflineau0941025',
  'nom' => 'JOUFFLINEAU',
  'prenom' => 'THOMAS',
  'rne' => '0941025D'
  )
);

/* o depuis une exportation CSV comportant les colonnes 'LOGIN', 'NOM', 'PRENOM'
Nous avions construit :
        ID : $prof[$colonnes['LOGIN']].substr($rne,0,-1);
       NOM : $prof[$colonnes['NOM']];
    PRENOM : $prof[$colonnes['PRENOM']];
       RNE : $rne;
*/
 
// OBJET CARTABLE
$carentENVOL = new CARENT_PROFS($rne, $professeurs, $cartableProfs);
			     
// SANS MISE A JOUR : MODIFICATIONS DETECTEES	
//$msg = utf8_encode( stripslashes( $cartableENVOL->toMySQL( false )));
$msg =  stripslashes( $carentENVOL->toMySQL( false ));

// MISE A JOUR
//$msg = utf8_encode( stripslashes( $cartableENVOL->toMySQL( true )));
$msg =  stripslashes( $carentENVOL->toMySQL( true ));

__LXF__('__IMPORT__PROFS__', get_defined_vars(), $msg );

echo $msg?$msg:'AUCUNE MODIFICATION';

include("majBaseProfs.php");

?>