<?php // $Id: modele.php 333 2011-10-04 15:01:34Z fl $
/**
 * MODLE DE DONNES
 * 
 * Gestion d'un table de donnes 
 *  
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package Modeles
 */
class Modele { 

	public $table;
	public $id;
	public $PDO;
	
	// CONSTRUCTEUR
	public function Modele(){ 
		$args = get_defined_vars();

		try{
			$this->PDO = new PDO(DSN,LOG,PWD);
		} catch (PDOException $e){
			print( "Erreur ! : ". $e->getMessage()."<br/>");
			die();
		}

		__LXF__(__CLASS__."::".__FUNCTION__ );	
	}
	
	// GET (rcupration)
	public function get( $champs = "*", $id = null){
		$args = get_defined_vars();

		$sql = "SELECT $champs FROM ".$this->table." WHERE id=".($id?$id:$this->id);
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_ASSOC);
		foreach($dat[0] as $k => $v){
			$this->$k = $v;	
		}
		$ret = $dat[0];

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}
	
	// SET (affectation)
	public function setID($id){
		$args = get_defined_vars();

		$this->id = $id;
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $this );
		return $this->get();	
	}
	
	public function exist($id, $_table=null){
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table;
		$sql = "SELECT COUNT(*) as exid FROM ".$table." WHERE id=".$id;
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->exid;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}
	
	public function existChamps($arrChamps, $_table=null){
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table;
		$conditions = array(); 
		foreach($arrChamps as $k => $v){
			$conditions[] = $k." = '".addslashes($v)."'";
		}
		$sql = "SELECT COUNT(*) as n FROM ".$table." WHERE ".implode("AND ",$conditions);
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}
	
	public function nonVide( $_table=null){
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table;
		$sql = "SELECT COUNT(*) as n FROM ".$table;
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}
	
	// SELECTION 
	public function select( $donnees = array(), $_tables=null ){
		$args = get_defined_vars();

		$tables = $_tables?$_tables:$this->table;
        $conditions = "1=1";
        $champs = "*";
        $limite = "";
        $ordre = "id DESC";
        extract($donnees);
        if(isset($donnees["limite"])) $limite = "LIMIT ".$donnees["limite"]; 
        $sql = "SELECT $champs FROM $tables WHERE $conditions ORDER BY $ordre $limite";
		$req = $this->PDO->query($sql);
		$fetch = isset($donnees['fetch'])?$donnees['fetch']:PDO::FETCH_ASSOC;
		$dat = $req->fetchAll($fetch);
		//$dat = $req->fetchAll(PDO::FETCH_ASSOC);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $dat );
        return $dat;
    }

	// SAUVEGARDE
	public function store($T, $_table = null, $execute = true){ // $T : tableau des champs de donnes
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table;
		$html = ""; $id = isset($T['id'])?$T['id']:0; // unset($T['id']);	
		if($this->exist($id)) :
			unset($T['id']);
			//$T = array_map("stripslashes", $T);
			$U = array(); 
			foreach( $T as $k => $v){
				$U[] = $k." = '".addslashes($v)."'";
			}
			$sql = "UPDATE ".$table." SET ".implode(",", $U)." WHERE id=".$id;
		else :	
			$T = array_map("addslashes", $T);
			$champs = array_keys($T);
			$sql = "INSERT INTO ".$table." (".implode(",", $champs).") VALUES ('".implode("','",$T)."')"; 
		endif;
		
		if($execute) :
			if($this->execute(utf8_decode($sql))) :
				$retour = "<p class='succes'>".$sql." <span>[Succ&egrave;s !]</span></p>";
			else :
				$retour = "<p class='erreur'>".$sql." <span>[Donn&eacute;es &agrave; jour !]</span></p>";
			endif;
		else:
			$retour = "<p class='noexec'>".$sql."</p>";			
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		return $retour;
	}
	
	public function storeClasses($C){
		$args = get_defined_vars();
		// supprimer les classes sconet avant (r)importation
		__LXF__(__CLASS__."::".__FUNCTION__, $args );	
	}

	// SUPPRESSION
	public function delete($id){
		$args = get_defined_vars();

		$sql = "DELETE FROM ".$this->table." WHERE id=$id";
		$ret = $this->execute($sql);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		return $ret;
	}

	// EXECUTION
	public function execute($sql) {
		$args = get_defined_vars();

		$ret = $this->PDO->exec($sql);
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		return $ret;
	}

	// CHARGEMENT (Charge un modle hrit)
    static function chargement($name){ 
    	$args = get_defined_vars();

        require_once(_ROOT_."/imports/$name.php");

        __LXF__(__CLASS__."::".__FUNCTION__, $arg );
        return new $name();
    }

}
?>
