<?php  // $Id: profsClassesModele.php 450 2011-10-20 11:36:56Z fl $
/**
 * MODLE DE DONNES
 * 
 * Extension profsClasses
 *  
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package BALADO
 * @subpackage Modeles
 */

class profsClassesModele extends Modele{
		
	var $profs_classes = "profs_classes";
	var $classes = "classes";
	var $eleves = "eleves";
	var $sconet = "sconet";
	var $partages = "partages";
	var $ens = 0;
	var $rne = "";
		
	public function init($_rne, $_ens){
		$args = get_defined_vars();

		$this->ens = $_ens;
		$this->rne = $_rne;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $this );	
	}
	
	public function testAjax($datas){
		ob_start();
		print_r($datas);
		$ob = ob_get_contents();
		ob_end_clean();
		return $ob;
	}

	public function partages( $classe ){
		$args = get_defined_vars();

		$id_classe = $this->idClasse($classe);
		$sql = "SELECT count(*) as n FROM ".$this->partages." WHERE type_ensemble='classe' AND id_ensemble=$id_classe AND id_prof=$this->ens" ;
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = "{ \"partages\":".$dat[0]->n." }";	

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}	
	
	private function idEleve( $id_sconet ){
		$args = get_defined_vars();

		$sql = "SELECT id FROM ".$this->eleves." WHERE id_sconet=$id_sconet";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->id;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}

	public function idClasse( $c ){
		$args = get_defined_vars();

		$sql = "SELECT id FROM ".$this->classes." WHERE rne='".$this->rne."' AND classe='".$c."'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->id?$dat[0]->id:0;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
	public function sconetEleves($classe){
		$args = get_defined_vars();

		$donnees = array(); $E = array(); 
		$id_classe = $this->idClasse($classe);
		$donnees['champs'] = "nom, prenom, login, naissance, id_cas, id as id_sconet";
		//$donnees['limite'] = "0,5";  
		$donnees['conditions'] = "rne='".$this->rne."'"." AND classe='$classe' AND actif=1";
		$eleves = $this->select($donnees, $this->sconet);
		foreach($eleves as $eleve){
				$eleve['rne'] = $this->rne;
				$eleve['id_classe'] = $id_classe;
				$E[] = $eleve;
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $E );	
		return $E;	
	}
	
	public function majSessionClassesGroupes(){
		$args = get_defined_vars();

		// CLASSES
		$sql = "SELECT id, classe as libelle FROM profs_classes, classes WHERE id_prof=".$this->ens." AND id_classe=classes.id AND classes.rne='".$this->rne."'";
		$req = $this->PDO->query($sql);
		$classes = $req->fetchAll(PDO::FETCH_ASSOC);
		foreach($classes as $k=>$classe){
			$classes[$k]['id'] = "c".$classe['id'];	
		}
		// GROUPES
		$sql = "SELECT id, libelle FROM profs_groupes WHERE id_prof = ".$this->ens." AND rne = '".$this->rne."'";
		$req = $this->PDO->query($sql);
		$groupes = $req->fetchAll(PDO::FETCH_ASSOC);
		foreach($groupes as $k=>$groupe){
			$groupes[$k]['id'] = "g".$groupe['id'];	
		}
		// maj SESSION
		// print_r(array_merge($classes,$groupes));
		$_SESSION['classes'] = array_merge($classes,$groupes);	

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $_SESSION );	
	}

	public function store($classe){ 
		$args = get_defined_vars();

		// TRANSACTION STORE ////////////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...
			// Ajouter dans la table $classes si elle n'existe pas 
			$idClasse = $this->idClasse($classe);
			if( !$idClasse ) :
				$sql = "INSERT INTO ".$this->classes." (rne, classe) VALUES ('".$this->rne."','$classe')";
				$this->execute($sql);
				$idClasse = $this->idClasse($classe);
				// Ajouter les lves dans la table $eleves 
				$eleves = $this->sconetEleves($classe);
				foreach( $eleves as $eleve){
					// Cryptage du mot de passe
					$idEleve = $this->idEleve($eleve['id_sconet']);
					if($idEleve){
						$sql = "UPDATE eleves SET id_classe='$idClasse' WHERE id=".$idEleve;	
					} else {
						$cryptage = "MD5"; $mdp = date("dmy", strtotime($eleve['naissance']));
						$eleve = array_map("addslashes", $eleve); $champs = array_keys($eleve);
						$sql = "INSERT INTO ".$this->eleves." (".implode(",", $champs).", mdp) VALUES ('".implode("','",$eleve)."', ".$cryptage."('".$mdp."'))";
					}
					$this->execute($sql);
				}
			endif;
			// Ajouter dans la table $profs_classes
			$sql = "INSERT INTO ".$this->profs_classes." (id_classe, id_prof) VALUES ('$idClasse','".$this->ens."')";
			$this->execute(utf8_decode($sql));

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
			// tout s'est bien pass ! on valide :
			return $this->PDO->commit();
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$ret = $e->getMessage();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
			return $ret;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
	}
	
	public function delete($classe){
		$args = get_defined_vars();
		
		// TRANSACTION STORE ////////////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...
			// Supprimer dans la table $profs_classes
			$id = $this->idClasse($classe); // il doit exister
			$sql = "DELETE FROM ".$this->profs_classes." WHERE id_classe=$id AND id_prof=".$this->ens;
			$this->execute($sql);
			/* Supprimer dans la table $classes au besoin
			if( !$this->classesBalado( $id ) ): // La classe est-elle utilise ?
				$sql = "DELETE FROM ".$this->classes." WHERE id=$id";
				$this->execute($sql);
				// Supprimer les lves dans la table $eleves 
				$sql = "DELETE FROM ".$this->eleves." WHERE id_classe=$id";
				$this->execute($sql);		
			endif; *//////// UNE UNIQUE REQUETE => TRANSACTION DESORMAIS INUTILE /////////////////////
			__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql ); 
			// tout s'est bien pass ! on valide :
			return $this->PDO->commit();
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$ret = $e->getMessage();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
			return $ret;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
		
	}

	public function classeNonVide($C){
		$args = get_defined_vars();

		$sql = "SELECT COUNT(*) as n FROM sconet WHERE rne='".$C['rne']."' AND classe='".$C['classe']."' AND actif=1";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}

	public function classes(){
		$args = get_defined_vars();

		$sql = "SELECT ".$this->classes.".id, classe, rne FROM ".$this->classes.", ".$this->profs_classes." WHERE id=id_classe AND rne='".$this->rne."' AND id_prof=".$this->ens." ORDER BY classe ASC";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_ASSOC);
		if( isset($dat) ){
			foreach ( $dat as $idx => $classe ) {
				if( !$this->classeNonVide( $classe ) ){ unset($dat[$idx]); }
			}
			$ret = $dat;
		} else {
			$ret = array();
		}
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}

	public function classesBalado( $id ){
		$args = get_defined_vars();

		$sql = "SELECT count(*) as n FROM ".$this->profs_classes." WHERE id_classe=$id";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}
	
}

?>