
<?php  // $Id $
/**
 * MODLE DE DONNES
 * 
 * Extension profsEleves
 *  
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package BALADO
 * @subpackage Modeles
 */

class profsElevesModele extends Modele{
	
	var $eleves = "eleves";	
	var $classes = "classes";
	var $elevgr = "eleves_groupes";
	var $profgr = "profs_groupes";
	var $ens = 0;
	var $rne = "";
		
	public function init($_rne, $_ens){
		$args = get_defined_vars();

		$this->ens = $_ens;
		$this->rne = $_rne;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $this );
	}
	
	public function testAjax($datas){
		ob_start();
		print_r($datas);
		$ob = ob_get_contents();
		ob_end_clean();
		return $ob;
	}

	public function idGroupe( $g ){
		$args = get_defined_vars();

		$sql = "SELECT id FROM ".$this->profgr." WHERE rne='".$this->rne."' AND id_prof='".$this->ens."' AND libelle='".$g."'";
		//echo $sql;
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->id?$dat[0]->id:0;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
	public function getClasse( $idc ){
		$args = get_defined_vars();

		$sql = "SELECT classe FROM ".$this->classes." WHERE rne='".$this->rne."' AND id=$idc";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret =  $dat[0]->classe?$dat[0]->classe:0;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	

	public function elevesDeLaClasse($idClasse){
		$args = get_defined_vars();

		$donnees = array(); $E = array(); 
		$donnees['champs'] = "id, nom, prenom";
		$donnees['ordre'] = "nom ASC, prenom ASC";
		//$donnees['limite'] = "0,5";  
		$donnees['conditions'] = "rne='".$this->rne."'"." AND id_classe='$idClasse'";
		$eleves = $this->select($donnees, $this->eleves);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $eleves );	
		return $eleves;	
	}

	public function elevesDuGroupe($libelleGroupe){
		$args = get_defined_vars();

		$donnees = array(); $E = array(); 
		$donnees['champs'] = "eleves.id, nom, prenom, id_classe";
		$donnees['ordre'] = "nom ASC, prenom ASC";
		$tables = "eleves, eleves_groupes";
		$idGroupe = $this->idGroupe($libelleGroupe);  
		$donnees['conditions'] = "eleves.id=eleves_groupes.id_eleve AND eleves_groupes.id_groupe='$idGroupe'";
		$donnees['fetch'] = PDO::FETCH_OBJ;
		$eleves = $this->select($donnees, $tables);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $eleves );	
		return $eleves;	
	}

	public function storeEleveGroupe($id_eleve, $libelleGroupe){ 
		$args = get_defined_vars();

		// TRANSACTION STORE ////////////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...
			// de rcuprer l'id_groupe depuis ($rne,$id_prof,$libelleGroupe) 
			$id_groupe = $this->idGroupe($libelleGroupe); 
			// d'insrer la liaison eleve_groupe
			if( $id_groupe ) :
				$sql = "INSERT INTO ".$this->elevgr." (id_eleve, id_groupe) VALUES ('$id_eleve','$id_groupe')";
				$this->execute($sql);
			endif;

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );	
			// tout s'est bien pass ! on valide :
			return $this->PDO->commit();
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$ret = $e->getMessage();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
			return $ret;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
	}
	
	public function deleteEleveGroupe($id_eleve, $libelleGroupe){
		$args = get_defined_vars();

		// TRANSACTION STORE ////////////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...
			// Supprimer dans la table $eleves_groupes
			$id_groupe = $this->idGroupe($libelleGroupe); // il doit exister
			$sql = "DELETE FROM ".$this->elevgr." WHERE id_groupe=$id_groupe AND id_eleve=$id_eleve";
			$this->execute($sql);

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );	
			// tout s'est bien pass ! on valide :
			return $this->PDO->commit();;
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$ret = $e->getMessage();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
			return $ret;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
		
	}

	public function classes(){
		$args = get_defined_vars();

		$sql = "SELECT ".$this->classes.".id, classe FROM ".$this->classes.", ".$this->profs_classes." WHERE id=id_classe AND rne='".$this->rne."' AND id_prof=".$this->ens." ORDER BY classe ASC";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_ASSOC);
		$ret = isset($dat)?$dat:array();

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}

	public function classesBalado( $id ){
		$args = get_defined_vars();

		$sql = "SELECT count(*) as n FROM ".$this->profs_classes." WHERE id_classe=$id";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
}

?>