<?php  // $Id: profsGroupesModele.php 450 2011-10-20 11:36:56Z fl $
/**
 * MODLE DE DONNES
 * 
 * Extension profsGroupes
 *  
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package BALADO
 * @subpackage Modeles
 */

class profsGroupesModele extends Modele{
		
	var $profs_groupes = "profs_groupes";
	var $eleves = "eleves_groupes";
	var $partages = "partages";
	var $ens = 0;
	var $rne = "";
		
	public function init($_rne, $_ens){
		$args = get_defined_vars();

		$this->ens = $_ens;
		$this->rne = $_rne;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $this );	
	}
	
	public function testAjax($datas){
		ob_start();
		print_r($datas);
		$ob = ob_get_contents();
		ob_end_clean();
		return $ob;
	}

	public function idGroupe( $g ){
		$args = get_defined_vars();

		$sql = "SELECT id FROM ".$this->profs_groupes." WHERE id_prof ='".$this->ens."'AND rne ='".$this->rne."' AND libelle ='".$g."'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->id?$dat[0]->id:0;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
	public function store($groupe){ 
		$args = get_defined_vars();

		// TRANSACTION STORE ////////////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...
			// Ajouter dans la table profs_groupes s'il n'existe pas 
			$mid = $this->idGroupe($groupe);
			if( !$mid ) :
				$sql = "INSERT INTO ".$this->profs_groupes." (id_prof, rne, libelle) VALUES ('".$this->ens."','".$this->rne."','$groupe')";
				$this->execute($sql);
				$id = $this->idGroupe($groupe);
			endif;

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );	
			// tout s'est bien pass ! on valide :
			$this->PDO->commit();
			return $mid?0:1;
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$ret = $e->getMessage();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
			return $ret;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
	}
	
	public function dependances($groupe){
		$args = get_defined_vars();

		$id = $this->idGroupe($groupe);
		$ret = "{ \"dependances\": { \"eleves\":".$this->eleves( $id ).", \"partages\":".$this->partages( $id )." } }";	

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
	public function delete($groupe){
		$args = get_defined_vars();

		// TRANSACTION STORE ////////////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...
			// Supprimer dans la table profs_groupes
			$id = $this->idGroupe($groupe); // il doit exister
			$sql = "DELETE FROM ".$this->profs_groupes." WHERE id=$id";
			$this->execute($sql);
			// Supprimer dans les tables eleves_groupes et partage
			if( $this->eleves( $id ) ):
				$sql = "DELETE FROM ".$this->eleves." WHERE id_groupe=$id";
				$this->execute($sql);
			endif;
			if( $this->partages( $id ) ):
				// Supprimer les lves dans la table eleves_groupes 
				$sql = "DELETE FROM ".$this->partages." WHERE id_ensemble=$id ";
				$this->execute($sql);		
			endif;

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );	
			// tout s'est bien pass ! on valide :
			return $this->PDO->commit();
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$ret = $e->getMessage();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
			return $ret;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
		
	}
	
	public function majSessionClassesGroupes(){
		$args = get_defined_vars();

		// CLASSES
		$sql = "SELECT id, classe as libelle FROM profs_classes, classes WHERE id_prof=".$this->ens." AND id_classe=classes.id AND classes.rne='".$this->rne."'";
		$req = $this->PDO->query($sql);
		$classes = $req->fetchAll(PDO::FETCH_ASSOC);
		foreach($classes as $k=>$classe){
			$classes[$k]['id'] = "c".$classe['id'];	
		}
		// GROUPES
		$sql = "SELECT id, libelle FROM profs_groupes WHERE id_prof = ".$this->ens." AND rne = '".$this->rne."'";
		$req = $this->PDO->query($sql);
		$groupes = $req->fetchAll(PDO::FETCH_ASSOC);
		foreach($groupes as $k=>$groupe){
			$groupes[$k]['id'] = "g".$groupe['id'];	
		}
		// maj SESSION
		// print_r(array_merge($classes,$groupes));
		$_SESSION['classes'] = array_merge($classes,$groupes);	

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $_SESSION );	
	}


	public function groupes(){
		$args = get_defined_vars();

		$sql = "SELECT libelle FROM ".$this->profs_groupes." WHERE rne='".$this->rne."' AND id_prof=".$this->ens." ORDER BY libelle ASC";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_ASSOC);
		$ret = isset($dat)?$dat:array();

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}

	public function eleves($id_groupe){
		$args = get_defined_vars();

		$sql = "SELECT count(*) as n FROM ".$this->eleves." WHERE id_groupe=$id_groupe";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}

	public function partages( $id_groupe ){
		$args = get_defined_vars();

		$sql = "SELECT count(*) as n FROM ".$this->partages." WHERE type_ensemble='groupe' AND id_ensemble=$id_groupe";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
}

?>