<?php  // $Id: sconetModele.php 401 2011-10-14 15:52:13Z fl $
/**
 * MODLE DE DONNES
 * 
 * Extension 
 *  
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package SCONET
 * @subpackage Modeles
 */

/*
TRUNCATE classes; TRUNCATE eleves; TRUNCATE profs_classes; TRUNCATE profs_groupes; TRUNCATE sconet; TRUNCATE sconet_classes; 
*/
class profsModele extends Modele{
		
	var $table = "profs_reserve";
	
	// tables secondaires
	var $profs = "profs";
	var $affectation = "affectation";
	
	public function testAjax($datas){
		ob_start();
		echo "<pre>";
		print_r($datas);
		echo "</pre>";
		$ob = ob_get_contents();
		ob_end_clean();
		return $ob;
	}

	public function store($T, $_table = null, $execute = true){ // $T : tableau des champs de donnes
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table;
		$html = ""; $id = isset($T['id'])?$T['id']:0; // unset($T['id']);	
		if($this->exist($id, $_table)) :
			unset($T['id']);
			//$T = array_map("stripslashes", $T);
			$U = array(); 
			foreach( $T as $k => $v){
				$U[] = $k." = '".addslashes($v)."'";
			}
			$sql = "UPDATE ".$table." SET ".implode(",", $U)." WHERE id=".$id;
			$ajout = false;
		else :	
			$T = array_map("addslashes", $T);
			$champs = array_keys($T);
			$sql = "INSERT INTO ".$table." (".implode(",", $champs).") VALUES ('".implode("','",$T)."')"; 
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );	
		
		if($execute) :
			$ret = $this->execute(utf8_decode($sql));
			if($ret=="") :
				$retour = "<p class='erreur'>".$sql."</p>"; 
			else :
				$retour = "<p class='succes'>".implode("|",$T)."</p>";	
			endif;
		else:
			$retour = "<p class='noexec'>".$sql."</p>";			
		endif;
		return $retour;
	}

/*
	private function idEleve( $id_sconet ){
		$sql = "SELECT id FROM eleves WHERE id_sconet=$id_sconet";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		return $dat[0]->id;
	}

	private function idSconetEleve( $id ){
		$sql = "SELECT id_sconet FROM eleves WHERE id=$id";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		return $dat[0]->id_sconet;
	}

	private function eleve( $id_sconet ){
		$sql = "SELECT * FROM eleves WHERE id_sconet='$id_sconet'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		return $dat[0];
	}

	private function idClasse( $rne, $classe ){
		$sql = "SELECT id FROM classes WHERE rne='$rne' AND classe='$classe'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		return $dat[0]->id;
	}
*/	
	public function ancienProf($id, $A, $_table = null, $execute = true){
		$args = get_defined_vars();

		//$sql  = "DELETE FROM profs_reserve WHERE id='".$id."'";
		$sql = "UPDATE profs_reserve SET actif = 0 WHERE id='".$id."'";
		$ret = $this->execute($sql); 

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );	
		// Information en retour
		$retour = "<p class='supprime'><span>Professeur sortant : </span>".$A['nom']." ".$A['prenom']." <span class='classe'>".$A['classe']."</span></p>";
		$retour = $ret?$retour:"";	
		return utf8_encode($retour);
	}

/*	
	public function updateSQL($eleve){
		// $eleve : rne, classe, nom, prenom, login, id_cas | classe, naissance, sexe, id
		$idClasse = $this->idClasse($eleve['rne'], $eleve['classe']); 
		$eleve['id_classe'] = $idClasse?$idClasse:0;
		
		$idSconet = $eleve['id']; unset($eleve['id']); unset($eleve['classe']); unset($eleve['sexe']); unset($eleve['login']); 
		if(!isset($eleve['id_cas'])) { $eleve['id_cas'] = 0; }
		$E = array();
		foreach( $eleve as $k => $v){
				$E[] = $k." = '".addslashes($v)."'";
			}
		$sql = "UPDATE eleves SET ".implode(",", $E)." WHERE id_sconet = ".$idSconet;
		return $sql;	
	}

	public function insertSQL($eleve){
		// Cryptage du mot de passe
		$cryptage = "MD5"; $mdp = date("dmy", strtotime($eleve['naissance']));

		$idClasse = $this->idClasse($eleve['rne'], $eleve['classe']); 
		$eleve['id_classe'] = $idClasse?$idClasse:0;
		$eleve['id_sconet'] = $eleve['id']; unset($eleve['id']);
		if(!isset($eleve['id_cas'])) { $eleve['id_cas'] = 0; }
		
		unset($eleve['classe']);  unset($eleve['sexe']);
		$eleve = array_map("addslashes", $eleve); $champs = array_keys($eleve);
		$sql = "INSERT INTO eleves (".implode(",", $champs).", mdp) VALUES ('".implode("','",$eleve)."', ".$cryptage."('".$mdp."'))";
		return $sql;
	}
	
	public function storeEleveSiBalado($E, $_table = null, $execute = true){
		$br="<br/>";
		// Classe
		$rne = $E['rne']; $classe = $E['classe']; 
		$idClasse = $this->idClasse($rne, $classe);
		// Eleve
		$idSconet = $E['id']; $id = $this->eleve($idSconet)->id; 
		// Balado
		if($idClasse and $id) :
			$sql = $this->updateSQL($E);
		elseif($idClasse and !$id):
			$sql = $this->insertSQL($E);
		endif;
		if($execute and isset($sql)) :
			$this->execute($sql);
			//$retour = ($ret=="")?("<p class='erreur'>".$sql."</p>"):"";
		elseif(isset($sql)) :
			$retour = "<p class='debug'>".$sql."</p>";	
		endif;
		return $retour;
	}
*/

	public function exist($id, $_table=null){
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table;
		$sql = "SELECT COUNT(*) as exid FROM ".$table." WHERE id='".$id."'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->exid;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
	public function gestionnaire( $rne ){
		$args = get_defined_vars();

		// 1. y-a-t-il un gestionnaire dans l'tablissement ? 
		$sql = "SELECT p.id as id, t.nom as nm, t.prenom as pn FROM ".$this->table." as t, ".$this->profs." as p, ".$this->affectation." as a WHERE p.prenom = 'gestionnaire' AND a.rne = '".$rne."' AND p.id = a.id_prof AND CONCAT(a.id_cas,'".substr($rne,0,-1)."') = t.id "; 
		$req = $this->PDO->query($sql); $ret = $sql;
		$dat = $req->fetchAll(PDO::FETCH_OBJ); $dat = $dat[0];                 
		// 2. si oui mettre  jour ses donnes utilisateurs Nom et Prnom
		if( isset( $dat->id )):
			$sql = "UPDATE ".$this->profs." SET nom = '".$dat->nm."', prenom = '".$dat->pn."' WHERE id = ".$dat->id;
			$this->PDO->exec($sql); $ret .= '\n'.$sql;
		// 3. sinon, RAF
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
	}

	private function professeur( $id ){
		$args = get_defined_vars();
		
		$sql = "SELECT id_prof FROM profs_reserve WHERE id='$id'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$return = $dat[0]->id_prof;
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return);
		return $return;
	}
	
	public function storeProfSiBalado($P, $_table = null, $execute = true){
		$args = get_defined_vars();
		
		extract( $P );
		
		$retour = $pid = $this->professeur($id);
		
		if( $pid != 0 ): 
			$sql = "UPDATE profs SET nom='$nom', prenom='$prenom' WHERE id='$pid'";
			$retour = $this->execute($sql);
		endif;
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $retour );
		return $retour;
	}

	public function storeProf($T, $_table = null, $execute = true){ // $T : tableau des champs de donnes
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table; $br="<br/>";
		$id = isset($T['id'])?$T['id']:0; $ajout = true; // unset($T['id']);	
		if( $this->exist($id, $_table) ) :
			unset($T['id']);
			//$T = array_map("stripslashes", $T);
			$U = array(); $U[] = 'actif = 1'; 
			foreach( $T as $k => $v){
				$U[] = $k." = '".addslashes($v)."'";
			}
			$sql = "UPDATE ".$table." SET ".implode(",", $U)." WHERE id='".$id."'";
			// Dtecter une non affectation
			$ajout = false;
		else :	
			$T = array_map("addslashes", $T);
			$champs = array_keys($T);
			$sql = "INSERT INTO ".$table." (".implode(",", $champs).") VALUES ('".implode("','",$T)."')"; 
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );	
		
		if($execute) :
			$modif = $this->execute($sql);
			$retour = $ajout?("<p class='ajoute'><span>Nouveau professeur : </span>".$T['nom']." ".$T['prenom']."</p>".$html):($modif?"<p class='ajoute'><span>Maj. professeur : </span>".$T['nom']." ".$T['prenom']."</p>":"");	
		else:
			$retour = "<p class='noexec'>".$sql."</p>";			
		endif;
		return $retour;
	}
/*
	public function storeClasse($C, $_table = null, $execute = true){ 
		// $C : tableau des champs de donnes : 'rne', 'classe'
		$table = $_table?$_table:$this->table; $retour="";
		if(!$this->existChamps($C, $_table) and $execute) :
			$C = array_map("addslashes", $C);
			$champs = array_keys($C);
			$sql = "INSERT INTO ".$table." (".implode(",", $champs).") VALUES ('".implode("','",$C)."')"; 
			$this->execute($sql);
			$retour = "<p class='ajoute'><span>Nouvelle classe : </span><span class='classe'>".$C['classe']."</span></p>";	
		/* 	LES CLASSES EXTRAITES DE SCONET NE SONT PAS VIDES PAR DEFINTION
			IL FAUT PROCEDER A UNE DIFFERENCE !!! ////////////////////////////////////////////////////////////////////////////////////
		else: 	
			// Si la classe est vide
			if(!$this->classeNonVide($C)):
				$rne = $C['rne']; $classe = $C['classe'];
				$idClasse = $this->idClasse($rne,$classe);
			// La supprimer dans sconet_classes :
				$sql = "DELETE FROM sconet_classes WHERE rne='$rne' AND classe='$classe'";
				//$this->execute($sql);
			// dans classes :	
				$sql = "DELETE FROM classes WHERE rne='$rne' AND classe='$classe'";
				//$this->execute($sql);
			// dans profs_classes :	
				$sql = "DELETE FROM profs_classes WHERE id_classe='$idClasse'";
				//$this->execute($sql);
			// dans partages :	
				$sql = "DELETE FROM partages WHERE id_ensemble='$idClasse' AND type_ensemble='classe'";
				//$this->execute($sql);
				//$retour = "<p class='succes'><span>Classe supprim&eacute;e: </span><span class='classe'>".$C['classe']."</span></p>";
			endif;
			// $retour = "<p class='succes'>blurp: ".$this->classeVide($C)."</p>";
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////	
		endif;
		return $retour;
	}
	
	public function siVideAlorsSupprime($C){
		$retour = "";
		if(!$this->classeNonVide($C)):
			$rne = $C['rne']; $classe = $C['classe'];
			$idClasse = $this->idClasse($rne,$classe);
		// La supprimer dans sconet_classes :
			$sql = "DELETE FROM sconet_classes WHERE rne='$rne' AND classe='$classe'";
			$this->execute($sql);
		// dans classes :	
			$sql = "DELETE FROM classes WHERE rne='$rne' AND classe='$classe'";
			$this->execute($sql);
		// dans profs_classes :	
			$sql = "DELETE FROM profs_classes WHERE id_classe='$idClasse'";
			$this->execute($sql);
		// dans partages :	
			$sql = "DELETE FROM partages WHERE id_ensemble='$idClasse' AND type_ensemble='classe'";
			$this->execute($sql);
			$retour = "<p class='supprime'><span>Classe supprim&eacute;e: </span><span class='classe'>".$C['classe']."</span></p>";
		endif;
		//$retour = "<p class='succes'>".$this->classeNonVide($C)."</p>";	
		return $retour;	
	}

	public function sconetEleves($rne, $classe=null){
		
		$donnees = array(); $E = array(); $nid = array('id' => nul);
		$donnees['conditions'] = "rne='$rne'".($classe?" AND classe='$classe'":"");
		$donnees['ordre'] = "classe ASC, nom ASC";
		//$donnees['limite'] = "0,5";
		$eleves = $this->select($donnees);
		foreach($eleves as $eleve){
				$E[$eleve['id']] = array_diff_key($eleve, $nid);
		}
		return $E;	
	}
	
*/

	public function sconetProfs($rne){
		$args = get_defined_vars();
		
		$donnees = array(); $P = array(); $nid = array('id' => nul);
		$donnees['conditions'] = "rne='$rne'";
		//$donnees['limite'] = "0,5";
		$professeurs = $this->select($donnees);
		foreach($professeurs as $prof){
				$P[$prof['id']] = array_diff_key($prof, $nid);
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $P );	
		return $P;	
	}

/*
	public function sconetClasses($rne){
		
		$donnees = array(); $C = array(); $nid = array('id' => nul);
		$donnees['conditions'] = "rne='$rne'";
		$donnees['ordre'] = "classe ASC";

		if( $this->nonvide('sconet_classes') ) {
			$classes = $this->select($donnees, 'sconet_classes');
			foreach($classes as $classe){
				$C[] = $classe['classe'];
			}
		} else {
			$donnees['champs'] = "DISTINCT classe, rne"; 
			$classes = $this->select($donnees);

			foreach($classes as $classe){
				$this->store($classe, 'sconet_classes');
				$C[] = $classe['classe'];
			}			
		}
		return $C;
	}
	
	public function eleveChangeClasse($classe, $idEleve, $rne){
		$retour = ""; $br="<br/>";	
		
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...

			// Sconet
			$sql = "UPDATE ".$this->table." SET classe = '$classe' WHERE id=".$idEleve; //return $sql;
			$this->execute(utf8_decode($sql)); 

			// Eleves
			// ancienne classe balado ? |  nouvelle classe balado ?
			// 1 | 1 => update. eleves.id_classe
			// 1 | 0 => delete eleves.id_classe ou update -|eleves.id_classe|
			// 0 | 1 => insert 
			// 0 | 0 => nothing
		
			$eleve = $this->eleve($idEleve);
			$idClasse = $this->idClasse($rne, $classe);
			// Si l'eleve existe dans la table eleves
			if($eleve->id){
			//  Si sa nouvelle classe est une classe Balado
				if($idClasse){
				// update eleves.id_classe
				$sql = "UPDATE eleves SET id_classe='".$idClasse."' WHERE id = ".$eleve->id; // OK
				//	Sinon
				} else {
				//	update -|eleves.id_classe|
				$sql = "UPDATE eleves SET id_classe='-".abs($eleve->id_classe)."' WHERE id = ".$eleve->id; // OK
				}
				$this->execute(utf8_decode($sql));
			// Sinon
			} elseif($idClasse){
			//	Si sa nouvelle classe est une classe Balado
			//		insert 
				$eleve = $this->get($champs = "*", $idEleve);
				$sql = $this->insertSQL($eleve);
				$this->execute(utf8_decode($sql));
			} 
			// Sinon
			//		nothing
			
			// tout s'est bien pass ! on valide :
			return $this->PDO->commit();
			//return $sql;
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			return $sql.$br.$e->getMessage();
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
	}

	public function nonVide($rne, $_table=""){
		$table = $this->table.$_table;
		$sql = "SELECT COUNT(*) as n FROM ".$table;
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		return $dat[0]->n;
	}

	public function classeNonVide($C){
		$sql = "SELECT COUNT(*) as n FROM sconet WHERE rne='".$C['rne']."' AND classe='".$C['classe']."'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		return $dat[0]->n;
	}
	
	private function archiveSconet($rne){
		// supprimer les enregistrements o rne=$rne
		$sql = "DELETE FROM ".$this->table."_archive WHERE rne='".$rne."'";
		if ($this->execute($sql)!=""):
			echo "ok!";
		else:
			echo "ko!";
		endif;
		
		// extraire les enregistrements	de la sconet o rne=$rne
		// les copier dans sconet_archives 
	}
	
	private function videTablesSconet($rne){
		if($this->nonVide($rne)) :
			$sql  = "DELETE FROM ".$this->table." WHERE rne='".$rne."'";
			$this->execute($sql);
			$sql = "DELETE FROM ".$this->table."_classes WHERE rne='".$rne."'";
			$this->execute($sql);
		else :
			return true;
		endif;
	}
	
	private function horsClasse($idSconet){
		$sql = "SELECT COUNT(*) as n FROM sconet WHERE id='$idSconet' AND classe LIKE '\_%'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		return $dat[0]->n;
	}
	
	public function reinitMotDePasse($idEleve){
	
		// Dbuter la transaction  /////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$this->PDO->beginTransaction();
		try { // on essaye ...
			$eleve = $this->eleve($this->idSconetEleve($idEleve));
			$cryptage = "MD5"; $mdp = date("dmy", strtotime($eleve->naissance));	
			$sql = "UPDATE eleves SET mdp = $cryptage('".$mdp."') WHERE id=$idEleve"; 
			$this->execute($sql);
			// tout s'est bien pass ! on valide :
			$this->PDO->commit();
			return $sql;
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			return $sql.$br.$e->getMessage();
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
		
	}
*/	
	
	public function verifieCSV($entetes, $champsNecessaires = array('Identifiant', 'Sconet', 'Nom', 'Prenom', 'Classe'), $champsInterdits = array() ){
		$args = get_defined_vars();

		// controler l'existance des champs : Identifiant (id_cas) , Sconet (id), Nom (nom), Prenom (prenom), Classe (classe)

		$champsNecessaires = array_diff( array_merge($entetes, $champsNecessaires), $entetes);
		if ( count($champsNecessaires) ):
			return array('errChampsManquants' => $champsNecessaires);
		endif;
		
		$champsInterdits = array_intersect($entetes, $champsInterdits);
		if ( count($champsInterdits) ):
			return array('errChampsInterdits' => $champsInterdits);
		endif;

		$ret = array_flip($entetes);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
		

}

?>