<?php // $Id: sconet.php 399 2011-10-12 15:22:35Z fl $
/**
 * IMPORTATION SCONET
 * 
 * Importe dans une base MySQL l'extraction standard : "ExportXML_ElevesSansAdresses.zip"
 *  
 * Motivation : Cette extraction contient l'ID Sconet UNIQUE d'un lve au cours de sa scolarit, ce qui permet une identification indpendante des donnes  
 * 
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package SCONET
 */

class SCONET {

	/**
	* Objet DOMDocument du fichier XML Sconet
	* @var DOMDocument()
	* @link http://www.php.net/manual/en/class.domdocument.php
	*/
 	private $XML;
	
	/**
	* Objet DOMDocument des fichiers de transformation XSLT 
	* @var DOMDocument()
	*/
	private $XSLT;
	
	/**
	* Objet DOMXPath - Permet d'accder aux noeuds d'un fichier XML en utlisant une expression XPATH
	* @var DOMXPath($XML)
	* @link http://php.net/manual/fr/class.domxpath.php manuel PHP
	*/
	public $XPATH;
	
	/**
	* RNE de l'tablissement
	* @var String	
	*/
	public $RNE;
	
	/**
	* Tableau des lves de l'tablissement RNE
	* @var array
	*/
	public $eleves = array(); 

	/**
	* Tableau des classes de l'tablissement RNE
	* @var array
	*/
	public $classes = array();

	/**
	* Modle de donnes SQL
	* @var Modele
	*/
	public $modele;
	
	
	/**
	* Constructeur 
	*
	* Initialisation des lves ou des classes depuis un fichier Sconet ($xml) aprs  
	* Chargement du fichier XML Sconet et de la feuille de transformation {@link http://balado/imports/sconetXML/extraction-eleves.xsl extraction-eleves.xsl}
	*
	* ou depuis la base de donnes ($modele, $rne)
	*
	* @link http://balado/imports/sconetXML/extraction-eleves.xsl extraction-eleves.xsl
	*
	* @param string $xml
	* @param sconetModele &$modele
	* @param string $classe ''
	* @param string $rne null
	*/
	public function SCONET($xml, & $modele, $classe='', $rne=null){
		$args = get_defined_vars();

		// Modele de donnes
		$this->modele = $modele;
		// Fichier XML SCONET
		$this->XML = new DOMDocument();
		//$this->XML->load($xml);
		if(@$this->XML->loadXML($xml)):
			// Transformation XSLT simplificatrice (Cf. utilisateurs.dtd)
			$xslt = new XSLTProcessor(); 
			$this->XSLT = new DOMDocument(); 
			$this->XSLT->load( _ROOT_.'/imports/sconetXML/extraction-eleves.xsl', LIBXML_NOCDATA);
			$xslt->importStylesheet( $this->XSLT ); 
			// Groupes utilisateurs commenant par $classe
			$xslt->setParameter('', 'start', $classe);
			$this->XML->loadXML($xslt->transformToXML($this->XML)); 
			// Filtre XPATH
			$this->XPATH = new DOMXPath($this->XML);
			$this->RNE = $this->XPATH->query("//utilisateurs/@rne")->item(0)->value;
			// Tableau des lves 
			$this->eleves = $this->toArray();
			// Tableau des classes
			$this->classes = $this->extractClassesToArray();
			//////////////////// debug //////////////////////////////////////////////////////////
			//// ob_start(); require_once(_ROOT_.'/FirePHPCore/fb.php'); FB::setEnabled(true); // 
			//// fb::info($this->eleves,'Sconet Eleves');   //
			//// fb::info($this->classes,'Sconet Classes'); //
			/////////////////////////////////////////////////////////////////////////////////////
		elseif($rne):
			$this->RNE = $rne;
			$this->eleves = $this->modele->sconetEleves($rne);
			$this->classes = $this->modele->sconetClasses($rne);
			//////////////////// debug //////////////////////////////////////////////////////////
			//// ob_start(); require_once(_ROOT_.'/FirePHPCore/fb.php'); FB::setEnabled(true); //
			//// fb::info($this->eleves,'Sconet Eleves');   //
			//// fb::info($this->classes,'Sconet Classes'); //
			/////////////////////////////////////////////////////////////////////////////////////
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $this );	
	}
	
	/**
	* Retourne le tableau des lves de la classe depuis la base de donnes [ id => [ nom, prenom, classe, rne, sexe] ]
	* @see $modele->sconetEleves
	* @param string $classe
	* @return array
	*/
	public function elevesDeLaClasse($classe){
		$args = get_defined_vars();

		$ret = $this->modele->sconetEleves($this->RNE, $classe);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}
	
	/**
	* Retourne le tableau des lves de la classe depuis le fichier XML [ id => [ nom, prenom, classe, rne, sexe, naissance] ]
	* @see $modele->sconetEleves
	* @param string $classes 
	* @return array
	*/
	private function toArray(){
		$args = get_defined_vars();

		$U = array();
		$utilisateurs = $this->XPATH->query("//utilisateur");
		foreach($utilisateurs as $utilisateur){
			$E = array("rne" => $this->RNE);
			$A = $this->XPATH->query("@*", $utilisateur)->item(0);
			$id = $E[$A->name] = $A->value;
			$D = $this->XPATH->query("*", $utilisateur);
			foreach( $D as $d){
				if($d->nodeName == 'naissance') :
					$d->nodeValue = implode("-",array_reverse(explode("/",$d->nodeValue)));
				endif;
				$E[$d->nodeName] = $d->nodeValue;
			}
			$U[$id] = $E;
		}
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $U );	
		return $U;
	}
	
	/**
	* Insre les lves et les classes dans la base de donnes
	*
	* Vide les tables au pralable
	*
	* TRANSACTION - Ncessite que le moteur de stockage des tables Sconet soient en InnoDB
	*
	* @see $modele->PDO, $modele->videTableSconet
	* @param boolean $debug 
	* @return string
	* 
	*/
	public function toMySQL($debug = false){
		$args = get_defined_vars();

		$html = "<h1>".$this->RNE."</h1>";
		if($debug) $html .= "<h2 class='debug'>Mode debuggage - Les requ&ecirc;tes ne sont pas ex&eacute;cut&eacute;es</h2>";
		// Gestionnaire d'erreur en mode exception
		$this->modele->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->modele->PDO->beginTransaction();
		try { // on essaye ...
		 	$this->modele->videTablesSconet($this->RNE);
			foreach($this->eleves as $E){
				$E['login'] = $this->getLogin($E['prenom'], $E['nom']);
				$html .= $this->modele->store($E, 'sconet');
				$html .= $debug?"<hr/>":"";
			}
			foreach($this->classes as $c){
				$C = array('classe' => $c, 'rne'=>$this->RNE);
				$html .= $this->modele->store($C,'sconet_classes');
				$html .= $debug?"<hr/>":"";
			}
			// tout s'est bien pass ! on valide :
			$this->modele->PDO->commit();
			// sinon une exception a eu lieu ...
		}
		catch(Exception $e){
			// ... on annule les modifications
			$this->modele->PDO->rollBack();
			$html .= utf8_encode("<h2 class='erreur'>La base SCONET n'a pu tre mise  jour !</h2>");
			$html .= utf8_encode("<p class='ui-state-error'>".$e->getMessage()."</p>");
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $html );	
		return $html;	
	}
	
	/**
	* Tableau des eleves sortants
	* Difference $this->elevesEtablissement - $this->eleves
	*
	* @return array
	*/
	private function elevesAnciens(){
		$args = get_defined_vars();

		$Ei = $this->modele->sconetEleves($this->RNE);
		$Ef = $this->eleves;
		$ret = array_diff_key($Ei,$Ef);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}

	/**
	* Insre les lves et les classes dans la base de donnes
	* Gestion de l'intgrit des tables
	* Version 2 de la mthode toMySQL
	*
	* TRANSACTION - Ncessite que le moteur de stockage des tables Sconet soient en InnoDB
	*
	* @see $modele->PDO, $modele->videTableSconet
	* @param boolean $debug 
	* @return string
	* 
	*/

	public function toMySQL2(){
		$args = get_defined_vars();

		$html = ""; /*"<h1>".$this->RNE."</h1>";*/ 
		// Gestionnaire d'erreur en mode exception
		$this->modele->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->modele->PDO->beginTransaction();
		try { // on essaye ...
		 	//$this->modele->videTablesSconet($this->RNE);
			foreach($this->eleves as $E){
				$E['login'] = $this->getLogin($E['prenom'], $E['nom']);
				$E['id_sconet'] = $E['id'];
				$html .= $this->modele->storeEleve($E, 'sconet');
				$html .= $this->modele->storeEleveSiBalado($E, 'eleves');
			}
			foreach($this->classes as $c){
				$C = array('classe' => $c, 'rne'=>$this->RNE);
				$html .= $this->modele->storeClasse($C,'sconet_classes');
			}
			foreach($this->elevesAnciens() as $id => $A){
				$html .= $this->modele->ancienEleve($id, $A, 'sconet');	
			}
			/* Parcourir l'ensemble des classes et faire le mnage si besoin
			Pour toutes les classes Sconet : */
			$classes = $this->modele->sconetClasses($this->RNE);
			foreach($classes as $c){
				$C = array('classe' => $c, 'rne'=>$this->RNE);
				$html .= $this->modele->siVideAlorsSupprime($C);
			}
		// tout s'est bien pass ! on valide :
			$this->modele->PDO->commit();
			// sinon une exception a eu lieu ...
		}
		catch(Exception $e){
			// ... on annule les modifications
			$this->modele->PDO->rollBack();
			$html .= utf8_encode("<h2 class='erreur'>La base SCONET n'a pu tre mise  jour !</h2>");
			$html .= utf8_encode("<p class='ui-state-error'>".$e->getMessage()."</p>");
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $html );	
		return $html;	
	}
	
	/**
	* Retourne une chaine normalisee (pas d'accent, pas d'espace, pas de quot,...) de longueur maximale donne
	* @param string $string
	* @param int $long = 50
	* @return string
	*/
	
	/* OLD
	private function normalize ($string, $long = 50) {
    	$swap = array(""=>"C", "'"=>"", " "=>"", "-"=>"", ""=>"E", ""=>"E"); // En faire la liste ...
    	return substr(strtolower(strtr(utf8_decode($string), $swap)),0,$long);
	}*/

	private function normalize ($string, $long = 50) {
		$args = get_defined_vars();

    	$string=strtolower($string);
		$old="-'";
		$new="aaaaaaceeeeiiiinooooouuuuyy000";	
		$string=str_replace(' ','',$string);
		$string=substr(strtolower(strtr($string,$old,$new)),0,$long);
		$string=str_replace('0','',$string);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $string );	
		return $string;
	}

	/**
	* Retourne le login d'un eleve pnom unique
	* @param string $prenom
	* @param string $nom
	* @param int $i
	* @return string
	*/

	private function getLogin($prenom,$nom){
		$args = get_defined_vars();

		$nom = $this->normalize ($nom, 10);
		$login = strtolower($prenom[0].$nom);
		$sql= "SELECT login  FROM (";
		$sql.="SELECT login FROM sconet where rne='".$this->RNE."' ";
		$sql.=" UNION ";
		$sql.=" SELECT login FROM profs ) AS temp1 where login LIKE '".$login."%'";
		$trouve = false;
		
		$res = $this->modele->PDO->query($sql);
		$dat = $res->fetchAll(PDO::FETCH_ASSOC);
		$tab_login[] = 0;
		
		foreach ($dat as $log) {
			$trouve = true;
			$num = str_replace($login,'',$log["login"]);
			$tab_login[] = $num;
		}
		if($trouve){
			$max = max($tab_login)+1;
			$ret = $login.$max;
		}
		else{
			$ret = $login;
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	} 
	
	private function getLoginOLD($prenom,$nom,$i=0){
		$args = get_defined_vars();

		//$login = $this->normalize($prenom[0].$nom,8).(($i!=0)?$i:"");
		//$sql = "SELECT COUNT(*) as n FROM sconet WHERE login = '".$login."'";
		$login = $this->normalize($prenom[0].$nom,8);
	
		$sql = "SELECT COUNT(*) as n FROM (
					SELECT DISTINCT login FROM (
						SELECT login FROM eleves UNION SELECT login FROM profs
					) AS temp1 WHERE login LIKE '".$login."%'
				) AS temp2";
				
		$res = $this->modele->PDO->query($sql);
		$dat = $res->fetchAll(PDO::FETCH_OBJ);
		/*if($dat[0]->n!=0){
			$i++;
			$login = $this->getLogin($prenom,$nom,$i);
		}*/
		$i = $dat[0]->n!=0?$dat[0]->n:"";
		return $login.$i;
	}
		
	/**
	* Retourne le tableau des classes depuis le fichier XML [ classe, rne ]
	* @return array
	*/
	public function extractClassesToArray(){
		$args = get_defined_vars();

		$U = array();
		$classes = $this->XPATH->query("//classe");
		foreach($classes as $classe){
			$U[] = $classe->nodeValue;
		}
		$ret = array_unique($U);

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );	
		return $ret;
	}

		
}

?>