<?php  // $Id: sconetModele.php 401 2011-10-14 15:52:13Z fl $
/**
 * MODLE DE DONNES
 * 
 * Extension 
 *  
 * @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
 * @author Franois L. <FL@ac-creteil.fr>
 * @version 0.9
 * @package SCONET
 * @subpackage Modeles
 */

/* TEST 
ELEVES CARTABLES
CLASSE;NOM;PRENOM;LOGIN;MOT DE PASSE;NUMERO ELEVE;INE;
3g;BEN MAAMER;Sirine;sbenmaamer;(dj attribu);3912;2409037267U;
3d;BOUTTEVILLE;Anais;aboutteville;(dj attribu);3916;2409055768D;
3c;GAYDU;Tracy;tgaydu;(dj attribu);3942;2409055674B;
3d;LAURIANO MARQUES;Marwin;mlauriano;(dj attribu);3955;2409055724F;
3g;SAKOUHI;Lina;lsakouhi;(dj attribu);3975;2409055775L;
3e;DECLUSEAUX;Guillaume;gdecluseaux;(dj attribu);3999;2409017042K;
3e;GUER;Valentin;vguer;(dj attribu);3944;2409055695Z;
3c;FORTIN;Axel;afortin;(dj attribu);3936;2409055761W;

TRUNCATE classes; TRUNCATE eleves; TRUNCATE profs_classes; TRUNCATE profs_groupes; TRUNCATE sconet; TRUNCATE sconet_classes; 
*/
class sconetModele extends Modele{
		
	var $table = "sconet";
	var $tables = array('classes');
	
	public function testAjax($datas){
		ob_start();
		echo "<pre>";
		print_r($datas);
		echo "</pre>";
		$ob = ob_get_contents();
		ob_end_clean();
		return utf8_encode($ob);
	}

	public function store($T, $_table = null, $execute = true){ // $T : tableau des champs de donnes
		$args = get_defined_vars();

		$table = $_table?$_table:$this->table;
		$html = ""; $id = isset($T['id'])?$T['id']:0; // unset($T['id']);	
		if($this->exist($id, $_table)) :
			unset($T['id']);
			//$T = array_map("stripslashes", $T);
			$U = array(); 
			foreach( $T as $k => $v){
				$U[] = $k." = '".addslashes($v)."'";
			}
			$sql = "UPDATE ".$table." SET ".implode(",", $U)." WHERE id=".$id;
			$ajout = false;
		else :	
			$T = array_map("addslashes", $T);
			$champs = array_keys($T);
			$sql = "INSERT INTO ".$table." (".implode(",", $champs).") VALUES ('".implode("','",$T)."')"; 
		endif;
		
		if($execute) :
			$ret = $this->execute(utf8_decode($sql));
			if($ret=="") :
				$retour = "<p class='erreur'>".$sql."</p>"; 
			else :
				$retour = "<p class='succes'>".implode("|",$T)."</p>";	
			endif;
		else:
			$retour = "<p class='noexec'>".$sql."</p>";			
		endif;
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $retour);
		return $retour;
	}

	private function idEleve( $id_sconet ){ 
		$args = get_defined_vars();
		
		$sql = "SELECT id FROM eleves WHERE id_sconet=$id_sconet";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$return = $dat[0]->id;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return);
		return $return;
	}

	private function idSconetEleve( $id ){
		$args = get_defined_vars();
		
		$sql = "SELECT id_sconet FROM eleves WHERE id=$id";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$return = $dat[0]->id_sconet;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return);
		return $return;
	}

	private function eleve( $id_sconet ){
		$args = get_defined_vars();
		
		$sql = "SELECT * FROM eleves WHERE id_sconet='$id_sconet'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$return = $dat[0];

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return);
		return $return;
	}

	private function idClasse( $rne, $classe ){
		$args = get_defined_vars();
		
		// Est-ce une classe balado ?
		$sql = "SELECT id FROM classes WHERE rne='$rne' AND classe='$classe'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$bid = $dat[0]->id;
		$return = $bid?$bid:0;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return);
		return $return;
	}
	
	public function ancienEleve($id, $A, $_table = null, $execute = true){
		$args = get_defined_vars();
		
		$br = "<br/>"; $archive = "_";
		// Changer le nom de la classe : _classe dans la table sconet
		//if( 0 !== strpos( $A['classe'], $archive ) ):
		if( $A['actif'] ):
			//$sql = "UPDATE sconet SET classe ='".$archive.$A['classe']."' WHERE id =".$id;
			$sql = "UPDATE sconet SET actif ='0' WHERE id =".$id; $return = $sql;
			$this->execute($sql); $return = $sql;
			// Dans la table eleves
			$sql = "UPDATE eleves SET id_classe ='-".$this->idClasse($A["rne"], $A["classe"])."' WHERE id_sconet ='".$id."'";
			$this->execute($sql); $return .= '\n'.$sql;
			// Retirer l'eleve d'un groupe eventuel
			$sql  = "DELETE FROM eleves_groupes WHERE id_eleve='".$this->idEleve($id)."'";
			$this->execute($sql); $return .= '\n'.$sql;
			__LXF__(__CLASS__."::".__FUNCTION__, $args, $return);

			// Information en retour
			$retour = "<p class='supprime'><span>&Eacutel&egrave;ve sortant : </span>".$A['nom']." ".$A['prenom']." <span class='classe'>".$A['classe']."</span></p>";	
			return utf8_encode($retour);
		endif;
		$return = false;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return);
		return false;
	}
	
	public function updateSQL($eleve){
		$args = get_defined_vars();

		// $eleve : rne, classe, nom, prenom, login, id_cas | classe, naissance, sexe, id
		$idClasse = $this->idClasse($eleve['rne'], $eleve['classe']); 
		//$eleve['id_classe'] = $idClasse?$idClasse:0;
		
		$idSconet = $eleve['id']; unset($eleve['id']); unset($eleve['classe']); /*unset($eleve['naissance']);*/ unset($eleve['sexe']); unset($eleve['login']); 
		if(!isset($eleve['id_cas'])) { $eleve['id_cas'] = 0; }
		$E = array();
		foreach( $eleve as $k => $v){
				$E[] = $k." = '".addslashes($v)."'";
			}
		$sql = "UPDATE eleves SET ".implode(",", $E)." WHERE id_sconet = ".$idSconet;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		return $sql;	
	}

	public function insertSQL($eleve){
		$args = get_defined_vars();

		// Cryptage du mot de passe
		$cryptage = "MD5"; $mdp = date("dmy", strtotime($eleve['naissance']));

		$idClasse = $this->idClasse($eleve['rne'], $eleve['classe']); 
		$eleve['id_classe'] = $idClasse?$idClasse:0;
		$eleve['id_sconet'] = $eleve['id']; unset($eleve['id']);
		if(!isset($eleve['id_cas'])) { $eleve['id_cas'] = 0; }
		
		unset($eleve['classe']); /*unset($eleve['naissance']);*/ unset($eleve['sexe']);
		$eleve = array_map("addslashes", $eleve); $champs = array_keys($eleve);
		$sql = "INSERT INTO eleves (".implode(",", $champs).", mdp) VALUES ('".implode("','",$eleve)."', ".$cryptage."('".$mdp."'))";

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		return $sql;
	}
	
	public function storeEleveSiBalado($E, $_table = null, $execute = true){
		$args = get_defined_vars();
		
		if( isset($E['id_sconet']) and 0==$E['id_sconet']):
			unset($E['id_sconet']);
		endif;

		$br="<br/>";
		// Classe
		$rne = $E['rne']; $classe = $E['classe'];
		// Eleve
		$idSconet = $E['id']; $id = $this->eleve($idSconet)->id; 
		// Balado
		$idClasse = $this->idClasse($rne, $classe);
		$idClasse = $idClasse?$idClasse:( - $this->eleve($idSconet)->id_classe );

		if($idClasse and $id) :
			$E['id_classe'] = $idClasse;
			$sql = $this->updateSQL($E);
		elseif($idClasse and !$id):
			$sql = $this->insertSQL($E);
		endif;
		if($execute and isset($sql)) :
			$this->execute($sql);
			//$retour = ($ret=="")?("<p class='erreur'>".$sql."</p>"):"";
		elseif(isset($sql)) :
			$retour = "<p class='debug'>".$sql."</p>";	
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		return $retour;
	}

	public function storeEleve($T, $_table = null, $execute = true){ // $T : tableau des champs de donnes
		$args = get_defined_vars();
		
		if( isset($T['id_sconet']) and 0==$T['id_sconet']):
			unset($T['id_sconet']);
		endif;

		$table = $_table?$_table:$this->table; $br="<br/>";
		$id = isset($T['id'])?$T['id']:0; $ajout = true; // unset($T['id']);	
		if($this->exist($id, $_table)) :
			unset($T['id']); unset($T['login']); $T['actif'] = 1;
			//$T = array_map("stripslashes", $T);
			$U = array(); 
			foreach( $T as $k => $v){
				$U[] = $k." = '".addslashes($v)."'";
			}
			$sql = "UPDATE ".$table." SET ".implode(",", $U)." WHERE id=".$id;
			// Dtecter une non affectation
			$ajout = $this->horsClasse($id)?true:false;
		else :	
			$T = array_map("addslashes", $T);
			$champs = array_keys($T);
			$sql = "INSERT INTO ".$table." (".implode(",", $champs).") VALUES ('".implode("','",$T)."')"; 
		endif;
		
		if($execute) :
			$modif = $this->execute($sql);
			$retour = $ajout?("<p class='ajoute'><span>Nouvel &eacute;l&egrave;ve : </span>".$T['nom']." ".$T['prenom']." <span class='classe'>".$T['classe']."</span></p>".$html):($modif?"<p class='ajoute'><span>Maj. &eacute;l&egrave;ve : </span>".$T['nom']." ".$T['prenom']." <span class='classe'>".$T['classe']."</span></p>":"");	
		else:
			$retour = "<p class='noexec'>".$sql."</p>";			
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		return $retour;
	}

	public function storeClasse($C, $_table = null, $execute = true){ 
		$args = get_defined_vars();

		// $C : tableau des champs de donnes : 'rne', 'classe'
		$table = $_table?$_table:$this->table; $retour="";
		if(!$this->existChamps($C, $_table) and $execute) :
			$C = array_map("addslashes", $C);
			$champs = array_keys($C);
			$sql = "INSERT INTO ".$table." (".implode(",", $champs).") VALUES ('".implode("','",$C)."')"; 
			$this->execute($sql);
			$retour = "<p class='ajoute'><span>Nouvelle classe : </span><span class='classe'>".$C['classe']."</span></p>";	
		/* 	LES CLASSES EXTRAITES DE SCONET NE SONT PAS VIDES PAR DEFINTION
			IL FAUT PROCEDER A UNE DIFFERENCE !!! ////////////////////////////////////////////////////////////////////////////////////
		else: 	
			// Si la classe est vide
			if(!$this->classeNonVide($C)):
				$rne = $C['rne']; $classe = $C['classe'];
				$idClasse = $this->idClasse($rne,$classe);
			// La supprimer dans sconet_classes :
				$sql = "DELETE FROM sconet_classes WHERE rne='$rne' AND classe='$classe'";
				//$this->execute($sql);
			// dans classes :	
				$sql = "DELETE FROM classes WHERE rne='$rne' AND classe='$classe'";
				//$this->execute($sql);
			// dans profs_classes :	
				$sql = "DELETE FROM profs_classes WHERE id_classe='$idClasse'";
				//$this->execute($sql);
			// dans partages :	
				$sql = "DELETE FROM partages WHERE id_ensemble='$idClasse' AND type_ensemble='classe'";
				//$this->execute($sql);
				//$retour = "<p class='succes'><span>Classe supprim&eacute;e: </span><span class='classe'>".$C['classe']."</span></p>";
			endif;
			// $retour = "<p class='succes'>blurp: ".$this->classeVide($C)."</p>";
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/	
		endif;
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );

		return $retour;
	}
	
	public function siVideAlorsSupprime($C){
		$args = get_defined_vars();
		
		$retour = "";
		if(!$this->classeNonVide($C)):
			$rne = $C['rne']; $classe = $C['classe'];
			$idClasse = $this->idClasse($rne,$classe);
		// La supprimer dans sconet_classes :
			$sql = "DELETE FROM sconet_classes WHERE rne='$rne' AND classe='$classe'";
			$this->execute($sql); $return = $sql;
		// dans classes :	
			$sql = "DELETE FROM classes WHERE rne='$rne' AND classe='$classe'";
			$this->execute($sql); $return .= '\n'.$sql;
		// dans profs_classes :	
			$sql = "DELETE FROM profs_classes WHERE id_classe='$idClasse'";
			$this->execute($sql); $return .= '\n'.$sql;
		// dans partages :	
			$sql = "DELETE FROM partages WHERE id_ensemble='$idClasse' AND type_ensemble='classe'";
			$this->execute($sql); $return .= '\n'.$sql;

			$retour = "<p class='supprime'><span>Classe supprim&eacute;e: </span><span class='classe'>".$C['classe']."</span></p>";
		endif;
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );	
		return $retour;	
	}

	public function sconetEleves($rne, $classe=null){
		$args = get_defined_vars();

		$donnees = array(); $E = array(); $nid = array('id' => null);
		$donnees['conditions'] = "rne='$rne'".($classe?" AND classe='$classe' AND actif=1":"" );
		$donnees['ordre'] = "classe ASC, nom ASC";
		//$donnees['limite'] = "0,5";
		$eleves = $this->select($donnees);
		foreach($eleves as $eleve){
				$E[$eleve['id']] = array_diff_key($eleve, $nid);
		}
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $E );	
		return $E;	
	}

	public function sconetClasses($rne){
		$args = get_defined_vars();

		$donnees = array(); $C = array(); $nid = array('id' => null);
		$donnees['conditions'] = "rne='$rne'";
		$donnees['ordre'] = "classe ASC";

		if( $this->nonvide('sconet_classes') ) {
			$classes = $this->select($donnees, 'sconet_classes');
			foreach($classes as $classe){
				if( $this->classeNonVide($classe) ):
					$C[] = $classe['classe'];
				endif;
			}
		} else {
			$donnees['champs'] = "DISTINCT classe, rne"; 
			$classes = $this->select($donnees);

			foreach($classes as $classe){
				$this->store($classe, 'sconet_classes');
				$C[] = $classe['classe'];
			}			
		}

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $C );	
		return $C;
	}
	
	public function eleveChangeClasse($classe, $idEleve, $rne){
		$args = get_defined_vars();

		$retour = ""; $br="<br/>";	
		
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		// Dbuter la transaction 
		$this->PDO->beginTransaction();
		try { // on essaye ...

			// Sconet
			$sql = "UPDATE ".$this->table." SET classe = '$classe' WHERE id=".$idEleve; //return $sql;
			$this->execute(utf8_decode($sql)); $return = $sql;

			// Eleves
			// ancienne classe balado ? |  nouvelle classe balado ?
			// 1 | 1 => update. eleves.id_classe
			// 1 | 0 => delete eleves.id_classe ou update -|eleves.id_classe|
			// 0 | 1 => insert 
			// 0 | 0 => nothing
		
			$eleve = $this->eleve($idEleve);
			$idClasse = $this->idClasse($rne, $classe);
			// Si l'eleve existe dans la table eleves
			if($eleve->id){
			//  Si sa nouvelle classe est une classe Balado
				if($idClasse){
				// update eleves.id_classe
				$sql = "UPDATE eleves SET id_classe='".$idClasse."' WHERE id = ".$eleve->id; // OK
				//	Sinon
				} else {
				//	update -|eleves.id_classe|
				$sql = "UPDATE eleves SET id_classe='-".abs($eleve->id_classe)."' WHERE id = ".$eleve->id; // OK
				}
				$this->execute(utf8_decode($sql)); $return .= '\n'.$sql;
			// Sinon
			} elseif($idClasse){
			//	Si sa nouvelle classe est une classe Balado
			//		insert 
				$eleve = $this->get($champs = "*", $idEleve);
				$sql = $this->insertSQL($eleve);
				$this->execute(utf8_decode($sql)); $return .= '\n'.$sql;
			} 
			// Sinon rien

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
			// tout s'est bien pass ! on valide :
			return $this->PDO->commit();
			
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$return = $sql.$br.$e->getMessage();
			
			__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
			return $return;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
		
	}

	public function nonVide($rne, $_table=""){
		$args = get_defined_vars();

		$table = $this->table.$_table;
		$sql = "SELECT COUNT(*) as n FROM ".$table;
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$return = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
		return $return;
	}

	public function classeNonVide($C){
		$args = get_defined_vars();

		$sql = "SELECT COUNT(*) as n FROM sconet WHERE rne='".$C['rne']."' AND classe='".$C['classe']."' AND actif=1";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$return = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
		return $return;
	}
	
	private function archiveSconet($rne){
		$args = get_defined_vars();

		// supprimer les enregistrements o rne=$rne
		$sql = "DELETE FROM ".$this->table."_archive WHERE rne='".$rne."'";
		if ($this->execute($sql)!=""):
			echo "ok!";
		else:
			echo "ko!";
		endif;
		
		__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
		// extraire les enregistrements	de la sconet o rne=$rne
		// les copier dans sconet_archives 
	}
	
	private function videTablesSconet($rne){
		$args = get_defined_vars();

		if($this->nonVide($rne)) :
			$sql  = "DELETE FROM ".$this->table." WHERE rne='".$rne."'";
			$this->execute($sql); $return = $sql;
			$sql = "DELETE FROM ".$this->table."_classes WHERE rne='".$rne."'";
			$this->execute($sql); $return .= '\n'.$sql;
			__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
		else :
			__LXF__(__CLASS__."::".__FUNCTION__, $args, true );
			return true;
		endif;
	}
	
	private function horsClasse($idSconet){
		$args = get_defined_vars();

		//$sql = "SELECT COUNT(*) as n FROM sconet WHERE id='$idSconet' AND classe LIKE '\_%'";
		$sql = "SELECT COUNT(*) as n FROM sconet WHERE id='$idSconet' AND actif='0'";
		$req = $this->PDO->query($sql);
		$dat = $req->fetchAll(PDO::FETCH_OBJ);
		$ret = $dat[0]->n;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $ret );
		return $ret;
	}
	
	public function reinitMotDePasse($idEleve){
		$args = get_defined_vars();

		// Dbuter la transaction  /////////////////////////////////////////////////////////////////
		$this->PDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$this->PDO->beginTransaction();
		try { // on essaye ...
			$eleve = $this->eleve($this->idSconetEleve($idEleve));
			$cryptage = "MD5"; $mdp = date("dmy", strtotime($eleve->naissance));	
			$sql = "UPDATE eleves SET mdp = $cryptage('".$mdp."') WHERE id=$idEleve"; 
			$this->execute($sql);
			// tout s'est bien pass ! on valide :
			$this->PDO->commit();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $sql );
			return $sql;
		} // sinon une exception a eu lieu ...
		catch(Exception $e){
			// ... on annule les modifications
			$this->PDO->rollBack();
			$return = $sql.$br.$e->getMessage();

			__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
			return $return;
		}
		// FIN DE LA TRANSACTION /////////////////////////////////////////////////////////////////////
	}

	public function verifieCSV($entetes, $champsNecessaires = array('Identifiant', 'Sconet', 'Nom', 'Prenom', 'Classe') ){
		$args = get_defined_vars();

		// controler l'existance des champs : Identifiant (id_cas) , Sconet (id), Nom (nom), Prenom (prenom), Classe (classe)

		$champsNecessaires = array_diff( array_merge($entetes, $champsNecessaires), $entetes);
		if ( count($champsNecessaires) ):
			$return =  array('errChampsManquants' => $champsNecessaires);
		else:
			$return =  array_flip($entetes);
		endif;

		__LXF__(__CLASS__."::".__FUNCTION__, $args, $return );
		return $return;
	}

}

?>