<?php // $Id: upload.php 61 2011-07-06 21:17:44Z fl $
/**
* UPLOAD
* 
* Tlchargement d'un fichier compress .zip, extraction, traitement 
*  
* @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
* @author Franois L. <FL@ac-creteil.fr>
* @version 0.9
* @package SCONET
* @subpackage Upload
*/

/** 
* Dtermination des "racines" depuis un niveau
* @param String $url 
* @param Integer $niveau profondeur / rpertoire racine de l'appli balado
*/
function remonte($url, $niveau){ 
	$tab = explode("/", $url);
	array_splice( $tab, count($tab)-1-$niveau);
	return implode("/",$tab);	 
}
// ici, dans: /sconet/sconetUpload => niveau = 2 ////////
$niveau = 2;
define('_HOST_',$_SERVER['HTTP_HOST']); 
define('_WEBROOT_',remonte($_SERVER['SCRIPT_NAME'],$niveau)); 
define('_ROOT_',remonte($_SERVER['SCRIPT_FILENAME'],$niveau)); 
/////////////////////////////////////////////////////////
require(_ROOT_."/controler/commun.lib.php"); // Objet F (fonctions commnunes)
require(_ROOT_."/pclzip/pclzip.lib.php");
require(_ROOT_.'/imports/connexion.php');
require(_ROOT_.'/imports/modele.php');
require(_ROOT_.'/imports/sconet.php');

$extensions = array('.zip');
$msg = "";
$debug = false;
$rne = isset($_POST['rne'])?$_POST['rne']:'';
$classe = isset($_POST['classe'])?$_POST['classe']:'';

if(isset($_FILES['fichier']))
	{
		$fichier = $_FILES['fichier'];
		
		$nom_fichier = basename($fichier['name']);
		//$suf_fichier = strstr($fichier['name'],'.');
		$suf_fichier = substr($fichier['name'],0,strpos($fichier['name'],'.'));
		$ext_fichier = strtolower(strstr($fichier['name'], '.')); 

		//Dbut des vrifications de scurit...
		if(!in_array($ext_fichier, $extensions)): 
			$msg =  "<span class='erreur'>Archive <em>.zip</em> attendu !</span>"; 
			echo '{"reponse":"'.$msg.'"}';
			return false;
		else: 	 
			$xml = ($ext_fichier == ".zip")?$nom_fichier:(_ROOT_."/sconetXML/xml/".$nom_fichier);
			//$trace = $fichier['tmp_name'];
			// TELECHARGEMENT 
			if(@move_uploaded_file($fichier['tmp_name'], $xml)) :
				if($ext_fichier == ".zip") {
					// DEZIP ventuel
					$zip = new PclZip($xml);
					//$zip->extract(PCLZIP_OPT_PATH, ROOT."sconet/xml", PCLZIP_OPT_REMOVE_PATH, $xml);
					$xml = $zip->extract(PCLZIP_OPT_EXTRACT_AS_STRING, PCLZIP_OPT_REMOVE_PATH, $xml);
					$xml = $xml[0]['content']; 
					//echo "{ 'reponse' : '".addslashes($xml)."' }";
					//exit;
				}
				// MODELE de donnes
				$sconet = Modele::chargement('sconetModele');

				// OBJET SCONET
				// $sconetXML = new SCONET(ROOT.'sconet/xml/'.$suf_fichier.'.xml', $sconet, $classe);
				$sconetXML = new SCONET($xml, $sconet, $classe);
				if(isset($sconetXML->RNE) and ($sconetXML->RNE == $rne) ):
					// TRANSFERT XML -> MySQL
					$msg = stripslashes($sconetXML->toMySQL2());
					//$classes = implode(", ", $sconetXML->extractClassesToArray());
					echo '{ "reponse":" '.$msg.'"}';
					return false;
				elseif ($sconetXML->RNE != $rne):
					$msg = utf8_encode("<span class='erreur'>Vous n'tes pas connect en tant qu'administrateur de l'tablissement :<br />". $sconetXML->RNE."</span>"); 
					echo '{ "reponse":"'.$msg.'"}';
					return false;									
				else:
					$msg = "<span class='erreur'>Fichier <em>SCONET</em> attendu !</span>"; 
					//$msg = $sconetXML->RNE;
					echo '{ "reponse":"'.$msg.'"}';
					return false;				
				endif;	
			endif;	
			$msg  = "Impossible de t&eacute;l&eacute;charger le fichier !";
			echo '{ "reponse":"'.$msg.'"}';	
		endif;
	}

?>