<?xml version="1.0" encoding="UTF-8"?>
<!-- $Id: extraction-eleves.xsl 28 2011-06-01 14:56:00Z fl $ -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="UTF-8" doctype-system="../utilisateurs.dtd"/>

  <xsl:param name="start"></xsl:param>
  <xsl:variable name="rne" select="//PARAMETRES/UAJ" />
  <xsl:key name="CLASSE" match="STRUCTURES_ELEVE" use="@ELEVE_ID"/>
  
  <xsl:template name="trim">
    <xsl:param name="S"/>
    <xsl:value-of select="translate($S,' ','')"></xsl:value-of>
  </xsl:template>
  
  <xsl:template match="BEE_ELEVES">
    <xsl:variable name="CS"><xsl:call-template name="code_structure"><xsl:with-param name="EID" select="@ELEVE_ID"/></xsl:call-template></xsl:variable>
    <utilisateurs n="{count(//ELEVE[not(DATE_SORTIE)][CODE_MEF])}" rne="{$rne}">
      <xsl:apply-templates select="//ELEVE"/>
    </utilisateurs>
  </xsl:template>
  
  <xsl:template match="//ELEVE">
  	<xsl:variable name="CS"><xsl:call-template name="code_structure"><xsl:with-param name="EID" select="@ELEVE_ID"/></xsl:call-template></xsl:variable>
      <xsl:if test="key('CLASSE',@ELEVE_ID) and not(DATE_SORTIE) and starts-with($CS,$start)">    
      <xsl:variable name="identifiant" select="concat(translate(NOM,'   ',''),translate(PRENOM,'   ',''),translate(DATE_NAISS,'\/   ',''))"/>
      <utilisateur id="{@ELEVE_ID}">
        <xsl:apply-templates select="NOM"/>
        <xsl:apply-templates select="PRENOM"/>
        <xsl:apply-templates select="DATE_NAISS"/>
        <xsl:apply-templates select="CODE_SEXE"/>
        <xsl:apply-templates select="@ELEVE_ID"/>
        </utilisateur>
      </xsl:if>
  </xsl:template>
  
  <xsl:template match="NOM">
    <nom><xsl:value-of select="."/></nom>
  </xsl:template>
  
  <xsl:template match="PRENOM">
    <prenom><xsl:value-of select="."/></prenom>
  </xsl:template>

  <xsl:template match="DATE_NAISS">
    <naissance><xsl:value-of select="."/></naissance>
  </xsl:template>
  
  <xsl:template match="CODE_SEXE">
    <sexe>
    	<xsl:choose>
    	<xsl:when test=".=1">M</xsl:when>    	
    	<xsl:when test=".=2">F</xsl:when>
    	<xsl:otherwise>E</xsl:otherwise>
    	</xsl:choose>
    </sexe>
  </xsl:template>

  <xsl:template match="DOUBLEMENT">
    <doublement><xsl:value-of select="."/></doublement>
  </xsl:template>
  
  <xsl:template match="ID_NATIONAL">
    <ine><xsl:value-of select="."/></ine>
  </xsl:template>

  <xsl:template name="code_structure">
  	<xsl:param name="EID"/>
  	<xsl:call-template name="trim"><xsl:with-param name="S" select="key('CLASSE',$EID)/STRUCTURE[1]/CODE_STRUCTURE"/></xsl:call-template>
  </xsl:template>

  <xsl:template match="@ELEVE_ID">
    <classe><xsl:call-template name="trim"><xsl:with-param name="S" select="key('CLASSE',.)/STRUCTURE[1]/CODE_STRUCTURE"/></xsl:call-template></classe>
  </xsl:template>
</xsl:stylesheet>
