<?php // $Id: uploadCSV.php 399 2011-10-12 15:22:35Z fl $
/**
* UPLOAD
* 
* Tlchargement d'un fichier compress .zip, extraction, traitement 
*  
* @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
* @author Franois L. <FL@ac-creteil.fr>
* @version 0.9
* @package LILIE
* @subpackage Upload
*/

/** 
* Dtermination des "racines" depuis un niveau
* @param String $url 
* @param Integer $niveau profondeur / rpertoire racine de l'appli balado
*/
function remonte($url, $niveau){ 
	$tab = explode("/", $url);
	array_splice( $tab, count($tab)-1-$niveau);
	return implode("/",$tab);	 
}
// ici, dans: /sconet/sconetUpload => niveau = 2 ////////
define('_HOST_',$_SERVER['HTTP_HOST']); 
define('_WEBROOT_',remonte($_SERVER['SCRIPT_NAME'],1)); 
define('_ROOT_',remonte($_SERVER['SCRIPT_FILENAME'],1)); 
/////////////////////////////////////////////////////////
require(_ROOT_."/controler/commun.lib.php"); // Objet F (fonctions commnunes)
require(_ROOT_."/pclzip/pclzip.lib.php");
require(_ROOT_.'/imports/connexion.php');
require(_ROOT_.'/imports/modele.php');
require(_ROOT_.'/imports/lilie.php');

$extensions = array('.csv');
$msg = "";
$debug = false;
$rne = isset($_POST['rne'])?$_POST['rne']:'';
$classe = isset($_POST['classe'])?$_POST['classe']:'';

if(isset($_FILES['fichier']))
	{
		__LXF__("__UPLOAD__CSV__", $_FILES );

		$fichier = $_FILES['fichier'];
		
		$nom_fichier = basename($fichier['name']);
		//$suf_fichier = strstr($fichier['name'],'.');
		$suf_fichier = substr($fichier['name'],0,strpos($fichier['name'],'.'));
		$ext_fichier = strtolower(strstr($fichier['name'], '.')); 

		//Dbut des vrifications de scurit...
		if(!in_array($ext_fichier, $extensions)): 
			$msg =  "<span class='erreur'>Fichier <em>".implode($extensions,", ")."</em> attendu !</span>"; 
			echo '{"reponse":"'.$msg.'"}';
			return false;
		else: 	 
			$csv = ($ext_fichier == ".zip")?$nom_fichier:(_ROOT_."/lilie/csv/".$nom_fichier);
			$trace = $fichier['tmp_name'];
			// TELECHARGEMENT 
			if(@move_uploaded_file($fichier['tmp_name'], $csv)) :
				if($ext_fichier == ".zip") {
					// DEZIP ventuel
					$zip = new PclZip($csv);
					//$zip->extract(PCLZIP_OPT_PATH, ROOT."sconet/xml", PCLZIP_OPT_REMOVE_PATH, $xml);
					$csv = $zip->extract(PCLZIP_OPT_EXTRACT_AS_STRING, PCLZIP_OPT_REMOVE_PATH, $csv);
					$csv = $csv[0]['content']; 
					echo "{ 'reponse' : '".addslashes($csv)."' }";
					exit;
				}

				// MODELE de donnes
				$lilie = Modele::chargement('sconetModele'); 
				
				$eleves = array();
				$fp = fopen ($csv,"r");
				// Ligne d'entte : 0-Profil;1-Etat;2-Identifiant;3-Sconet;4-Nom;5-Prnom;6-Niveau;7-Mef;8-Classe
				$entetes = fgetcsv ($fp, 1000, ";"); 
				// tester la prsence des champs ncessaires et dterminer le numro de colonne de ces champs
				$colonnes = $lilie->verifieCSV($entetes, array('Identifiant', 'Sconet', 'Nom', 'Prnom', 'Classe')); 
				if(isset($colonnes['error'])):
					fclose ($fp); // inutile de continuer
					$gluO = "&laquo;&nbsp;";  $gluF = "&nbsp;&raquo;"; 
					if(count($colonnes['error'])>1):
						$glue = "$gluF, $gluO";
						$msg = "Les colonnes $gluO".implode($glue,$colonnes['error'])."$gluF sont manquantes";
					else:
						$msg = "La colonne $gluO".$colonnes['error'][0]."$gluF est manquante";
					endif;
					$msg .= " dans le fichier CSV !"; $csv = 0;
				else :
					// Eleves [ id => [ nom, prenom, classe, rne, sexe, naissance] ] // format sconetModele
					while ($eleve = fgetcsv ($fp, 1000, ";")) {
						$id_cas = substr($eleve[$colonnes['Identifiant']],5); // lilie
						$id_sconet = $eleve[$colonnes['Sconet']]; // sconet
						$id = $eleve[$colonnes['Sconet']]; // eleve

						$E = array("id" => $id, "id_cas" => $id_cas,
						"nom" => utf8_encode($eleve[$colonnes['Nom']]), "prenom" => utf8_encode($eleve[$colonnes['Prnom']]), 
						"classe" => strim($eleve[$colonnes['Classe']]), "rne" => $rne);
						//$E["naissance"] = "0000-00-00"; $E['sexe']="";
						$eleves[$id] = $E;
					}
					fclose ($fp);
									
					// OBJET LILIE
					$lilieCSV = new LILIE($rne, $eleves, $lilie);
					$msg = stripslashes($lilieCSV->toMySQL()); $csv = 1;
				endif;

				echo "{ \"reponse\":\"".utf8_encode($msg)."\", \"csv\":$csv }";	
				//echo '{ "reponse":"'.normalize($reponse).'"}';	
				
				
				
				/* MODELE de donnes 
				$sconet = Modele::chargement('sconetModele');

				// OBJET SCONET
				// $sconetXML = new SCONET(ROOT.'sconet/xml/'.$suf_fichier.'.xml', $sconet, $classe);
				$sconetXML = new SCONET($xml, $sconet, $classe);
				if(isset($sconetXML->RNE) and ($sconetXML->RNE == $rne) ):
					// TRANSFERT XML -> MySQL
					$msg = stripslashes($sconetXML->toMySQL($debug));
					//$classes = implode(", ", $sconetXML->extractClassesToArray());
					echo '{ "reponse":" '.$msg.'"}';
					return false;
				elseif ($sconetXML->RNE != $rne):
					$msg = utf8_encode("<span class='erreur'>Vous n'tes pas connect en tant qu'administrateur de l'tablissement :<br />". $sconetXML->RNE."</span>"); 
					echo '{ "reponse":"'.$msg.'"}';
					return false;									
				else:
					$msg = "<span class='erreur'>Fichier <em>SCONET</em> attendu !</span>"; 
					$msg = $sconetXML->RNE;
					echo '{ "reponse":"'.$msg.'"}';
					return false;				
				endif;
				*/ // FIN TELECHARGEMENT	
			endif;	
			//$reponse  = "Impossible de t&eacute;l&eacute;charger le fichier !";
			//echo '{ "reponse":"'.normalize($reponse).'"}';	
			//$reponse = $lilieCSV->reponse();
			//echo "{ 'reponse' : '".$reponse."' }";
		endif;
	}

	function strim ($string) {
    	$swap = array(" "=>"");
    	return strtr(utf8_encode($string), $swap);
	}
	
	function normalize ($string) {
    	$swap = array("'"=>"_"); // En faire la liste ...
    	return strtr(utf8_encode($string), $swap);
	}

?>