<?php // $Id: uploadCartableCSV.php 399 2011-10-12 15:22:35Z fl $
/**
* UPLOAD
* 
* Tlchargement d'un fichier compress .zip, extraction, traitement 
*  
* @author Jean-Marc L. <Jean-Marc.Labat@ac-creteil.fr>
* @author Franois L. <FL@ac-creteil.fr>
* @version 0.9
* @package CARTABLE
* @subpackage Upload
*/

/** 
* Dtermination des "racines" depuis un niveau
* @param String $url 
* @param Integer $niveau profondeur / rpertoire racine de l'appli balado
*/
function remonte($url, $niveau){ 
	$tab = explode("/", $url);
	array_splice( $tab, count($tab)-1-$niveau);
	return implode("/",$tab);	 
}


ini_set("auto_detect_line_endings", true);

// ici, dans: /sconet/sconetUpload => niveau = 2 ////////
define('_HOST_',$_SERVER['HTTP_HOST']); 
define('_WEBROOT_',remonte($_SERVER['SCRIPT_NAME'],1)); 
define('_ROOT_',remonte($_SERVER['SCRIPT_FILENAME'],1)); 
/////////////////////////////////////////////////////////
require(_ROOT_."/controler/commun.lib.php"); // Objet F (fonctions commnunes)
require(_ROOT_."/pclzip/pclzip.lib.php");
require(_ROOT_.'/imports/connexion.php');
require(_ROOT_.'/imports/modele.php');
require(_ROOT_.'/imports/cartable.php');

$extensions = array('.csv');
$msg = "";
$debug = false;
$rne = isset($_POST['rne'])?$_POST['rne']:'';
$classe = isset($_POST['classe'])?$_POST['classe']:'';

if(isset($_FILES['fichier']))
	{
		
		__LXF__("__UPLOAD__CARTABLE__CSV__FILE__", $_FILES );

		$fichier = $_FILES['fichier'];
		
		//$nom_fichier = basename($fichier['name']);
		//$suf_fichier = strstr($fichier['name'],'.');
		$suf_fichier = substr($fichier['name'],0,strpos($fichier['name'],'.'));
		$ext_fichier = strtolower(strstr($fichier['name'], '.')); 
		$nom_fichier = $rne.$ext_fichier;

		//Dbut des vrifications de scurit...
		if(!in_array($ext_fichier, $extensions)): 
			$msg =  "<span class='erreur'>Fichier <em>".implode($extensions,", ")."</em> attendu !</span>"; 
			echo '{"reponse":"'.$msg.'"}';
			return false;
		else: 	 
			$csv = ($ext_fichier == ".zip")?$nom_fichier:(_ROOT_."/imports/csv/".$nom_fichier);
			$trace = $fichier['tmp_name'];
			// TELECHARGEMENT 
			if(@move_uploaded_file($fichier['tmp_name'], $csv)) :
				if($ext_fichier == ".zip") {
					// DEZIP ventuel
					$zip = new PclZip($csv);
					//$zip->extract(PCLZIP_OPT_PATH, ROOT."sconet/xml", PCLZIP_OPT_REMOVE_PATH, $xml);
					$csv = $zip->extract(PCLZIP_OPT_EXTRACT_AS_STRING, PCLZIP_OPT_REMOVE_PATH, $csv);
					$csv = $csv[0]['content']; 
					echo "{ 'reponse' : '".addslashes($csv)."' }";
					exit;
				}

				// MODELE de donnes
				$cartable = Modele::chargement('sconetModele'); 
				
				$eleves = array();
				$fp = fopen ($csv,"r");
				// Ligne d'entte Lilie : 0-Profil;1-Etat;2-Identifiant;3-Sconet;4-Nom;5-Prnom;6-Niveau;7-Mef;8-Classe
				// Ligne d'entte Cart. : 0-CLASSE;1-NOM;2-PRENOM;3-LOGIN;4-MOT_DE_PASSE;5-NUMERO_ELEVE;6-INE
				$entetes = fgetcsv ($fp, 1000, ";"); 
				// tester la prsence des champs ncessaires et dterminer le numro de colonne de ces champs
				$colonnes = $cartable->verifieCSV($entetes, array('LOGIN', 'NUMERO ELEVE', 'NOM', 'PRENOM', 'CLASSE')); 
				
				if(isset($colonnes['errChampsManquants'])):
					fclose ($fp); // inutile de continuer
					$gluO = "&laquo;&nbsp;";  $gluF = "&nbsp;&raquo;"; 
					if(count($colonnes['errChampsManquants'])>1):
						$glue = "$gluF, $gluO";
						$msg = "Les colonnes $gluO".implode($glue,$colonnes['errChampsManquants'])."$gluF sont manquantes";
					else:
						$msg = "La colonne $gluO".$colonnes['errChampsManquants'][0]."$gluF est manquante";
					endif;
					$msg .= " dans le fichier CSV !"; 
					unlink($csv); $csv = 0;
				else :
					// Eleves [ id => [ nom, prenom, classe, rne, sexe, naissance] ] // format sconetModele
					while ($eleve = fgetcsv ($fp, 1000, ";")) {
						$id_cas = $eleve[$colonnes['LOGIN']]; 
						$id_cas = ("ID : " == substr($id_cas,0,5))?substr($id_cas,5):$id_cas; // pour lilie
						$id_sconet = 0; // ID Sconet non connu
						$id = (integer) $eleve[$colonnes['NUMERO ELEVE']].substr($rne,0,-1); // eleve
						//$id_sconet = $id;

						$E = array("id" => $id, "id_cas" => $id_cas, "id_sconet" => $id_sconet,

						// PB.UTF8 EVENTUEL //
						//"nom" => utf8_encode($eleve[$colonnes['NOM']]), "prenom" => utf8_encode($eleve[$colonnes['PRENOM']]), 
						"nom" => $eleve[$colonnes['NOM']], "prenom" => $eleve[$colonnes['PRENOM']], 

						"classe" => strim($eleve[$colonnes['CLASSE']]), "rne" => $rne);
						//$E["naissance"] = "0000-00-00"; $E['sexe']="";
						$eleves[$id] = $E;
					}
					fclose ($fp);
									
					// OBJET CARTABLE
					$cartableCSV = new CARTABLE($rne, $eleves, $cartable);
					//$msg = utf8_encode( stripslashes( $cartableCSV->toMySQL( false ) )); 
					$msg = stripslashes( $cartableCSV->toMySQL( false ) ); 
					$csv = 1;
				endif;

				$json = array( "reponse" => $msg, "csv" => $csv );
				echo json_encode( $json );
				
				// FIN TELECHARGEMENT	
			endif;	
		endif;
	
	} else {

		__LXF__("__UPLOAD__CARTABLE__CSV__POST__", $_POST );

		extract( $_POST );
		
		// MODELE de donnes
		$cartable = Modele::chargement('sconetModele'); 
		$eleves = array();

		// FICHIER CSV
		$csv = _ROOT_."/imports/csv/".$rne.".csv";
		$fp = fopen ($csv,"r");
		$entetes = fgetcsv ($fp, 1000, ";"); 

		$colonnes = $cartable->verifieCSV($entetes, array('LOGIN', 'NUMERO ELEVE', 'NOM', 'PRENOM', 'CLASSE')); 

		if( 'commit' == $transaction ):

			while ($eleve = fgetcsv ($fp, 1000, ";")) {
						$id_cas = $eleve[$colonnes['LOGIN']]; 
						$id_cas = ("ID : " == substr($id_cas,0,5))?substr($id_cas,5):$id_cas; // pour lilie
						$id_sconet = 0; // ID Sconet non connu
						$id = (integer) $eleve[$colonnes['NUMERO ELEVE']].substr($rne,0,-1); // eleve

						$E = array("id" => $id, "id_cas" => $id_cas, "id_sconet" => $id_sconet,

						// PB.UTF8 EVENTUEL //
						//"nom" => utf8_encode($eleve[$colonnes['NOM']]), "prenom" => utf8_encode($eleve[$colonnes['PRENOM']]), 
						"nom" => $eleve[$colonnes['NOM']], "prenom" => $eleve[$colonnes['PRENOM']], 
						
						"classe" => strim($eleve[$colonnes['CLASSE']]), "rne" => $rne);
						//$E["naissance"] = "0000-00-00"; $E['sexe']="";
						$eleves[$id] = $E;
					}
					fclose ($fp);
									
			// OBJET CARTABLE
			$cartableCSV = new CARTABLE($rne, $eleves, $cartable);
			$msg = utf8_encode( stripslashes( $cartableCSV->toMySQL( true ) )); 
			
		endif;
		
		unlink($csv); 
		/*
		if( count( $eleves ) > 0 ):
			echo "<ul id='liste_eleves'>";
				foreach($eleves as $eleve){
					echo "<li><span class='nom'>".$eleve['nom']."</span> <span class='prenom'>".$eleve['prenom']."</prenom></li>";
				}
			echo  "</ul>";
		endif;
		*/
	}

	function strim ($string) {
    	$swap = array(" "=>"");
    	return strtr(utf8_encode($string), $swap);
	}
	
	function normalize ($string) {
    	$swap = array("'"=>"_"); // En faire la liste ...
    	return strtr(utf8_encode($string), $swap);
	}

?>