/* $Id: jquery.debug.js 61 2011-07-06 21:17:44Z fl $ */ 
/* DEBUG /////////////////////////////////////////////////////////////////////////////////////////////////////////
Affichage de Proprits/Mthodes d'un objet JavaScript jQuery ou non dans la console Firebug
Initialisation : (si $=jQuery)
	$.debug.init() ou $.debug.init(true); // false pour inhiber
Appel : 
	$.debug.X( obj, options) 	pour un objet quelconque
	$(selector).debug(options) 	pour une slection jQuery (chanage possible)

/* OPTIONS PAR DEFAUT /////////////////////////////////////////////////////////////////////////////////////////////
options = { property:'all', value:'yes', methods:'none', icone:'info', content:null } 
pour des appels : $.debug.X( obj ) , $(selector).debug()
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// PROPERTY ///////////////////////////////////////////////////////////////////////////////////////////////////////
Affiche respectivement : toutes les proprits, aucune, la proprit, les proprits
property : 'all', 'none', nom, [ 'nom1', 'nom2', ... ]

property : 'all' appliqu  une slection jQuery, n'affiche que les proprits du premier objet 
property : nom, [ 'nom1', 'nom2', ... ] appliqu  une slection jQuery, affiche les proprits de tous les objets 

ex: $('.classe').debug({ property : [ 'tagName', 'inneHTML'] });

// VALUE ///////////////////////////////////////////////////////////////////////////////////////////////////////////

Affiche ou non les valeurs
value : 'yes', 'no' 

ex: $.debug(event, { value : 'no', 'methods' }); 
pour afficher les proprits (sans les valeurs) et les mthodes  d'un objet event

// METHODS /////////////////////////////////////////////////////////////////////////////////////////////////////////
Affiche ou non les mthodes 
methods: 'all', 'none'

// ICONE ///////////////////////////////////////////////////////////////////////////////////////////////////////////
Affichage Icone
icone : 'log' ou 'debug', 'info', 'warn', 'error'

// CONTENT /////////////////////////////////////////////////////////////////////////////////////////////////////////
Raccourci contenu (equivalent  {property:'innerHTML'}, {property:'textContent'} 
content : 'html', 'text'

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/

jQuery.debug = {
	
	flag : false,
	init : function(etat){
			if (etat = (etat == undefined || etat)) {
				//console.clear();		
				console.warn('Le plugin jQuery Debug est activ !');
			} else if( this.flag ){
				//console.clear();
				console.info('Le plugin jQuery Debug est dsactiv !');						
			}
			jQuery.debug.flag = etat;
	},
	
	// A viter, le retour d'erreur renvoie  ces lignes !!!
	console : function(msg, icone){
		if(!jQuery.debug.flag)  return;
		switch (icone){
			case 'log' : 
				console.log(msg);
				break;
			case 'info':
				console.info(msg);
				break;
			case 'warn':
				console.warn(msg);
				break;
			case 'error': 
				console.error(msg); 
				break;
			case 'debug' : 
				console.debug(msg);
			default:		
				console.debug(msg);
		}
	},
	
	isArray : function( variable ) { return variable && typeof variable === 'object' && variable.constructor === Array; },
	isXML : function( variable ) { return variable && typeof variable === 'object' && variable.constructor === XMLDocument; },
	
	superTypeOf : function( variable){
		if( jQuery.debug.isArray(variable )) return 'array'; 
		if( String(variable) == '[object XMLDocument]') return 'xml';
		else return typeof variable;
	},
	
	clear : function(){
		if (this.flag){ console.clear(); }
		return this;		
	},
	
	sql : function( _sql, options ){
		if(!jQuery.debug.flag) return;
		var defaults = {
			url: "ajax/debug.sql.php",
			data: { sql: _sql },
			type: 'POST', 
			dataType: 'text', // text | html | xml | script | json | jsonp
			success: function(data){ jQuery.debug.X(data);  },
			async: true, 
			cache: false // inhibe le cache
		};
		var opts = jQuery.extend(defaults, options);
		jQuery.ajax( opts  );			
		
	},
	
	ajax : function ( _url, options ){
		if(!jQuery.debug.flag) return;
		var defaults = {
			url: "ajax/"+_url,
			data: { hello: "World !" },
			type: 'POST', // POST | GET
			dataType: 'text', // text | html | xml | script | json | jsonp
			success: function(data){ jQuery.debug.X(data);  },
			async: true, 
			cache: false // inhibe le cache
		};
		var opts = jQuery.extend(defaults, options);
		jQuery.ajax( opts  );			
	},
	
	X : function(obj, options){
		if(!jQuery.debug.flag) return;
		var defaults = {
			property: 'all',
			value: 'yes',
			methods: 'none',
			icone: 'info',
			content: null // text (si textContent) | html (si innerHTML)	
		};
		var opts = jQuery.extend(defaults, options);
		if(opts.content){ 
			switch(opts.content){
				case 'html':
					if(obj['innerHTML']!==undefined) { console[opts.icone]( jQuery(obj).html()); }
					else { console.error( 'Aucun contenu HTML'); }
					break;
				case 'text':
					if(obj['textContent']!==undefined) { console[opts.icone]( jQuery(obj).text()); }
					else { console.error( 'Aucun contenu Textuel'); }
					break;
			}
			return
		}
		var name; var exist = false;
		console[opts.icone]( jQuery.debug.superTypeOf(obj) );
		if( typeof obj === 'string') { console[opts.icone](obj); return; } 
		if( String(obj)=='[object XMLDocument]') { obj = obj.firstChild; console[opts.icone](obj); }
		for (name in obj){
			switch(opts.property){
				case 'all':
					val = (opts.value=='yes')?(': ' + obj[name]):"";
					if(typeof obj[name] !== 'function') console[opts.icone](name + String(val)); 
				case 'none':
					exist = true;
					break;
				default :
					if(jQuery.debug.isArray(opts.property)){
						for( p in opts.property ){
							if(name == opts.property[p]){ console[opts.icone](name + ': ' + obj[name]); exist = true; }
						}
					} else {
						if(name == opts.property){ console[opts.icone](name + ': ' + obj[name]); exist = true; }
					}
			}
			if(typeof obj[name] == 'function' && opts.methods != 'none') console[opts.icone](name + ': ' + obj[name]); 
		}
		if(!exist) { console.error("[ " + opts.property + ' ] n\'est pas une proprit de l\'objet'); }	
	}
}

// Permet le chanage jQuery
jQuery.fn.clear = function(options){
	if(jQuery.debug.flag) jQuery.debug.clear();
	return this;
}
	
jQuery.fn.debug = function(options){
	if(!jQuery.debug.flag) return;
	var defaults = {
		property: 'all',
		value: 'yes',
		methods: 'none',
		icone: 'info',
		content: null // text (si textContent) | html (si innerHTML)	
	};
	var opts = jQuery.extend(defaults, options);
	if(opts.property!='all' && this.size()>1){
		for(var i =0;i<this.size();i++){ 
			jQuery.debug.X(this[i], opts);
			console.log("_______________________________________________________________________________");	
		}
	} else {
		jQuery.debug.X(this[0], opts);
	}
	return this;
}


