<?php
if(isset($_SESSION['user_login'])&&(!empty($_SESSION['user_login'])) && (is_super_admin($_SESSION['user_login']))){
	
	$user_login = Secure::bdd($_SESSION['user_login']);
	
	$cal = Secure::bdd($_GET['cal']);
	$cal_identite_color = $_SESSION['identite_color'];

	$is_super_admin = is_super_admin($user_login);
	$is_admin = is_admin($user_login,recuperer_id($cal));
	$is_editeur = is_editeur($user_login,recuperer_id($cal));
	
	$infos_user = recup_infos($user_login,recuperer_id($cal));
	if(is_user_exist_uid($user_login)){
		$infos_user_ldap = recup_infos_ldap($user_login);
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<title>Calendrier Académique</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/main.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-ui-custom.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-notify.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery.prettyCheckable.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/fullcalendar.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/fullcalendar.print.css" media="print"/>
	<link type="text/css" rel="stylesheet" href="<?php echo $url_css;?>/jquery.miniColors.css" />
	<script src="/piwik/envoleTrackeur.js.php?appli=calendrier&amp;profil=<?php if (isset($_SESSION['user_profil'])) print $_SESSION['user_profil']; else print "??"; ?>"></script>
	<script type="text/javascript" src="lib/jquery/jquery.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-ui.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-qtip.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-notify.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-prettyCheckable.js"></script>
	<script type="text/javascript" src="lib/scripts/fullcalendar.js"></script>
	<script type="text/javascript" src="lib/scripts/jquery.miniColors.js"></script>
	<script type="text/javascript" src="lib/scripts/scripts.js"></script>
	<script>
	$(document).ready(function() {
		$(".colors").miniColors();
	});
	</script>
</head>
<body>
<?php require_once 'menu.php';?>
<div id="container">
<div id="msg_erreur"></div>
<?php require_once 'warnings.php';?>
<table class="tab_affich_cal">
	<tr class="tr_adm_table" style="border: 1px solid <?php echo $cal_identite_color;?>;background-color: <?php echo $cal_identite_color;?>;">
		<td>Titre</td><td>Couleur identité</td><td>Couleur checkbox</td><td colspan="2"></td>
	</tr>
	<?php
	$cpt_ligne = 1;
	foreach($calendriers as $calendrier){
		if($cpt_ligne%2==0){$couleur = "#F7F7F7";}else{$couleur = "#EEEEEE";}
		echo '<form method="post" action="application/controleurs/gestcalendrier.php?action=update">'.
			 '<tr style="background-color:'.$couleur.';border:1px solid '.$couleur.'">'.
			 '<td class="default"><input type="text" id="cal_titre" name="cal_titre" size="20" maxlength="20" value="'.$calendrier['calendrier_titre'].'"/></td>'.
			 '<td><input type="text" id="cal_identite_color" name="cal_identite_color" class="colors" size="7" value="'.$calendrier['calendrier_identite_color'].'"/></td>'.
			 '<td>'.
	  		 '<select id="cal_checkbox_color" name="cal_checkbox_color">';
			 foreach($enums as $enum)
			 {
			 	if($calendrier['calendrier_checkbox_color'] == $enum){
					echo "<option value=".Secure::html($enum)." selected>".Secure::html($enum)."</option>";
				}else{
					echo "<option value=".Secure::html($enum).">".Secure::html($enum)."</option>";
			 	}
			 }
			echo '</select>'.
			'</td>'.
			'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
			'<input type="hidden" id="cal_id" name="cal_id" size="40" maxlength="30" value="'.Secure::html($calendrier['calendrier_id']).'"/>'.
			'<td><input type="image" src="'.$url_img.'/maj.png" value="Modifier" title="Modifier le calendrier" onclick="if(window.confirm(\'Voulez-vous vraiment modifier ce calendrier ?\')){return true;}else{return false;};"/></td>'.
			'</form>';
		echo '<form method="post" action="application/controleurs/gestcalendrier.php?action=delete">'.
				 	'<td><input type="hidden" name="cal_id" value="'.Secure::html($calendrier['calendrier_id']).'" />'.
					'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
				 	'<input type="image" src="'.$url_img.'/delete.png" value="Supprimer" title="Supprimer ce calendrier" onclick="if(window.confirm(\'Voulez-vous vraiment supprimer ce calendrier, ainsi que ses événements, utilisateurs et catégories ?\')){return true;}else{return false;};"/>'.
				 	'</td></form>'.
			'</tr>';
			$cpt_ligne++;
	}
	?>
	<tr><td colspan="5"><hr style="background-color: <?php echo $cal_identite_color;?>;"/></td></tr>
	<form id="form_ajout_cal" method="post" action="application/controleurs/gestcalendrier.php?action=add" onsubmit="return VerifFormCal(this,'form_ajout_cal')">
		<td class="default">Titre sans majuscule, ni espace, ni caractères spéciaux : <input type="text" id="cal_titre" name="cal_titre" size="20" maxlength="20" /></td>
		<td><input type="text" id="cal_identite_color" name="cal_identite_color" class="colors" size="7" value="#000000"/></td>
		<td>
			<select id="cal_checkbox_color" name="cal_checkbox_color">
					<?php 
					foreach($enums as $enum){
						echo '<option value='.Secure::html($enum).'>'.stripslashes($enum).'</option>';
					}
					?>
			</select>
		</td>
		<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>
		<td colspan="2"><input type="image" value="Ajout Cal" src="<?php echo $url_img;?>/plus.png" Alt="Ajout Cal" title="Ajouter ce calendrier"/></td>
	</form>
</table>
</div>
</body>
</html>
<?php
}else{
	header('Location: /calendrier/index.php?page=accueil');
}
