<?php
if(!isset($_SESSION)) {
	session_start();
}
require_once dirname(__FILE__).'/../../includes/base.inc.php';

//On inclut les modèles
require_once dirname(__FILE__).'/../modeles/usercal.php';
require_once dirname(__FILE__).'/../modeles/users.php';
require_once dirname(__FILE__).'/../modeles/calendriers.php';
require_once dirname(__FILE__).'/../modeles/categories.php';
require_once dirname(__FILE__).'/../modeles/evenements.php';

if(isset($_SESSION['user_login'])&&(!empty($_SESSION['user_login'])) && (is_super_admin($_SESSION['user_login']))){

	if(isset($_GET['action'])&&(!empty($_GET['action']))){
		
		switch($_GET['action']){
			case "add":
				if(isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))&&
				isset($_POST['cal_titre'])&&(!empty($_POST['cal_titre']))&&
				isset($_POST['cal_identite_color'])&&(!empty($_POST['cal_identite_color']))&&
				isset($_POST['cal_checkbox_color'])&&(!empty($_POST['cal_checkbox_color']))){
					
					$cal_titre = Secure::bdd(preg_replace('/[^a-z\d_]/u', '', strtolower($_POST['cal_titre'])));
					$cal_identite_color = Secure::bdd($_POST['cal_identite_color']);
					$enum_calendrier = recuperer_enum_calendrier();
					if(in_array($_POST['cal_checkbox_color'],$enum_calendrier)){
						$cal_checkbox_color = $_POST['cal_checkbox_color'];						
						if(ajouter_calendrier($cal_titre, $cal_identite_color, $cal_checkbox_color)){
							header('Location: /calendrier/index.php?page=gestcalendrier&cal='.Secure::bdd($_POST['user_cal']).'');
						}						
					}
				}
			break;
			
			case "update":
				if(isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))&&
				isset($_POST['cal_id'])&&(!empty($_POST['cal_id']))&&
				isset($_POST['cal_titre'])&&(!empty($_POST['cal_titre']))&&
				isset($_POST['cal_identite_color'])&&(!empty($_POST['cal_identite_color']))&&
				isset($_POST['cal_checkbox_color'])&&(!empty($_POST['cal_checkbox_color']))){

					$cal_id = Secure::bdd($_POST['cal_id']);
					$cal_titre = Secure::bdd($_POST['cal_titre']);
					$cal_identite_color = Secure::bdd($_POST['cal_identite_color']);
					$enum_calendrier = recuperer_enum_calendrier();
					if(in_array($_POST['cal_checkbox_color'],$enum_calendrier) && is_int($cal_id)){
						$cal_checkbox_color = $_POST['cal_checkbox_color'];
						if(modifier_calendrier($cal_id, $cal_identite_color, $cal_checkbox_color, $cal_titre)){
							header('Location: /calendrier/index.php?page=gestcalendrier&cal='.Secure::bdd($_POST['cal_titre']).'');
						}
					}
				} else {
					header('Location: /calendrier/index.php?page=gestcalendrier&cal='.Secure::bdd($_POST['user_cal']).'');
				}
			break;
			
			case "delete":
				if(isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))&&
				isset($_POST['cal_id'])&&(!empty($_POST['cal_id']))){

					$cal_id = Secure::bdd($_POST['cal_id']);
					if(is_int($cal_id)){
						if(supprimer_usercal($cal_id)){
							if(supprimer_evenement_par_cal($cal_id)){
								if(supprimer_categorie_par_cal($cal_id)){
									if(supprimer_calendrier($cal_id)){
										header('Location: /calendrier/index.php?page=gestcalendrier&cal='.Secure::bdd($_POST['user_cal']).'');
									}
								}
							}
						}
					}
				}
			break;
		}
	}else{
		$calendriers = recuperer_calendriers();
		$enums = recuperer_enum_calendrier();
		
		//On inclut la vue
		include dirname(__FILE__).'/../vues/gestcalendrier.php';	
	}
}else{
	header('Location: /calendrier/index.php?page=accueil');
}