<?php
function recuperer_evenements()
{
	global $bdd;

	$evenements = array();
	try{
		$reponse = $bdd->prepare("SELECT * FROM evenements WHERE evenement_etat = ?");
		$reponse -> execute(array("1"));
		while ($donnees = $reponse->fetch())
		{
			 $evenements[] = $donnees;
		}
		$reponse->closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $evenements;
}
function recuperer_evenement($event_id)
{
	global $bdd;

	$evenement = array();
	try{
		$reponse = $bdd->prepare("SELECT evenement_id, evenement_titre, DATE_FORMAT(evenement_date_debut, '%d/%m/%Y') AS evenement_date_debut,DATE_FORMAT(evenement_date_fin, '%d/%m/%Y') AS evenement_date_fin, evenement_description, evenement_categorie, evenement_affectation, evenement_etat, affectation_id, affectation_description ".
								 "FROM evenements, affectations ".
								 "WHERE evenements.evenement_affectation=affectations.affectation_id AND evenement_id = ? ".
								 "AND evenements.evenement_etat = ? ;)");
		$reponse -> execute(array($event_id,"1"));
		while($donnees = $reponse->fetch()){
			$evenement[] = $donnees;
		}
		$reponse->closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $evenement;
}
function recuperer_evenements_dun_calendrier_avenir($calendrier_titre)
{
	global $bdd;

	$evenements = array();
	try{
		$reponse = $bdd->prepare("SELECT * FROM evenements, calendriers
                                 WHERE evenements.evenement_calendrier = calendriers.calendrier_id
                                 AND calendrier_titre = ?
                                 AND (evenement_date_debut >= CURDATE() OR evenement_date_fin >= CURDATE())
                                 AND evenement_etat = ?");
		$reponse -> execute(array($calendrier_titre,"1"));
		while ($donnees = $reponse->fetch())
		{
			 $evenements[] = $donnees;
		}
		$reponse->closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $evenements;
}
function ajouter_evenement($event_cal,$event_titre,$event_date_debut,$event_date_fin,$event_desc,$event_cat,$recup_infos)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("INSERT INTO evenements (evenement_calendrier,evenement_titre,evenement_date_debut,evenement_date_fin,evenement_description,evenement_categorie,evenement_affectation,evenement_auteur,evenement_editeur) ".
								 "VALUES (?,?,?,?,?,?,?,?,?)");
		$reponse -> execute(array($event_cal,$event_titre,$event_date_debut,$event_date_fin,$event_desc,$event_cat,$recup_infos[3],$recup_infos[5],$recup_infos[5]));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function modifier_evenement($event_titre,$event_date_debut,$event_date_fin,$event_desc,$event_cat,$recup_infos,$event_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE evenements SET evenement_titre = ?, evenement_date_debut = ?, evenement_date_fin = ?, ".
								 "evenement_description = ?, evenement_categorie = ?, evenement_editeur = ? ".
								 "WHERE evenement_id = ? ;");
		$reponse -> execute(array($event_titre,$event_date_debut,$event_date_fin,$event_desc,$event_cat,$recup_infos[5],$event_id));
		$reponse->closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function supprimer_evenement($event_id,$affect_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE evenements SET evenement_etat = ? WHERE evenement_id = ? ;");
		$reponse -> execute(array("0",$event_id));
		$reponse->closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function supprimer_evenement_par_cal($cal_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("DELETE FROM evenements WHERE evenement_calendrier = ? ;");
		$reponse -> execute(array($cal_id));
		$reponse->closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function compter_evenements($user_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT COUNT(*) AS cpt_event FROM evenements WHERE evenement_auteur = ? OR evenement_editeur = ? ");
		$reponse -> execute(array($user_id,$user_id));
		$donnees = $reponse->fetch();
		$cpt_event = $donnees['cpt_event'];
		$reponse->closeCursor();
		return $cpt_event;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function compter_evenements_dune_categorie($cat_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT COUNT(*) AS cpt_event FROM evenements WHERE evenement_categorie = ? AND evenement_etat = ?");
		$reponse -> execute(array($cat_id,1));
		$donnees = $reponse->fetch();
		$cpt_event = $donnees['cpt_event'];
		$reponse->closeCursor();
		return $cpt_event;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function compter_evenements_avenir_dune_categorie($cat_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT COUNT(*) AS cpt_event FROM evenements WHERE evenement_categorie = ? AND evenement_etat = ? AND (evenement_date_debut >= CURDATE() OR evenement_date_fin >= CURDATE())");
		$reponse -> execute(array($cat_id,1));
		$donnees = $reponse->fetch();
		$cpt_event = $donnees['cpt_event'];
		$reponse->closeCursor();
		return $cpt_event;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}