<?php
if(isset($_SESSION['user_login'])&&(!empty($_SESSION['user_login'])) && (is_super_admin($_SESSION['user_login']) || is_admin($_SESSION['user_login'],recuperer_id($_GET['cal'])))){
	$user_login = Secure::bdd($_SESSION['user_login']);

	$cal = Secure::bdd($_GET['cal']);
	$cal_identite_color = $_SESSION['identite_color'];
    if(isset($_GET['sec'])&&(!empty($_GET['sec']))&&(is_numeric($_GET['sec']))){
		$sec = Secure::bdd($_GET['sec']);
	} else {
		$sec = 1;
	}
	$is_super_admin = is_super_admin($user_login);
	$is_admin = is_admin($user_login,recuperer_id($cal));
	$is_editeur = is_editeur($user_login,recuperer_id($cal));

	$infos_user = recup_infos($user_login,recuperer_id($cal));
	if(is_user_exist_uid($user_login)){
		$infos_user_ldap = recup_infos_ldap($user_login);
	}
	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr">
	<head>
		<title>Administration</title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
		<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/main.css"/>
		<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/bootstrap.min.css"/>
		<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-ui-custom.css"/>
		<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-ui.css"/>
		<link type="text/css" rel="stylesheet" href="<?php echo $url_css;?>/jquery.miniColors.css" />
        <?php
        // Inclusion de la sonde piwik envole
        $applisonde="calendrier";
        include "/var/www/html/sondepiwik/envoleSonde.php"; 
        ?>
		<script type="text/javascript" src="lib/jquery/jquery.js"></script>
		<script type="text/javascript" src="lib/jquery/jquery-ui.js"></script>
		<script type="text/javascript" src="lib/bootstrap.min.js"></script>
		<script type="text/javascript" src="lib/scripts/jquery.miniColors.js"></script>
		<script type="text/javascript" src="lib/scripts/scripts.js"></script>
		<script>
		$(document).ready(function() {
			$("#user").autocomplete({
				source: "includes/searchcn.inc.php",
				minLength: 2
			});
			$(".colors").miniColors();
			show_div(<?php echo $sec;?>);
		});
		function show_div(div){
			var fadein = 1200;
			switch (div) {
				case 1:
					$("#categories, #affectations").hide();
					$("#utilisateurs").fadeIn(fadein).show();
					$(".span_user_ss").css({"background-color":"<?php echo $cal_identite_color;?>"});
					$(".span_cat_ss, .span_affect_ss").css("background-color","#FFFFFF");
					$(".span_user").css({"color":"#000000"});
					$(".span_cat, .span_affect").css({"color":"#7e7e7e"});
				break;
				case 2:
					$("#utilisateurs, #affectations").hide();
					$("#categories").fadeIn(fadein).show();
					$(".span_cat_ss").css("background-color","<?php echo $cal_identite_color;?>");
					$(".span_user_ss, .span_affect_ss").css("background-color","#FFFFFF");
					$(".span_cat").css({"color":"#000000"});
					$(".span_user, .span_affect").css({"color":"#7e7e7e"});
				break;
				case 3:
					$("#utilisateurs, #categories").hide();
					$("#affectations").fadeIn(fadein).show();
					$(".span_affect_ss").css("background-color","<?php echo $cal_identite_color;?>");
					$(".span_user_ss, .span_cat_ss").css("background-color","#FFFFFF");
					$(".span_affect").css({"color":"#000000"});
					$(".span_user, .span_cat").css({"color":"#7e7e7e"});
				break;
				default:
					$("#utilisateurs, #categories, #affectations").hide();
				break;
			}
		}
		</script>
		<style>.ui-autocomplete { height: 150px; overflow-y: scroll; overflow-x: hidden; font-size: 12px;}</style>
	</head>
	<body>
	<?php require_once 'menu.php';?>
	<div id="container">
		<?php require_once 'warnings.php';?>
		<table class="table table-condensed">
			<tr>
				<td><span onclick="show_div(1);" class="span_user">Utilisateurs</span></td>
				<td><span onclick="show_div(2);" class="span_cat">Catégories</span></td>
				<td><span onclick="show_div(3);" class="span_affect">Affectations</span></td>
			</tr>
			<tr>
				<td class="span_user_ss"></td>
				<td class="span_cat_ss"></td>
				<td class="span_affect_ss"></td>
			</tr>
		</table>
		<div id="msg_erreur"></div>
		<!-- Affichage des utilisateurs -->
		<div id="utilisateurs">
			<div class="row">
			<?php
			if(!empty($users)) {
			?>			
		    	<div class="col-lg-12">
					<table class="table table-condensed">
						<tr class="tr_adm_table" style="border: 1px solid <?php echo $cal_identite_color;?>;background-color: <?php echo $cal_identite_color;?>;">
							<td>Login</td><td>Droit</td><td>Affectation</td><td colspan="2"></td>
						</tr>
						<?php				
						foreach($users as $user)
						{
							$infos_user_ldap = recup_infos_ldap(Secure::html($user['user_login']));
							echo '<form method="post" action="application/controleurs/administration.php?action=upduser">'.
								  	'<tr>'.
								  		'<td>'.$infos_user_ldap[3].' ('.Secure::html($user['user_login']).') <input type="hidden" name="user_id" value="'.Secure::html($user['user_id']).'"/></td>'.
								  		'<td>'.
									  		'<select id="user_droit" name="user_droit" class="form-control input-sm">';
											foreach($droits as $droit)
											{
												if($user['droit_id'] == $droit['droit_id']){
													echo "<option value=".Secure::html($user['droit_id'])." selected>".Secure::html($droit['droit_description'])."</option>";
												}else{
													echo "<option value=".Secure::html($droit['droit_id']).">".Secure::html($droit['droit_description'])."</option>";
												}
											}
											echo '</select>'.
										'</td>'.
										'<td>'.
											'<select id="user_affect" name="user_affect" class="form-control input-sm">';
											foreach($affectations as $affect)
											{
												if($user['user_affectation'] == $affect['affectation_id']){
													echo "<option value=".Secure::html($user['user_affectation'])." selected>".Secure::html($affect['affectation_description'])."</option>";
												}else{
													echo "<option value=".Secure::html($affect['affectation_id']).">".Secure::html($affect['affectation_description'])."</option>";
												}
											}
											echo '</select>'.
										'</td>'.
										'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
										'<td><button type="submit" class="btn btn-primary btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment modifier cet utilisateur ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-refresh" aria-hidden="true"></span></button></td>';
							echo '</form>';
							echo '<form method="post" action="application/controleurs/administration.php?action=deluser">'.
								 	'<td><input type="hidden" name="user_id" value="'.Secure::html($user['user_id']).'" />'.
									'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
								 	'<button type="submit" class="btn btn-danger btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment supprimer cet utilisateur ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button>'.
								 	'</td></form>'.
								 '</tr>';
						}
						?>
					</table>
				</div>
				<?php
				} else {
					echo "<p>Aucun utilisateur sur ce calendrier</p>";
				}
				?>
				<div class="col-lg-6"></div>
				<div class="col-lg-6">
					<!-- Ajout d'un utilisateur -->
					<form class="form-inline" id="form_ajout_user" method="post" action="application/controleurs/administration.php?action=adduser" onsubmit="return VerifFormUser(this,'form_ajout_user')">
						<div class="form-group">
							<input type="text" class="form-control input-sm" id="user" name="user" placeholder="Nom (2 lettres min.)"/>				
							<select id="droit_user" name="droit_user" class="form-control input-sm">
								<?php
								foreach($droits as $droit)
								{
									echo "<option value=".Secure::html($droit['droit_id']).">".Secure::html($droit['droit_description'])."</option>";
								}
								?>
							</select>
						
							<select id="affectation_user" name="affectation_user" class="form-control input-sm">
								<?php
								foreach($affectations as $affect)
								{
									echo "<option value=".Secure::html($affect['affectation_id']).">".stripslashes(Secure::html($affect['affectation_description']))."</option>";
								}
								?>
							</select>				
							<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>
							<button type="submit" class="btn btn-success btn-sm"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span></button>
						</div>
					</form>
				</div>
			</div>					
		</div>
		<!-- Affichage des categories -->
		<div id="categories">
			<div class="row">
				<?php
				if(!empty($categories)) {					
				?>
				<div class="col-lg-12">
					<table class="table table-condensed">
						<div class="alert alert-warning alert-dismissible" role="alert">
						 	<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						 	<p><strong>Notes : </strong>Une catégorie contenant des évènements actifs à venir ne peut être supprimée.</p>		
						</div>
						<tr class="tr_adm_table" style="border: 1px solid <?php echo $cal_identite_color;?>;background-color: <?php echo $cal_identite_color;?>;">
							<td colspan="2">Description</td><td>Couleur</td><td colspan="2"></td>
						</tr>
						<?php
						foreach($categories as $cat)
						{
							$cpt_event_venir = compter_evenements_avenir_dune_categorie($cat['categorie_id']);
							echo '<form method="post" action="application/controleurs/administration.php?action=updcat">'.
							 		'<tr>'.
								 		'<td colspan="2"><input type="text" class="form-control input-sm" id="cat_desc" name="cat_desc" value="'.Secure::html($cat['categorie_description']).'"><input type="hidden" name="cat_id" value="'.Secure::html($cat['categorie_id']).'"/></td>'.
								 		'<td><div class="form-inline"><input type="text" class="form-control colors input-sm" id="cat_couleur" name="cat_couleur" size="7" value="'.Secure::html($cat['categorie_couleur']).'"/></div></td>'.
								 		'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
								 		'<td><button type="submit" class="btn btn-primary btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment modifier cette catégorie ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-refresh" aria-hidden="true"></span></button></td>'.
						     	'</form>';

							if($cpt_event_venir==0){
							echo '<form method="post" action="application/controleurs/administration.php?action=delcat">'.
								 	'<td><input type="hidden" name="cat_id" value="'.Secure::html($cat['categorie_id']).'" />'.
										'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
										'<button type="submit" class="btn btn-danger btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment supprimer cette catégorie ainsi que les événements associés ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button>'.
								 	'</td>'.
								 '</form>';
							}else{
								echo '<td><span class="glyphicon glyphicon-ban-circle" aria-hidden="true" title="Suppression impossible - il y a des événements actifs à venir" style="font-size:1.4em;"></span></td>';
							}
							echo '</tr>';
						}
						?>
					</table>
				</div>
				<?php
				} else {
					echo "<p>Aucune catégorie sur ce calendrier</p>";
				}
				?>
				<div class="col-lg-6"></div>
				<div class="col-lg-6">
					<!-- Ajout d'une categorie -->
					<form class="form-inline" id="form_ajout_cat" method="post" action="application/controleurs/administration.php?action=addcat" onsubmit="return VerifFormCat(this,'form_ajout_cat')">
						<div class="form-group">
							<input type="text" class="form-control input-sm" id="cat_desc" name="cat_desc" size="25" maxlength="25" placeholder="Description"/>
							<input type="text" class="form-control colors input-sm" id="cat_couleur" name="cat_couleur" size="7" value="#000000"/>
							<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>
							<button type="submit" class="btn btn-success btn-sm"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span></button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- Affichage des affectations -->
		<div id="affectations">
			<div class="row">
				<div class="col-lg-12">
					<table class="table table-condensed">			
						<div class="alert alert-warning alert-dismissible" role="alert">
						 	<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						 	<p><strong>Notes : </strong>La liste des affectations est commune à tous les calendriers.</p>
							<p>La catégorie par défaut "Autres" ne peut être supprimée.</p>
						</div>
						<tr class="tr_adm_table" style="border: 1px solid <?php echo $cal_identite_color;?>;background-color: <?php echo $cal_identite_color;?>;">
							<td colspan="3">Description</td><td colspan="2"></td>
						</tr>
						<?php
						foreach($affectations as $affect)
						{
							$cpt_user_affect = compter_utilisateurs_dune_affectation($affect['affectation_id']);
							echo '<tr>'.
								  	'<td colspan="3">'.Secure::html($affect['affectation_description']).'</td>'.
							 	  	'<form method="post" action="application/controleurs/administration.php?action=delaffect">'.
									'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
								 	'<td colspan="2"><input type="hidden" name="affect_id" value="'.Secure::html($affect['affectation_id']).'" />';
									if($affect['affectation_id']!="1"){
								 		if($cpt_user_affect==0){
								 			echo '<button type="submit" class="btn btn-danger btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment supprimer cette affectation ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-trash" aria-hidden="true"></button>';
								 		}else{
								 			echo '<span class="glyphicon glyphicon-ban-circle" aria-hidden="true" title="Suppression impossible - il y a au moins un utilisateur dans cette affectation, dans ce calendrier ou dans un autre." style="font-size:1.4em;"></span>';
								 		}
								 	}else{
										echo '<span class="glyphicon glyphicon-ban-circle" aria-hidden="true" title="Suppression impossible - affectation par défaut" style="font-size:1.4em;"></span>';
									}
							echo '</td>'.
								 	'</form>'.
								  '</tr>';
						}
						?>
					</table>
				</div>
				<div class="col-lg-9"></div>
				<div class="col-lg-3">			
					<!-- Ajout d'une affectation -->
					<form class="form-inline" id="form_ajout_affect" method="post" action="application/controleurs/administration.php?action=addaffect" onsubmit="return VerifFormAffect(this,'form_ajout_affect')">
						<div class="form-group">						
							<input type="text" class="form-control input-sm" id="affect_desc" name="affect_desc" size="20" maxlength="20" placeholder="Description"/>
							<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>						
							<button type="submit" class="btn btn-success btn-sm"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span></button>						
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	</body>
	</html>
<?php
}else{
	header('Location: /calendrier/index.php?page=accueil');
}
?>
