<?php
if(isset($_SESSION['user_login'])&&(!empty($_SESSION['user_login'])) && (is_super_admin($_SESSION['user_login']))){
	
	$user_login = Secure::bdd($_SESSION['user_login']);
	
	$cal = Secure::bdd($_GET['cal']);
	$cal_identite_color = $_SESSION['identite_color'];

	$is_super_admin = is_super_admin($user_login);
	$is_admin = is_admin($user_login,recuperer_id($cal));
	$is_editeur = is_editeur($user_login,recuperer_id($cal));
	
	$infos_user = recup_infos($user_login,recuperer_id($cal));
	if(is_user_exist_uid($user_login)){
		$infos_user_ldap = recup_infos_ldap($user_login);
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<title>Calendrier Académique</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/main.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/bootstrap.min.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-ui-custom.css"/>
    <?php
    // Inclusion de la sonde piwik envole
    $applisonde="calendrier";
    include "/var/www/html/sondepiwik/envoleSonde.php"; 
    ?>
	<script type="text/javascript" src="lib/jquery/jquery.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-ui.js"></script>
	<script type="text/javascript" src="lib/bootstrap.min.js"></script>
	<script type="text/javascript" src="lib/scripts/scripts.js"></script>
	<script>
	$(document).ready(function() {
		$("#user").autocomplete({
			source: "includes/searchcn.inc.php",
			minLength: 2
		});		
	});
	</script>
	<style>.ui-autocomplete { height: 150px; overflow-y: scroll; overflow-x: hidden; font-size: 12px;}</style>
</head>
<body>
	<?php require_once 'menu.php';?>
	<div id="container">
		<div id="msg_erreur"></div>
		<?php require_once 'warnings.php';?>		
		<div class="alert alert-warning alert-dismissible" role="alert">
		 	<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		 	<p><strong>Notes : </strong>Avant d'ajouter un super admin, vérifiez bien que cette personne n'est pas déjà admin/éditeur d'un calendrier.</p>
			<p>Un super admin a le droit de créer des calendriers (et de créer/modifier des évènements), de gérer les droits pour chaque calendrier, et de créer d'autres super admin.</p>
		</div>
		<div class="row">
		    <div class="col-lg-12">
				<table class="table table-condensed">
					<tr class="tr_adm_table" style="background-color: <?php echo $cal_identite_color;?>;">
						<td colspan="2">Liste des super admin</td>
					</tr>
					<?php
					$cpt_ligne = 1;
					foreach($sadmins as $sadmin)
					{
						echo "<tr>";
						echo "<td>".$sadmin['user_login']."</td>";
						if($sadmin['user_id'] != 1) {
						echo '<form method="post" action="application/controleurs/gestsadmin.php?action=delsa">'.
							 	'<td class="td_user_del"><input type="hidden" name="user_id" value="'.Secure::html($sadmin['user_id']).'" />'.
							 	'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.							
							 	'<button type="submit" class="btn btn-danger btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment supprimer cet utilisateur ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-trash" aria-hidden="true"></button>'.
							 	'</td></form>'.
							 '</tr>';
						} else {
							echo "<td></td>";
						}					
						echo "</tr>";
					}
					?>
				</table>
			</div>
			<div class="col-lg-9"></div>
			<div class="col-lg-3">
				<form class="form-inline" id="form_ajout_user" method="post" action="application/controleurs/gestsadmin.php?action=addsa" onsubmit="if(this.user.value.length==0){alert('Nom requis.');return false;}">
		            <div class="form-group">
	   					<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>
						<input type="text" class="form-control input-sm"  id="user" name="user" placeholder="Nom (2 lettres min.)"/>
	   				</div>		  
		   			<button type="submit" class="btn btn-success btn-sm"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span></button>
		   		</form>
			</div>
		</div>
	</div>	
</body>
</html>
<?php
}else{
	header('Location: /calendrier/index.php?page=accueil');
}
