<?php
require_once dirname(__FILE__).'/includes/base.inc.php';
require_once dirname(__FILE__).'/application/modeles/evenements.php';
require_once dirname(__FILE__).'/application/modeles/calendriers.php';

$calendrier_titre = Secure::bdd($_GET["cal"]);

if(is_exist_calendrier($calendrier_titre)) {

$filename = $calendrier_titre.".ics";

$events = recuperer_evenements_dun_calendrier_avenir($calendrier_titre);

header('Content-type: text/calendar; charset=utf-8');
header('Content-Disposition: attachment; filename=' . $filename);

$output = "BEGIN:VCALENDAR
METHOD:PUBLISH
VERSION:2.0
PRODID:-//Rectorat Dijon//NONSGML v1.0//EN\n";

foreach($events as $event) {
$output .= "BEGIN:VEVENT
DTEND:".convertDateToiCalNextDay($event['evenement_date_fin'])."
UID:".uniqid()."
DTSTAMP:".dateToCal(time())."
DESCRIPTION:".escapeString($event['evenement_description'])."
SUMMARY:".escapeString($event['evenement_titre'])."
DTSTART:".convertDateToiCal($event['evenement_date_debut'])."
END:VEVENT\n";
}

$output .= "END:VCALENDAR";

echo $output;
}
?>