//Fonction trim (suppression des espaces en début et fin de chaine)
function trim (str) {
	str = str.replace(/^\s+/, '');
	for (var i = str.length - 1; i >= 0; i--) {
		if (/\S/.test(str.charAt(i))) {
			str = str.substring(0, i + 1);
			break;
		}
	}
	return str;
}
//Verifie les champs du formulaire et envoi un message d'erreur sur la page
//La verification comprend :
// - Verification des champs vides
// - Verification des formats de date
// - Coherence des dates saisies
function VerifForm(event_titre,event_date_debut,event_date_fin,event_desc,event_cat,type) {
    var error = "error_"+type;
	if (event_titre == "") {
        document.getElementById(error).innerHTML='Le titre de l\'événement est obligatoire !';        
    	return false;
    }
    if ((event_date_debut == "")||(event_date_fin == "")) {
    	document.getElementById(error).innerHTML='Les dates de l\'événement sont obligatoires !';        
    	return false;
    } else {
    	if((verifierDate(event_date_debut))&&(verifierDate(event_date_fin))){
    		if(comparerDate(event_date_debut,event_date_fin)!=-1){
    			
    		}else{
    			document.getElementById(error).innerHTML='La date de début ne peut-être infèrieure à la date de fin !';    	        
    	    	return false;
    		}    		
    	}else{
    		document.getElementById(error).innerHTML='Le format de date est JJ/MM/AAAA !';	        
	    	return false;
    	}
    }  
    if (event_desc == "") {
    	document.getElementById(error).innerHTML='La description de l\'événement est obligatoire !';       
    	return false;
    } 
    if (event_cat == null) {
    	document.getElementById(error).innerHTML='La catégorie de l\'événement est obligatoire !';       
    	return false;
    } 
    return true;
}
function VerifFormUser(form,name_form) {
	
	var user_login = trim(document.getElementById(name_form).user.value);
	var user_droit = document.getElementById(name_form).droit_user.value;
	var user_affectation = document.getElementById(name_form).affectation_user.value; 
	
	if (user_login == "") {		
        document.getElementById('msg_erreur').innerHTML='Création d\'un nouvel utilisateur - Le login de l\'utilisateur est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.user.focus();
    	return false;
    } else {    	
    	document.getElementById('msg_erreur').style.display='none';    
    }
	
	if (user_droit == "") {
        document.getElementById('msg_erreur').innerHTML='Création d\'un nouvel utilisateur - Le droit de l\'utilisateur est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.user_droit.focus();
    	return false;
    } else {
    	document.getElementById('msg_erreur').style.display='none';
    }
	
	if (user_affectation == "") {
        document.getElementById('msg_erreur').innerHTML='Création d\'un nouvel utilisateur - L\'affectation de l\'utilisateur est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.user_affectation.focus();
    	return false;
    } else {
    	document.getElementById('msg_erreur').style.display='none';
    }
	return true;
}
function VerifFormCat(form,name_form) {
	
	var cat_desc = trim(document.getElementById(name_form).cat_desc.value);	
	var cat_couleur = document.getElementById(name_form).cat_couleur.value;
	
	if (cat_desc == "") {
        document.getElementById('msg_erreur').innerHTML='Création d\'une nouvelle catégorie - La catégorie est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.cat_desc.focus();
    	return false;
    } else {
    	document.getElementById('msg_erreur').style.display='none';
    }
	
	if (cat_couleur == "") {
        document.getElementById('msg_erreur').innerHTML='Création d\'une nouvelle catégorie - La couleur est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.cat_couleur.focus();
    	return false;
    } else {
    	document.getElementById('msg_erreur').style.display='none';
    }
	
	return true;
}
function VerifFormAffect(form,name_form) {	
	
	var affect_desc = trim(document.getElementById(name_form).affect_desc.value);	

	if (affect_desc == "") {
        document.getElementById('msg_erreur').innerHTML='Création d\'une nouvelle affectation - La description est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.affect_desc.focus();
    	return false;
    } else {
    	document.getElementById('msg_erreur').style.display='none';
    }	
	return true;
}
function VerifFormCal(form,name_form) {
	
	var cal_titre = document.getElementById(name_form).cal_titre.value;
	var cal_identite_color = document.getElementById(name_form).cal_identite_color.value;
	var cal_checkbox_color = document.getElementById(name_form).cal_checkbox_color.value; 
	
	if (cal_titre == "") {		
        document.getElementById('msg_erreur').innerHTML='Création d\'un nouveau calendrier - Le titre du calendrier est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.cal_titre.focus();
    	return false;
    } else {    	
    	document.getElementById('msg_erreur').style.display='none';    
    }
	
	if (cal_identite_color == "") {
        document.getElementById('msg_erreur').innerHTML='Création d\'un nouveau calendrier - La couleur d\'identité du calendrier est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.cal_identite_color.focus();
    	return false;
    } else {
    	document.getElementById('msg_erreur').style.display='none';
    }
	
	if (cal_checkbox_color == "") {
        document.getElementById('msg_erreur').innerHTML='Création d\'un nouveau calendrier - La couleur des checkbox du calendrier est obligatoire !';
        document.getElementById('msg_erreur').style.display='block';
        document.getElementById('msg_erreur').className='focus';
    	form.cal_checkbox_color.focus();
    	return false;
    } else {
    	document.getElementById('msg_erreur').style.display='none';
    }
	return true;
}
//Verifie un format de date JJ/MM/AAAA
function verifierDate(dateString){	
	var reg=new RegExp("^(0[1-9]|[12][0-9]|3[01])/(0[1-9]|1[012])/[0-9]{4}$","g");
	return reg.test(dateString);
}
//Verifie un login
function verifierLogin(loginString){	
	var reg=new RegExp("^[a-z0-9]+$","g");
	
	return reg.test(loginString);
}
//Compare 2 dates (JJ-MM-AAAA) et renvoi :
// 1 si la date1 < date2
// 0 si date1 = date2
// -1 si date1 > date2
function comparerDate(date1,date2){
	anneed1 = date1.substr(6,4);
	moisd1 = date1.substr(3,2);
	jourd1 = date1.substr(0,2);
	anneed2 = date2.substr(6,4);
	moisd2 = date2.substr(3,2);
	jourd2 = date2.substr(0,2);
	
	d1 = new Date(0);
	d1.setFullYear(anneed1, moisd1, jourd1);
	d2 = new Date(0);
	d2.setFullYear(anneed2, moisd2, jourd2);
		
	if(d1 > d2)
		res = -1;
	else if(d1 < d2)
		res = 1;
	else
		res = 0;
	
	return res;	
}