<?php
function recuperer_categories()
{
	global $bdd;

	$categories = array();
	try{
		$reponse = $bdd->prepare("SELECT * FROM categories WHERE categorie_etat = ?");
		$reponse -> execute(array("1"));
		while ($donnees = $reponse->fetch())
		{
			 $categories[] = $donnees;
		}
		$reponse->closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $categories;
}
function recuperer_categories_par_cal($cal_id)
{
	global $bdd;

	$categories = array();
	try{
		$reponse = $bdd->prepare("SELECT * FROM categories WHERE categorie_etat = ? AND categorie_calendrier = ? ");
		$reponse -> execute(array("1",$cal_id));
		while ($donnees = $reponse->fetch())
		{
			 $categories[] = $donnees;
		}
		$reponse->closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $categories;
}
function ajouter_categorie($cat_cal,$cat_desc,$cat_col)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("INSERT INTO categories (categorie_calendrier,categorie_description,categorie_couleur) ".
								 "VALUES (?,?,?)");
		$reponse -> execute(array($cat_cal,$cat_desc,$cat_col));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function supprimer_categorie($cat_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE categories SET categorie_etat = ? WHERE categorie_id = ? ;");
		$reponse -> execute(array("0",$cat_id));
		$reponse -> closeCursor();

		$reponse = $bdd->prepare("UPDATE evenements SET evenement_etat = ? WHERE evenement_categorie = ? AND evenement_date_debut < CURDATE();");
		$reponse -> execute(array("0",$cat_id));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function supprimer_categorie_par_cal($cal_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("DELETE FROM categories WHERE categorie_calendrier = ? ;");
		$reponse -> execute(array($cal_id));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function modifier_categorie($cat_id,$cat_desc,$cat_couleur)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE categories SET categorie_couleur = ?, categorie_description = ? WHERE categorie_id = ? ;");
		$reponse -> execute(array($cat_couleur,$cat_desc,$cat_id));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}