<?php
/**********************************************************************************************************/
/****************************** Fonctions basiques (Regexp, format, replace) ******************************/
/**********************************************************************************************************/
//Verifie le format date en AAAA-MM-JJ
function check_date_alt($date){
	$pattern_date = "/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/";
	return preg_match($pattern_date,$date);
}
function check_login($user_login){
	$pattern_login = "^[a-z0-9]+$^";
	return preg_match($pattern_login,$user_login);
}
//Formatage d'une date au format AAAA-MM-DD en JJ/MM/AAAA
function format_date($date,$param){
	$annee = substr($date, 0, 4);
	$mois = substr($date, 5, 2);
	$jour = substr($date, 8, 2);
	$date_format = $jour.'/'.$mois.'/'.$annee;
	return $date_format;
}
//Formatage d'une date au format AAAA-MM-DD en JJ/MM
function format_date_light($date){
	$mois = substr($date, 5, 2);
	$jour = substr($date, 8, 2);
	$date_format = $jour.'/'.$mois;
	return $date_format;
}
//Formatage d'une date au format JJ/MM/AAAA en AAAA-MM-DD
function format_date_inv($date){
	$jour = substr($date, 0, 2);
	$mois = substr($date, 3, 2);
	$annee = substr($date, 6, 4);
	$date_format = $annee.'-'.$mois.'-'.$jour;
	return $date_format;
}
//Fonction pour comparer deux dates
function compare_date($date1,$date2){
	$d1_xpl = explode("-",$date1);
	$d2_xpl = explode("-",$date2);
	$d1_comp = $d1_xpl[0].$d1_xpl[1].$d1_xpl[2];
	$d2_comp = $d2_xpl[0].$d2_xpl[1].$d2_xpl[2];
	if($d2_comp>=$d1_comp){
		return true;
	}else{
		return false;
	}
}
function dateToCal($timestamp) {
    return date('Ymd\THis\Z', $timestamp);
}

// Escapes a string of characters
function escapeString($string) {
    return preg_replace('/([\,;])/','\\\$1', $string);
}

//Transforme une date YYYY-MM-DD en YYYYMMDD
function convertDateToiCal($date) {
    return str_replace("-","",$date);
}
//Transforme une date YYYY-MM-DD en YYYYMMDD et y aoute un jour
//(utile pour la date de fin dans lageneration
//de l'ics pour un event sur plusieurs jours
function convertDateToiCalNextDay($date) {
    $new_date = date('Y-m-d', strtotime('+1 day', strtotime($date)));
    return str_replace("-","",$new_date);
}
//Fonction pour stripslashes les tableau
function stripslashes_deep($value)
{
   $value = is_array($value) ?
               array_map('stripslashes_deep', $value) :
               stripslashes($value);

   return $value;
}
function array_htmlspecialchars($input)
{
    if (is_array($input))
    {
        foreach ($input as $key => $value)
        {
            if (is_array($value)) $input[$key] = array_htmlspecialchars($value);
            else $input[$key] = htmlspecialchars($value);
        }
        return $input;
    }
    return htmlspecialchars($input);
}
//Verifie si un tableau ne contient que des entiers sous forme de string
function arrayHasOnlyInts($array)
{
    foreach ($array as $value)
    {
        if (!ctype_digit($value)) // there are several ways to do this
        {
             return false;
        }
    }
    return true;
}
/**********************************************************************************************************/
/*********************************************** Fonctions LDAP *******************************************/
/**********************************************************************************************************/
function recup_infos_ldap($user_login){
	require dirname(__FILE__).'/../config/ldap.inc.php';
	try{
		$ldapconn = ldap_connect($ldaphost,$ldapport) or die("Impossible de se connecter au serveur LDAP {$ldaphost}");
		$infos_user_ldap = array();
		if($ldapconn){
			$ldapbind = ldap_bind($ldapconn);
	 		if($ldapbind){
	    		$filtre=$ldap_uid."=".$user_login;
		        $read=ldap_search($ldapconn,$ldapdn,$filtre);
		        $info=ldap_get_entries($ldapconn,$read);
	 			if(isset($info[0][$ldap_uid][0])){
		        	$infos_user_ldap[0] = $info[0][$ldap_uid][0];
		        }
		        if(isset($info[0][$ldap_rne][0])){
		        	 $infos_user_ldap[1] = $info[0][$ldap_rne][0];
		        }
		        if(isset($info[0][$ldap_title][0])){
		        	$infos_user_ldap[2] = $info[0][$ldap_title][0];
		        }
	 			 if(isset($info[0][$ldap_cn][0])){
		        	$infos_user_ldap[3] = $info[0][$ldap_cn][0];
		        }
	 			if(isset($info[0][$ldap_fredurne][0])){
		        	$infos_user_ldap[4] = $info[0][$ldap_fredurne][0];
		        }
	 			if(isset($info[0][$ldap_typensi][0])){
		        	$infos_user_ldap[5] = $info[0][$ldap_typensi][0];
	 			}
		        //on recupere le RNE contenu dans le FREDURNE car il est plus à jour que l'attribut RNE
		        if(isset($infos_user_ldap[4])){
		        	$attributs = explode("$",$infos_user_ldap[4]);
		       	 	$infos_user_ldap[6] = $attributs[0];
		        }
	    	}else{
	       		echo 'Connexion LDAP anonmye échouée';
	    	}
		}else{
			echo 'Erreur de connection au serveur LDAP';
		}
		ldap_close($ldapconn);
	}catch(Exception $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $infos_user_ldap;
}
function is_user_exist($cn){
	require dirname(__FILE__).'/../config/ldap.inc.php';
	try{
		$ldapconn = ldap_connect($ldaphost,$ldapport) or die("Impossible de se connecter au serveur LDAP {$ldaphost}");
		if($ldapconn){
			$ldapbind = ldap_bind($ldapconn);
	 		if($ldapbind){
	    		$filtre=$ldap_cn."=".$cn;
		        $read=ldap_search($ldapconn,$ldapdn,$filtre);
		        $info=ldap_get_entries($ldapconn,$read);
				if(empty($info[0][$ldap_uid][0])){
					return false;
				}else{
					return true;
				}
	    	}else{
	       		echo 'Connexion LDAP anonmye échouée';
	    	}
		}else{
			echo 'Erreur de connection au serveur LDAP';
		}
	}catch(Exception $e){
		echo 'Exception : '.$e->getMessage();
	}
	ldap_close($ldapconn);
}
function is_user_exist_uid($uid){
	require dirname(__FILE__).'/../config/ldap.inc.php';
	try{
		$ldapconn = ldap_connect($ldaphost,$ldapport) or die("Impossible de se connecter au serveur LDAP {$ldaphost}");
		if($ldapconn){
			$ldapbind = ldap_bind($ldapconn);
	 		if($ldapbind){
	    		$filtre=$ldap_uid."=".$uid;
		        $read=ldap_search($ldapconn,$ldapdn,$filtre);
		        $info=ldap_get_entries($ldapconn,$read);
				if(empty($info[0][$ldap_uid][0])){
					return false;
				}else{
					return true;
				}
	    	}else{
	       		echo 'Connexion LDAP anonmye échouée';
	    	}
		}else{
			echo 'Erreur de connection au serveur LDAP';
		}
	}catch(Exception $e){
		echo 'Exception : '.$e->getMessage();
	}
	ldap_close($ldapconn);
}
function recuperer_login_ldap($cn){
	require dirname(__FILE__).'/../config/ldap.inc.php';
	try{
		$ldapconn = ldap_connect($ldaphost,$ldapport) or die("Impossible de se connecter au serveur LDAP {$ldaphost}");
		if($ldapconn){
			$ldapbind = ldap_bind($ldapconn);
	 		if($ldapbind){
	    		$filtre=$ldap_cn."=".$cn;
		        $read=ldap_search($ldapconn,$ldapdn,$filtre);
		        $info=ldap_get_entries($ldapconn,$read);
				$user_login = $info[0][$ldap_uid][0];
	    	}else{
	       		echo 'Connexion LDAP anonmye échouée';
	    	}
		}else{
			echo 'Erreur de connection au serveur LDAP';
		}
	}catch(Exception $e){
		echo 'Exception : '.$e->getMessage();
	}
	ldap_close($ldapconn);
	return $user_login;
}
/**********************************************************************************************************/
/******************************************** Fonctions EXPORT CSV ****************************************/
/**********************************************************************************************************/
//Pour récupèrer le nom des champs car on utilise PDO
function getNomsChamps($NomTable,$NbrChamps) {
	require dirname(__FILE__).'/../config/mysql.inc.php';
	global $bdd;
	$reponse = $bdd->query("SHOW COLUMNS FROM $NomTable");
	$ListeChamps = $reponse->fetchAll(PDO::FETCH_ASSOC);
	foreach ($ListeChamps as $Champ) {
		$NomsChamps[] = $Champ['Field'];
	}
	if($NbrChamps!="0"){
		for($i=0; $i<$NbrChamps; $i++){
			$NomsChampsModif[] = $NomsChamps[$i];
		}
		return $NomsChampsModif;
	}else{
		return $NomsChamps;
	}
}