<?php
if(!isset($_SESSION)) {
	session_start();
}
require_once dirname(__FILE__).'/../../includes/base.inc.php';

//On inclut les modèles
require_once dirname(__FILE__).'/../modeles/affectations.php';
require_once dirname(__FILE__).'/../modeles/evenements.php';
require_once dirname(__FILE__).'/../modeles/categories.php';
require_once dirname(__FILE__).'/../modeles/droits.php';
require_once dirname(__FILE__).'/../modeles/usercal.php';
require_once dirname(__FILE__).'/../modeles/users.php';
require_once dirname(__FILE__).'/../modeles/calendriers.php';

$erreur_champs_obl = 'Erreur - Tous les champs sont obligatoires. <a href="../../index.php?page=accueil">Retour</a>';
if(isset($_SESSION['user_login'])&&(!empty($_SESSION['user_login']))
	&& (is_super_admin($_SESSION['user_login']) || is_admin($_SESSION['user_login'],recuperer_id($_GET['cal'])) || is_admin($_SESSION['user_login'],recuperer_id($_POST['user_cal'])))){

	if(isset($_GET['action'])&&(!empty($_GET['action']))){

		switch($_GET['action']){
			//------------------------------ ADDUSER -----------------------------
			case "adduser":
				if(isset($_POST['user'])&&(!empty($_POST['user']))&&
				isset($_POST['droit_user'])&&(!empty($_POST['droit_user']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))&&
				isset($_POST['affectation_user'])&&(!empty($_POST['affectation_user']))){

					//On vérifie d'abord si l'utilisateur existe bien avant de l'ajouter
					if(is_user_exist(Secure::bdd($_POST['user']))) {
						$user_login = recuperer_login_ldap(Secure::bdd($_POST['user']));

						if(!is_super_admin($user_login)) {

							$user_droit = trim(Secure::bdd($_POST['droit_user']));
							$user_cal = recuperer_id(Secure::bdd($_POST['user_cal']));
							$user_affect =  trim(Secure::bdd($_POST['affectation_user']));
							//Si l'user n'existe pas on va le créer puis créer une entrée dans la table de correspondance
							if(is_exist_bdd($user_login) == 0){
								$lastID = ajouter_user($user_login,$user_affect);
								if(ajouter_usercal($lastID, $user_cal, $user_droit)){
									header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=1');
								}
							//Si il existe en base, on va juste le réactiver si nécessaire et créer l'entrée dans la table de correspondance si elle n'existe pas déjà
							}else{
								$user_id = recuperer_user_id($user_login);
								if(activer_user($user_id)){
									if(is_exist_usercal($user_id, $user_cal) == 0){
										if(ajouter_usercal($user_id, $user_cal, $user_droit)){
											header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=1');
										}
									}else{
										header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=1');
									}
								}
							}
						}else{
							header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=1');
						}
					}else{
						header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=1');
					}
				}else{
					echo $erreur_champs_obl;
				}
			break;
			//------------------------------ DELUSER -----------------------------
			case "deluser":
				if(isset($_POST['user_id'])&&(!empty($_POST['user_id']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))){

					$user_id = Secure::bdd($_POST['user_id']);
					$user_cal = recuperer_id(Secure::bdd($_POST['user_cal']));

					//On ne supprime pas un utilisateur, on supprime sa relation avec un calendrier et on le désactive
					if(desactiver_user($user_id)) {
						if(supprimer_usercal_par_user($user_id, $user_cal)){
							header('Location: ../../index.php?page=administration&cal='.Secure::html($_POST['user_cal']).'&sec=1');
						}
					}
				}else{
					echo $erreur_champs_obl;
				}
			break;
			//------------------------------ UPDUSER -----------------------------
			case "upduser":
				if(isset($_POST['user_id'])&&(!empty($_POST['user_id']))&&
				isset($_POST['user_droit'])&&(!empty($_POST['user_droit']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))&&
				isset($_POST['user_affect'])&&(!empty($_POST['user_affect']))){

					$user_id = Secure::bdd($_POST['user_id']);
					$user_droit = Secure::bdd($_POST['user_droit']);
					$user_cal = recuperer_id(Secure::bdd($_POST['user_cal']));
					$user_affect = Secure::bdd($_POST['user_affect']);

					if(modifier_user($user_id,$user_affect)){
						if(modifier_usercal($user_id,$user_cal,$user_droit)){
							header('Location: ../../index.php?page=administration&cal='.Secure::html($_POST['user_cal']).'&sec=1');
						}
					}
				}else{
					echo $erreur_champs_obl;
				}
			break;
			//------------------------------ ADDCAT -----------------------------
			case "addcat":
				if(isset($_POST['cat_desc'])&&(!empty($_POST['cat_desc']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))&&
				isset($_POST['cat_couleur'])&&(!empty($_POST['cat_couleur']))){

					$cat_desc = trim(Secure::bdd($_POST['cat_desc']));
					$cat_cal = recuperer_id(Secure::bdd($_POST['user_cal']));
					$cat_col = trim(Secure::bdd($_POST['cat_couleur']));

					if(ajouter_categorie($cat_cal,$cat_desc,$cat_col)){
						header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=2');
					}
				}else{
					echo $erreur_champs_obl;
				}
			break;
			//------------------------------ DELCAT -----------------------------
			case "delcat":
				if(isset($_POST['cat_id'])&&(!empty($_POST['cat_id']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))){

					$cat_id = Secure::bdd($_POST['cat_id']);

					$cpt_event_venir = compter_evenements_avenir_dune_categorie($cat_id);
					if($cpt_event_venir == 0){
						if(supprimer_categorie($cat_id)){
							header('Location: ../../index.php?page=administration&cal='.Secure::html($_POST['user_cal']).'&sec=2');
						}
					}else{
						header('Location: ../../index.php?page=administration&cal='.Secure::html($_POST['user_cal']).'&sec=2');
					}
				}else{
					echo $erreur_champs_obl;
				}
			break;
			//------------------------------ UPDCAT -----------------------------
			case "updcat":
				if(isset($_POST['cat_id'])&&(!empty($_POST['cat_id']))&&
				isset($_POST['cat_desc'])&&(!empty($_POST['cat_desc']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))&&
				isset($_POST['cat_couleur'])&&(!empty($_POST['cat_couleur']))){

					$cat_id = Secure::bdd($_POST['cat_id']);
					$cat_desc = Secure::bdd($_POST['cat_desc']);
					$cat_cal = recuperer_id(Secure::bdd($_POST['user_cal']));
					$cat_couleur = Secure::bdd($_POST['cat_couleur']);

					if(modifier_categorie($cat_id,$cat_desc,$cat_couleur)){
						header('Location: ../../index.php?page=administration&cal='.Secure::html($_POST['user_cal']).'&sec=2');
					}
				}else{
					echo $erreur_champs_obl;
				}
			break;
			//----------------------------- ADDAFFECT ----------------------------
			case "addaffect":
				if(isset($_POST['affect_desc'])&&(!empty($_POST['affect_desc']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))){

					$affect_desc = trim(Secure::bdd($_POST['affect_desc']));

					if(ajouter_affectation($affect_desc)){
						header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=3');
					}

				}else{
					echo $erreur_champs_obl;
				}
			break;
			//----------------------------- DELAFFECT ----------------------------
			case "delaffect":
				if(isset($_POST['affect_id'])&&(!empty($_POST['affect_id']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))){

					$affect_id = Secure::bdd($_POST['affect_id']);

					if(supprimer_affectation($affect_id)){
						header('Location: ../../index.php?page=administration&cal='.Secure::bdd($_POST['user_cal']).'&sec=3');
					}
				}else{
					echo $erreur_champs_obl;
				}
			break;

			default:
				echo "Erreur - Cette action n'existe pas.";
			break;
		}
	}
	else{
		//On récupère les affectations, users et catégories
		$affectations = recuperer_affectations();
		$users = recuperer_users_par_cal(recuperer_id(Secure::bdd($_GET['cal'])));
		$categories = recuperer_categories_par_cal(recuperer_id(Secure::bdd($_GET['cal'])));
		$droits = recuperer_droits_light();

		//On inclut la vue
		include dirname(__FILE__).'/../vues/administration.php';
	}
}else{
	header('Location: /calendrier/index.php?page=accueil');
}