<?php
if(!isset($_SESSION)) {
	session_start();
}

require_once dirname(__FILE__).'/../../includes/base.inc.php';

//On inclut les modèles
require_once dirname(__FILE__).'/../modeles/affectations.php';
require_once dirname(__FILE__).'/../modeles/evenements.php';
require_once dirname(__FILE__).'/../modeles/categories.php';
require_once dirname(__FILE__).'/../modeles/droits.php';
require_once dirname(__FILE__).'/../modeles/usercal.php';
require_once dirname(__FILE__).'/../modeles/users.php';
require_once dirname(__FILE__).'/../modeles/calendriers.php';

if(isset($_SESSION['user_login']) && !empty($_SESSION['user_login']) && is_super_admin($_SESSION['user_login'])) {

	if(isset($_GET['action'])&&(!empty($_GET['action']))) {

		switch ($_GET['action']) {
			case 'addsa':
				if(isset($_POST['user'])&&(!empty($_POST['user']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))){

					//On vérifie d'abord si l'utilisateur existe bien avant de l'ajouter
					if(is_user_exist(Secure::bdd($_POST['user']))){
						$user_login = recuperer_login_ldap(Secure::bdd($_POST['user']));
						
						//Si l'user n'existe pas on va le créer puis créer une entrée dans la table de correspondance
						if(is_exist_bdd($user_login) == 0){
							$lastID = ajouter_user($user_login,1);
							if(ajouter_usercal($lastID, 1, 1)){
								header('Location: ../../index.php?page=gestsadmin&cal='.Secure::bdd($_POST['user_cal']));
							}
						//Si il existe en base, on va juste le réactiver si nécessaire et créer l'entrée dans la table de correspondance si elle n'existe pas déjà
						}else{
							$user_id = recuperer_user_id($user_login);
							if(activer_user($user_id)){
								if(modifier_user($user_id,1)) {
									if(is_exist_usercal_su($user_id) == 0){
										if(ajouter_usercal($user_id, 1, 1)){
											header('Location: ../../index.php?page=gestsadmin&cal='.Secure::bdd($_POST['user_cal']));
										}
									}else{
										header('Location: ../../index.php?page=gestsadmin&cal='.Secure::bdd($_POST['user_cal']));
									}
								}
							}
						}
					}else{
						header('Location: ../../index.php?page=gestsadmin&cal='.Secure::bdd($_POST['user_cal']));
					}
				}
				break;

			case 'delsa':
				if(isset($_POST['user_id'])&&(!empty($_POST['user_id']))&&
				isset($_POST['user_cal'])&&(!empty($_POST['user_cal']))){

					$user_id = Secure::bdd($_POST['user_id']);
					//On ne supprime pas un utilisateur, on supprime sa relation avec un calendrier et on le désactive
					if(desactiver_user($user_id)) {
						if(supprimer_usercal_par_user($user_id, 1)){						
							header('Location: ../../index.php?page=gestsadmin&cal='.Secure::bdd($_POST['user_cal']));						
						}
					}
				}
				break;
			
			default:
				# code...
				break;
		}

	}else{
		$sadmins = recuperer_superadmin();

		//On inclut la vue
		include dirname(__FILE__).'/../vues/gestsadmin.php';	
	}

}else{
	header('Location: /calendrier/index.php?page=accueil');
}
