<?php
function recuperer_calendriers()
{
	global $bdd;

	$calendriers = array();
	try{
		$reponse = $bdd->prepare("SELECT * FROM calendriers");
		$reponse -> execute(array());
		while ($donnees = $reponse->fetch())
		{
			 $calendriers[] = $donnees;
		}
		$reponse->closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $calendriers;
}
function ajouter_calendrier($cal_titre,$cal_identite_color,$cal_checkbox_color)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("INSERT INTO calendriers (calendrier_titre, calendrier_identite_color, calendrier_checkbox_color) ".
								 "VALUES (?,?,?)");
		$reponse -> execute(array($cal_titre,$cal_identite_color,$cal_checkbox_color));
		$lastID = $bdd->lastInsertId();
		$reponse -> closeCursor();
		return $lastID;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function modifier_calendrier($cal_id,$cal_identite_color,$cal_checkbox_color,$cal_titre,$cal_widget_vue)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE calendriers SET calendrier_titre = ?, calendrier_identite_color = ?, calendrier_checkbox_color = ?, calendrier_widget_vue = ? ".
								 "WHERE calendrier_id = ?");
		$reponse -> execute(array($cal_titre,$cal_identite_color,$cal_checkbox_color,$cal_widget_vue,$cal_id));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function supprimer_calendrier($cal_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("DELETE FROM calendriers WHERE calendrier_id = ?");
		$reponse -> execute(array($cal_id));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function is_exist_calendrier($calendrier_titre)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT count(*) AS cpt_calendrier ".
								 "FROM calendriers ".
								 "WHERE calendrier_titre = ?");
		$reponse -> execute(array($calendrier_titre));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['cpt_calendrier'];
}
function recuperer_id($calendrier_titre)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT calendrier_id ".
								 "FROM calendriers ".
								 "WHERE calendrier_titre = ?");
		$reponse -> execute(array($calendrier_titre));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['calendrier_id'];
}
function recuperer_titre($calendrier_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT calendrier_titre ".
								 "FROM calendriers ".
								 "WHERE calendrier_id = ?");
		$reponse -> execute(array($calendrier_id));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['calendrier_titre'];
}
function recuperer_identite_color($calendrier_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT calendrier_identite_color ".
								 "FROM calendriers ".
								 "WHERE calendrier_id = ?");
		$reponse -> execute(array($calendrier_id));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['calendrier_identite_color'];
}
function recuperer_checkbox_color($calendrier_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT calendrier_checkbox_color ".
								 "FROM calendriers ".
								 "WHERE calendrier_id = ?");
		$reponse -> execute(array($calendrier_id));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['calendrier_checkbox_color'];
}
function recuperer_enum_calendrier()
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SHOW COLUMNS FROM calendriers WHERE field='calendrier_checkbox_color'");
		$reponse -> execute(array());
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return explode("','",substr($donnees['Type'],6,-2));
}