<?php
function recuperer_users()
{
	global $bdd;

	$users = array();
	try{
		$reponse = $bdd->prepare("SELECT * FROM users WHERE user_etat = ?");
		$reponse -> execute(array("1"));
		while ($donnees = $reponse->fetch())
		{
			 $users[] = $donnees;
		}
		$reponse -> closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $users;
}
function recuperer_users_par_cal($cal_id)
{
	global $bdd;

	$users = array();
	try{
		$reponse = $bdd->prepare("SELECT * FROM users, usercal ".
								 "WHERE users.user_id=usercal.user_id ".
								 "AND usercal.calendrier_id = ? ".
								 "AND users.user_id != ?".
								 "AND usercal.droit_id != ?".
								 "AND user_etat = ? ");
		$reponse -> execute(array($cal_id,"1","1","1"));
		while ($donnees = $reponse->fetch())
		{
			 $users[] = $donnees;
		}
		$reponse -> closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $users;
}
function ajouter_user($user_login,$user_affectation)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("INSERT INTO users (user_login,user_affectation) ".
								 "VALUES (?,?)");
		$reponse -> execute(array($user_login,$user_affectation));
		$lastID = $bdd->lastInsertId();
		$reponse -> closeCursor();
		return $lastID;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function supprimer_user($user_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("DELETE FROM users WHERE user_id = ? AND user_id != ?");
		$reponse -> execute(array($user_id,"1"));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function modifier_user($user_id,$user_affectation)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE users SET user_affectation = ? WHERE user_id = ? AND user_id != ?");
		$reponse -> execute(array($user_affectation,$user_id,"1"));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function desactiver_user($user_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE users SET user_etat = ? WHERE user_id = ? AND user_id != ?");
		$reponse -> execute(array("0",$user_id,"1"));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function activer_user($user_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("UPDATE users SET user_etat = ? WHERE user_id = ? AND user_id != ?");
		$reponse -> execute(array("1",$user_id,"1"));
		$reponse -> closeCursor();
		return true;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}
function is_exist_bdd($user_login)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT count(*) AS cpt_user ".
								 "FROM users ".
								 "WHERE user_login = ?");
		$reponse -> execute(array($user_login));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['cpt_user'];
}
function is_editeur($user_login,$cal_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT count(*) AS cpt_user ".
								 "FROM users, usercal ".
								 "WHERE users.user_id=usercal.user_id ".
								 "AND user_login = ? ".
								 "AND droit_id = ? ".
								 "AND calendrier_id = ? ".
								 "AND user_etat = ?");
		$reponse -> execute(array($user_login,"3",$cal_id,"1"));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['cpt_user'];
}
function is_admin($user_login,$cal_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT count(*) AS cpt_user ".
								 "FROM users, usercal ".
								 "WHERE users.user_id=usercal.user_id ".
								 "AND user_login = ? ".
								 "AND droit_id = ? ".
								 "AND calendrier_id = ? ".
								 "AND user_etat = ?");
		$reponse -> execute(array($user_login,"2",$cal_id,"1"));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['cpt_user'];
}
function is_super_admin($user_login)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT count(*) AS cpt_user ".
								 "FROM users, usercal ".
								 "WHERE users.user_id=usercal.user_id ".
								 "AND user_login = ? ".
								 "AND droit_id = ? ".
								 "AND user_etat = ?");
		$reponse -> execute(array($user_login,"1","1"));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['cpt_user'];
}
function recup_infos($user_login,$cal_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT * FROM users, affectations, droits, usercal ".
								 "WHERE users.user_affectation=affectations.affectation_id ".
								 "AND users.user_id=usercal.user_id ".
								 "AND usercal.droit_id=droits.droit_id ".
								 /*#16173"AND calendrier_id= ? ".*/
								 "AND user_login = ? ");
		$reponse -> execute(array(/*$cal_id,*/$user_login));
		$infos_user = array();
		while ($donnees = $reponse->fetch())
		    {
		    	$infos_user[0] = $donnees['user_login'];
		      	$infos_user[1] = $donnees['droit_id'];
		      	$infos_user[2] = $donnees['droit_description'];
		      	$infos_user[3] = $donnees['user_affectation'];
		      	$infos_user[4] = $donnees['affectation_description'];
		      	$infos_user[5] = $donnees['user_id'];
		    }
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $infos_user;
}
function recuperer_user_id($user_login)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT user_id ".
								 "FROM users ".
								 "WHERE user_login = ?");
		$reponse -> execute(array($user_login));
		$donnees = $reponse->fetch();
		$reponse->closeCursor();
	}catch(PDOException $e){
		echo 'Exception : '.$e->getMessage();
	}
	return $donnees['user_id'];
}
function recuperer_superadmin()
{
	global $bdd;

	$sadmins = array();
	try{
		$reponse = $bdd->prepare("SELECT users.user_id, user_login ".
								 "FROM users, usercal ".
								 "WHERE users.user_id=usercal.user_id ".
								 "AND usercal.droit_id = ?");
		$reponse -> execute(array("1"));
		while ($donnees = $reponse->fetch())
		{
			 $sadmins[] = $donnees;
		}
		$reponse -> closeCursor();
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
	return $sadmins;
}
function compter_utilisateurs_dune_affectation($affect_id)
{
	global $bdd;

	try{
		$reponse = $bdd->prepare("SELECT COUNT(*) AS cpt_user FROM users WHERE user_affectation = ? AND user_etat = ?");
		$reponse -> execute(array($affect_id,1));
		$donnees = $reponse->fetch();
		$cpt_user = $donnees['cpt_user'];
		$reponse->closeCursor();
		return $cpt_user;
	}catch (Exception $e)
	{
		die('Erreur : ' . $e->getMessage());
	}
}