<?php
if(isset($_SESSION['user_login'])&&(!empty($_SESSION['user_login']))){
$user_login = Secure::bdd($_SESSION['user_login']);

$cal = Secure::bdd($_GET['cal']);
$cal_checkbox_color = $_SESSION['checkbox_color'];

$is_admin = is_admin($user_login,recuperer_id($cal));
$is_super_admin = is_super_admin($user_login);
$is_editeur = is_editeur($user_login,recuperer_id($cal));

if($is_super_admin) {
	$infos_user = recup_infos($user_login,1);
} else {
	$infos_user = recup_infos($user_login,recuperer_id($cal));
}

if(is_user_exist_uid($user_login)){
	$infos_user_ldap = recup_infos_ldap($user_login);
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<title>Calendrier Académique</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/main.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/bootstrap.min.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-ui-custom.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-notify.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery.prettyCheckable.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/fullcalendar.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/fullcalendar.print.css" media="print"/>
	<?php
	// Inclusion de la sonde piwik envole
	$profil = "??";
	if (isset($_SESSION['user_profil'])) $profil = $_SESSION['user_profil']; 
	if(file_exists('/var/www/html/sondepiwik/envoleTrackeur.js.php')) echo "<script src='/sondepiwik/envoleTrackeur.js.php?appli=calendrier&profil=$profil'></script>";
	elseif(file_exists('/var/www/html/piwik/envoleTrackeur.js.php')) echo "<script src='/piwik/envoleTrackeur.js.php?appli=calendrier&amp;profil=".$profil."'></script>"; 
	?>
	<script type="text/javascript" src="lib/jquery/jquery.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-ui.js"></script>
	<script type="text/javascript" src="lib/bootstrap.min.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-qtip.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-notify.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-prettyCheckable.js"></script>
	<script type="text/javascript" src="lib/scripts/fullcalendar.js"></script>
	<script type="text/javascript" src="lib/scripts/scripts.js"></script>
	<script type="text/javascript">
	$(document).ready(function() {
		event_affectation = '';
		$("#container_calendar_add").dialog({autoOpen: false});
		$("#container_calendar_mod").dialog({autoOpen: false});
		jQuery('input').filter('.datepicker').datepicker({
			dateFormat: 'dd/mm/yy',
			monthNames: ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'],
			dayNamesMin: ['Di', 'Lu', 'Ma', 'Me', 'Je', 'Ve', 'Sa']
		});

		$("[name^='chbox_']").attr('checked', true);

		show_calendar('all');

		$("input:submit, input:button",".demo").button();

		$(".notify").css('display','none');

	 	$('input.myClass').prettyCheckable({
			color: '<?php echo $cal_checkbox_color;?>'
		});
	});
	function show_calendar(array_cat_id){
		
		//On convertit le tableau en string pour l'envoyer en POST, un array ne passe pas
		array_cat_id = array_cat_id.toString();
		event_cal = "<?php echo $cal;?>";
		
		$('#calendar').fullCalendar({
			header: {left: 'prev,next today',center: 'title',right: ''},aspectRatio: 2,firstDay: 1,
			events: {
				url: "application/modeles/calendrierjson.php",
				type: 'POST',
				data: { cat: array_cat_id, cal: event_cal },
			},
			eventBorderColor: "#A6BEDE",
			eventRender: function(event, element) {
				if(event.end == null){
					element.qtip({
					content: '<u><b>Description</b></u> : '+event.description+'<br/>'+'<u><b>Début</b></u> : '+$.fullCalendar.formatDate(event.start,'dd/MM/yyyy'),
					position: {target: 'mouse'},
					style: {background: event.color,textAlign: 'left',border: {width: 1,radius: 5,color: event.color},tip: 'topLeft'}});
				}else{
					element.qtip({
					content: '<u><b>Description</b></u> : '+event.description+'<br/>'+'<u><b>Début</b></u> : '+$.fullCalendar.formatDate(event.start,'dd/MM/yyyy')+'<br/>'+'<u><b>Fin</b></u> : '+$.fullCalendar.formatDate(event.end,'dd/MM/yyyy'),
					position: {target: 'mouse'},
					style: {background: event.color,textAlign: 'left',border: {width: 1,radius: 5,color: event.color},tip: 'topLeft'}});
				}
			},
			loading: function(bool) {
				if (bool) $('#loading').show();
				else $('#loading').hide();
			},
			<?php
			if($is_admin || $is_editeur || $is_super_admin){
			?>
			dayClick: function(date) {
				var date_debut = $.fullCalendar.formatDate(date,'dd-MM-yyyy');
				var d = new Date();
				var date_ajd = $.fullCalendar.formatDate(d,'dd/MM/yyyy');
				if(comparerDate(date_ajd,date_debut)!=-1){
					//initialisation des champs à vide
					document.getElementById("error_add").innerHTML='';
					document.getElementById("event_titre_add").value='';
					document.getElementById("event_desc_add").value='';
					//et des dates
					var d_event = $.fullCalendar.formatDate(date,'dd/MM/yyyy');
					document.getElementById("event_date_debut_add").value = d_event;
					document.getElementById("event_date_fin_add").value = d_event;
					$("#container_calendar_add").dialog({
						autoOpen: true,
						minHeight: 0,
						minWidth: 600
					});
				}
			},
			eventClick: function(event) {
				document.getElementById("error_mod").innerHTML='';
				var affectation_user = <?php echo $infos_user[3];?>;
				if(event.affectation == affectation_user){
					document.getElementById("event_id_mod").value = event.id;
					document.getElementById("event_titre_mod").value = event.title;
					document.getElementById("event_date_debut_mod").value = $.fullCalendar.formatDate(event.start,'dd/MM/yyyy');
					if(event.end == null){
						document.getElementById("event_date_fin_mod").value = $.fullCalendar.formatDate(event.start,'dd/MM/yyyy');
					}else{
						document.getElementById("event_date_fin_mod").value = $.fullCalendar.formatDate(event.end,'dd/MM/yyyy');
					}
					document.getElementById("event_desc_mod").value = event.description;
					document.getElementById("event_id_del").value = event.id;
					document.getElementById("affect_id_del").value = event.affectation;
					$("#container_calendar_mod").dialog({
						autoOpen: true,
						minHeight: 0,
						minWidth: 600
					});
				}
				$('.styled-select-mod option[value='+event.categorie+']').attr("selected", "selected");
			},
			<?php
			}
			?>
			eventMouseover: function(event, element, view) {
				$(this).css({"cursor": "pointer"});
			}
		});
	}

	function update_calendar(){
		$('#calendar').fullCalendar('destroy');
		//On met dans un tableau les catégories à afficher
		var array_cat_id = new Array();
		$("input:checkbox:checked").each(function(){
				array_cat_id.push($(this).val());
			}
	    );
		show_calendar(array_cat_id);
	}

	//Notifications
	function create( template, vars, opts ){
		return $container.notify("create", template, vars, opts);
	}

	$(function() {
		//Notification
		$container = $("#notification").notify();
		//Formulaires
		$(".submit_add").click(function() {
			var title = $("#event_titre_add").val();
			var date_debut = $("#event_date_debut_add").val();
			var date_fin = $("#event_date_fin_add").val();
			var desc = $("#event_desc_add").val();
			var cal = $("#event_cal").val();
			var cat = $("#event_cat_add").val();
			var dataString = 'event_cal='+ cal + '&event_titre_add='+ title + '&event_date_debut_add=' + date_debut + '&event_date_fin_add=' + date_fin + '&event_desc_add=' + desc + '&event_cat_add=' + cat;

			if(VerifForm(title,date_debut,date_fin,desc,cat,"add")){
				$.ajax({
					type: "POST",
					url: "application/controleurs/evenements.php?action=add",
					data: dataString,
					success: function(){
						//ajout de la notification
						create("default", { title:'Notification événement', text:'Evénement '+title+' ajouté avec succès.'});
						//On ferme le formulaire
						$("#container_calendar_add").dialog("close");
						//On réinitialise les event du calendrier
						$('#calendar').fullCalendar('refetchEvents');
					}
				});
			}else{
				$('.error').fadeOut(200).show();
			}
			return false;
		});
		$(".submit_mod").click(function() {
			var id = $("#event_id_mod").val();
			var title = $("#event_titre_mod").val();
			var date_debut = $("#event_date_debut_mod").val();
			var date_fin = $("#event_date_fin_mod").val();
			var desc = $("#event_desc_mod").val();
			var cal = $("#event_cal").val();
			var cat = $("#event_cat_mod").val();
			var dataString = 'event_cal='+ cal + '&event_id_mod='+ id + '&event_titre_mod='+ title + '&event_date_debut_mod=' + date_debut + '&event_date_fin_mod=' + date_fin + '&event_desc_mod=' + desc + '&event_cat_mod=' + cat;

			if(VerifForm(title,date_debut,date_fin,desc,cat,"mod")){
				$.ajax({
					type: "POST",
					url: "application/controleurs/evenements.php?action=update",
					data: dataString,
					success: function(){
						create("default", { title:'Notification événement', text:'Evénement '+title+' modifié avec succès.'});
						$("#container_calendar_mod").dialog("close");
						$('#calendar').fullCalendar('refetchEvents');
					}
				});
			}else{
				$('.error').fadeOut(200).show();
			}
			return false;
		});
		$(".submit_del").click(function() {
			 if(confirm("Voulez-vous vraiment supprimer cet événement ?")) {
				var id = $("#event_id_del").val();
				var affect = $("#affect_id_del").val();
				var cal = $("#event_cal").val();
				var dataString = 'event_cal='+ cal + '&event_id_del='+ id + '&affect_id_del='+ affect;

				if(id=='' || affect=='')
				{
					$('.error').fadeOut(200).show();
				}
				else
				{
					$.ajax({
						type: "POST",
						url: "application/controleurs/evenements.php?action=delete",
						data: dataString,
						success: function(){
							create("default", { title:'Notification événement', text:'Evénement supprimé avec succès.'});
							$("#container_calendar_mod").dialog("close");
							$('#calendar').fullCalendar('refetchEvents');
						}
					});
				}
				return false;
			 }
		});
	});
	</script>
</head>
<body>
<div id="notification" style="display:none;">
	<div id="default">
		<a class="ui-notify-close ui-notify-cross" href="#">x</a>
		<h1>#{title}</h1>
		<p>#{text}</p>
	</div>
</div>
<?php require_once 'menu.php';?>
<div id="container">
	<?php require_once 'warnings.php';?>
	<div id="legende">
		<table class="tab_legende">
			<tr class="tab_legende_cat">
			<?php
			if(count($categories)!=0){
				$taille = 100/count($categories);
			}else{
				$taille = 100;
			}
			foreach($categories as $cat){
				echo "<td class=\"default\" style=\"width:".$taille."%;\">".Secure::html($cat['categorie_description'])."</td>";
			}
			?>
			</tr>
			<tr>
			<?php
			foreach($categories as $cat){
				echo "<td style=\"background-color:".Secure::html($cat['categorie_couleur']).";height:2px;\"</td>";
			}
			?>
			</tr>
			<tr>
			<?php
			foreach($categories as $cat){
				echo "<td onclick='update_calendar()'><input type='checkbox' class='myClass' name='chbox_".Secure::html($cat['categorie_id'])."' value='".Secure::html($cat['categorie_id'])."'></td>";
			}
			?>
			</tr>
		</table>
	</div>
	<div id="container_calendar">
		<div id='loading' style='display:none'>chargement...</div>
		<div id='switch_calendar' class="demo"><button type="button" class="btn btn-default" onclick="update_calendar('all');">Mois</button><button type="button" class="btn btn-default" onclick="window.location.href='index.php?page=calendrier_T&cal=<?php echo $_GET['cal']; ?>'">Trimestre</button></div>
		<div id='calendar'></div>
	</div>
	<div id="container_calendar_add" title="Ajout d'un événement">
		<span id="error_add" class="error" style="display:none;"></span>
		<form method="post" name="form">
			<table class="table table-condensed">
				<tr><td>Titre : </td><td><input type="text" class="form-control input-sm" id="event_titre_add" name="event_titre_add" size="40" maxlength="40" /></td></tr>
				<tr><td>Début : </td><td><input type="text" class="form-control datepicker input-sm" id="event_date_debut_add" name="event_date_debut_add" maxlength="10" value=""/></td><tr>
				<tr><td>Fin : </td><td><input type="text" class="form-control datepicker input-sm" id="event_date_fin_add" name="event_date_fin_add" maxlength="10" value=""/></td></tr>
				<tr><td>Description :  </td><td><input type="text" class="form-control input-sm" id="event_desc_add" name="event_desc_add" maxlength="200" /></p></td></tr>
				<tr><td>Catégorie : </td>				
					<td>
						<select id="event_cat_add" name="event_cat_add" class="form-control input-sm">
							<?php
							foreach($categories as $cat){
								echo "<option value=".Secure::html($cat['categorie_id']).">".Secure::html($cat['categorie_description'])."</option>";
							}
							?>
						</select>
					</td>
				</tr>
				<input type="hidden" id="event_cal" name="event_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>
				<tr><td colspan="4" style="text-align:right"><button type="submit" class="btn btn-success btn-sm submit_add"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span></button></td></tr>
			</table>
		</form>
	</div>
	<div id="container_calendar_mod" title="Modification d'un événement">
		<span id="error_mod" class="error" style="display:none;"></span>
		<form method="post" name="form">
			<table class="table table-condensed">
				<tr><td>Titre : </td><td><input type="text" class="form-control input-sm" id="event_titre_mod" name="event_titre_mod" maxlength="40" value=""/><input type="hidden" id="event_id_mod" name="event_id_mod" value="" /></td></tr>
				<tr><td>Début : </td><td><input type="text" class="form-control datepicker input-sm" id="event_date_debut_mod" name="event_date_debut_mod" maxlength="10" value=""/></td><tr>
				<tr><td>Fin : </td><td><input type="text" class="form-control datepicker input-sm" id="event_date_fin_mod" name="event_date_fin_mod" maxlength="10" value=""/></td></tr>
				<tr><td>Description :  </td><td><input type="text" class="form-control input-sm" id="event_desc_mod" name="event_desc_mod" maxlength="200" value="" /></p></td></tr>
				<tr><td>Catégorie : </td>
				<td>
					<div class="styled-select-mod">
						<select id="event_cat_mod" name="event_cat_mod" class="form-control input-sm">
						<?php
						foreach($categories as $cat){
							echo "<option value=".Secure::html($cat['categorie_id']).">".Secure::html($cat['categorie_description'])."</option>";
						}
						?>
						</select>
					</div>
				</td></tr>
				<input type="hidden" id="event_cal" name="event_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>
				<input type="hidden" id="event_id_del" name="event_id_del" value="" /><input type="hidden" id="affect_id_del" name="affect_id_del" value="" />
				<tr><td colspan="4" style="text-align:right">
					
					<button type="submit" class="btn btn-success btn-sm submit_mod"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span></button>
					<button type="submit" class="btn btn-danger btn-sm submit_del"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button>
				</td><tr>
			</table>
		</form>
	</div>
</div>
</body>
</html>
<?php
} else {
	header('Location: /calendrier/index.php?page=accueil');
}
?>
