<?php
if(isset($_SESSION['user_login'])&&(!empty($_SESSION['user_login'])) && (is_super_admin($_SESSION['user_login']))){
	
	$user_login = Secure::bdd($_SESSION['user_login']);
	
	$cal = Secure::bdd($_GET['cal']);
	$cal_identite_color = $_SESSION['identite_color'];

	$is_super_admin = is_super_admin($user_login);
	$is_admin = is_admin($user_login,recuperer_id($cal));
	$is_editeur = is_editeur($user_login,recuperer_id($cal));
	
	$infos_user = recup_infos($user_login,recuperer_id($cal));
	if(is_user_exist_uid($user_login)){
		$infos_user_ldap = recup_infos_ldap($user_login);
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<title>Calendrier Académique</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/main.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/bootstrap.min.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-ui-custom.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery-notify.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/jquery.prettyCheckable.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/fullcalendar.css"/>
	<link rel="stylesheet" type="text/css" href="<?php echo $url_css;?>/fullcalendar.print.css" media="print"/>
	<link type="text/css" rel="stylesheet" href="<?php echo $url_css;?>/jquery.miniColors.css" />
	<?php
	// Inclusion de la sonde piwik envole
	$profil = "??";
	if (isset($_SESSION['user_profil'])) $profil = $_SESSION['user_profil']; 
	if(file_exists('/var/www/html/sondepiwik/envoleTrackeur.js.php')) echo "<script src='/sondepiwik/envoleTrackeur.js.php?appli=calendrier&profil=$profil'></script>";
	elseif(file_exists('/var/www/html/piwik/envoleTrackeur.js.php')) echo "<script src='/piwik/envoleTrackeur.js.php?appli=calendrier&amp;profil=".$profil."'></script>"; 
	?>
	<script type="text/javascript" src="lib/jquery/jquery.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-ui.js"></script>
	<script type="text/javascript" src="lib/bootstrap.min.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-qtip.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-notify.js"></script>
	<script type="text/javascript" src="lib/jquery/jquery-prettyCheckable.js"></script>
	<script type="text/javascript" src="lib/scripts/fullcalendar.js"></script>
	<script type="text/javascript" src="lib/scripts/jquery.miniColors.js"></script>
	<script type="text/javascript" src="lib/scripts/scripts.js"></script>
	<script>
	$(document).ready(function() {
		$(".colors").miniColors();
	});
	</script>
</head>
<body>
<?php require_once 'menu.php';?>
<div id="container">
	<div id="msg_erreur"></div>
	<?php require_once 'warnings.php';?>
	<div class="row">
		<div class="col-lg-12">
			<table class="table table-condensed">
				<tr class="tr_adm_table" style="background-color: <?php echo $cal_identite_color;?>;">
					<td>Titre</td><td>Couleur identité</td><td>Couleur checkbox</td><td width="25%">Vue Widget</td><td colspan="2"></td>
				</tr>
				<?php
				foreach($calendriers as $calendrier){
					echo '<form method="post" action="application/controleurs/gestcalendrier.php?action=update">'.
						 '<tr>'.
						 '<td><input type="text" class="form-control input-sm" id="cal_titre" name="cal_titre" size="20" maxlength="20" value="'.$calendrier['calendrier_titre'].'"/></td>'.
						 '<td><div class="form-inline"><input type="text" id="cal_identite_color" name="cal_identite_color" class="form-control colors input-sm" size="7" value="'.$calendrier['calendrier_identite_color'].'"/></div></td>'.
						 '<td>'.
				  		 '<select id="cal_checkbox_color" name="cal_checkbox_color" class="form-control input-sm">';
						 foreach($enums as $enum)
						 {
						 	if($calendrier['calendrier_checkbox_color'] == $enum){
								echo "<option value=".Secure::html($enum)." selected>".Secure::html($enum)."</option>";
							}else{
								echo "<option value=".Secure::html($enum).">".Secure::html($enum)."</option>";
						 	}
						 }
						echo '</select>'.
						'</td>'.
						'<td>'.
						'<select id="cal_widget_vue" name="cal_widget_vue" class="form-control input-sm">';
						foreach ($widgetvues as $key => $vue) {
							switch ($vue) {
								case 'd':
									$vue_lib = "Événements du jour";
									break;
								case 'w':
									$vue_lib = "Événements de la semaine";
									break;
								case 'm':
									$vue_lib = "Événements du mois (par défaut)";
									break;
								case 'y':
									$vue_lib = "Événements de l'année";
									break;
								default:
									$vue_lib = "";
									break;
							}
							if($calendrier['calendrier_widget_vue'] == $vue){
								echo "<option value=".Secure::html($vue)." selected>".Secure::html($vue_lib)."</option>";
							}else{
								echo "<option value=".Secure::html($vue).">".Secure::html($vue_lib)."</option>";
						 	}
						}
						echo '</select>'.
						'</td>'.
						'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
						'<input type="hidden" id="cal_id" name="cal_id" size="40" maxlength="30" value="'.Secure::html($calendrier['calendrier_id']).'"/>'.
						'<td><button type="submit" class="btn btn-primary btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment modifier ce calendrier ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-refresh" aria-hidden="true"></span></button></td>'.
						'</form>';
					if($calendrier['calendrier_id']!=1) {
					echo '<form method="post" action="application/controleurs/gestcalendrier.php?action=delete">'.
						 	'<td><input type="hidden" name="cal_id" value="'.Secure::html($calendrier['calendrier_id']).'" />'.
							'<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="'.$cal.'"/>'.
							'<button type="submit" class="btn btn-danger btn-sm" onclick="if(window.confirm(\'Voulez-vous vraiment supprimer ce calendrier, ainsi que ses événements, utilisateurs et catégories ?\')){return true;}else{return false;};"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button>'.
						 	'</td></form>';						
					} else {
						echo '<td><span class="glyphicon glyphicon-ban-circle" aria-hidden="true" title="Suppression impossible - calendrier par défaut" style="font-size:1.4em;"></span></td>';
					}
					echo '</tr>';
				}
				?>
			</table>
		</div>
		<div class="col-lg-6"></div>
		<div class="col-lg-6">
			<form class="form-inline" id="form_ajout_cal" method="post" action="application/controleurs/gestcalendrier.php?action=add" onsubmit="return VerifFormCal(this,'form_ajout_cal')">
	            <div class="form-group">
	            	<input type="text" class="form-control input-sm" id="cal_titre" name="cal_titre" maxlength="20" placeholder="Titre du calendrier"/>
	            	<input type="hidden" id="user_cal" name="user_cal" size="40" maxlength="30" value="<?php echo $cal;?>"/>
	            </div>
	            <div class="form-group">
					<input type="text" id="cal_identite_color" name="cal_identite_color" class="form-control colors input-sm" size="7" value="#000000"/>
				</div>
				<div class="form-group">
					<select class="form-control input-sm" id="cal_checkbox_color" name="cal_checkbox_color">
						<?php 
						foreach($enums as $enum){
							echo '<option value='.Secure::html($enum).'>'.stripslashes($enum).'</option>';
						}
						?>
					</select>
				</div>
	   			<button type="submit" class="btn btn-success btn-sm"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span></button>
	   		</form>
		</div>

	</div>
</div>
</body>
</html>
<?php
}else{
	header('Location: /calendrier/index.php?page=accueil');
}
