<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<script type="text/javascript" src="lib/jquery/jquery.js"></script>
	<script type="text/javascript">
	$(document).ready(function() {
		$("[id^='caldiv_']").hide();
		$(".caldiv:first").fadeIn(1200).show();
		$(".cala:first").css({"color":"#CF2D8F","font-weight":"bold","border-bottom":"5px solid #CF2D8F"});
	});
	function OuvrirPopup(page,nom,option) {
		   var win = window.open(page,nom,option);
		   win.focus();
		}
	function show_content(cal) {
		$("[id^='caldiv_']").hide();
		$("#caldiv_"+cal).fadeIn(1200).show();
		$(".cala").css({"color":"#476670","font-weight":"normal","border-bottom":"5px solid #ccc"});
		$("#cala_"+cal).css({"color":"#CF2D8F","font-weight":"bold","border-bottom":"5px solid #CF2D8F"});
	}
	</script>
	<?php
	// Inclusion de la sonde piwik envole
	if(file_exists('/var/www/html/sondepiwik/envoleTrackeur.js.php')) 
	{
	    include "/var/www/html/sondepiwik/envoleProfil.php";     
	    echo "<script src='/sondepiwik/envoleTrackeur.js.php?appli=calendrier&profil=$profil'></script>";
	}
	elseif(file_exists('/var/www/html/piwik/envoleTrackeur.js.php')) 
	{     
	    include "/var/www/html/piwik/envoleProfil.php";     
	    echo "<script src='/piwik/envoleTrackeur.js.php?appli=calendrier&amp;profil=".$profil."'></script>"; 
	}
	?>
	<style>
	body {
		font-size: 0.8em;
		font-family: Arial,Tahoma,Verdana,sans-serif;
	}
	a {
		text-decoration:none;
		color:#666;
	}
	#affichage img{
		float:right;
		margin:-10px -8px 0 0;
	}
	ul.calist{
		background: #fff;
		list-style-type: none;
		list-style-image: none;
		padding:0 0 40px 10px;
		margin: 0px;
		border: 0px;
	}
	ul.eventlist{
		background: #fff;
		list-style-type: none;
		list-style-image: none;
		padding:0 5px 0 5px;
		margin: 0px;
		border: 0px;
	}
	ul.calist li{
		float: left;
		height: 21px;
		margin: 2px 2px 0 2px;
		border: 1px solid #778;
		list-style-type: none;
		list-style-image: none;
		border: 0px;
		background-color: #fff;
		border-bottom: 5px solid #ccc;
	}
	ul.calist a {
		float: left;
		display: block;
		text-decoration: none;
		padding: 3px;
		color: #476670;
	}
	.caldiv ul{
		list-style-type: none;
	}
	.caldiv ul li{
		background: #E9E9E9;
	}
	</style>
</head>
<?php
require_once dirname(__FILE__).'/includes/base.inc.php';
require_once dirname(__FILE__).'/includes/auth.inc.php';
require_once dirname(__FILE__).'/includes/functions.inc.php';
require_once dirname(__FILE__).'/application/modeles/users.php';
require_once dirname(__FILE__).'/application/modeles/calendriers.php';

$calendriers = recuperer_calendriers();

echo '<div id="container">';	
	echo '<ul class="calist">';
	foreach($calendriers as $calendrier)
	{
		echo '<li id="calli_'.$calendrier['calendrier_titre'].'" class="calli"><a href="javascript:show_content(\''.$calendrier['calendrier_titre'].'\');" id="cala_'.$calendrier['calendrier_titre'].'" class="cala">'.$calendrier['calendrier_titre'].'</a></li>';
	}
	echo '</ul>';

	foreach($calendriers as $calendrier)
	{
		switch ($calendrier['calendrier_widget_vue']) {
			case 'd':
				$req_event = 'SELECT * FROM evenements, categories, calendriers '.
						 'WHERE evenements.evenement_categorie=categories.categorie_id '.
						 'AND evenements.evenement_calendrier=calendriers.calendrier_id '.
						 'AND (evenement_date_debut <= CURDATE() && evenement_date_fin >= CURDATE()) '.
						 'AND calendrier_titre = ? '.
						 'AND evenement_etat = ? '.
						 'ORDER BY evenement_date_debut';				
				break;
			case 'w':
				$req_event = 'SELECT * FROM evenements, categories, calendriers '.
						 'WHERE evenements.evenement_categorie=categories.categorie_id '.
						 'AND evenements.evenement_calendrier=calendriers.calendrier_id '.
						 'AND (evenement_date_debut <= CURDATE() + INTERVAL 7 DAY && evenement_date_fin >= CURDATE()) '.
						 'AND calendrier_titre = ? '.
						 'AND evenement_etat = ? '.
						 'ORDER BY evenement_date_debut';
				break;				
			case 'm':
				$req_event = 'SELECT * FROM evenements, categories, calendriers '.
						 'WHERE evenements.evenement_categorie=categories.categorie_id '.
						 'AND evenements.evenement_calendrier=calendriers.calendrier_id '.
						 'AND (evenement_date_debut <= CURDATE() + INTERVAL 1 MONTH && evenement_date_fin >= CURDATE()) '.
						 'AND calendrier_titre = ? '.
						 'AND evenement_etat = ? '.
						 'ORDER BY evenement_date_debut';				
				break;
			case 'y':
				$req_event = 'SELECT * FROM evenements, categories, calendriers '.
						 'WHERE evenements.evenement_categorie=categories.categorie_id '.
						 'AND evenements.evenement_calendrier=calendriers.calendrier_id '.
						 'AND (evenement_date_debut <= CURDATE() + INTERVAL 1 YEAR && evenement_date_fin >= CURDATE()) '.
						 'AND calendrier_titre = ? '.
						 'AND evenement_etat = ? '.
						 'ORDER BY evenement_date_debut';				
				break;
			default:
				# code...
				break;
		}				
		echo '<div id="caldiv_'.$calendrier['calendrier_titre'].'" class="caldiv">';		
			echo '<ul class="eventlist">';
			try{				
				$reponse = $bdd->prepare($req_event);
				$reponse -> execute(array($calendrier['calendrier_titre'],"1"));
				$nb_events = 0;				
				while ($donnees = $reponse->fetch()){
					if($donnees['evenement_date_debut'] == $donnees['evenement_date_fin']){
						$dateToShow = format_date_light(Secure::html($donnees['evenement_date_debut']));
					} else {
						$dateToShow = format_date_light(Secure::html($donnees['evenement_date_debut'])).' au '.format_date_light(Secure::html($donnees['evenement_date_fin']));
					}
					echo '<li><span style="background-color:'.Secure::html($donnees['calendrier_identite_color']).';">&nbsp;</span>&nbsp;<a href="javascript:OuvrirPopup(\'index.php?page=calendrier&cal='.Secure::html($donnees['calendrier_titre']).'\',\'\',\'\')">'.$dateToShow.' dans '.Secure::html($donnees['categorie_description']).' : '.Secure::html($donnees['evenement_titre']).'</a></li>';
					$nb_events++;
				}
				if($nb_events==0){
					echo '<li><span style="background-color:'.Secure::html($calendrier['calendrier_identite_color']).';">&nbsp;</span>&nbsp;<a href="javascript:OuvrirPopup(\'index.php?page=calendrier&cal='.Secure::html($calendrier['calendrier_titre']).'\',\'\',\'\')">Aucun événement</li>';
				}
				$reponse->closeCursor();
			}catch(PDOException $e){
				echo 'Exception : '.$e->getMessage();
			}
			echo '</ul>';
		echo '</div>';
	}
echo '</div>';
?>
