-- phpMyAdmin SQL Dump
-- version 3.4.10.1deb1
-- http://www.phpmyadmin.net
--
-- Client: localhost
-- Généré le : Jeu 13 Juin 2013 à 15:59
-- Version du serveur: 5.5.31
-- Version de PHP: 5.3.10-1ubuntu3.6

CREATE DATABASE calendrier CHARACTER SET utf8 COLLATE utf8_general_ci;

-- création du user de la base
grant all privileges on calendrier.* to calendrier@%%adresse_ip_web identified by 'calendrier';
flush privileges ;

-- connexion à la base
\r calendrier

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de données: `calendrier`
--

-- --------------------------------------------------------

--
-- Structure de la table `affectations`
--

CREATE TABLE IF NOT EXISTS `affectations` (
  `affectation_id` int(11) NOT NULL AUTO_INCREMENT,
  `affectation_description` varchar(30) NOT NULL,
  `affectation_etat` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`affectation_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Contenu de la table `affectations`
--

INSERT INTO `affectations` (`affectation_id`, `affectation_description`, `affectation_etat`) VALUES
(1, 'Autres', 1);

-- --------------------------------------------------------

--
-- Structure de la table `calendriers`
--

CREATE TABLE IF NOT EXISTS `calendriers` (
  `calendrier_id` int(11) NOT NULL AUTO_INCREMENT,
  `calendrier_titre` varchar(11) NOT NULL,
  `calendrier_identite_color` varchar(7) NOT NULL,
  `calendrier_checkbox_color` enum('blue','green','yellow','red') NOT NULL DEFAULT 'blue',
  PRIMARY KEY (`calendrier_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `calendriers`
--

INSERT INTO `calendriers` (`calendrier_id`, `calendrier_titre`, `calendrier_identite_color`, `calendrier_checkbox_color`) VALUES
(1, 'gestion', '#1E90FF', 'blue');

-- --------------------------------------------------------

--
-- Structure de la table `categories`
--

CREATE TABLE IF NOT EXISTS `categories` (
  `categorie_id` int(11) NOT NULL AUTO_INCREMENT,
  `categorie_calendrier` int(11) NOT NULL,
  `categorie_description` text NOT NULL,
  `categorie_couleur` varchar(7) NOT NULL,
  `categorie_textcouleur` varchar(7) NOT NULL DEFAULT '#000000',
  `categorie_etat` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`categorie_id`),
  KEY `categorie_calendrier` (`categorie_calendrier`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Contenu de la table `categories`
--

INSERT INTO `categories` (`categorie_id`, `categorie_calendrier`, `categorie_description`, `categorie_couleur`, `categorie_textcouleur`, `categorie_etat`) VALUES
(1, 1, 'Catégorie 1', '#f5bfdc', '#000000', 1),
(2, 1, 'Catégorie 2', '#a8ffae', '#000000', 1),
(3, 1, 'Catégorie 3', '#0d8014', '#000000', 1),
(4, 1, 'Catégorie 4', '#6fc4f2', '#000000', 1);

-- --------------------------------------------------------

--
-- Structure de la table `droits`
--

CREATE TABLE IF NOT EXISTS `droits` (
  `droit_id` int(11) NOT NULL AUTO_INCREMENT,
  `droit_description` varchar(30) NOT NULL,
  `droit_etat` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`droit_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Contenu de la table `droits`
--

INSERT INTO `droits` (`droit_id`, `droit_description`, `droit_etat`) VALUES
(1, 'superadministrateur', 1),
(2, 'administrateur', 1),
(3, 'editeur', 1);

-- --------------------------------------------------------

--
-- Structure de la table `evenements`
--

CREATE TABLE IF NOT EXISTS `evenements` (
  `evenement_id` int(11) NOT NULL AUTO_INCREMENT,
  `evenement_calendrier` int(11) NOT NULL,
  `evenement_titre` text NOT NULL,
  `evenement_date_debut` date NOT NULL,
  `evenement_date_fin` date NOT NULL,
  `evenement_description` text NOT NULL,
  `evenement_categorie` int(11) NOT NULL,
  `evenement_affectation` int(11) NOT NULL,
  `evenement_auteur` int(11) NOT NULL,
  `evenement_editeur` int(11) NOT NULL,
  `evenement_etat` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`evenement_id`),
  KEY `evenement_calendrier` (`evenement_calendrier`),
  KEY `evenement_categorie` (`evenement_categorie`),
  KEY `evenement_affectation` (`evenement_affectation`),
  KEY `evenement_auteur` (`evenement_auteur`),
  KEY `evenement_editeur` (`evenement_editeur`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- Structure de la table `usercal`
--

CREATE TABLE IF NOT EXISTS `usercal` (
  `user_id` int(11) NOT NULL,
  `calendrier_id` int(11) NOT NULL,
  `droit_id` int(11) NOT NULL,
  `usercal_etat` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_id`,`calendrier_id`),
  KEY `user_id` (`user_id`),
  KEY `calendrier_id` (`calendrier_id`),
  KEY `droit_id` (`droit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Contenu de la table `usercal`
--

INSERT INTO `usercal` (`user_id`, `calendrier_id`, `droit_id`, `usercal_etat`) VALUES
(1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Structure de la table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_login` varchar(20) NOT NULL,
  `user_affectation` int(11) NOT NULL,
  `user_etat` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_login` (`user_login`),
  KEY `user_affectation` (`user_affectation`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

--
-- Contenu de la table `users`
--

INSERT INTO `users` (`user_id`, `user_login`, `user_affectation`, `user_etat`) VALUES
(1, 'admin', 1, 1);

--
-- Contraintes pour les tables exportées
--

--
-- Contraintes pour la table `categories`
--
ALTER TABLE `categories`
  ADD CONSTRAINT `categories_ibfk_1` FOREIGN KEY (`categorie_calendrier`) REFERENCES `calendriers` (`calendrier_id`);

--
-- Contraintes pour la table `evenements`
--
ALTER TABLE `evenements`
  ADD CONSTRAINT `evenements_ibfk_1` FOREIGN KEY (`evenement_categorie`) REFERENCES `categories` (`categorie_id`),
  ADD CONSTRAINT `evenements_ibfk_2` FOREIGN KEY (`evenement_affectation`) REFERENCES `affectations` (`affectation_id`),
  ADD CONSTRAINT `evenements_ibfk_3` FOREIGN KEY (`evenement_auteur`) REFERENCES `users` (`user_id`),
  ADD CONSTRAINT `evenements_ibfk_4` FOREIGN KEY (`evenement_editeur`) REFERENCES `users` (`user_id`),
  ADD CONSTRAINT `evenements_ibfk_5` FOREIGN KEY (`evenement_calendrier`) REFERENCES `calendriers` (`calendrier_id`);

--
-- Contraintes pour la table `usercal`
--
ALTER TABLE `usercal`
  ADD CONSTRAINT `usercal_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  ADD CONSTRAINT `usercal_ibfk_2` FOREIGN KEY (`calendrier_id`) REFERENCES `calendriers` (`calendrier_id`),
  ADD CONSTRAINT `usercal_ibfk_3` FOREIGN KEY (`droit_id`) REFERENCES `droits` (`droit_id`);

--
-- Contraintes pour la table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`user_affectation`) REFERENCES `affectations` (`affectation_id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
