var NAVTREE =
[
  [ "CDC", "index.html", [
    [ "Pages associées", "pages.html", [
      [ "Liste des choses à faire", "todo.html", null ]
    ] ],
    [ "Structures de données", "annotated.html", [
      [ "Admin", "class_admin.html", null ],
      [ "Authentification", "class_authentification.html", null ],
      [ "Box", "class_box.html", null ],
      [ "Connexion", "class_connexion.html", null ],
      [ "Level", "class_level.html", null ],
      [ "Logger", "class_logger.html", null ],
      [ "Manager", "class_manager.html", null ],
      [ "Message", "class_message.html", null ],
      [ "MyException", "class_my_exception.html", null ],
      [ "Profile", "class_profile.html", null ],
      [ "Responsible", "class_responsible.html", null ],
      [ "SchoolReport", "class_school_report.html", null ],
      [ "Student", "class_student.html", null ],
      [ "Teacher", "class_teacher.html", null ],
      [ "User", "class_user.html", null ]
    ] ],
    [ "Index des structures de données", "classes.html", null ],
    [ "Hiérarchie des classes", "hierarchy.html", [
      [ "Authentification", "class_authentification.html", null ],
      [ "Box", "class_box.html", null ],
      [ "Connexion", "class_connexion.html", null ],
      [ "Level", "class_level.html", null ],
      [ "Logger", "class_logger.html", null ],
      [ "Message", "class_message.html", null ],
      [ "MyException", "class_my_exception.html", null ],
      [ "Profile", "class_profile.html", null ],
      [ "SchoolReport", "class_school_report.html", null ],
      [ "User", "class_user.html", [
        [ "Student", "class_student.html", [
          [ "Responsible", "class_responsible.html", [
            [ "Teacher", "class_teacher.html", [
              [ "Manager", "class_manager.html", [
                [ "Admin", "class_admin.html", null ]
              ] ]
            ] ]
          ] ]
        ] ]
      ] ]
    ] ],
    [ "Champs de donnée", "functions.html", null ],
    [ "Liste des fichiers", "files.html", [
      [ "/home/gerald/dev/git/cdc/src/addMessage.content.php", "add_message_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/box.content.php", "box_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/bugReport.php", "bug_report_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/cdc.config.php", "cdc_8config_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/config.content.php", "config_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/config.php", "config_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/connexion.php", "connexion_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/count.content.php", "count_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/credits.content.php", "credits_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/dashboard.content.php", "dashboard_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/function.php", "function_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/index.php", "index_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/logout.php", "logout_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/manageLevel.content.php", "manage_level_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/manageUser.content.php", "manage_user_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/rules.content.php", "rules_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/schoolReport.content.php", "school_report_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/stats.content.php", "stats_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/suspend.content.php", "suspend_8content_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Admin.class.php", "_admin_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Authentification.class.php", "_authentification_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Box.class.php", "_box_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Connexion.class.php", "_connexion_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Level.class.php", "_level_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Logger.class.php", "_logger_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Manager.class.php", "_manager_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Message.class.php", "_message_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/MyException.class.php", "_my_exception_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Profile.class.php", "_profile_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Responsible.class.php", "_responsible_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/SchoolReport.class.php", "_school_report_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Student.class.php", "_student_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/Teacher.class.php", "_teacher_8class_8php.html", null ],
      [ "/home/gerald/dev/git/cdc/src/includes/User.class.php", "_user_8class_8php.html", null ]
    ] ],
    [ "Variables globale", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

