-- Remplissage de la base Mysql pour cdc
-- Equipe EOLE 2011

-- connexion à la base
\r cdc


SET NAMES 'utf8';
SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

CREATE SCHEMA IF NOT EXISTS `cdc` DEFAULT CHARACTER SET latin1 ;
USE `cdc` ;

-- -----------------------------------------------------
-- Table `cdc`.`config`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`config` (
  `rules` TEXT CHARACTER SET 'utf8' COLLATE 'utf8_general_ci' NOT NULL )
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`profile`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`profile` (
  `id_profile` TINYINT(1) UNSIGNED NOT NULL ,
  `grade` VARCHAR(35) NULL DEFAULT NULL ,
  `have_school_report` TINYINT(1)  NOT NULL ,
  PRIMARY KEY (`id_profile`) )
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`user`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`user` (
  `id_user` INT(11) NOT NULL AUTO_INCREMENT ,
  `login` VARCHAR(50) NOT NULL ,
  `password` VARCHAR(40) CHARACTER SET 'utf8' COLLATE 'utf8_bin' NOT NULL ,
  `lastname` VARCHAR(30) NOT NULL ,
  `firstname` VARCHAR(30) NOT NULL ,
  `email` VARCHAR(40) CHARACTER SET 'utf8' COLLATE 'utf8_bin' NOT NULL ,
  `birth_date` DATE NOT NULL DEFAULT '9999-01-01' ,
  `id_profile` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0' ,
  `rules` TINYINT(1)  NOT NULL DEFAULT '0' ,
  `enabled` TINYINT(1)  NOT NULL DEFAULT '0' ,
  `admin` TINYINT(1)  NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id_user`) ,
  INDEX `fk_user_profile` (`id_profile` ASC) ,
  CONSTRAINT `fk_user_profile`
    FOREIGN KEY (`id_profile` )
    REFERENCES `cdc`.`profile` (`id_profile` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`connection`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`connection` (
  `id_connection` INT(11) NOT NULL AUTO_INCREMENT ,
  `date_connection` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ,
  `ip` VARCHAR(15) NULL DEFAULT NULL ,
  `id_user` INT(11) NOT NULL ,
  PRIMARY KEY (`id_connection`) ,
  INDEX `fk_connection_user` (`id_user` ASC) ,
  CONSTRAINT `fk_connection_user`
    FOREIGN KEY (`id_user` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`discipline`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`discipline` (
  `id_discipline` INT(11) NOT NULL AUTO_INCREMENT ,
  `name` VARCHAR(50) CHARACTER SET 'utf8' COLLATE 'utf8_unicode_ci' NOT NULL ,
  PRIMARY KEY (`id_discipline`) )
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`level`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`level` (
  `id_level` INT(11) NOT NULL AUTO_INCREMENT ,
  `name` VARCHAR(20) NOT NULL ,
  PRIMARY KEY (`id_level`) )
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`member_of_level`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`member_of_level` (
  `id_level` INT(11) NOT NULL ,
  `id_user` INT(11) NOT NULL ,
  `manager` TINYINT(1)  NOT NULL DEFAULT 0 ,
  INDEX `fk_member_of_level_level` (`id_level` ASC) ,
  INDEX `fk_member_of_level_user` (`id_user` ASC) ,
  CONSTRAINT `fk_member_of_level_level`
    FOREIGN KEY (`id_level` )
    REFERENCES `cdc`.`level` (`id_level` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_member_of_level_user`
    FOREIGN KEY (`id_user` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`type`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`type` (
  `id_type` INT(11) NOT NULL AUTO_INCREMENT ,
  `wording` VARCHAR(50) NULL DEFAULT NULL ,
  PRIMARY KEY (`id_type`) )
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`message`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`message` (
  `id_message` INT(11) NOT NULL AUTO_INCREMENT ,
  `title` VARCHAR(50) NULL DEFAULT NULL ,
  `content` VARCHAR(2500) NULL DEFAULT NULL ,
  `transmitter` INT(11) NOT NULL ,
  `date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ,
  `id_type` INT(11) NOT NULL ,
  PRIMARY KEY (`id_message`) ,
  INDEX `fk_message_type` (`id_type` ASC) ,
  INDEX `fk_message_transmitter` (`transmitter` ASC) ,
  CONSTRAINT `fk_message_type`
    FOREIGN KEY (`id_type` )
    REFERENCES `cdc`.`type` (`id_type` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_message_transmitter`
    FOREIGN KEY (`transmitter` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`responsible`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`responsible` (
  `id_student` INT(11) NOT NULL ,
  `id_responsible` INT(11) NOT NULL ,
  INDEX `fk_responsible` (`id_responsible` ASC) ,
  INDEX `fk_student` (`id_student` ASC) ,
  CONSTRAINT `fk_responsible`
    FOREIGN KEY (`id_responsible` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_student`
    FOREIGN KEY (`id_student` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`school_report`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`school_report` (
  `id_report` INT(11) NOT NULL AUTO_INCREMENT ,
  `status` TINYINT(1)  NULL DEFAULT '0' ,
  `id_user` INT(11) NOT NULL ,
  PRIMARY KEY (`id_report`) ,
  INDEX `fk_user` (`id_user` ASC) ,
  CONSTRAINT `fk_user`
    FOREIGN KEY (`id_user` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`teacher`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`teacher` (
  `id_user` INT(11) NOT NULL ,
  `id_discipline` INT(11) NOT NULL ,
  INDEX `fk_teacher_user` (`id_user` ASC) ,
  INDEX `fk_teacher_discipline` (`id_discipline` ASC) ,
  CONSTRAINT `fk_teacher_user`
    FOREIGN KEY (`id_user` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_teacher_discipline`
    FOREIGN KEY (`id_discipline` )
    REFERENCES `cdc`.`discipline` (`id_discipline` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `cdc`.`belong`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `cdc`.`belong` (
  `id_message` INT(11) NOT NULL ,
  `id_report` INT(11) NOT NULL ,
  `id_recipient` INT(11) NOT NULL ,
  `validation` TINYINT(1)  NOT NULL ,
  `validation_date` TIMESTAMP NOT NULL ,
  INDEX `fk_belong_school_report` (`id_report` ASC) ,
  INDEX `fk_belong_message` (`id_message` ASC) ,
  INDEX `fk_belong_id_user` (`id_recipient` ASC) ,
  CONSTRAINT `fk_belong_message`
    FOREIGN KEY (`id_message` )
    REFERENCES `cdc`.`message` (`id_message` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_belong_school_report`
    FOREIGN KEY (`id_report` )
    REFERENCES `cdc`.`school_report` (`id_report` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_belong_id_user`
    FOREIGN KEY (`id_recipient` )
    REFERENCES `cdc`.`user` (`id_user` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = MyISAM
DEFAULT CHARACTER SET = utf8;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

-- -----------------------------------------------------
-- Data for table `cdc`.`config`
-- -----------------------------------------------------
START TRANSACTION;
USE `cdc`;
INSERT INTO `cdc`.`config` (`rules`) VALUES ('<h3 class=\"access\">Les &eacute;l&egrave;ves fr&eacute;quentant l\'&eacute;cole &eacute;l&eacute;mentaire 10 rue de l\'&Eacute;ducation, sont tenus de respecter les r&egrave;gles de vie &eacute;num&eacute;r&eacute;es dans ce r&egrave;glement, valables pour tout le personnel scolaire et extra-scolaire.</h3>\n<div id=\"intertitre_1\" class=\"intertitre before_right resize\" style=\"margin-bottom: 10px;\">\n<h3 class=\"access\">R&egrave;glement g&eacute;n&eacute;ral</h3>\n</div>\n<div id=\"para_1\" class=\"para_825231 resize\">\n<div class=\"texte\">\n<div class=\"access firstletter\"><strong>I .LES HORAIRES :</strong> <br /> <br /> 1. <strong> Enseignement collectif </strong>: <br /> <br /> Matin : entr&eacute;e 8h20-8h30 / sortie 11h30 <br /> <br /> Apr&egrave;s-midi : entr&eacute;e 13h20-13h30 / sortie 16h30 <br /> <br /> Etude-Ateliers : 18h <br /> <br /> Les horaires d&rsquo;entr&eacute;e sont &agrave; respecter, car tout retard p&eacute;nalise l&rsquo;enfant et sa classe. <br /> <br /> <span class=\"u\">A la sortie des classes</span>, les enseignants et le gardien ne sont pas responsables des &eacute;l&egrave;ves dont les parents viendraient les chercher en retard. Veillez &agrave; ce que vos enfants ne se retrouvent pas expos&eacute;s aux dangers de la rue. <br /> <br /> <br /> 2. <strong>Activit&eacute;s &agrave; l\'intention des groupes d\'&eacute;l&egrave;ves </strong>: <br /> <br /> Deux heures par semaine d\'AIDE PERSONNALIS&Eacute;E sont mises en oeuvre selon les modalit&eacute;s d&eacute;finies dans le projet d\'&eacute;cole. <br /> Un document, sign&eacute; par les familles, contractualise ces modalit&eacute;s de prise en charge des &eacute;l&egrave;ves. <br /> Des stages de remise &agrave; niveau sont propos&eacute;s aux &eacute;l&egrave;ves de CM1 et CM2, aux vacances de printemps et d\'&eacute;t&eacute;. <br /> <br /> 3. <strong>Activit&eacute;s p&eacute;ri-scolaires</strong> : <br /> Les &eacute;l&egrave;ves inscrits &agrave; l\'&eacute;tude et aux ateliers organis&eacute;s par l\'&eacute;cole sortent &agrave; 18h. <br /> <span class=\"u\">Toute &eacute;ventuelle modification</span> ( un enfant qui exceptionnellement ne d&eacute;jeune pas &agrave; la cantine ou ne participe pas &agrave; une activit&eacute; &agrave; laquelle il est inscrit) doit &ecirc;tre signifi&eacute; par &eacute;crit &agrave; la directrice. <br /> <br /> <strong>II.FREQUENTATION ET OBLIGATION SCOLAIRE :</strong> <br /> <br /> La fr&eacute;quentation r&eacute;guli&egrave;re de l&rsquo;&eacute;cole est obligatoire. <br /> <br /> <span class=\"u\">En cas d&rsquo;ABSENCE</span> <br /> <br /> Les parents doivent pr&eacute;venir l&rsquo;&eacute;cole, le matin m&ecirc;me, par t&eacute;l&eacute;phone. Toute absence doit ensuite &ecirc;tre justifi&eacute;e par &eacute;crit dans le cahier de correspondance. Pour une absence de plus de deux jours, un certificat m&eacute;dical sera obligatoire. <br /> <br /> <strong>III. AUTORISATION DE SORTIE : </strong> <br /> <br /> En aucun cas, les enfants ne peuvent quitter seuls l&rsquo;&eacute;cole pendant le temps scolaire. Pour toute autorisation de sortie exceptionnelle, contacter la directrice. <br /> <br /> <strong>IV.OBJETS DE VALEUR OU DANGEREUX :</strong> <br /> <br /> Les bijoux, l&rsquo;argent (en dehors de ce qui est demand&eacute; par les enseignants : coop&eacute;rative, photos&hellip;) sont interdits &agrave; l&rsquo;&eacute;cole, de m&ecirc;me que tout objet &eacute;lectronique ( portables, consoles de jeux, lecteurs MP3), les couteaux ou les briquets. <br /> <br /> <strong>V. S&Eacute;CURIT&Eacute; - SOINS ET URGENCES :</strong> <br /> <br /> 1. <strong>S&eacute;curit&eacute;</strong> : <br /> Des exercices d\'&eacute;vacuation sont organis&eacute;s chaque trimestre pour entra&icirc;ner &eacute;l&egrave;ves et personnel sur la conduite &agrave; tenir en cas d\'incendie. <br /> L\'&eacute;cole a &eacute;labor&eacute; un PPMS ( Plan Particulier de Mise en S&ucirc;ret&eacute;) dont les modalit&eacute;s sont pr&eacute;sent&eacute;es chaque ann&eacute;e au premier conseil d\'&eacute;cole. <br /> <br /> 2. <strong>Soins et urgences</strong> : <br /> Il est interdit d&rsquo;apporter des m&eacute;dicaments &agrave; l&rsquo;&eacute;cole : les ma&icirc;tres n&rsquo;ayant pas le droit de les administrer. Dans des cas bien particuliers, des exceptions sont pr&eacute;vues ; dans ce cas, pr&eacute;venir la directrice qui &eacute;tablira un dossier avec le M&eacute;decin scolaire. <br /> La pharmacie de l\'&eacute;cole dispose de produits d\'urgence pour les petites plaies. <br /> En cas de malaises ou d\'accidents graves, les parents sont imm&eacute;diatement inform&eacute;s et le SAMU est contact&eacute; par la directrice ou un enseignant. <br /> <br /> <strong>VI. VIE SCOLAIRE :</strong> <br /> <br /> La vie des &eacute;l&egrave;ves et l\'activit&eacute; des enseignants sont organis&eacute;es de mani&egrave;re &agrave; permettre d\'atteindre les objectifs nationaux. <br /> L\'&eacute;quipe p&eacute;dagogique, et chaque ma&icirc;tre en particulier, doivent obtenir de chaque &eacute;l&egrave;ve un travail &agrave; la mesure de ses capacit&eacute;s. En cas de travail insuffisant, le ma&icirc;tre ou l\'&eacute;quipe p&eacute;dagogique s\'interroge sur des causes et d&eacute;cide des mesures appropri&eacute;es. <br /> <br /> Adultes et enfants se doivent mutuellement le respect. <br /> <br /> <span style=\"font-style: italic;\">Rappel : Loi sur le la&iuml;cit&eacute; <br /> Conform&eacute;ment aux dispositions de l\'article 141.5.1 du code de l\'&eacute;ducation <br /> Le port de signes ou de tenues par lesquels les &eacute;l&egrave;ves manifestent ostensiblement une appartenance religieuse es interdit.</span> <br /> <br /> Les d&eacute;placements &agrave; l&rsquo;int&eacute;rieur des locaux se font dans l&rsquo;ordre et le calme. L&rsquo;acc&egrave;s des couloirs et des classes est interdit aux &eacute;l&egrave;ves sans autorisation. Les &eacute;l&egrave;ves ne sont autoris&eacute;s qu\'exceptionnellement &agrave; se rendre aux toilettes pendant la classe, pour des raisons de s&eacute;curit&eacute; ; ils peuvent y aller durant toutes les r&eacute;cr&eacute;ations. <br /> <br /> Les enfants sont responsables de leurs v&ecirc;tements, et il est conseill&eacute; de les marquer &agrave; leur nom. <br /> <br /> Les bonbons et chewing-gums sont interdits. <br /> <br /> La relation entre parents et enseignants est tr&egrave;s importante pour favoriser la r&eacute;ussite des &eacute;l&egrave;ves. <br /> Les parents doivent signer les cahiers, qui leur sont communiqu&eacute;s r&eacute;guli&egrave;rement, et tout document relatif &agrave; la scolarit&eacute;. <br /> Chaque trimestre un livret scolaire est remis aux parents. <br /> Les familles ne doivent pas h&eacute;siter &agrave; prendre rendez-vous avec les enseignants, par l\'interm&eacute;diaire du cahier de correspondance, pour faire le point sur la scolarit&eacute; des enfants.</div>\n</div>\n</div>');

COMMIT;

-- -----------------------------------------------------
-- Data for table `cdc`.`profile`
-- -----------------------------------------------------
START TRANSACTION;
USE `cdc`;
INSERT INTO `cdc`.`profile` (`id_profile`, `grade`, `have_school_report`) VALUES (10, 'Élève', 1);
INSERT INTO `cdc`.`profile` (`id_profile`, `grade`, `have_school_report`) VALUES (20, 'Responsable', 0);
INSERT INTO `cdc`.`profile` (`id_profile`, `grade`, `have_school_report`) VALUES (30, 'Enseignant', 0);
INSERT INTO `cdc`.`profile` (`id_profile`, `grade`, `have_school_report`) VALUES (40, 'Professeur principal', 0);

COMMIT;
