<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file addMessage.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Gère l'ajout d'un message dans un ou plusieurs carnets ou à une toute une classe
 */

?>
<?php
if ($_SESSION['profile']==20){
    if((isset($_SESSION['adultStudent']))&&($_SESSION['adultStudent']==True))
        echo '<h2>'.$GLOBALS["titles"]["addmessage3"].'</h2>', chr(10);
    else
        echo '<h2>'.$GLOBALS["titles"]["addmessage2"].$_SESSION['schoolReportFirstname'].'</h2>', chr(10);
}
// si action = preview on affiche la prévisualisation du mot
if(isset($_GET['action'])&&($_GET['action']=='preview')) {
    $tabRecipientInfos = $u->selectOnRecipient($_POST['id_user']);
    // Fixe le nombre de destinataire à 1 : $_SESSION['selectStudent'] pour la gestion du f5 après le submit
    $_SESSION['selectStudent'] = 1;
    if ($_SESSION['profile'] >= 30) {
        if($_POST['selectIdLevel']){
            $levelInfos = Level::selectLevel($_POST['selectIdLevel']);
            echo '<h2>'.$GLOBALS["titles"]["addmessage2"].$tabRecipientInfos[0]['firstname'].' '.$tabRecipientInfos[0]['lastname'].' - '.$levelInfos[0]['name'].' </h2>', chr(10);
        }
    }
    if ($_SESSION['profile'] >= 30)
        displaysubAction("homeAddMessage");
    else
        displaysubAction();
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=send" method="post">', chr(10);
    echo $GLOBALS["formMessage"]["recipient"].' : ', chr(10);
    echo ' <strong> '.$tabRecipientInfos[0]['firstname'].' '.$tabRecipientInfos[0]['lastname'].' </strong><br /><br/>', chr(10);
    echo $GLOBALS["formMessage"]["subject"].' :<strong> '.$_POST['title'].' </strong><br /><br/>', chr(10);
    echo $GLOBALS["formMessage"]["content"].' :<br />', chr(10);
    echo(stripslashes($_POST['message'])).'<br>', chr(10);
    //echo $_POST['message'].'<br>', chr(10);
    echo '<input type="hidden" name="id_user" value="'.$_POST['id_user'].'" />', chr(10);
    echo '<input type="hidden" name="selectNameLevel" value="'.$levelInfos[0]['name'].'" />', chr(10);
    echo '<input type="hidden" name="selectIdLevel" value="'.$_POST['selectIdLevel'].'" />', chr(10);
    // FIXME gestion du type de message ?
    //echo '<input type="hidden" name="id_type" value="'.$_POST['id_type'].'" /><br />', chr(10);
    //echo '<input type="hidden" name="profile" value="'.$_POST['profile'].'" /><br />', chr(10);
    echo '<input type="hidden" name="title" value="'.$_POST['title'].'" />', chr(10);
    // encodage du message pour pas interférer avec le flux html de la page
    echo '<input type="hidden" name="message" value="'.htmlentities($_POST['message'], ENT_QUOTES, "UTF-8").'" />', chr(10);

    echo '<input type="hidden" name="surname" value="'.$tabRecipientInfos[0]['firstname'].'" />', chr(10);
    echo '<input type="hidden" name="name" value="'.$tabRecipientInfos[0]['lastname'].'" />', chr(10);
    if (isset($tabRecipientInfos[0]['id_report']))
        echo '<input type="hidden" name="id_report" value="'.$tabRecipientInfos[0]['id_report'].'" />', chr(10);
        //valider : renvoit sur la page d'accueil
    echo '<input type="submit" name="valider" value="'.$GLOBALS["formMessage"]["validate"].'"/>', chr(10);
    //valider et continuer: renvoit sur la rédaction d'un nouveau mot pour un professeur
    if ($_SESSION['profile'] >= 30)
        echo '<input type="submit" name="validerContinue" value="'.$GLOBALS["formMessage"]["validatecontinue"].'"/>', chr(10);
    echo '</form>';
    if (isset($_SESSION['idSchoolReport'])) {
        // on récupe l'id du proprio du carnet
        $idOwner = $schoolReport->getIdSchoolReportOwner();
        // on remplace l'iduser par l'iduser du carnet sélectionné
        $tabAllInLevel = $u->selectAllInLevel($idOwner);
        // obtenir tous les membres d'une classe
        $tabAllMemberLevel = $u->selectAllMemberLevel($tabAllInLevel[0]['id_level'],30);
    }
    elseif ($_SESSION['profile'] >= 30) {
        $tabAllInLevel = $u->selectAllInLevel($_SESSION['id_user']);
        // Parcours de toutes le classes pour obtenir chaque membre
        $tabAllMemberLevel = array();
        foreach ($tabAllInLevel as $level) {
            $MemberLevel = $u->selectAllMemberLevel($level['id_level'],10);
            $tabAllMemberLevel = array_merge($tabAllMemberLevel, $MemberLevel);
        }
    // Vérification du nombre de classe en charge du professeur
    $tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
    if (sizeof($tabAllLevel) != 0){
        // Cas1 : le professeur a une seule classe
        if (sizeof($tabAllLevel) == 1)
            displayForm($tabAllMemberLevel);
        // Cas2 : le professeur à plusieurs classe
        else{
            //displayForm($tabAllMemberLevel);
            //On ré-affiche le formulaire de choix (changement) de la classe si besoin
            echo '<form name="selectLevel" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'?content=addmessage" >',chr(10);
            echo $GLOBALS["formMessage"]["classes"].' : <br />', chr(10);
            echo '<select name="selectIdLevel">',chr(10);
            foreach ($tabAllLevel as $id => $level) {
                echo '<option value="'.$level['id_level'].'"';
                if ((isset($_POST['selectIdLevel']))&&($_POST['selectIdLevel'] == $level['id_level']))
                    echo ' selected="selected"';
                elseif ((isset($_POST['selectIdLevel']))&&($_POST['selectIdLevel'] == $level['id_level']))
                    echo ' selected="selected"';
                echo '>';
                echo $level['name'];
                echo '</option>',chr(10);
            }
            echo '</select>',chr(10);
            if($_SESSION['javascript']== "inactif")
                echo '<input type="submit" name="submit" value="Ok"/>', chr(10);
            echo '</form>',chr(10);
            /*fin affichage de la classe avec possiblilité de changer de classe */
            // Visualisation : réaffichage du message pour modification du message
            $tabRecipientInfos = $u->selectOnRecipient($_POST['id_user']);
            echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=preview" method="post">', chr(10);
            echo $GLOBALS["formMessage"]["recipient"].' : <br />', chr(10);
            // Réa-affichage du nom du destinataire avec possiblilité de changer le destinataire
            // Liste des élèves de classe du destinataire en cours
            $tabAllMemberLevel = Teacher::selectAllMemberLevel($_POST['selectIdLevel'],10);
            //Liste des élèves non suspendus à vide a peupler
            $noSuspendStudent = array();
            echo '<select name="id_user">', chr(10);
            foreach ($tabAllMemberLevel as $id => $value) {
                if( $tabAllMemberLevel[$id]['status'] == False || SUSPEND == False)
                //Enregistrement des élèves non suspendus
                array_push($noSuspendStudent, $tabAllMemberLevel[$id]['id_user']);
                echo '<option';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                echo ' class="suspend"';
                echo' value="'.$tabAllMemberLevel[$id]['id_user'].'"';
                if ((isset($_POST['id_user']))&&($_POST['id_user'] == $tabAllMemberLevel[$id]['id_user']))
                    echo ' selected ';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                    echo ' disabled="disabled" ';
                echo '>';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                echo $tabAllMemberLevel[$id]['firstname'].' '.$tabAllMemberLevel[$id]['lastname'];
                }
                echo '</option>', chr(10);
                echo '</select><br />', chr(10);
            /* fin de sélection de nouveau destinataire */
            echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
            echo '<input type="text" name="title" value="';
            if (isset($_POST['title']))
                echo $_POST['title'];
            echo '" size=35 /><br />';
            echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
            echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
            if (isset($_POST['message']))
                echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
            echo '</textarea><br />', chr(10);
            echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
            //echo '<input type="hidden" name="id_user" value="'.$_POST['id_user'].'" />', chr(10);
            echo '<input type="hidden" name="selectIdLevel" value="'.$_POST['selectIdLevel'].'" />', chr(10);
            echo '<input type="hidden" name="selectedNameLevel" value="'.$_POST['selectedNameLevel'].'" />', chr(10);
            echo '</form>',chr(10);
        }
    }
    else
        echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
    }
    //displayForm($tabAllMemberLevel); réaffichage du formulaire d'ajout en dessous
    if ($_SESSION['profile']==20)
        displayForm($tabAllMemberLevel);

}
// On affiche la prévisualisation du mot pour l'ajout dans plusieurs carnets
elseif(isset($_GET['action'])&&($_GET['action']=='previewMultiple')) {
    $selectIdLevel = $_SESSION['selectedIdLevelTeacher'];
    /* Début de la prévisualisation */
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=sendMultiple" method="post">', chr(10);
    //Conservation des élèves non suspendus
    $student = $_SESSION['noSuspendStudent'];
    $count = count($student);
    if(isset($_SESSION['countEffectiveStudent']))
        $countEffectiveStudent = $_SESSION['countEffectiveStudent'];
    // si nombre d'\élèves non suspendus = nombre d'élèves de la classe
    if($count == $countEffectiveStudent){
        echo '<h2>'.$GLOBALS["titles"]["addmessage5"].' - '.$_SESSION['selectedNameLevelTeacher'].'</h2>', chr(10);
        displaysubAction("viewListSchoolReport");
        //echo $GLOBALS["formMessage"]["recipient"].' :', chr(10);
        echo $GLOBALS["formMessage"]["recipient"].' : ', chr(10);
        echo '<strong> classe de '.$_SESSION['selectedNameLevelTeacher'].' </strong><br/>', chr(10);

    }else{
        echo '<h2>'.$GLOBALS["titles"]["addmessage4"].' - '.$_SESSION['selectedNameLevelTeacher'].'</h2>', chr(10);
        displaysubAction("viewListSchoolReport");
        //echo $GLOBALS["formMessage"]["recipient"].' :', chr(10);
        echo $GLOBALS["formMessage"]["recipient"].' : ', chr(10);
        for($i=0;$i<$count;$i++){
            $tabStudentInfos =Teacher::selectOneStudent($student[$i]);
            foreach ($tabStudentInfos as $value) {
                echo '<strong> '.$value['firstname'].' '.$value['lastname'].' </strong>;' ;
            }
        }
    }
    echo '<br />', chr(10);
    //echo $GLOBALS["formMessage"]["subject"].' :<br />', chr(10);
    //echo $_POST['title'].'<br />', chr(10);
    echo $GLOBALS["formMessage"]["subject"].' :<strong> '.$_POST['title'].' </strong><br /><br/>', chr(10);
    //echo $GLOBALS["formMessage"]["content"].' :<br />', chr(10);
    echo $GLOBALS["formMessage"]["content"].' : ', chr(10);
    echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8").'<br>', chr(10);
    echo '<input type="hidden" name="title" value="'.$_POST['title'].'" />', chr(10);
    echo '<input type="hidden" name="message" value="'.htmlentities($_POST['message'], ENT_QUOTES, "UTF-8").'" />', chr(10);
    //valider : renvoit sur la page d'accueil
    echo '<input type="submit" name="valider" value="'.$GLOBALS["formMessage"]["validate"].'"/>', chr(10);
    // valider et continuer : renvoit sur la rédaction d'un nouveau mot
    echo '<input type="submit" name="validerContinue" value="'.$GLOBALS["formMessage"]["validatecontinue"].'"/>', chr(10);
    echo '</form>';
    /* Fin de la prévisualisation */
    // Vérification du nombre de classe en charge du professeur
    $tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
    if (sizeof($tabAllLevel) != 0){
        //On ré-affiche le formulaire de choix (changement) de la classe si besoin
        echo '<form name="selectLevel" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'?content=addmessage&level">',chr(10);
        echo $GLOBALS["formMessage"]["classes"].' : <br />', chr(10);
        echo '<select name="selectIdLevel">',chr(10);
        foreach ($tabAllLevel as $id => $level) {
            echo '<option value="'.$level['id_level'].'"';
            if ((isset($_POST['selectIdLevel']))&&($_POST['selectIdLevel'] == $level['id_level']))
                echo ' selected="selected"';
            elseif ((isset($selectIdLevel))&&($selectIdLevel == $level['id_level']))
                    echo ' selected="selected"';
            echo '>';
            echo $level['name'];
            echo '</option>',chr(10);
        }
        echo '</select>',chr(10);
        if($_SESSION['javascript']== "inactif")
            echo '<input type="submit" name="submit" value="Ok"/>', chr(10);
        echo '</form>',chr(10);
        // fin affichage de la classe avec possiblilité de changer de classe
        // Visualisation : réaffichage du message pour modification du message
        echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=previewMultiple" method="post">', chr(10);
        echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
        echo '<input type="text" name="title" value="';
        if (isset($_POST['title']))
            echo $_POST['title'];
        echo '" size=35 /><br />';
        echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
        echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
        if (isset($_POST['message']))
            echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
        echo '</textarea><br />', chr(10);
        echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
        echo '</form>',chr(10);
    }
    else
        echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
}
// on sauvegarde le mot
elseif(isset($_GET['action'])&&($_GET['action']=='send')) {
    // Modification du modication par le professeur si plusieurs classe
    if($_POST['validerContinue']){
        // Ajout de mot dans le carnet d'un élève
        $student = $_SESSION['selectStudent'];
        $count = count($student);
        if($count == 1 && ($_POST['message']) ){
            $message = new Message();
            if (isset($_SESSION['idSchoolReport'])) {
                $message->addMessage($_POST['title'],html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8"),$_SESSION['id_user'],$_POST['id_user'],$_SESSION['idSchoolReport']);
                unset($_SESSION['selectStudent']);
                unset($_POST['title']);
                unset($_POST['message']);
                // infoboard
                $info = 'Votre mot a bien été envoyé au professeur '.$_POST['surname'].' ' .$_POST['name'];
                $type_message = 'info';
            }
            elseif ($_SESSION['profile'] >= 30) {
                $message->addMessage($_POST['title'],$_POST['message'],$_SESSION['id_user'],$_POST['id_user'],$_POST['id_report']);
                unset($_SESSION['selectStudent']);
                unset($_POST['title']);
                unset($_POST['message']);
                unset($_POST['id_report']);
                // infoboard
                $info = 'Votre mot a bien été ajouté au carnet de <span class=\"bold\">'.$_POST['surname'].' '.$_POST['name'].'<\/span>';
                $type_message = 'info';
            }
        }
        else{
            // infoboard
            $info = 'Veuillez ajouter un objet ou un contenu à votre mot ';
            $type_message = 'warning';
        }
        echo '<script type="text/javascript">';
        echo 'var message = "'.$info.'";';
        echo 'displayInfoboard("'.$type_message.'",message);';
        echo '</script>';
        if ($_SESSION['profile'] >= 30) {
            echo '<h2>'.$GLOBALS["titles"]["addmessage"].' - '.$_POST['selectNameLevel'].'</h2>', chr(10);
            //$_SESSION['selectedNameLevelTeacher'] = $_POST['selectNameLevel'];
            //$_SESSION['selectedIdLevelTeacher'] = $_POST['selectIdLevel'];
            displaysubAction("addMessagetoLevel");
            // echo $_POST['selectIdLevel']; la classe ne change pas
            // on a déjà $_POST['selectIdLevel'] donc supression de $_SESSION['noChangeIdLevel']
            unset($_SESSION['noChangeIdLevel']);
            $GLOBALS['message'] = array( 'carmax'    => '800 caractères maximum',);
            unset($_POST['title']);
            unset($_POST['message']);
            unset($_POST['id_report']);
            unset($_POST['id_user']);
            displayForm($tabAllMemberLevel);
        }
    }
    // valider -> renvoit sur la page d'accueil
    else {
        // Ajout de mot dans le carnet d'un élève
        $student = $_SESSION['selectStudent'];
        $count = count($student);
        if($count == 1 && ($_POST['message']) ){
            $message = new Message();
            if (isset($_SESSION['idSchoolReport'])) {
                $message->addMessage($_POST['title'],html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8"),$_SESSION['id_user'],$_POST['id_user'],$_SESSION['idSchoolReport']);
                unset($_SESSION['selectStudent']);
                unset($_POST['title']);
                unset($_POST['message']);
                // infoboard
                $info = 'Votre mot a bien été envoyé au professeur <span class=\"bold\">'.$_POST['surname'].' '.$_POST['name'].'<\/span>';
                $type_message = 'info';
            }
            elseif ($_SESSION['profile'] >= 30) {
                $message->addMessage($_POST['title'],html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8"),$_SESSION['id_user'],$_POST['id_user'],$_POST['id_report']);
                unset($_SESSION['selectStudent']);
                unset($_POST['title']);
                unset($_POST['message']);
                unset($_POST['id_report']);
                unset($_POST['id_user']);
                // infoboard
                $info = 'Votre mot a bien été ajouté au carnet de <span class=\"bold\">'.$_POST['surname'].' '.$_POST['name'].'<\/span>';
                $type_message = 'info';
            }
        }
        else{
            // infoboard
            $info = 'Veuillez ajouter un objet ou un contenu à votre mot ';
            $type_message = 'warning';
        }
        echo '<script type="text/javascript">';
        echo 'var message = "'.$info.'";';
        echo 'displayInfoboard("'.$type_message.'",message);';
        echo '</script>';
        /*
        if ($_SESSION['profile'] == 20) {
            // Redirection
            $page = 'index.php';
            echo '<script language="javascript" type="text/javascript">', chr(10);
            echo '<!--', chr(10);
            echo 'window.location.replace("'.$page.'")', chr(10);
            echo '-->', chr(10);
            echo '</script>';
         }*/
        if ($_SESSION['profile']==20){
             if (isset($_SESSION['idSchoolReport'])) {
                // on récupe l'id du proprio du carnet
                $idOwner = $schoolReport->getIdSchoolReportOwner();
                // on remplace l'iduser par l'iduser du carnet sélectionné
                $tabAllInLevel = $u->selectAllInLevel($idOwner);
                // obtenir tous les membres d'une classe
                if (sizeof($tabAllInLevel) != 0) {
                    $tabAllMemberLevel = $u->selectAllMemberLevel($tabAllInLevel[0]['id_level'],30);
                    $GLOBALS['message'] = array( 'carmax'    => '800 caractères maximum',);
                    unset($_POST['title']);
                    unset($_POST['message']);
                    displayForm($tabAllMemberLevel);
                }
            }
        }
        elseif ($_SESSION['profile'] >= 30) {
            //$tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
            //echo '<h2>'.$GLOBALS["titles"]["addmessage"].' - '.$tabAllLevel[0]['name'].'</h2>', chr(10);
            //displaysubAction("addMessagetoLevel");
            //$GLOBALS['message'] = array( 'carmax'    => '800 caractères maximum',);
            unset($_POST['title']);
            unset($_POST['message']);
            unset($_POST['id_report']);
            unset($_POST['id_user']);
            unset($_POST['selectIdLevel']);
            // On change de classe donc supression de $_SESSION['noChangeIdLevel']
            unset($_SESSION['noChangeIdLevel']);
            //displayForm($tabAllMemberLevel);
            // Redirection
            $page = 'index.php?content=sentMessages';
            echo '<script language="javascript" type="text/javascript">', chr(10);
            echo '<!--', chr(10);
            echo 'window.location.replace("'.$page.'")', chr(10);
            echo '-->', chr(10);
            echo '</script>';
        }
    }
}
// Ajout de mot dans le carnet de plusieurs élèves
elseif(isset($_GET['action'])&&($_GET['action']=='sendMultiple')) {
    if($_POST['validerContinue']){
        /* Ajout du mot dans plusieurs carnets */
        $message = new Message();
        $student = $_SESSION['noSuspendStudent'];
        $count = count($student);
        if(isset($_SESSION['countEffectiveStudent']))
            $countEffectiveStudent = $_SESSION['countEffectiveStudent'];
        if($count> 1 && ($_POST['message']) ){
            if($count == $countEffectiveStudent){
                for($i=0;$i<$count;$i++){
                    $tabRecipientInfos = $u->selectOnRecipient($student[$i]);
                    $message->addMessage($_POST['title'],html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8"),$_SESSION['id_user'],$student[$i],$tabRecipientInfos[0]['id_report']);
                    unset($_SESSION['noSuspendStudent']);
                }
                unset($_SESSION['countEffectiveStudent']);
                // infoboard
                $info = 'Votre mot a bien été ajouté à tous les carnets de la classe de <span class=\"bold\">'.$_SESSION['selectedNameLevelTeacher'].'';
                $type_message = 'info';
            }else{
                for($i=0;$i<$count;$i++){
                    $tabRecipientInfos = $u->selectOnRecipient($student[$i]);
                    $message->addMessage($_POST['title'],html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8"),$_SESSION['id_user'],$student[$i],$tabRecipientInfos[0]['id_report']);
                    unset($_SESSION['noSuspendStudent']);
                    // infoboard
                    $tabStudentInfos =Teacher::selectOneStudent($student[$i]);
                    foreach ($tabStudentInfos as $value) {
                        $info .= 'Votre mot a bien été ajouté au carnet de <span class=\"bold\">'.$value['firstname'].' '.$value['lastname'].'<\/span><br />\n';
                    }
                    $type_message = 'info';
                }
            }
        }
        else{
            // infoboard
            $info = 'Veuillez choisir un destinataire ou ajouter un objet ou un contenu à votre mot ';
            $type_message = 'warning';
            }
        echo '<script type="text/javascript">';
        echo 'var message = "'.$info.'";';
        echo 'displayInfoboard("'.$type_message.'",message);';
        echo '</script>';
        /* Fin d'envoi du message */
        /* Retour à à nouveau à l'ajout de message '*/
        echo '<h2>'.$GLOBALS["titles"]["addmessage"].' - '.$_SESSION['selectedNameLevelTeacher'].'</h2>', chr(10);
        $_SESSION['noChangeIdLevel'] = $_SESSION['selectedIdLevelTeacher'];
        displaysubAction("addMessagetoLevel");
        unset($_POST['title']);
        unset($_POST['message']);
        unset($_POST['id_report']);
        $GLOBALS['message'] = array( 'carmax'    => '800 caractères maximum',);
        displayForm($tabAllMemberLevel);
    }
    // valider -> renvoit sur la page d'accueil
    else{
        /* Ajout du mot dans plusieurs carnets */
        $message = new Message();
        $student = $_SESSION['noSuspendStudent'];
        $count = count($student);
        if(isset($_SESSION['countEffectiveStudent']))
            $countEffectiveStudent = $_SESSION['countEffectiveStudent'];
        if($count> 1 && ($_POST['message']) ){
            if($count == $countEffectiveStudent){
                for($i=0;$i<$count;$i++){
                    $tabRecipientInfos = $u->selectOnRecipient($student[$i]);
                    $message->addMessage($_POST['title'],html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8"),$_SESSION['id_user'],$student[$i],$tabRecipientInfos[0]['id_report']);
                    unset($_SESSION['noSuspendStudent']);
                }
                unset($_SESSION['countEffectiveStudent']);
                // infoboard
                $info = 'Votre mot a bien été ajouté à tous les carnets de la classe de <span class=\"bold\">'.$_SESSION['selectedNameLevelTeacher'].'';
                $type_message = 'info';
            }else{
                for($i=0;$i<$count;$i++){
                    $tabRecipientInfos = $u->selectOnRecipient($student[$i]);
                    $message->addMessage($_POST['title'],html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8"),$_SESSION['id_user'],$student[$i],$tabRecipientInfos[0]['id_report']);
                    unset($_SESSION['noSuspendStudent']);
                    // infoboard
                    $tabStudentInfos =Teacher::selectOneStudent($student[$i]);
                    foreach ($tabStudentInfos as $value) {
                        $info .= 'Votre mot a bien été ajouté au carnet de <span class=\"bold\">'.$value['firstname'].' '.$value['lastname'].'<\/span><br />\n';
                    }
                    $type_message = 'info';
                }
            }
        }
        else{
            // infoboard
            $info = 'Veuillez choisir un destinataire ou ajouter un objet ou un contenu à votre mot ';
            $type_message = 'warning';
            }
        echo '<script type="text/javascript">';
        echo 'var message = "'.$info.'";';
        echo 'displayInfoboard("'.$type_message.'",message);';
        echo '</script>';
        /* Fin d'envoi du message */
        /* Retour à à nouveau à l'ajout de message '*/
        $tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
        unset($_SESSION['selectedNameLevelTeacher']);
        unset($_SESSION['selectedIdLevelTeacher']);
        // On change de classe donc supression de $_SESSION['noChangeIdLevel']
        unset($_SESSION['noChangeIdLevel']);
        $_SESSION['selectedIdLevelTeacher'] = $tabAllLevel[0]['id_level'];
        $_SESSION['selectedNameLevelTeacher'] = $tabAllLevel[0]['name'];
        echo '<h2>'.$GLOBALS["titles"]["addmessage"].' - '.$tabAllLevel[0]['name'].'</h2>', chr(10);
        displaysubAction("addMessagetoLevel");
        unset($_POST['title']);
        unset($_POST['message']);
        unset($_POST['id_report']);
        $GLOBALS['message'] = array( 'carmax'    => '800 caractères maximum',);
        displayForm($tabAllMemberLevel);
        // Redirection
        /*$page = 'index.php';
        echo '<script language="javascript" type="text/javascript">', chr(10);
        echo '<!--', chr(10);
        echo 'window.location.replace("'.$page.'")', chr(10);
        echo '-->', chr(10);
        echo '</script>';*/


    }
}
// on affiche le formulaire de composition d'un mot
else {
    // obtenir toutes les classes de l'utilisateur
    // @fixme nom de variable très mal choisi : plutot idUserUnderCare
    if (isset($_SESSION['idSchoolReport'])) {
        // on récupe l'id du proprio du carnet
        $idOwner = $schoolReport->getIdSchoolReportOwner();
        // on remplace l'iduser par l'iduser du carnet sélectionné
        $tabAllInLevel = $u->selectAllInLevel($idOwner);
        // obtenir tous les membres d'une classe
        if (sizeof($tabAllInLevel) != 0) {
            $tabAllMemberLevel = $u->selectAllMemberLevel($tabAllInLevel[0]['id_level'],30);
            displaysubAction();
            displayForm($tabAllMemberLevel);
        }
        else {
            if ($_SESSION['profile'] == 20) {
                if($_SESSION['adultStudent'] == True) {
                    echo '<div id="empty">'.$GLOBALS["message"]["noclass"].'</div>', chr(10);
                }
                else {
                    echo '<div id="empty">' .$_SESSION['schoolReportFirstname']. ' '.$GLOBALS["responsible"]["nostudentclass"].'</div>', chr(10);
                }
            }
            else
                echo '<div id="empty">'.$GLOBALS["message"]["noclass"].'</div>', chr(10);
            }
    }
    elseif ($_SESSION['profile'] >= 30) {
        $tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
        if($tabAllLevel){
            // obtenir tous les membres d'une classe
            $tabAllInLevel = $u->selectAllInLevel($_SESSION['id_user']);
            if (sizeof($tabAllInLevel) != 0) {
                // Parcours de toutes le classes pour obtenir chaque membre
                $tabAllMemberLevel = array();
                foreach ($tabAllInLevel as $level) {
                    $MemberLevel = $u->selectAllMemberLevel($level['id_level'],10);
                    $tabAllMemberLevel = array_merge($tabAllMemberLevel, $MemberLevel);
                }
                if (isset($_GET['selectStudent'])) {
                    echo '<h2>'.$GLOBALS["titles"]["addmessage2"].$_SESSION['schoolReportFirstname'].' '.$_SESSION['schoolReportLastname'].' - '.$_SESSION['selectedNameLevelTeacher'].'</h2>', chr(10);
                    displaysubAction("viewSchoolReport");
                }
                elseif (isset($_GET['level'])) {
                    unset($_SESSION['selectedIdLevelTeacher']);
                    unset($_SESSION['selectedNameLevelTeacher']);
                    echo '<h2>'.$GLOBALS["titles"]["addmessage5"].'</h2>', chr(10);
                }
                elseif (isset($_GET['multipleStudent'])) {
                    //Conservation des élèves non suspendus
                    $student = $_SESSION['noSuspendStudent'];
                    $count = count($student);
                    if(isset($_SESSION['countEffectiveStudent']))
                        $countEffectiveStudent = $_SESSION['countEffectiveStudent'];
                    // si nombre d'\élèves non suspendus = nombre d'élèves de la classe
                    if($count == $countEffectiveStudent){
                        echo '<h2>'.$GLOBALS["titles"]["addmessage5"].' - '.$_SESSION['selectedNameLevelTeacher'].'</h2>', chr(10);

                    }else{
                        echo '<h2>'.$GLOBALS["titles"]["addmessage4"].' - '.$_SESSION['selectedNameLevelTeacher'].'</h2>', chr(10);
                    }
                    displaysubAction("viewListSchoolReport");
                }
                elseif (isset($_POST['selectIdLevel'])) {
                    $levelInfos = Level::selectLevel($_POST['selectIdLevel']);
                    unset($_SESSION['selectedIdLevelTeacher']);
                    $_SESSION['selectedIdLevelTeacher'] = $_POST['selectIdLevel'];
                    foreach($levelInfos as $id => $value){
                        echo '<h2>'.$GLOBALS["titles"]["addmessage"].' - '.$levelInfos[$id]['name'].'</h2>', chr(10);
                        unset($_SESSION['selectedNameLevelTeacher']);
                        $_SESSION['selectedNameLevelTeacher'] = $levelInfos[$id]['name'];
                    }
                    displaysubAction("addMessagetoLevel");
                }
                else{
                    echo '<h2>'.$GLOBALS["titles"]["addmessage"].' - '.$tabAllLevel[0]['name'].'</h2>', chr(10);
                    $_SESSION['selectedNameLevelTeacher'] = $tabAllLevel[0]['name'];
                    $_SESSION['selectedIdLevelTeacher'] = $tabAllLevel[0]['id_level'];
                    displaysubAction("addMessagetoLevel");
                }
                $tabAllStudentsInfos = $u->selectAllMemberLevel($_SESSION['selectedIdLevelTeacher'],10);
                $_SESSION['tabAllStudentsInfos'] = $tabAllStudentsInfos;
                displayForm($tabAllMemberLevel);
            }
            else{
                echo '<h2>'.$GLOBALS["titles"]["addmessage"].'</h2>', chr(10);
                echo '<div id="empty">'.$GLOBALS["message"]["noclass"].'</div>', chr(10);
                }
            }
        else{
            echo '<h2>'.$GLOBALS["titles"]["addmessage"].'</h2>', chr(10);
            displaysubAction();
            echo '<div id="empty">Vous ne pouvez pas ajouter un mot dans un carnet car vous n\' avez pas de '.$GLOBALS["formMessage"]["classes"].' ! </div>', chr(10);
            }
    }
}
/**
 * @brief Fonction d'affichage du formulaire d'ajout d'un message
 */
function displayForm($tabAllMemberLevel) {
// Script pour alerter lorsqu'on a atteind la limite maximale de caractères
?>
    <style>
        .surlignage {
            background-color: #FFFF70;
            color: #FF1493;
        }
    </style>
    <script type="text/javascript">
        function LimiterTexte(Champs, nbCarMax) {
            if (Champs.value.length >= nbCarMax) {
                Champs.value = Champs.value.substring(0, nbCarMax);
                $("#message_tip_maxcar").attr("class","surlignage");
            } else if ($("#message_tip_maxcar").attr("class")=="surlignage"){
                $("#message_tip_maxcar").attr("class","");
            }
        }
    </script>
<?php
    if ($_SESSION['profile'] >= 30) {
        if (isset($_GET['selectStudent'])) {
            if (($_SESSION['status'] == False)||(SUSPEND==False)) {
            // Récuperation des infos sur l'élève sélectionné
            $selectedNameLevel = $_SESSION['selectedNameLevelTeacher'];
            $selectIdLevel = $_SESSION['selectedIdLevelTeacher'];
            $IdUserSelected = $_SESSION['IdUserSelected'];
            // Vérification du nombre de classe en charge du professeur
            $tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
            if (sizeof($tabAllLevel) != 0){
            // Cas1: le professeur à plusieurs classe on affiche ces classes sinon rien
            if (sizeof($tabAllLevel) > 1){
            //On ré-affiche le formulaire de choix (changement) de la classe si besoin
                echo '<form name="selectLevel" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'?content=addmessage" >',chr(10);
                echo $GLOBALS["formMessage"]["classes"].' : <br />', chr(10);
                echo '<select name="selectIdLevel">',chr(10);
                foreach ($tabAllLevel as $id => $level) {
                    echo '<option value="'.$level['id_level'].'"';
                    if ((isset($_POST['selectIdLevel']))&&($_POST['selectIdLevel'] == $level['id_level']))
                        echo ' selected="selected"';
                    elseif ((isset($selectIdLevel))&&($selectIdLevel == $level['id_level']))
                        echo ' selected="selected"';
                    echo '>';
                    echo $level['name'];
                    echo '</option>',chr(10);
                }
                echo '</select>',chr(10);
                if($_SESSION['javascript']== "inactif")
                    echo '<input type="submit" name="submit" value="Ok"/>', chr(10);
                echo '</form>',chr(10);
            }
            /*fin affichage de la classe avec possiblilité de changer de classe */
            /* Formulaire de composition de message */
            echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=preview" method="post">', chr(10);
            //echo $GLOBALS["formMessage"]["recipient"].' : '.$_SESSION['schoolReportFirstname'].' '.$_SESSION['schoolReportLastname'].' <br /><br />', chr(10);
            echo $GLOBALS["formMessage"]["recipient"].' : <br />', chr(10);
            // Réa-affichage du nom du destinataire avec possiblilité de changer le destinataire
            // Liste des élèves de classe du destinataire en cours
            $tabAllMemberLevel = Teacher::selectAllMemberLevel($selectIdLevel,10);
            //Liste des élèves non suspendus à vide a peupler
            $noSuspendStudent = array();
            echo '<select name="id_user">', chr(10);
            foreach ($tabAllMemberLevel as $id => $value) {
                if( $tabAllMemberLevel[$id]['status'] == False || SUSPEND == False)
                //Enregistrement des élèves non suspendus
                array_push($noSuspendStudent, $tabAllMemberLevel[$id]['id_user']);
                echo '<option';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                echo ' class="suspend"';
                echo' value="'.$tabAllMemberLevel[$id]['id_user'].'"';
                if ((isset($_POST['id_user']))&&($_POST['id_user'] == $tabAllMemberLevel[$id]['id_user']))
                    echo ' selected ';
                if ((isset($IdUserSelected))&&($IdUserSelected == $tabAllMemberLevel[$id]['id_user']))
                    echo ' selected ';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                    echo ' disabled="disabled" ';
                echo '>';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                echo $tabAllMemberLevel[$id]['firstname'].' '.$tabAllMemberLevel[$id]['lastname'];
                }
                echo '</option>', chr(10);
                echo '</select><br />', chr(10);
            /* fin de sélection de nouveau destinataire */
            echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
            echo '<input type="text" name="title" value="';
            if (isset($_POST['title']))
                echo $_POST['title'];
            echo '" size=35 /><br />';
            echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
            echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
            if (isset($_POST['message']))
                echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
            echo '</textarea><br />', chr(10);
            //echo '<input type="hidden" name="id_user" value="'.$IdUserSelected.'" />', chr(10);
            echo '<input type="hidden" name="selectIdLevel" value="'.$selectIdLevel.'" />', chr(10);
            echo '<input type="hidden" name="selectedNameLevel" value="'.$selectedNameLevel.'" />', chr(10);
            echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
            echo '</form>',chr(10);
            }
            else
                echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
            }
            else
                echo '<div id="empty">Le carnet de '.$_SESSION['schoolReportFirstname'].' a été suspendu par xxx pour la raison suivante : xxx</div>', chr(10);
        }
        /* Ajout de un mot  à toute une classe */
        elseif(isset($_GET['level'])) {
            $tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
            // affichage du nom de la classe selectionnée
            // si l'on choisit sa classe dans la liste des classe du menu déroulant
            if (isset($_POST['selectIdLevel'])){
                $_SESSION['selectedIdLevelTeacher'] = $_POST['selectIdLevel'];
            }
            else
                // affichage de la première classe de la liste
                $_SESSION['selectedIdLevelTeacher'] = $tabAllLevel[0]['id_level'];
            foreach ($tabAllLevel as $id => $level) {
                if ($level['id_level'] == $_SESSION['selectedIdLevelTeacher'])
                    $_SESSION['selectedNameLevelTeacher'] = $tabAllLevel[$id]['name'];
            }
            displaysubAction("viewListSchoolReport");
            // choix de la classe
            echo '<form name="selectLevel" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'?content=addmessage&level">',chr(10);
            echo $GLOBALS["formMessage"]["classes"].' : <br />', chr(10);
            echo '<select name="selectIdLevel">',chr(10);
            foreach ($tabAllLevel as $id => $level) {
                echo '<option value="'.$level['id_level'].'"';
                if ((isset($_POST['selectIdLevel']))&&($_POST['selectIdLevel'] == $levelTeacher['id_level']))
                    echo ' selected="selected"';
                elseif ((isset($_SESSION['selectedIdLevelTeacher']))&&($_SESSION['selectedIdLevelTeacher'] == $level['id_level']))
                    echo ' selected="selected"';
                echo '>';
                echo $level['name'];
                echo '</option>',chr(10);
            }
            echo '</select>',chr(10);
            if($_SESSION['javascript']== "inactif")
                echo '<input type="submit" name="Submit" value="Ok" />',chr(10);
            echo '</form>',chr(10);
            if (isset($_SESSION['selectedIdLevelTeacher'])){
                /* Enregistrement d'effectif de la classe en cours */
                $effectiveStudent = Level::countStudentInLevel($_SESSION['selectedIdLevelTeacher']);
                $countEffectiveStudent = $effectiveStudent[0]['nbInLevel'];
                //Conservation de l'éffectif'
                $_SESSION['countEffectiveStudent'] = $countEffectiveStudent;
                // Liste des élèves de classe du destinataire en cours
                $tabAllMemberLevel = Teacher::selectAllMemberLevel($_SESSION['selectedIdLevelTeacher'],10);
                $noSuspendStudent = array();
                foreach ($tabAllMemberLevel as $id => $value) {
                    //Pour toute la classe pas d'élèves suspendus
                    array_push($noSuspendStudent, $tabAllMemberLevel[$id]['id_user']);
                }
                //Conservation des élèves
                $_SESSION['noSuspendStudent'] = $noSuspendStudent;
                if ($countEffectiveStudent != 0) {
                    // Affichage du affichage du formulaire d'ajout de mot à une toute une classe
                    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=previewMultiple" method="post">', chr(10);
                    echo $GLOBALS["formMessage"]["recipient"].' : <strong> classe de '.$_SESSION['selectedNameLevelTeacher'].' </strong> </br></br>', chr(10);
                    echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
                    echo '<input type="text" name="title" value="';
                    if (isset($_POST['title']))
                        echo $_POST['title'];
                    echo '" size=35 /><br />';
                    echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
                    echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
                    if (isset($_POST['message']))
                        echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
                    echo '</textarea><br />', chr(10);
                    echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
                    echo '</form>',chr(10);
                }
                else
                    echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
            }
        }
        /* Ajout de un mot dans plusieurs carnets ou à toute une classe */
        elseif (isset($_GET['multipleStudent'])) {
            $effectiveStudent = Level::countStudentInLevel($_SESSION['selectedIdLevelTeacher']);
            $countEffectiveStudent = $effectiveStudent[0]['nbInLevel'];
            $idSelectStudent = array();
            if ($_POST['idSelect']){
                $idSelectStudent = $_POST['idSelect'];
            }
            elseif ($_GET['idSelect']){
                $tabAllStudent = $_SESSION['tabAllStudentsInfos'];
                foreach ($tabAllStudent as $id => $value) {
                    array_push($idSelectStudent,$tabAllStudent[$id]['id_user']);
                }
            }
            else{
                echo '<div id="empty">Pas de destinataire, vous n\'avez pas sélectionné d\'élèves</div>', chr(10);
            }
            $countStudent = count($idSelectStudent);
            if ($countStudent>0){
                if($countStudent==1){
                    $tabStudentInfos =Teacher::selectOneStudent($idSelectStudent[0]);
                    $schoolReport = New SchoolReport($idSelectStudent[0]);
                    $idSchoolReport = $schoolReport->getIdSchoolReport();
                    $selectedNameLevel = $_SESSION['selectedNameLevelTeacher'];
                    $status = $schoolReport->getStatus($idSchoolReport);
                    $idStatus = $status[0]['status'];
                    if (($idStatus == False)||(SUSPEND==False)){
                        echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=preview" method="post">', chr(10);
                        echo $GLOBALS["formMessage"]["recipient"].' : '.$tabStudentInfos[0]['firstname'].' '.$tabStudentInfos[0]['lastname'].' <br /><br />', chr(10);
                        echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
                        echo '<input type="text" name="title" value="';
                        if (isset($_POST['title']))
                            echo $_POST['title'];
                        echo '" size=35 /><br />';
                        echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
                        echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
                        if (isset($_POST['message']))
                            echo $_POST['message'];
                        echo '</textarea><br />', chr(10);
                        echo '<input type="hidden" name="id_user" value="'.$idSelectStudent[0].'" />', chr(10);
                        echo '<input type="hidden" name="selectedNameLevel" value="'.$selectedNameLevel.'" />', chr(10);
                        echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
                        echo '</form>',chr(10);
                    }
                    else {
                        echo '<div id="empty">Le carnet de '.$_SESSION['schoolReportFirstname'].' '.$_SESSION['schoolReportLastname'].' a été suspendu par xxx pour la raison suivante : xxx</div>', chr(10);
                        }
                    }
                    /* Si message à tous la classe pas d'exlusion même au carnet suspendus */
                    elseif($countStudent == $countEffectiveStudent){
                        $allStudent = array();
                        unset($_SESSION['noSuspendStudent']);
                        unset($_SESSION['countEffectiveStudent']);
                        $_SESSION['countEffectiveStudent'] = $countEffectiveStudent;
                        for($i=0;$i<$countStudent;$i++){
                            array_push($allStudent,$idSelectStudent[$i]);
                        }
                        $_SESSION['noSuspendStudent'] = $allStudent;
                        echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=previewMultiple" method="post">', chr(10);
                        echo $GLOBALS["formMessage"]["recipient"].' : <strong> classe de '.$_SESSION['selectedNameLevelTeacher'].' </strong> </br></br>', chr(10);
                        echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
                        echo '<input type="text" name="title" value="';
                        if (isset($_POST['title']))
                            echo $_POST['title'];
                        echo '" size=35 /><br />';
                        echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
                        echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
                        if (isset($_POST['message']))
                            echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
                        echo '</textarea><br />', chr(10);
                        echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
                        echo '</form>',chr(10);
                    }
                    else{
                        echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=previewMultiple" method="post">', chr(10);
                        //Liste des élèves non suspendus à vide a peupler
                        $noSuspendStudent = array();
                        unset($_SESSION['noSuspendStudent']);
                        unset($_SESSION['countEffectiveStudent']);
                        echo $GLOBALS["formMessage"]["recipient"].' :', chr(10);
                        for($i=0;$i<$countStudent;$i++){
                            $tabStudentInfos =Teacher::selectOneStudent($idSelectStudent[$i]);
                            $schoolReport = New SchoolReport($idSelectStudent[$i]);
                            $idSchoolReport = $schoolReport->getIdSchoolReport();
                            $status = $schoolReport->getStatus($idSchoolReport);
                            $idStatus = $status[0]['status'];
                            if (($idStatus == False)||(SUSPEND==False)){
                                //Enregistrement des élèves non suspendus
                                array_push($noSuspendStudent,$idSelectStudent[$i]);
                                foreach ($tabStudentInfos as $value) {
                                    echo ' '.$value['firstname'].' '.$value['lastname'].' ;' ;
                                }
                            }
                            //Affichage de l'élève suspendu pour info
                            else{
                                foreach ($tabStudentInfos as $value) {
                                    echo '<s> '.$value['firstname'].' '.$value['lastname'].' ;</s>';
                                }
                            }

                        }
                        echo ' <br /><br />', chr(10);
                        // Si tous les élèves sont suspendus ajout de mot possible sinon impossible
                        $_SESSION['noSuspendStudent'] = $noSuspendStudent;
                        if (sizeof($noSuspendStudent)>0){
                            echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
                            echo '<input type="text" name="title" value="';
                            if (isset($_POST['title']))
                                echo $_POST['title'];
                            echo '" size=35 /><br />';
                            echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
                            echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
                            if (isset($_POST['message']))
                                echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
                            echo '</textarea><br />', chr(10);
                            echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
                            echo '</form>',chr(10);
                        }
                        else {
                            echo '<div id="empty">Impossible d\''.$GLOBALS["titles"]["addmessage4"].' car tous les destinataires sont suspendus dans cette classe !</div>', chr(10);
                        }
                    }
                }
            else {
                echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].' </div>', chr(10);
            }
        }
        /*** Fin Ajout de un mot dans plusieurs carnets ou à toute une classe ***/
        /* Affichage par defaut de l'interface d'envoi de message pour un professeur */
        else {
            // choix de la classe
            $tabAllLevel = Teacher::selectAllLevelForTeacher($_SESSION['id_user']);
            if (sizeof($tabAllLevel) != 0){
                // Cas1 : le professeur a une seule classe
                if (sizeof($tabAllLevel) == 1) {
                    $selectIdLevel =  $tabAllLevel[0]['id_level'];
                    $selectNameLevel = $tabAllLevel[0]['name'];
                }
                // Cas2 : le professeur à plusieurs classe
                else {
                    // On ne change pas de classe : Valider et continuer
                    if(isset($_SESSION['noChangeIdLevel']))
                        $noChangeIdLevel = $_SESSION['noChangeIdLevel'];
                    //On affiche le formulaire de choix de la classe
                    echo '<form name="selectLevel" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'?content=addmessage" >',chr(10);
                    echo $GLOBALS["formMessage"]["classes"].' : <br />', chr(10);
                    echo '<select name="selectIdLevel">',chr(10);
                    foreach ($tabAllLevel as $id => $level) {
                        echo '<option value="'.$level['id_level'].'"';
                        if ((isset($_POST['selectIdLevel']))&&($_POST['selectIdLevel'] == $level['id_level']))
                            echo ' selected="selected"';
                        elseif ((isset($noChangeIdLevel))&&($noChangeIdLevel == $level['id_level']))
                            echo ' selected="selected"';
                        echo '>';
                        echo $level['name'];
                        $selectNameLevel = $level['name'];
                        echo '</option>',chr(10);
                    }
                    echo '</select>',chr(10);
                    echo '<input type="hidden" name="selectNameLevel" value="'.$level['name'].'" />',chr(10);
                    //echo '<input type="submit" name="submit" value="Ok" />',chr(10);
                    if($_SESSION['javascript']== "inactif")
                        echo '<input type="submit" name="submit" value="Ok"/>', chr(10);
                    echo '</form>',chr(10);
                }
                // choisir le destinataire du mot
                if (isset($_POST['selectIdLevel'])){
                    $selectIdLevel = $_POST['selectIdLevel'];
                    $tabAllMemberLevel = Teacher::selectAllMemberLevel($selectIdLevel,10);
                }
                elseif (isset($noChangeIdLevel)){
                    $selectIdLevel = $noChangeIdLevel;
                    $tabAllMemberLevel = Teacher::selectAllMemberLevel($selectIdLevel,10);
                }
                else
                    $tabAllMemberLevel = Teacher::selectAllMemberLevel($tabAllLevel[0]['id_level'],10);
                if (sizeof($tabAllMemberLevel) != 0){
                    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=preview" method="post">', chr(10);
                    echo $GLOBALS["formMessage"]["recipient"].' : <br />', chr(10);
                    //Liste des élèves non suspendus à vide a peupler
                    $noSuspendStudent = array();
                    echo '<select name="id_user">', chr(10);
                    foreach ($tabAllMemberLevel as $id => $value) {
                        if( $tabAllMemberLevel[$id]['status'] == False || SUSPEND == False)
                        //Enregistrement des élèves non suspendus
                        array_push($noSuspendStudent, $tabAllMemberLevel[$id]['id_user']);
                        echo '<option';
                        if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                            echo ' class="suspend"';
                        echo' value="'.$tabAllMemberLevel[$id]['id_user'].'"';
                        if ((isset($_POST['id_user']))&&($_POST['id_user'] == $tabAllMemberLevel[$id]['id_user']))
                        echo ' selected ';
                        if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                        echo ' disabled="disabled" ';
                        echo '>';
                        if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                        echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                        echo $tabAllMemberLevel[$id]['firstname'].' '.$tabAllMemberLevel[$id]['lastname'];
                    }
                    echo '</option>', chr(10);
                    echo '</select><br />', chr(10);
                    if (sizeof($noSuspendStudent)>0){
                    echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
                    echo '<input type="text" name="title" value="';
                    if (isset($_POST['title']))
                        echo $_POST['title'];
                    echo '" size=35 /><br />';
                    echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
                    //echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
                    echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
                    if (isset($_POST['message']))
                        echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
                    echo '</textarea><br />', chr(10);
                    //unset($_POST['selectedNameLevel']);
                    if (isset($selectIdLevel))
                        echo '<input type="hidden" name="selectIdLevel" value="'.$selectIdLevel.'" />',chr(10);
                    else
                        echo '<input type="hidden" name="selectIdLevel" value="'.$tabAllLevel[0]['id_level'].'" />',chr(10);
                    if (isset($selectNameLevel))
                        echo '<input type="hidden" name="selectedNameLevel" value="'.$selectNameLevel.'" />',chr(10);
                    else
                        echo '<input type="hidden" name="selectedNameLevel" value="'.$tabAllLevel[0]['name'].'" />',chr(10);
                    echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
                    }
                    else {
                        echo '<div id="empty">Impossible d\''.$GLOBALS["titles"]["addmessage"].' car tous les destinataires sont suspendus !</div>', chr(10);
                                }
                    echo '</form>',chr(10);
                }
                else
                    echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
            }
            else
                echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
        }
    }else {
        if (sizeof($tabAllMemberLevel) != 0) {
            echo '<form action="'.$_SERVER['PHP_SELF'].'?content=addmessage&action=preview" method="post">', chr(10);
            echo $GLOBALS["formMessage"]["recipient"].' : <br />', chr(10);
            // choisir le destinataire du mot
            echo '<select name="id_user">', chr(10);
            foreach ($tabAllMemberLevel as $id => $value) {
                echo '<option';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                    echo ' class="suspend"';
                echo' value="'.$tabAllMemberLevel[$id]['id_user'].'"';
                if ((isset($_POST['id_user']))&&($_POST['id_user'] == $tabAllMemberLevel[$id]['id_user']))
                    echo ' selected ';
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                    echo ' disabled="disabled" ';
                echo '>';
                #if ($_SESSION['profile'] >= 30) {
                #    // ajout de la classe devant les noms des élèves
                #    echo $tabAllMemberLevel[$id]['nameLevel'].' - ';
                #}
                if ((isset($tabAllMemberLevel[$id]['status']))&&($tabAllMemberLevel[$id]['status']==True)&&(SUSPEND == True))
                    echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                echo $tabAllMemberLevel[$id]['firstname'].' '.$tabAllMemberLevel[$id]['lastname'];
                if ($_SESSION['profile'] <= 30) {
                    // ajout de la matière après le nom du prof
                    if (empty($tabAllMemberLevel[$id]['matiere']))
                        echo " - pas de matière";
                    else
                        echo ' - '.$tabAllMemberLevel[$id]['matiere'];
                }
                echo '</option>', chr(10);
            }
            echo '</select><br />', chr(10);
            echo $GLOBALS["formMessage"]["subject"].' : <br />', chr(10);
            echo '<input type="text" name="title" value="';
            if (isset($_POST['title']))
                echo $_POST['title'];
            echo '" size=35 /><br />';
            echo $GLOBALS["formMessage"]["content"].' : (<span id="message_tip_maxcar" class="">'.$GLOBALS["message"]["carmax"].'</span>)<br />', chr(10);
            echo '<textarea class="addMessage" name="message" maxlength="800" onkeyup="LimiterTexte(this, 800);" rows="10">';
            if (isset($_POST['message']))
                echo html_entity_decode($_POST['message'], ENT_QUOTES, "UTF-8");
            echo '</textarea><br />', chr(10);
            echo '<input id="seeAddMessage" type="submit" name="ajouter" value="'.$GLOBALS["formMessage"]["display"].'" />', chr(10);
            echo '</form>', chr(10);
        }
        else
            echo '<div id="empty">Il n\'y a pour le moment aucun professeur dans cette classe !</div>', chr(10);
    }
}
?>
