<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file box.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Gère l'affichage des mots destinés aux enseignants et émis par les enseignants
 */
?>

<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>

<?php
if (isset($_POST['displaymessage'])) {
    // Demande d'affichage d'un seul message
    $message = New Message;
    $oneMessage = $message->getMessage($_POST['id_message']);
    //displaysubAction("box");
    // Envoi de message à l'élève dont le carnet est ouvert
    echo '<a href="index.php?content=addmessage&selectStudent"><img class="icone" src="./images/icons/accessories-text-editor.png" title="Ajouter un mot dans son carnet" alt="nouveau message" /></a><br /><br />', chr(10);
    if ((isset($_GET['content']))&&($_GET['content'] == 'sentMessages')){ // pour différencier si on est dans "messages émis" ou non
        displayOneMessage($oneMessage, "sent");
    } else {
        displayOneMessage($oneMessage, "received");
    }
} elseif (isset($_POST['validation'])) {
	/*
    // Demande de validation d'un message
    $message = New Message;
    if ($message->validMessage($_POST['id_message'],$_SESSION['id_user'])) {
        $info = $GLOBALS['message']['novalidatenote'];
        $type_message = 'warning';
    } else {
        $info = $GLOBALS['message']['validatenote'];
        $typeMessage = 'info';
    }
    // infoboard
    echo '<script type="text/javascript">';
    echo 'var message = "'.$info.'";';
    echo 'displayInfoboard('.$typeMessage.',message);';
    echo '</script>';

    // Ré-affichage des mots selon si on est dans "messages émis" ou "mots à votre attention"
    if ((isset($_GET['content']))&&($_GET['content'] == 'sentMessages')){ // pour différencier si on est dans "messages émis" ou non
        displayBox("sent");
    } else {
        displayBox("received");
    }
    */
    $message = New Message;
	$message->validMessage($_POST['id_message'],$_SESSION['id_user']);
	$info = 'Le mot a été validé';
    $typeMessage = 'info';
    // infoboard
    echo '<script type="text/javascript">';
    echo 'var message = "'.$info.'";';
    echo 'displayInfoboard('.$typeMessage.',message);';
    echo '</script>';
    // Ré-affichage des mots selon si on est dans "messages émis" ou "mots à votre attention"
    echo '<h2>'.$GLOBALS['titles']['box'].'</h2>', chr(10);
    displaysubAction("box");
    $box = new Box();
    $tabAllMessage = $box->getBox($_SESSION['id_user']);
	displayAllMessages($tabAllMessage, $type="received");
} elseif ((isset($_GET['content']))&&($_GET['content'] == 'sentMessages')) {
    // Demande des messages émis
    displayBox("sent");
} else {
    // Affichage des messages reçus
    displayBox("received");
}
// ===================================================
/**
 * @brief Affichage des mots
 * @param $type si "received" (valeur par défaut) alors affiche les mots reçus sinon (par exemple valeur "sent") alors n'affiche que les mots envoyés
 */
function displayBox($type="received") {
    $box = new Box();
    if ($type == "received"){
        $tabAllMessage = $box->getBox($_SESSION['id_user']);
        echo '<h2>'.$GLOBALS['titles']['box'].'</h2>', chr(10);
        $nothing = "<div id='empty'>".$GLOBALS['message']['nonoteforyou']."</div>\n";
    } else {
        $tabAllMessage = $box->getSentMessages($_SESSION['id_user']);
        echo '<h2>'.$GLOBALS['titles']['box2'].'</h2>', chr(10);
        $nothing = "<div id='empty'>".$GLOBALS['message']['nonoteyours']."</div>\n";
    }
    if (sizeof($tabAllMessage) != 0) {
        displaysubAction("box");
        displayAllMessages($tabAllMessage, $type);
    } else {
        echo $nothing;
    }
}

/**
 * @brief Mise en forme de l'affichage des mots
 * @param $tabAllMessage tableau des messages
 * @param $type si "received" (valeur par défaut) alors affiche les mots reçus sinon (par exemple valeur "sent") alors n'affiche que les mots envoyés
 */
function displayAllMessages($tabAllMessage, $type="received") {
    if (isset($tabAllMessage)) {
        echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
        echo '<caption />', chr(10);
        echo '<thead>', chr(10);
        echo '<tr>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleObject'].'</th>', chr(10);
        if ($type == "received") {
            echo '<th>'.$GLOBALS['titleMessage']['titleTransmitter'].'</th>', chr(10);
        } else {
            echo '<th>'.$GLOBALS['titleMessage']['titleRecipient'].'</th>', chr(10);
        }
        echo '<th>'.$GLOBALS['titleMessage']['titleDate'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleValidation'].'</th>', chr(10);
        echo '</tr>', chr(10);
        echo '</thead>', chr(10);
        echo '<tbody>', chr(10);
        foreach ($tabAllMessage as $ceMessage) {
            echo '<tr>', chr(10);
            echo '<td><p class="objet-message">'.$ceMessage['title'].'</p>', chr(10);
            echo '<div class="mcontent">', chr(10);
            // on coupe le message
            echo cutMessage($ceMessage['content']), chr(10);
            if ((isset($_GET['content']))&&($_GET['content'] == 'sentMessages')) { // pour différencier si on est dans "messages émis ou non"
                echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'?content=sentMessages" method="post">', chr(10);
            } else {
                echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'" method="post">', chr(10);
            }
            echo '<input type="hidden" name="action" value="displaymessage" />', chr(10);
            echo '<input type="hidden" name="id_message" value="'.$ceMessage['id_message'].'" />', chr(10);
            // on affiche un bouton différent si le message est déjà validé ou non
            if (($ceMessage['validation']==0)&&(!((isset($_GET['content']))&&($_GET['content'] == 'sentMessages')))) // pas de validation quand on est l'éméteur
                echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['toread'].'"/>', chr(10);
            else
                echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['see'].'"/>', chr(10);
            echo '</form>', chr(10);
            echo '</div><!-- mcontent -->', chr(10);
            echo '</td>', chr(10);
            echo '<td>'.$ceMessage['lastname'].' '.$ceMessage['firstname'].'</td>', chr(10);
            echo '<td>'.$ceMessage['date'].' à '.$ceMessage['time'].' </td>', chr(10);
            echo '<td>', chr(10);
            if ($ceMessage['validation']==0)
                echo '<span style="display:none;">0</span><img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" />', chr(10);
            else
                echo '<span style="display:none;">1</span><img class="icone" src="./images/icons/dialog-ok.png" alt="mot non validé" />', chr(10);
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '<br />', chr(10);
    }
    else
        echo '<div id="empty">'.$GLOBALS['message']['emptyschoolreport'].'</div>', chr(10);
}

/**
 * @brief Mise en forme de l'affichage d'un seul mot
 * @param $oneMessage objet de type Message
 * @param $type si "received" (valeur par défaut) alors affiche les mots reçus sinon (par exemple valeur "sent") alors n'affiche que les mots envoyés
 */
function displayOneMessage($oneMessage, $type="received") {
    // affichage un message
    if (isset($oneMessage)) {
        // affichage des libellés
        echo '<div class="table">', chr(10);
        echo '<div class="caption"></div>', chr(10);
        echo '<div class="tbody">', chr(10);
        echo '<div class="tr">', chr(10);
        echo '<div class="td1"><span class="title">'.$GLOBALS['titleMessage']['titleObject'].'</span></div>', chr(10);
        if ($type == "received") {
            echo '<div class="td2"><span class="title">'.$GLOBALS['titleMessage']['titleTransmitter'].'</span></div>', chr(10);
        } else {
            echo '<div class="td2"><span class="title">'.$GLOBALS['titleMessage']['titleRecipient'].'</span></div>', chr(10);
        }
        echo '<div class="td3"><span class="title">Date</span></div>', chr(10);
        echo '<div class="tdend"><span class="title">Validation</span></div>', chr(10);
        echo '</div><!-- fermeture de tr -->', chr(10);
        echo '</div><!-- fermeture de tbody -->', chr(10);
        echo '</div><!-- fermeture de table -->', chr(10);
        echo '<br/><br/>', chr(10);
        foreach ($oneMessage as $id => $value) {
            echo '<div class="table">', chr(10);
            echo '<div class="caption"></div>', chr(10);
            echo '<div class="tbody">', chr(10);
            echo '<div class="tr">', chr(10);
            echo '<div class="td1">'.$oneMessage[$id]['title'].'</div>', chr(10);
            if ($type == "received") {
                echo '<div class="td2">', chr(10);
                if($oneMessage[$id]['id_profile']==10){
					echo ' <a href="index.php?content=viewSchoolReport&action=viewCarnet&idUser='.$oneMessage[$id]['id_user'].'" title="voir son carnet" >'.$oneMessage[$id]['lastname'].' '.$oneMessage[$id]['firstname'].'</a> - <a href="index.php?content=viewSchoolReport&idLevel='.$oneMessage[$id]['idLevel'].'" title="voir les carnets">'.$oneMessage[$id]['classe'].' </a> ', chr(10);
					/* Conservation des infos de l'élève dont le carnet est ouvert pour l'envoie de message */
					unset($_SESSION['selectedIdLevelTeacher']);
					unset($_SESSION['selectedNameLevelTeacher']);
					unset($_SESSION['IdUserSelected']);
					unset($_SESSION['schoolReportFirstname']);
					unset($_SESSION['schoolReportLastname']);
					$_SESSION['selectedIdLevelTeacher'] = $oneMessage[$id]['idLevel'];
					$_SESSION['selectedNameLevelTeacher'] = $oneMessage[$id]['classe'];
					$_SESSION['IdUserSelected'] = $oneMessage[$id]['id_user'];
					$_SESSION['schoolReportFirstname'] = $oneMessage[$id]['firstname'];
					$_SESSION['schoolReportLastname'] = $oneMessage[$id]['lastname'];
				}
				else
					echo ' '.$oneMessage[$id]['lastname'].' '.$oneMessage[$id]['firstname'].' ', chr(10);
                if($oneMessage[$id]['id_profile']==20){
					echo ' : Responsable de <a href="index.php?content=viewSchoolReport&action=viewCarnet&idUser='.$oneMessage[$id]['studentIdUser'].'" title="voir son carnet" >'.$oneMessage[$id]['studentFirstname'].' '.$oneMessage[$id]['studentLastname'].'</a> - <a href="index.php?content=viewSchoolReport&idLevel='.$oneMessage[$id]['idLevel'].'" title="voir les carnets">'.$oneMessage[$id]['classe'].' </a> ';
					/* Conservation des infos de l'élève dont le carnet est ouvert pour l'envoie de message */
					unset($_SESSION['selectedIdLevelTeacher']);
					unset($_SESSION['selectedNameLevelTeacher']);
					unset($_SESSION['IdUserSelected']);
					unset($_SESSION['schoolReportFirstname']);
					unset($_SESSION['schoolReportLastname']);
					$_SESSION['selectedIdLevelTeacher'] = $oneMessage[$id]['idLevel'];
					$_SESSION['selectedNameLevelTeacher'] = $oneMessage[$id]['classe'];
					$_SESSION['IdUserSelected'] = $oneMessage[$id]['studentIdUser'];
					$_SESSION['schoolReportFirstname'] = $oneMessage[$id]['studentFirstname'];
					$_SESSION['schoolReportLastname'] = $oneMessage[$id]['studentLastname'];
				}
				echo '</div>', chr(10);
            } else {
				$tabStudentInfos = Student::getUserInfos($oneMessage[$id]['id_userRecipient']);
                echo '<div class="td2"><a href="index.php?content=viewSchoolReport&action=viewCarnet&idUser='.$oneMessage[$id]['id_userRecipient'].'" title="voir son carnet" >'.$oneMessage[$id]['lastnameRecipient'].' '.$oneMessage[$id]['firstnameRecipient'].'</a>    - <a href="index.php?content=viewSchoolReport&idLevel='.$tabStudentInfos['idLevel'].'" title="voir les carnets">'.$tabStudentInfos['classe'].' </a></div>', chr(10);
                /* Conservation des infos de l'élève dont le carnet est ouvert pour l'envoie de message */
                unset($_SESSION['selectedIdLevelTeacher']);
				unset($_SESSION['selectedIdLevelTeacher']);
				unset($_SESSION['selectedNameLevelTeacher']);
				unset($_SESSION['IdUserSelected']);
				unset($_SESSION['schoolReportFirstname']);
				unset($_SESSION['schoolReportLastname']);
				$_SESSION['selectedIdLevelTeacher'] = $tabStudentInfos['idLevel'];
				$_SESSION['selectedNameLevelTeacher'] = $tabStudentInfos['classe'];
				$_SESSION['IdUserSelected'] = $oneMessage[$id]['id_userRecipient'];
				$_SESSION['schoolReportFirstname'] = $oneMessage[$id]['firstnameRecipient'];
				$_SESSION['schoolReportLastname'] = $oneMessage[$id]['lastnameRecipient'];
            }
            echo '<div class="td3">Le '.$oneMessage[$id]['date'].' à '.$oneMessage[$id]['time'].'</div>', chr(10);
            echo '<div class="tdend">', chr(10);
            if ($oneMessage[$id]['validation']==0)
                echo '<img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" />', chr(10);
            else
                echo '<img class="icone" src="./images/icons/dialog-ok.png" alt="mot non validé" />', chr(10);
            echo '</div><!-- fermeture de tdend -->', chr(10);
            echo '</div><!-- fermeture de tr -->', chr(10);
            echo '</div><!-- fermeture de tbody -->', chr(10);
            echo '</div><!-- fermeture de table -->', chr(10);
            echo '<br />', chr(10);
            echo '<div class="mcontent">';
            echo '<p>'.$oneMessage[$id]['content'].'</p><br />', chr(10);
            echo '</div>';
            if ((isset($_GET['content']))&&($_GET['content'] == 'sentMessages')) { // pour différencier si on est dans "messages émis ou non"
                echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'?content=sentMessages" method="post">', chr(10);
            } else {
                echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'" method="post">', chr(10);
            }
            echo '<input type="hidden" name="id_message" value="'.$oneMessage[$id]['id_message'].'" />', chr(10);
            // on affiche un bouton différent si le message est déjà validé ou non
            if (($oneMessage[$id]['validation']==0)&&(!((isset($_GET['content']))&&($_GET['content'] == 'sentMessages')))) { // pas de validation quand on est l'éméteur
                echo '<input type="submit" name="validation" value="'.$GLOBALS['formMessage']['toapprove'].'"/>', chr(10);
            }
            echo '<input type="submit" name="retour" value="'.$GLOBALS['formMessage']['back'].'"/>', chr(10);
            echo '</form>', chr(10);
        }
        echo '<br />', chr(10);
    } else {
        echo '<div id="empty">'.$GLOBALS['message']['error'].'</div>', chr(10);
    }
}
?>
