<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file Admin.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe regroupant les méthodes utilisés uniquement par les admin de l'application
 * @todo enlever les méthodes inutiles
 */

class Admin extends Manager
{

    /**
     * @brief le constructeur permet de loguer l'instanciation de la classe
     */
    public function __construct()
    {
        if (DEBUG==True)
            Logger::log('création d\'un nouvel Admin');
        //$this->label_profile = "Administrateur";
    }

#    function getLabelProfile() {
#        return $this->label_profile;
#    }

    /**
     * @brief Méthode permettant l'ajout d'un utilisateur
     * @param $login login
     * @param $lastname nom
     * @param $firstname prénom
     * @param $password mot de passe
     * @param $email adresse courriel
     * @param $birth_date date de naissance
     * @param $profile profile utilisateur
     * @param $enabled compte actif
     * @public
     */
    public function addUser($login,$lastname,$firstname,$password,$email,$birth_date,$profile,$enabled) {
        if (DEBUG==True)
            Logger::log('passage dans addUser');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "INSERT INTO user (login,lastname,firstname,password,email,birth_date,id_profile,enabled) VALUES (:login,:lastname,:firstname,:password,:email,:birth_date,:profile,:enabled)";
        if (DEBUG==True)
            Logger::log('insertion d\'un nouvel utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('login', $login, PDO::PARAM_STR);
        $stmt->bindParam('lastname', $lastname, PDO::PARAM_STR);
        $stmt->bindParam('firstname', $firstname, PDO::PARAM_STR);
        $stmt->bindParam('password', $password, PDO::PARAM_STR);
        $stmt->bindParam('email', $email, PDO::PARAM_STR);
        $stmt->bindParam('birth_date', $birth_date, PDO::PARAM_STR);
        $stmt->bindParam('profile', $profile, PDO::PARAM_INT);
        $stmt->bindParam('enabled', $enabled, PDO::PARAM_BOOL);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        if ($profile == 10) {
            // retourne le dernier ID
            $idUser = $db->lastInsertId();
            //$this->addSchoolReport($idUser);
            Logger::log('passage dans addUser si l\'utilisateur est un élève ');
			$db = Connection::getInstance();
			if(!$db) {
				throw new MyException (ERR_CONNECT_DB);
			}
			$sql = 'INSERT INTO school_report (id_user) VALUES (:idUser)';
			if (DEBUG==True)
				Logger::log('ajout d\'un carnet : '.$sql);
			$stmt = $db->prepare($sql);
			if ($stmt === null) {
				throw new MyException ('erreur de préparation à la requête');
			}
			$stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
			if ($stmt->execute() === false) {
				$stmt->errorInfo();
			}
        }
    }


	/**
     * @brief Méthode permettant l'ajout d'un utilisateur avec une discipline
     * @param $login login
     * @param $lastname nom
     * @param $firstname prénom
     * @param $password mot de passe
     * @param $email adresse courriel
     * @param $birth_date date de naissance
     * @param $profile profile utilisateur
     * @param $idDiscipline compte actif
     * @param $enabled compte actif
     * @public
     */
    public function addUserDiscipline($login,$lastname,$firstname,$password,$email,$birth_date,$profile,$enabled,$idDiscipline) {
        if (DEBUG==True)
            Logger::log('passage dans addUserDiscipline');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "INSERT INTO user (login,lastname,firstname,password,email,birth_date,id_profile,enabled) VALUES (:login,:lastname,:firstname,:password,:email,:birth_date,:profile,:enabled)";
        if (DEBUG==True)
            Logger::log('insertion d\'un nouvel utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('login', $login, PDO::PARAM_STR);
        $stmt->bindParam('lastname', $lastname, PDO::PARAM_STR);
        $stmt->bindParam('firstname', $firstname, PDO::PARAM_STR);
        $stmt->bindParam('password', $password, PDO::PARAM_STR);
        $stmt->bindParam('email', $email, PDO::PARAM_STR);
        $stmt->bindParam('birth_date', $birth_date, PDO::PARAM_STR);
        $stmt->bindParam('profile', $profile, PDO::PARAM_INT);
        $stmt->bindParam('enabled', $enabled, PDO::PARAM_BOOL);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        // Attribution de matière à un profile enseigant
        if ($profile >= 30) {
            // retourne le dernier ID
            $idUser = $db->lastInsertId();
            //$this->addSchoolReport($idUser);
            Logger::log('passage dans addUserDiscipline si l\'utilisateur est un professeur ');
			$db = Connection::getInstance();
			if(!$db) {
				throw new MyException (ERR_CONNECT_DB);
			}
			$sql = "INSERT INTO teacher (id_user,id_discipline) VALUES (:idUser,:idDiscipline )";
			if (DEBUG==True)
				Logger::log('attribution d\'une discipline à un enseigant : '.$sql);
			$stmt = $db->prepare($sql);
			if ($stmt === null) {
				throw new MyException ('erreur de préparation à la requête');
			}
			$stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
			$stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
			if ($stmt->execute() === false) {
				$stmt->errorInfo();
			}
        }
    }


    /**
     * @brief Ajouter un carnet
     * @param $idUser l'id de l'utilisateur pour l'ajout du carnet
     * @public
     */
    public function addSchoolReport($idUser) {
        Logger::log('passage dans addSchoolReport');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'INSERT INTO school_report (id_user) VALUES (:idUser)';
        if (DEBUG==True)
            Logger::log('ajout d\'un carnet : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


    /**
     * @brief Supprimer un utilisateur.
     * @param $idRemove l'id de l'utilisateur à supprimer
     * @public
     */
    public function removeUser($idUser) {
        Logger::log('passage dans removeUser');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "DELETE FROM user WHERE id_user = :idUser";
        if (DEBUG==True)
            Logger::log('suppression d\'un utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

    /**
     * @brief sélectionner tous les membres potentiels d'une classe
     * @param int id du level concerné
     * @return un tableau contenant les membres potentiels
     * @public
     */

    public function selectAllPossibleMembership($id_level,$id_profile) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllMembership : Admin.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT DISTINCT user.id_user,login,firstname,lastname FROM user LEFT JOIN member_of_level ON member_of_level.id_user = user.id_user left join level ON  member_of_level.id_level = level.id_level WHERE user.id_profile = :id_profile and (member_of_level.id_level  is null OR  member_of_level.id_level <> :id_level) ORDER BY lastname";
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_profile', $id_profile, PDO::PARAM_INT);
        $stmt->bindParam('id_level', $id_level, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }


    /**
     * @brief Sélectionner tous les utilisateurs.
     * @return un tableau contenant tous les élèves
     * @public
     */
    function selectAllUsers()
    {
        Logger::log('passage dans selectAllUsers : Admin.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        //$sql = "SELECT * FROM user ORDER BY lastname";
        $sql = "SELECT id_user,lastname,firstname,login,email,birth_date,password,enabled,user.id_profile as profile,admin,profile.grade FROM user JOIN profile ON profile.id_profile=user.id_profile ORDER BY lastname";
        if (DEBUG==True)
            Logger::log('selection de tous les utilisateurs : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
    // @fixme regarder comment c'est géré dans une autre méthode, dans schoolreport.content par exemple
    if ($count > 0)
        return $result;
    }


     /**
     * @brief Sélectionner un utilisateur.
     * @return un tableau contenant tous les élèves
     * @public
     */
    function selectOneUser($idUser){
        Logger::log('passage dans selectOneUser : Admin.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        //$sql = "SELECT * FROM user ORDER BY lastname";
        $sql = "SELECT id_user,lastname,firstname,login,email,birth_date,password,enabled,user.id_profile as profile,admin,profile.grade FROM user JOIN profile ON profile.id_profile=user.id_profile WHERE user.id_user = :idUser";
        if (DEBUG==True)
            Logger::log('selection d\'un utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }



    /**
     * @brief Méthode permettant de récupérer le réglement intérieur dans la BDD
     * @return un tableau contenant le réglement
     * @public
     */
    public function editRules() {
        Logger::log('passage dans editRules');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT rules FROM config";
        if (DEBUG==True)
            Logger::log('selection du règlement intérieur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        if($count == 0)
            throw new MyException (ERR_SELECT_NB_NULL);
        return $result;
    }

    /**
     * @brief Méthode permettant d'enregister le réglement intérieur dans la BDD
     * @param Le règlement intérieur à enregistrer
     * @public
     */
    public function saveRules($rules) {
        Logger::log('passage dans saveRules');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $testRules = parent::getRules();
        // test si une entrée existe
        if (sizeof($testRules) < 1) {
            if ($count == 0) {
                $sqlAlt = "INSERT INTO config (rules) VALUES ('')";
                if (DEBUG==True)
                    Logger::log('création d\'un règlement vide : '.$sqlAlt);
                $stmt = $db->prepare($sqlAlt);
                if ($stmt->execute() === false) {
                    $stmt->errorInfo();
                }
            }
        }
        $sql = "UPDATE config SET rules = :rules";
        if (DEBUG==True)
            Logger::log('mise à jour du règlement intérieur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('rules', $rules, PDO::PARAM_STR);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

    /**
     * @brief Méthode permettant d'activer un compte
     * @param L'id de l'utilisateur à mettre à jour
     * @public
     */
    public function enabledUser($idUser,$value) {
        Logger::log('passage dans enabledUsers');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "UPDATE user SET enabled = :value WHERE id_user = :idUser";
        if (DEBUG==True)
            Logger::log('mise à jour de l\'utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        $stmt->bindParam('value', $value, PDO::PARAM_BOOL);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

    /**
     * @brief Obtenir les informations utilisateurs
     * @param Id de l'utilisateur en cours
     * @return Tableau contenant les informations utilisateurs
     * @todo l'id en paramètre n'est pas souhaitable
     */
    public function getUserInfos($idUser) {
        Logger::log('passage dans surcharge getUserInfos Admin');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupération des informations de l'utilisateur par rapport au login
        $sql = "SELECT id_user,firstname,lastname,enabled,login,email,birth_date,id_profile as profile,birth_date,birth_date as birthdate,DATE_FORMAT(birth_date,'%Y') as year,DATE_FORMAT(birth_date,'%m') as month,DATE_FORMAT(birth_date,'%d') as day FROM user WHERE id_user = :idUser";
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('selectionner tous de l\'utilisateur');
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        // le login n'existe pas
        if($count == 0)
            return False;
        elseif($count > 1)
            throw new MyException (ERR_SELECT_NB_ROW);
        elseif ($count == 1) {
            return $result;
        }
        else
            return False;
    }

    /**
     * @brief Obtenir les informations d'une classe
     * @param Id de la classe en cours
     * @return Tableau contenant les informations de la classe
     * @todo l'id en paramètre n'est pas souhaitable
     */
    public function getLevelInfos($idLevel) {
        Logger::log('passage dans getLevelInfos');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupération des informations de l'utilisateur par rapport au login
        $sql = "SELECT id_level,name FROM level WHERE id_level = :idLevel";
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('selectionner tous d\'une classe');
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        // la classe n'existe pas
        if($count == 0)
            return False;
        elseif($count > 1)
            throw new MyException (ERR_SELECT_NB_ROW);
        elseif ($count == 1) {
            return $result;
        }
        else
            return False;
    }

    /**
     * @bried mise à jour des informations utilisateurs
     * @param login
     * @param lastname
     * @param firstname
     * @param password
     * @param email
     * @param birthdate
     * @param profile
     * @param enabled
     * @param id de l'utilisateur
     */
    public function updateUserInfos($login,$lastname,$firstname,$password,$email,$birth_date,$profile,$enabled,$idUser) {
        Logger::log('passage dans updateUserInfos Admin');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // mise à jour des informations de l'utilisateur par rapport au login
        $sql = "UPDATE user SET login= :login,lastname= :lastname,firstname= :firstname,password= :password,email= :email,birth_date= :birth_date, id_profile = :profile, enabled = :enabled WHERE id_user= :idUser";
        $sqlAlt = "UPDATE user SET login= :login,lastname= :lastname,firstname= :firstname,email= :email,birth_date= :birth_date, id_profile = :profile, enabled = :enabled WHERE id_user= :idUser";
        if (empty($password)) {
            if (DEBUG==True)
                Logger::log('mise à jour des infos utilisateur sans mdp : '.$sqlAlt);
            $stmt = $db->prepare($sqlAlt);
        }
        else {
            if (DEBUG==True)
                Logger::log('mise à jour des infos utilisateur : '.$sql);
            $stmt = $db->prepare($sql);
        }
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('login', $login, PDO::PARAM_STR);
        $stmt->bindParam('lastname', $lastname, PDO::PARAM_STR);
        $stmt->bindParam('firstname', $firstname, PDO::PARAM_STR);
        if (!empty($password))
            $stmt->bindParam('password', $password, PDO::PARAM_STR);
        $stmt->bindParam('email', $email, PDO::PARAM_STR);
        $stmt->bindParam('birth_date', $birth_date, PDO::PARAM_STR);
        $stmt->bindParam('profile', $profile, PDO::PARAM_INT);
        $stmt->bindParam('enabled', $enabled, PDO::PARAM_INT);
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes modifiées : '.$count);
        // l'id n'existe pas
        if($count == 0)
            return 2;
        elseif($count > 1)
            throw new MyException (ERR_UPDATE_NB_ROW);
    }

    /**
     * @brief Supprimer une classe.
     * @param $idRemove l'id de la classe à supprimer
     * @public
     */
    public function removeLevel($idLevel) {
        Logger::log('passage dans removeLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "DELETE FROM level WHERE id_level = :idLevel";
        if (DEBUG==True)
            Logger::log('suppression d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

    /**
     * Description: méthode permettant l'ajout d'une classe
     * Paramètres: nom de la classe à ajouter
     * Return:
     */
    static function addLevel($name) {
        Logger::log('passage dans addLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "INSERT INTO level (name) VALUES (:name)";
        if (DEBUG==True)
            Logger::log('insertion d\'une nouvelle classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('name', $name, PDO::PARAM_STR);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


    /**
     * @bried mise à jour des informations d'une classe
     * @param name nom de la classe
     * @param id de la classe
     */
    public function updateLevelInfos($name,$idLevel) {
        Logger::log('passage dans updateLevelInfos Admin');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupération des informations de l'utilisateur par rapport au login
        $sql = "UPDATE level SET name= :name WHERE id_level= :idLevel";
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('name', $name, PDO::PARAM_STR);
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes modifiées : '.$count);
        // l'id n'existe pas
        if($count == 0)
            throw new MyException (ERR_UPDATE_NULL);
        elseif($count > 1)
            throw new MyException (ERR_UPDATE_NB_ROW);
    }


    /**
     * @brief Supprimer une discipline.
     * @param $idDiscipline l'id de la discipline à supprimer
     * @public
     */
    public function removeDiscipline($idDiscipline) {
        Logger::log('passage dans removeDiscipline');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "DELETE FROM discipline WHERE id_discipline = :idDiscipline";
        if (DEBUG==True)
            Logger::log('suppression d\'une discipline : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


	 /**
     * Description: méthode permettant l'ajout d'une discipline
     * Paramètres: $name nom de la classe discipline
     * Return:
     */
    static function addDiscipline($name) {
        Logger::log('passage dans addDiscipline');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "INSERT INTO discipline (name) VALUES (:name)";
        if (DEBUG==True)
            Logger::log('insertion d\'une nouvelle discipline : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('name', $name, PDO::PARAM_STR);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


    /**
     * @bried mise à jour des informations d'une discipline
     * @param name nom de la classe
     * @param id de la classe
     */
    public function updateDisciplineInfos($name,$idDiscipline) {
        Logger::log('passage dans updateDisciplineInfos Admin');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "UPDATE discipline SET name= :name WHERE id_discipline= :idDiscipline";
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('name', $name, PDO::PARAM_STR);
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes modifiées : '.$count);
        // l'id n'existe pas
        if($count == 0)
            throw new MyException (ERR_UPDATE_NULL);
        elseif($count > 1)
            throw new MyException (ERR_UPDATE_NB_ROW);
    }


    /**
     * @brief  méthode permettant l'attribution d'une discipline à un enseigant
     * @param l'id de la discipline, id de l'enseigant
     * @return
     */
    public function addDisciplineToTeacher($idTeacher,$idDiscipline) {
        Logger::log('passage dans addDisciplineToTeacher');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "INSERT INTO teacher (id_user,id_discipline) VALUES (:idTeacher,:idDiscipline )";
        if (DEBUG==True)
            Logger::log('attribution d\'une discipline à un enseigant : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idTeacher', $idTeacher, PDO::PARAM_INT);
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


    /**
     * @brief  méthode permettant le retrait d'une discipline principale d\'un enseigant
     * @param $idTeacher l'id du professeur'
     * @param $idDiscipline discipline principale du professeur
     * @public
    */
    public function removeDisciplineToTeacher($idTeacher,$idDiscipline) {
        if (DEBUG==True)
            Logger::log('passage dans removeDisciplineToTeacher');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "DELETE FROM teacher WHERE id_user = :idTeacher AND id_discipline = :idDiscipline";
        if (DEBUG==True)
            Logger::log('retrait d\'une discipline principale d\'un enseigant : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idTeacher', $idTeacher, PDO::PARAM_INT);
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


    /**
     * @brief  méthode permettant la modification d'une discipline principale d\'un enseigant
     * @param l'id de la discipline, id de l'enseigant
     * @return
     */
    static function updateDisciplineToTeacher($newIdDiscipline,$idTeacher,$idDiscipline) {
        Logger::log('passage dans updateDisciplineToTeacher');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "UPDATE teacher SET id_discipline = :newIdDiscipline WHERE teacher.id_user = :idTeacher AND teacher.id_discipline = :idDiscipline";
        if (DEBUG==True)
            Logger::log('modification de la discipline d\'un enseigant : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('newIdDiscipline', $newIdDiscipline, PDO::PARAM_INT);
        $stmt->bindParam('idTeacher', $idTeacher, PDO::PARAM_INT);
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

    /**
     * @brief retourne la liste des personnes faisant partie d'une classe selon le profil
     * @param (int) id de la classe
     * @param (int) id du profil
     * @return (array) les id nom et prénom des utilisateurs de la classe
     * @public
     */
    public function selectAllMembership($id_level,$id_profile) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllMembership : Admin.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'SELECT user.id_user,firstname,lastname FROM user JOIN member_of_level ON member_of_level.id_user = user.id_user WHERE user.id_profile = :id_profile AND member_of_level.id_level = :id_level ORDER BY lastname';
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_profile', $id_profile, PDO::PARAM_INT);
        $stmt->bindParam('id_level', $id_level, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }

    /**
     * @brief retourne la liste des élèves et responsables savoir s'ils ont validé le réglement intérieur
     * @return (array) les id nom et prénom, validation du réglement
     * @public
     */
    public function selectAllStudentAndResponsibleForRulesValidation() {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllStudentAndResponsibleForRulesValidation : Admin.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'SELECT firstname,lastname,grade,rules
                FROM user
                JOIN profile ON user.id_profile = profile.id_profile
                WHERE user.id_profile = 10
                OR user.id_profile = 20
                ORDER BY grade,rules,lastname';
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }

	/**
     * @brief Méthode permettant l'ajout d'un utilisateur dans une classe
     * @param $selectIdLevel selectIdLevel
     * @param $toBox toBox
     * @public
     */
    public function addMemberOfLevel($selectIdLevel,$toBox) {
        if (DEBUG==True)
            Logger::log('passage dans addMemberOfLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "INSERT INTO member_of_level (id_level,id_user) VALUES (:selectIdLevel,:toBox)";
        if (DEBUG==True)
            Logger::log('insertion d\'un nouvel utilisateur dans une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('selectIdLevel', $selectIdLevel, PDO::PARAM_INT);
        $stmt->bindParam('toBox', $toBox, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


    /**
     * @brief Méthode permettant la suppression d'un utilisateur dans une classe
     * @param $selectIdLevel selectIdLevel
     * @param $fromBox fromBox
     * @public
     */
    public function removeMemberOfLevel($selectIdLevel,$fromBox) {
        if (DEBUG==True)
            Logger::log('passage dans removeMemberOfLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "DELETE FROM member_of_level WHERE id_level = :selectIdLevel AND id_user = :fromBox";
        if (DEBUG==True)
            Logger::log('suppression d\'un nouvel utilisateur dans une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('selectIdLevel', $selectIdLevel, PDO::PARAM_INT);
        $stmt->bindParam('fromBox', $fromBox, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

     /**
     * @brief Méthode retournant la liste des utilisateurs n'étant pas membre d'une classe
     * @param $id_profile id_profile
     * @public
     */
      public function selectAllUsersNoMembership($id_profile) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllUsersNoMembership : Admin.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT DISTINCT user.id_user, login, firstname, lastname FROM user LEFT JOIN member_of_level ON user.id_user = member_of_level.id_user LEFT JOIN level ON member_of_level.id_level = level.id_level WHERE member_of_level.id_level IS NULL AND user.id_profile = :id_profile";
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes n\'étant pas membre d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_profile', $id_profile, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }

    /**
     * @brief Méthode retournant la liste des utilisateurs étant déjà membre d'une classe
     * @param $id_level id_level
     * @public
     */
      public function selectAllUsersMembership($id_level) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllUsersMembership : Admin.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT DISTINCT user.id_user, login, firstname, lastname FROM user LEFT JOIN member_of_level ON user.id_user = member_of_level.id_user LEFT JOIN level ON member_of_level.id_level = level.id_level WHERE member_of_level.id_level <>0 AND level.id_level = :id_level";
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes  déjà membre d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_level', $id_level, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }


    /**
     * @brief Méthode retournant la liste des responsables dont le nom contient les lettres saisies
     * @param $letter letter
     * @public
     */
      public function selectAllPossibleResponsible($letter) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllPossibleResponsible : Admin.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT DISTINCT user.id_user, login, firstname, lastname FROM user LEFT JOIN responsible ON user.id_user = responsible.id_responsible WHERE user.id_profile =20 AND lastname LIKE :letter";
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes  déjà membre d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $letter = "%".$letter."%";
        $stmt->bindParam('letter', $letter, PDO::PARAM_STR);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }


    /**
     * @brief Méthode retournant la liste des élèves dont le nom contient les lettres saisies
     * @param $letter letter
     * @public
     */
      public function selectAllPossibleStudent($letter) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllPossibleStudent : Admin.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        //$sql = "SELECT DISTINCT user.id_user, login, firstname, lastname FROM user where user.id_profile = 10 and lastname LIKE '%:letter%'";
        $sql = "SELECT DISTINCT user.id_user, login, firstname, lastname FROM user where user.id_profile = 10 and lastname LIKE :letter";
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes  déjà membre d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $letter = "%".$letter."%";
        $stmt->bindParam('letter', $letter, PDO::PARAM_STR);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }


	/**
     * @brief Méthode permettant la filation d'un élève à un responsable
     * @param $idStudent idStudent
     * @param $idResponsible idResponsible
     * @public
     */
    public function addAffiliate($idStudent,$idResponsible) {
        if (DEBUG==True)
            Logger::log('passage dans addAffiliate');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "INSERT INTO responsible (id_student,id_responsible) VALUES (:idStudent,:idResponsible)";
        if (DEBUG==True)
            Logger::log('création d\'une nouvelle filiation : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idStudent', $idStudent, PDO::PARAM_INT);
        $stmt->bindParam('idResponsible', $idResponsible, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }


    /**
     * @brief Méthode permettant la suppression d'une filation d'un élève à un responsable
     * @param $idStudent idStudent
     * @param $idResponsible idResponsible
     * @public
     */
    public function removeAffiliate($idStudent,$idResponsible) {
        if (DEBUG==True)
            Logger::log('passage dans removeAffiliate');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "DELETE FROM responsible WHERE responsible.id_student = :idStudent AND responsible.id_responsible = :idResponsible LIMIT 1";
        if (DEBUG==True)
            Logger::log('suppression d\'une nouvel filiation : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idStudent', $idStudent, PDO::PARAM_INT);
        $stmt->bindParam('idResponsible', $idResponsible, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }



}
?>